/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.nio.ByteBuff;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.ByteBufferAllocator;
import org.apache.hadoop.hbase.util.ByteBufferArray;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MiscTests.class, SmallTests.class})
public class TestByteBufferArray {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestByteBufferArray.class);

    @Test
    public void testAsSubBufferWhenEndOffsetLandInLastBuffer() throws Exception {
        int capacity = 0x400000;
        ByteBufferAllocator allocator = new ByteBufferAllocator(){

            public ByteBuffer allocate(long size) throws IOException {
                return ByteBuffer.allocateDirect((int)size);
            }
        };
        ByteBufferArray array = new ByteBufferArray((long)capacity, allocator);
        ByteBuff subBuf = array.asSubByteBuff(0L, capacity);
        subBuf.position(capacity - 1);
        Assert.assertTrue((boolean)subBuf.hasRemaining());
        subBuf.get();
        Assert.assertFalse((boolean)subBuf.hasRemaining());
    }

    @Test
    public void testByteBufferCreation() throws Exception {
        int capacity = 490907010;
        ByteBufferAllocator allocator = new ByteBufferAllocator(){

            public ByteBuffer allocate(long size) throws IOException {
                return ByteBuffer.allocateDirect((int)size);
            }
        };
        ByteBufferArray array = new ByteBufferArray((long)capacity, allocator);
        Assert.assertEquals((long)119L, (long)array.buffers.length);
        for (int i = 0; i < array.buffers.length; ++i) {
            if (i == array.buffers.length - 1) {
                Assert.assertEquals((long)0L, (long)array.buffers[i].capacity());
                continue;
            }
            Assert.assertEquals((long)0x400000L, (long)array.buffers[i].capacity());
        }
    }

    @Test
    public void testByteBufferCreation1() throws Exception {
        ByteBufferAllocator allocator = new ByteBufferAllocator(){

            public ByteBuffer allocate(long size) throws IOException {
                return ByteBuffer.allocateDirect((int)size);
            }
        };
        DummyByteBufferArray array = new DummyByteBufferArray(0x700000L, allocator);
        array.bufferCount = 25;
        array.buffers = new ByteBuffer[array.bufferCount + 1];
        array.createBuffers(allocator);
        for (int i = 0; i < array.buffers.length; ++i) {
            if (i == array.buffers.length - 1) {
                Assert.assertEquals((long)0L, (long)array.buffers[i].capacity());
                continue;
            }
            Assert.assertEquals((long)458752L, (long)array.buffers[i].capacity());
        }
    }

    private static class DummyByteBufferArray
    extends ByteBufferArray {
        public DummyByteBufferArray(long capacity, ByteBufferAllocator allocator) throws IOException {
            super(capacity, allocator);
        }

        int getThreadCount() {
            return 16;
        }
    }
}

