/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Stream;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseIOException;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.FutureUtils;
import org.apache.hbase.thirdparty.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MiscTests.class, SmallTests.class})
public class TestFutureUtils {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestFutureUtils.class);
    private ExecutorService executor;

    @Before
    public void setUp() {
        this.executor = Executors.newFixedThreadPool(1, new ThreadFactoryBuilder().setDaemon(true).build());
    }

    @After
    public void tearDown() {
        this.executor.shutdownNow();
    }

    @Test
    public void testRecordStackTrace() throws IOException {
        CompletableFuture future = new CompletableFuture();
        this.executor.execute(() -> future.completeExceptionally(new HBaseIOException("Inject error!")));
        try {
            FutureUtils.get(future);
            Assert.fail((String)"The future should have been completed exceptionally");
        }
        catch (HBaseIOException e) {
            Assert.assertEquals((Object)"Inject error!", (Object)e.getMessage());
            StackTraceElement[] elements = e.getStackTrace();
            Assert.assertThat((Object)elements[0].toString(), (Matcher)CoreMatchers.containsString((String)"java.lang.Thread.getStackTrace"));
            Assert.assertThat((Object)elements[1].toString(), (Matcher)CoreMatchers.startsWith((String)"org.apache.hadoop.hbase.util.FutureUtils.setStackTrace"));
            Assert.assertThat((Object)elements[2].toString(), (Matcher)CoreMatchers.startsWith((String)"org.apache.hadoop.hbase.util.FutureUtils.rethrow"));
            Assert.assertThat((Object)elements[3].toString(), (Matcher)CoreMatchers.startsWith((String)"org.apache.hadoop.hbase.util.FutureUtils.get"));
            Assert.assertThat((Object)elements[4].toString(), (Matcher)CoreMatchers.startsWith((String)"org.apache.hadoop.hbase.util.TestFutureUtils.testRecordStackTrace"));
            Assert.assertTrue((boolean)Stream.of(elements).anyMatch(element -> element.toString().contains("--------Future.get--------")));
        }
        catch (Throwable t) {
            throw new AssertionError("Caught unexpected Throwable", t);
        }
    }
}

