/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io;

import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
public final class TimeRange {
    public static final long INITIAL_MIN_TIMESTAMP = 0L;
    public static final long INITIAL_MAX_TIMESTAMP = Long.MAX_VALUE;
    private static final TimeRange ALL_TIME = new TimeRange(0L, Long.MAX_VALUE);
    private final long minStamp;
    private final long maxStamp;
    private final boolean allTime;

    public static TimeRange allTime() {
        return ALL_TIME;
    }

    public static TimeRange at(long ts) {
        if (ts < 0L || ts == Long.MAX_VALUE) {
            throw new IllegalArgumentException("invalid ts:" + ts);
        }
        return new TimeRange(ts, ts + 1L);
    }

    public static TimeRange from(long minStamp) {
        TimeRange.check(minStamp, Long.MAX_VALUE);
        return new TimeRange(minStamp, Long.MAX_VALUE);
    }

    public static TimeRange until(long maxStamp) {
        TimeRange.check(0L, maxStamp);
        return new TimeRange(0L, maxStamp);
    }

    public static TimeRange between(long minStamp, long maxStamp) {
        TimeRange.check(minStamp, maxStamp);
        return new TimeRange(minStamp, maxStamp);
    }

    private TimeRange(long minStamp, long maxStamp) {
        this.minStamp = minStamp;
        this.maxStamp = maxStamp;
        this.allTime = TimeRange.isAllTime(minStamp, maxStamp);
    }

    private static boolean isAllTime(long minStamp, long maxStamp) {
        return minStamp == 0L && maxStamp == Long.MAX_VALUE;
    }

    private static void check(long minStamp, long maxStamp) {
        if (minStamp < 0L || maxStamp < 0L) {
            throw new IllegalArgumentException("Timestamp cannot be negative. minStamp:" + minStamp + ", maxStamp:" + maxStamp);
        }
        if (maxStamp < minStamp) {
            throw new IllegalArgumentException("maxStamp is smaller than minStamp");
        }
    }

    public long getMin() {
        return this.minStamp;
    }

    public long getMax() {
        return this.maxStamp;
    }

    public boolean isAllTime() {
        return this.allTime;
    }

    public boolean withinTimeRange(long timestamp) {
        assert (timestamp >= 0L);
        if (this.allTime) {
            return true;
        }
        return this.minStamp <= timestamp && timestamp < this.maxStamp;
    }

    public boolean includesTimeRange(TimeRange tr) {
        if (this.allTime) {
            return true;
        }
        assert (tr.getMin() >= 0L);
        return this.getMin() < tr.getMax() && this.getMax() >= tr.getMin();
    }

    public boolean withinOrAfterTimeRange(long timestamp) {
        assert (timestamp >= 0L);
        if (this.allTime) {
            return true;
        }
        return timestamp >= this.minStamp;
    }

    public int compare(long timestamp) {
        assert (timestamp >= 0L);
        if (this.allTime) {
            return 0;
        }
        if (timestamp < this.minStamp) {
            return -1;
        }
        return timestamp >= this.maxStamp ? 1 : 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("maxStamp=");
        sb.append(this.maxStamp);
        sb.append(", minStamp=");
        sb.append(this.minStamp);
        return sb.toString();
    }
}

