/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics2.lib;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.UniqueNames;

public class DefaultMetricsSystemHelper {
    private static final Log LOG = LogFactory.getLog(DefaultMetricsSystemHelper.class);
    private final Method removeObjectMethod;
    private final Field sourceNamesField;
    private final Field mapField;

    public DefaultMetricsSystemHelper() {
        Field f2;
        Field f1;
        Method m;
        Class<?> clazz = DefaultMetricsSystem.INSTANCE.getClass();
        try {
            m = clazz.getDeclaredMethod("removeObjectName", String.class);
            m.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            m = null;
        }
        this.removeObjectMethod = m;
        try {
            f1 = clazz.getDeclaredField("sourceNames");
            f1.setAccessible(true);
            f2 = UniqueNames.class.getDeclaredField("map");
            f2.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            LOG.trace((Object)e);
            f1 = null;
            f2 = null;
        }
        this.sourceNamesField = f1;
        this.mapField = f2;
    }

    public boolean removeObjectName(String name) {
        block3: {
            if (this.removeObjectMethod != null) {
                try {
                    this.removeObjectMethod.invoke((Object)DefaultMetricsSystem.INSTANCE, name);
                    return true;
                }
                catch (Exception e) {
                    if (!LOG.isTraceEnabled()) break block3;
                    LOG.trace((Object)("Unable to remove object name from cache: " + name), (Throwable)e);
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSourceName(String name) {
        block6: {
            if (this.sourceNamesField == null || this.mapField == null) {
                return;
            }
            try {
                Object sourceNames = this.sourceNamesField.get(DefaultMetricsSystem.INSTANCE);
                HashMap map = (HashMap)this.mapField.get(sourceNames);
                Object object = sourceNames;
                synchronized (object) {
                    map.remove(name);
                }
            }
            catch (Exception ex) {
                if (!LOG.isTraceEnabled()) break block6;
                LOG.trace((Object)"Received exception while trying to access Hadoop Metrics classes via reflection.", (Throwable)ex);
            }
        }
    }
}

