/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import org.apache.hadoop.hbase.CompatibilitySingletonFactory;
import org.apache.hadoop.hbase.regionserver.MetricsRegionServerSourceFactory;
import org.apache.hadoop.hbase.regionserver.MetricsUserSource;
import org.apache.hadoop.hbase.testclassification.MetricsTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MetricsTests.class, SmallTests.class})
public class TestMetricsUserSourceImpl {
    @Test
    public void testCompareToHashCodeEquals() throws Exception {
        MetricsRegionServerSourceFactory fact = (MetricsRegionServerSourceFactory)CompatibilitySingletonFactory.getInstance(MetricsRegionServerSourceFactory.class);
        MetricsUserSource one = fact.createUser("ONE");
        MetricsUserSource oneClone = fact.createUser("ONE");
        MetricsUserSource two = fact.createUser("TWO");
        Assert.assertEquals((long)0L, (long)one.compareTo((Object)oneClone));
        Assert.assertEquals((long)one.hashCode(), (long)oneClone.hashCode());
        Assert.assertNotEquals((Object)one, (Object)two);
        Assert.assertTrue((one.compareTo((Object)two) != 0 ? 1 : 0) != 0);
        Assert.assertTrue((two.compareTo((Object)one) != 0 ? 1 : 0) != 0);
        Assert.assertTrue((two.compareTo((Object)one) != one.compareTo((Object)two) ? 1 : 0) != 0);
    }

    @Test(expected=RuntimeException.class)
    public void testNoGetRegionServerMetricsSourceImpl() throws Exception {
        CompatibilitySingletonFactory.getInstance(MetricsUserSource.class);
    }

    @Test
    public void testGetUser() {
        MetricsRegionServerSourceFactory fact = (MetricsRegionServerSourceFactory)CompatibilitySingletonFactory.getInstance(MetricsRegionServerSourceFactory.class);
        MetricsUserSource one = fact.createUser("ONE");
        Assert.assertEquals((Object)"ONE", (Object)one.getUser());
    }
}

