/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.http.log;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.URL;
import java.net.URLConnection;
import java.util.logging.Level;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.impl.Jdk14Logger;
import org.apache.commons.logging.impl.Log4JLogger;
import org.apache.hadoop.hbase.http.HttpServer;
import org.apache.hadoop.util.ServletUtil;
import org.apache.log4j.LogManager;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.impl.Log4jLoggerAdapter;

@InterfaceAudience.Private
public final class LogLevel {
    public static final String USAGES = "\nUsage: General options are:\n\t[-getlevel <host:httpPort> <name>]\n\t[-setlevel <host:httpPort> <name> <level>]\n";
    static final String MARKER = "<!-- OUTPUT -->";
    static final Pattern TAG = Pattern.compile("<[^>]*>");

    public static void main(String[] args) {
        if (args.length == 3 && "-getlevel".equals(args[0])) {
            LogLevel.process("http://" + args[1] + "/logLevel?log=" + args[2]);
            return;
        }
        if (args.length == 4 && "-setlevel".equals(args[0])) {
            LogLevel.process("http://" + args[1] + "/logLevel?log=" + args[2] + "&level=" + args[3]);
            return;
        }
        System.err.println(USAGES);
        System.exit(-1);
    }

    private static void process(String urlstring) {
        try {
            URL url = new URL(urlstring);
            System.out.println("Connecting to " + url);
            URLConnection connection = url.openConnection();
            connection.connect();
            try (InputStreamReader streamReader = new InputStreamReader(connection.getInputStream());
                 BufferedReader bufferedReader = new BufferedReader(streamReader);){
                String line;
                while ((line = bufferedReader.readLine()) != null) {
                    if (!line.startsWith(MARKER)) continue;
                    System.out.println(TAG.matcher(line).replaceAll(""));
                }
            }
        }
        catch (IOException ioe) {
            System.err.println("" + ioe);
        }
    }

    private LogLevel() {
    }

    @InterfaceAudience.LimitedPrivate(value={"HDFS", "MapReduce"})
    @InterfaceStability.Unstable
    public static class Servlet
    extends HttpServlet {
        private static final long serialVersionUID = 1L;
        static final String FORMS = "<div class='container-fluid content'>\n<div class='row inner_header'>\n<div class='page-header'>\n<h1>Get/Set Log Level</h1>\n</div>\n</div>\nActions:<p><center>\n<table class='table' style='border: 0;' width='95%' >\n<tr>\n<form>\n<td class='centered'>\n<input style='font-size: 12pt; width: 10em' type='submit' value='Get Log Level' class='btn' />\n</td>\n<td style='text-align: center;'>\n<input type='text' name='log' size='50' required='required' placeholder='Log Name (required)' />\n</td>\n<td width=\"40%\">Get the current log level for the specified log name.</td>\n</form>\n</tr>\n<tr>\n<form>\n<td class='centered'>\n<input style='font-size: 12pt; width: 10em' type='submit' value='Set Log Level' class='btn' />\n</td>\n<td style='text-align: center;'>\n<input type='text' name='log' size='50' required='required' placeholder='Log Name (required)' />\n<input type='text' name='level' size='50' required='required' placeholder='Log Level (required)' />\n</td>\n<td width=\"40%\" style=\"\">Set the specified log level for the specified log name.</td>\n</form>\n</tr>\n</table>\n</center>\n</p>\n<hr/>\n";

        public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            PrintWriter out;
            if (!HttpServer.hasAdministratorAccess(this.getServletContext(), request, response)) {
                return;
            }
            response.setContentType("text/html");
            try {
                String headerPath = "header.jsp?pageTitle=Log Level";
                request.getRequestDispatcher(headerPath).include((ServletRequest)request, (ServletResponse)response);
                out = response.getWriter();
            }
            catch (FileNotFoundException e) {
                out = ServletUtil.initHTML((ServletResponse)response, (String)"Log Level");
            }
            out.println(FORMS);
            String logName = ServletUtil.getParameter((ServletRequest)request, (String)"log");
            String level = ServletUtil.getParameter((ServletRequest)request, (String)"level");
            if (logName != null) {
                out.println("<p>Results:</p>");
                out.println("<!-- OUTPUT -->Submitted Log Name: <b>" + logName + "</b><br />");
                Logger log = LoggerFactory.getLogger((String)logName);
                out.println("<!-- OUTPUT -->Log Class: <b>" + log.getClass().getName() + "</b><br />");
                if (level != null) {
                    out.println("<!-- OUTPUT -->Submitted Level: <b>" + level + "</b><br />");
                }
                if (log instanceof Log4JLogger) {
                    Servlet.process(((Log4JLogger)log).getLogger(), level, out);
                } else if (log instanceof Jdk14Logger) {
                    Servlet.process(((Jdk14Logger)log).getLogger(), level, out);
                } else if (log instanceof Log4jLoggerAdapter) {
                    Servlet.process(LogManager.getLogger((String)logName), level, out);
                } else {
                    out.println("Sorry, " + log.getClass() + " not supported.<br />");
                }
            }
            try {
                String footerPath = "footer.jsp";
                out.println("</div>");
                request.getRequestDispatcher(footerPath).include((ServletRequest)request, (ServletResponse)response);
            }
            catch (FileNotFoundException e) {
                out.println(ServletUtil.HTML_TAIL);
            }
            out.close();
        }

        private static void process(org.apache.log4j.Logger log, String level, PrintWriter out) throws IOException {
            if (level != null) {
                if (!level.equals(org.apache.log4j.Level.toLevel((String)level).toString())) {
                    out.println("<!-- OUTPUT --><div class='text-danger'>Bad level : <strong>" + level + "</strong><br /></div>");
                } else {
                    log.setLevel(org.apache.log4j.Level.toLevel((String)level));
                    out.println("<!-- OUTPUT --><div class='text-success'>Setting Level to <strong>" + level + "</strong> ...<br /></div>");
                }
            }
            out.println("<!-- OUTPUT -->Effective level: <b>" + log.getEffectiveLevel() + "</b><br />");
        }

        private static void process(java.util.logging.Logger log, String level, PrintWriter out) throws IOException {
            Level lev;
            if (level != null) {
                log.setLevel(Level.parse(level));
                out.println("<!-- OUTPUT -->Setting Level to " + level + " ...<br />");
            }
            while ((lev = log.getLevel()) == null) {
                log = log.getParent();
            }
            out.println("<!-- OUTPUT -->Effective level: <b>" + lev + "</b><br />");
        }
    }
}

