/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.procedure2;

import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
class CompletedProcedureRetainer<TEnvironment> {
    private final Procedure<TEnvironment> procedure;
    private long clientAckTime;

    public CompletedProcedureRetainer(Procedure<TEnvironment> procedure) {
        this.procedure = procedure;
        this.clientAckTime = -1L;
    }

    public Procedure<TEnvironment> getProcedure() {
        return this.procedure;
    }

    public boolean hasClientAckTime() {
        return this.clientAckTime != -1L;
    }

    public long getClientAckTime() {
        return this.clientAckTime;
    }

    public void setClientAckTime(long clientAckTime) {
        this.clientAckTime = clientAckTime;
    }

    public boolean isExpired(long now, long evictTtl, long evictAckTtl) {
        return this.hasClientAckTime() && now - this.getClientAckTime() >= evictAckTtl || now - this.procedure.getLastUpdate() >= evictTtl;
    }
}

