/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.classification.InterfaceAudience;

@InterfaceAudience.Private
public class CacheStats {
    static final int DEFAULT_WINDOW_PERIODS = 5;
    private final AtomicLong hitCount = new AtomicLong(0L);
    private final AtomicLong hitCachingCount = new AtomicLong(0L);
    private final AtomicLong missCount = new AtomicLong(0L);
    private final AtomicLong missCachingCount = new AtomicLong(0L);
    private final AtomicLong evictionCount = new AtomicLong(0L);
    private final AtomicLong evictedBlockCount = new AtomicLong(0L);
    private final int numPeriodsInWindow;
    private final long[] hitCounts;
    private final long[] hitCachingCounts;
    private final long[] requestCounts;
    private final long[] requestCachingCounts;
    private long lastHitCount = 0L;
    private long lastHitCachingCount = 0L;
    private long lastRequestCount = 0L;
    private long lastRequestCachingCount = 0L;
    private int windowIndex = 0;

    public CacheStats() {
        this(5);
    }

    public CacheStats(int numPeriodsInWindow) {
        this.numPeriodsInWindow = numPeriodsInWindow;
        this.hitCounts = CacheStats.initializeZeros(numPeriodsInWindow);
        this.hitCachingCounts = CacheStats.initializeZeros(numPeriodsInWindow);
        this.requestCounts = CacheStats.initializeZeros(numPeriodsInWindow);
        this.requestCachingCounts = CacheStats.initializeZeros(numPeriodsInWindow);
    }

    public void miss(boolean caching) {
        this.missCount.incrementAndGet();
        if (caching) {
            this.missCachingCount.incrementAndGet();
        }
    }

    public void hit(boolean caching) {
        this.hitCount.incrementAndGet();
        if (caching) {
            this.hitCachingCount.incrementAndGet();
        }
    }

    public void evict() {
        this.evictionCount.incrementAndGet();
    }

    public void evicted() {
        this.evictedBlockCount.incrementAndGet();
    }

    public long getRequestCount() {
        return this.getHitCount() + this.getMissCount();
    }

    public long getRequestCachingCount() {
        return this.getHitCachingCount() + this.getMissCachingCount();
    }

    public long getMissCount() {
        return this.missCount.get();
    }

    public long getMissCachingCount() {
        return this.missCachingCount.get();
    }

    public long getHitCount() {
        return this.hitCount.get();
    }

    public long getHitCachingCount() {
        return this.hitCachingCount.get();
    }

    public long getEvictionCount() {
        return this.evictionCount.get();
    }

    public long getEvictedCount() {
        return this.evictedBlockCount.get();
    }

    public double getHitRatio() {
        return (float)this.getHitCount() / (float)this.getRequestCount();
    }

    public double getHitCachingRatio() {
        return (float)this.getHitCachingCount() / (float)this.getRequestCachingCount();
    }

    public double getMissRatio() {
        return (float)this.getMissCount() / (float)this.getRequestCount();
    }

    public double getMissCachingRatio() {
        return (float)this.getMissCachingCount() / (float)this.getRequestCachingCount();
    }

    public double evictedPerEviction() {
        return (float)this.getEvictedCount() / (float)this.getEvictionCount();
    }

    public void rollMetricsPeriod() {
        this.hitCounts[this.windowIndex] = this.getHitCount() - this.lastHitCount;
        this.lastHitCount = this.getHitCount();
        this.hitCachingCounts[this.windowIndex] = this.getHitCachingCount() - this.lastHitCachingCount;
        this.lastHitCachingCount = this.getHitCachingCount();
        this.requestCounts[this.windowIndex] = this.getRequestCount() - this.lastRequestCount;
        this.lastRequestCount = this.getRequestCount();
        this.requestCachingCounts[this.windowIndex] = this.getRequestCachingCount() - this.lastRequestCachingCount;
        this.lastRequestCachingCount = this.getRequestCachingCount();
        this.windowIndex = (this.windowIndex + 1) % this.numPeriodsInWindow;
    }

    public long getSumHitCountsPastNPeriods() {
        return CacheStats.sum(this.hitCounts);
    }

    public long getSumRequestCountsPastNPeriods() {
        return CacheStats.sum(this.requestCounts);
    }

    public long getSumHitCachingCountsPastNPeriods() {
        return CacheStats.sum(this.hitCachingCounts);
    }

    public long getSumRequestCachingCountsPastNPeriods() {
        return CacheStats.sum(this.requestCachingCounts);
    }

    public double getHitRatioPastNPeriods() {
        double ratio = (double)CacheStats.sum(this.hitCounts) / (double)CacheStats.sum(this.requestCounts);
        return Double.isNaN(ratio) ? 0.0 : ratio;
    }

    public double getHitCachingRatioPastNPeriods() {
        double ratio = (double)CacheStats.sum(this.hitCachingCounts) / (double)CacheStats.sum(this.requestCachingCounts);
        return Double.isNaN(ratio) ? 0.0 : ratio;
    }

    private static long sum(long[] counts) {
        long sum = 0L;
        for (long count : counts) {
            sum += count;
        }
        return sum;
    }

    private static long[] initializeZeros(int n) {
        long[] zeros = new long[n];
        for (int i = 0; i < n; ++i) {
            zeros[i] = 0L;
        }
        return zeros;
    }
}

