/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile;

import com.google.common.collect.MinMaxPriorityQueue;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hbase.io.HeapSize;
import org.apache.hadoop.hbase.io.hfile.CachedBlock;

@InterfaceAudience.Private
public class CachedBlockQueue
implements HeapSize {
    private MinMaxPriorityQueue<CachedBlock> queue;
    private long heapSize;
    private long maxSize;

    public CachedBlockQueue(long maxSize, long blockSize) {
        int initialSize = (int)(maxSize / blockSize);
        if (initialSize == 0) {
            ++initialSize;
        }
        this.queue = MinMaxPriorityQueue.expectedSize((int)initialSize).create();
        this.heapSize = 0L;
        this.maxSize = maxSize;
    }

    public void add(CachedBlock cb) {
        if (this.heapSize < this.maxSize) {
            this.queue.add((Object)cb);
            this.heapSize += cb.heapSize();
        } else {
            CachedBlock head = (CachedBlock)this.queue.peek();
            if (cb.compareTo(head) > 0) {
                this.heapSize += cb.heapSize();
                this.heapSize -= head.heapSize();
                if (this.heapSize > this.maxSize) {
                    this.queue.poll();
                } else {
                    this.heapSize += head.heapSize();
                }
                this.queue.add((Object)cb);
            }
        }
    }

    public CachedBlock poll() {
        return (CachedBlock)this.queue.poll();
    }

    public CachedBlock pollLast() {
        return (CachedBlock)this.queue.pollLast();
    }

    public long heapSize() {
        return this.heapSize;
    }
}

