/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile.bucket;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hbase.io.hfile.bucket.IOEngine;
import org.apache.hadoop.hbase.util.ByteBufferArray;

@InterfaceAudience.Private
public class ByteBufferIOEngine
implements IOEngine {
    private ByteBufferArray bufferArray;

    public ByteBufferIOEngine(long capacity, boolean direct) throws IOException {
        this.bufferArray = new ByteBufferArray(capacity, direct);
    }

    @Override
    public boolean isPersistent() {
        return false;
    }

    @Override
    public int read(ByteBuffer dstBuffer, long offset) throws IOException {
        assert (dstBuffer.hasArray());
        return this.bufferArray.getMultiple(offset, dstBuffer.remaining(), dstBuffer.array(), dstBuffer.arrayOffset());
    }

    @Override
    public void write(ByteBuffer srcBuffer, long offset) throws IOException {
        assert (srcBuffer.hasArray());
        this.bufferArray.putMultiple(offset, srcBuffer.remaining(), srcBuffer.array(), srcBuffer.arrayOffset());
    }

    @Override
    public void sync() {
    }

    @Override
    public void shutdown() {
    }
}

