/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapred;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.mapred.InputSplit;

@Deprecated
@InterfaceAudience.Public
@InterfaceStability.Stable
public class TableSplit
implements InputSplit,
Comparable<TableSplit> {
    private TableName m_tableName;
    private byte[] m_startRow;
    private byte[] m_endRow;
    private String m_regionLocation;

    public TableSplit() {
        this((TableName)null, HConstants.EMPTY_BYTE_ARRAY, HConstants.EMPTY_BYTE_ARRAY, "");
    }

    public TableSplit(TableName tableName, byte[] startRow, byte[] endRow, String location) {
        this.m_tableName = tableName;
        this.m_startRow = startRow;
        this.m_endRow = endRow;
        this.m_regionLocation = location;
    }

    public TableSplit(byte[] tableName, byte[] startRow, byte[] endRow, String location) {
        this(TableName.valueOf((byte[])tableName), startRow, endRow, location);
    }

    public TableName getTable() {
        return this.m_tableName;
    }

    public byte[] getTableName() {
        return this.m_tableName.getName();
    }

    public byte[] getStartRow() {
        return this.m_startRow;
    }

    public byte[] getEndRow() {
        return this.m_endRow;
    }

    public String getRegionLocation() {
        return this.m_regionLocation;
    }

    public String[] getLocations() {
        return new String[]{this.m_regionLocation};
    }

    public long getLength() {
        return 0L;
    }

    public void readFields(DataInput in) throws IOException {
        this.m_tableName = TableName.valueOf((byte[])Bytes.readByteArray((DataInput)in));
        this.m_startRow = Bytes.readByteArray((DataInput)in);
        this.m_endRow = Bytes.readByteArray((DataInput)in);
        this.m_regionLocation = Bytes.toString((byte[])Bytes.readByteArray((DataInput)in));
    }

    public void write(DataOutput out) throws IOException {
        Bytes.writeByteArray((DataOutput)out, (byte[])this.m_tableName.getName());
        Bytes.writeByteArray((DataOutput)out, (byte[])this.m_startRow);
        Bytes.writeByteArray((DataOutput)out, (byte[])this.m_endRow);
        Bytes.writeByteArray((DataOutput)out, (byte[])Bytes.toBytes((String)this.m_regionLocation));
    }

    public String toString() {
        return this.m_regionLocation + ":" + Bytes.toStringBinary((byte[])this.m_startRow) + "," + Bytes.toStringBinary((byte[])this.m_endRow);
    }

    @Override
    public int compareTo(TableSplit o) {
        return Bytes.compareTo((byte[])this.getStartRow(), (byte[])o.getStartRow());
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof TableSplit)) {
            return false;
        }
        TableSplit other = (TableSplit)o;
        return this.m_tableName.equals((Object)other.m_tableName) && Bytes.equals((byte[])this.m_startRow, (byte[])other.m_startRow) && Bytes.equals((byte[])this.m_endRow, (byte[])other.m_endRow) && this.m_regionLocation.equals(other.m_regionLocation);
    }
}

