/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.handler;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.executor.EventHandler;
import org.apache.hadoop.hbase.executor.EventType;
import org.apache.hadoop.hbase.master.DeadServer;
import org.apache.hadoop.hbase.master.MasterServices;

@InterfaceAudience.Private
public class LogReplayHandler
extends EventHandler {
    private static final Log LOG = LogFactory.getLog(LogReplayHandler.class);
    private final ServerName serverName;
    protected final Server master;
    protected final MasterServices services;
    protected final DeadServer deadServers;

    public LogReplayHandler(Server server, MasterServices services, DeadServer deadServers, ServerName serverName) {
        super(server, EventType.M_LOG_REPLAY);
        this.master = server;
        this.services = services;
        this.deadServers = deadServers;
        this.serverName = serverName;
        this.deadServers.add(serverName);
    }

    @Override
    public String toString() {
        String name = this.serverName.toString();
        return this.getClass().getSimpleName() + "-" + name + "-" + this.getSeqid();
    }

    @Override
    public void process() throws IOException {
        try {
            if (this.master != null && this.master.isStopped()) {
                return;
            }
            this.services.getMasterFileSystem().splitLog(this.serverName);
        }
        catch (Exception ex) {
            if (ex instanceof IOException) {
                this.services.getExecutorService().submit(this);
                this.deadServers.add(this.serverName);
                throw new IOException("failed log replay for " + this.serverName + ", will retry", ex);
            }
            throw new IOException(ex);
        }
        finally {
            this.deadServers.finish(this.serverName);
        }
        LOG.info((Object)("Finished processing of shutdown of " + this.serverName));
    }
}

