/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest.model;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.bind.annotation.XmlAnyAttribute;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.namespace.QName;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.codehaus.jackson.annotate.JsonAnyGetter;
import org.codehaus.jackson.annotate.JsonAnySetter;

@XmlRootElement(name="ColumnSchema")
@InterfaceAudience.Private
public class ColumnSchemaModel
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static QName BLOCKCACHE = new QName("BLOCKCACHE");
    private static QName BLOCKSIZE = new QName("BLOCKSIZE");
    private static QName BLOOMFILTER = new QName("BLOOMFILTER");
    private static QName COMPRESSION = new QName("COMPRESSION");
    private static QName IN_MEMORY = new QName("IN_MEMORY");
    private static QName TTL = new QName("TTL");
    private static QName VERSIONS = new QName("VERSIONS");
    private String name;
    private Map<QName, Object> attrs = new LinkedHashMap<QName, Object>();

    @JsonAnySetter
    public void addAttribute(String name, Object value) {
        this.attrs.put(new QName(name), value);
    }

    public String getAttribute(String name) {
        Object o = this.attrs.get(new QName(name));
        return o != null ? o.toString() : null;
    }

    @XmlAttribute
    public String getName() {
        return this.name;
    }

    @XmlAnyAttribute
    @JsonAnyGetter
    public Map<QName, Object> getAny() {
        return this.attrs;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{ NAME => '");
        sb.append(this.name);
        sb.append('\'');
        for (Map.Entry<QName, Object> e : this.attrs.entrySet()) {
            sb.append(", ");
            sb.append(e.getKey().getLocalPart());
            sb.append(" => '");
            sb.append(e.getValue().toString());
            sb.append('\'');
        }
        sb.append(" }");
        return sb.toString();
    }

    public boolean __getBlockcache() {
        Object o = this.attrs.get(BLOCKCACHE);
        return o != null ? Boolean.valueOf(o.toString()) : true;
    }

    public int __getBlocksize() {
        Object o = this.attrs.get(BLOCKSIZE);
        return o != null ? Integer.valueOf(o.toString()) : 65536;
    }

    public String __getBloomfilter() {
        Object o = this.attrs.get(BLOOMFILTER);
        return o != null ? o.toString() : HColumnDescriptor.DEFAULT_BLOOMFILTER;
    }

    public String __getCompression() {
        Object o = this.attrs.get(COMPRESSION);
        return o != null ? o.toString() : HColumnDescriptor.DEFAULT_COMPRESSION;
    }

    public boolean __getInMemory() {
        Object o = this.attrs.get(IN_MEMORY);
        return o != null ? Boolean.valueOf(o.toString()) : false;
    }

    public int __getTTL() {
        Object o = this.attrs.get(TTL);
        return o != null ? Integer.valueOf(o.toString()) : Integer.MAX_VALUE;
    }

    public int __getVersions() {
        Object o = this.attrs.get(VERSIONS);
        return o != null ? Integer.valueOf(o.toString()) : 1;
    }

    public void __setBlocksize(int value) {
        this.attrs.put(BLOCKSIZE, Integer.toString(value));
    }

    public void __setBlockcache(boolean value) {
        this.attrs.put(BLOCKCACHE, Boolean.toString(value));
    }

    public void __setBloomfilter(String value) {
        this.attrs.put(BLOOMFILTER, value);
    }

    public void __setCompression(String value) {
        this.attrs.put(COMPRESSION, value);
    }

    public void __setInMemory(boolean value) {
        this.attrs.put(IN_MEMORY, Boolean.toString(value));
    }

    public void __setTTL(int value) {
        this.attrs.put(TTL, Integer.toString(value));
    }

    public void __setVersions(int value) {
        this.attrs.put(VERSIONS, Integer.toString(value));
    }
}

