/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.visibility;

import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hbase.security.visibility.expression.ExpressionNode;
import org.apache.hadoop.hbase.security.visibility.expression.LeafExpressionNode;
import org.apache.hadoop.hbase.security.visibility.expression.NonLeafExpressionNode;
import org.apache.hadoop.hbase.security.visibility.expression.Operator;

@InterfaceAudience.Private
public class ExpressionExpander {
    public ExpressionNode expand(ExpressionNode src) {
        if (!src.isSingleNode()) {
            NonLeafExpressionNode nlExp = (NonLeafExpressionNode)src;
            List<ExpressionNode> childExps = nlExp.getChildExps();
            Operator outerOp = nlExp.getOperator();
            if (this.isToBeExpanded(childExps)) {
                NonLeafExpressionNode newNode = new NonLeafExpressionNode(nlExp.getOperator());
                for (ExpressionNode exp : childExps) {
                    if (exp.isSingleNode()) {
                        newNode.addChildExp(exp);
                        continue;
                    }
                    newNode.addChildExp(this.expand(exp));
                }
                nlExp = this.expandNonLeaf(newNode, outerOp);
            }
            return nlExp;
        }
        if (src instanceof NonLeafExpressionNode && ((NonLeafExpressionNode)src).getOperator() == Operator.NOT) {
            return this.negate((NonLeafExpressionNode)src);
        }
        return src;
    }

    private ExpressionNode negate(NonLeafExpressionNode nlExp) {
        ExpressionNode notChild = nlExp.getChildExps().get(0);
        if (notChild instanceof LeafExpressionNode) {
            return nlExp;
        }
        NonLeafExpressionNode nlNotChild = (NonLeafExpressionNode)notChild;
        if (nlNotChild.getOperator() == Operator.NOT) {
            return nlNotChild.getChildExps().get(0);
        }
        Operator negateOp = nlNotChild.getOperator() == Operator.AND ? Operator.OR : Operator.AND;
        NonLeafExpressionNode newNode = new NonLeafExpressionNode(negateOp);
        for (ExpressionNode expNode : nlNotChild.getChildExps()) {
            NonLeafExpressionNode negateNode = new NonLeafExpressionNode(Operator.NOT);
            negateNode.addChildExp(expNode.deepClone());
            newNode.addChildExp(this.expand(negateNode));
        }
        return newNode;
    }

    private boolean isToBeExpanded(List<ExpressionNode> childExps) {
        for (ExpressionNode exp : childExps) {
            if (exp.isSingleNode()) continue;
            return true;
        }
        return false;
    }

    private NonLeafExpressionNode expandNonLeaf(NonLeafExpressionNode newNode, Operator outerOp) {
        block12: {
            NonLeafExpressionNode rightChildNLE;
            NonLeafExpressionNode leftChildNLE;
            block15: {
                block16: {
                    block14: {
                        ExpressionNode rightChild;
                        ExpressionNode leftChild;
                        block13: {
                            block11: {
                                List<ExpressionNode> newChildExps = newNode.getChildExps();
                                assert (newChildExps.size() == 2);
                                leftChild = newChildExps.get(0);
                                rightChild = newChildExps.get(1);
                                if (!rightChild.isSingleNode()) break block11;
                                assert (leftChild instanceof NonLeafExpressionNode);
                                newNode = this.mergeChildNodes(newNode, outerOp, rightChild, (NonLeafExpressionNode)leftChild);
                                break block12;
                            }
                            if (!leftChild.isSingleNode()) break block13;
                            assert (rightChild instanceof NonLeafExpressionNode);
                            newNode = this.mergeChildNodes(newNode, outerOp, leftChild, (NonLeafExpressionNode)rightChild);
                            break block12;
                        }
                        leftChildNLE = (NonLeafExpressionNode)leftChild;
                        rightChildNLE = (NonLeafExpressionNode)rightChild;
                        if (outerOp != leftChildNLE.getOperator() || outerOp != rightChildNLE.getOperator()) break block14;
                        NonLeafExpressionNode leftChildNLEClone = leftChildNLE.deepClone();
                        leftChildNLEClone.addChildExps(rightChildNLE.getChildExps());
                        newNode = leftChildNLEClone;
                        break block12;
                    }
                    if (outerOp != Operator.OR) break block15;
                    if (leftChildNLE.getOperator() != Operator.OR || rightChildNLE.getOperator() != Operator.AND) break block16;
                    leftChildNLE.addChildExp(rightChildNLE);
                    newNode = leftChildNLE;
                    break block12;
                }
                if (leftChildNLE.getOperator() != Operator.AND || rightChildNLE.getOperator() != Operator.OR) break block12;
                rightChildNLE.addChildExp(leftChildNLE);
                newNode = rightChildNLE;
                break block12;
            }
            if (leftChildNLE.getOperator() == Operator.OR && rightChildNLE.getOperator() == Operator.AND) {
                newNode = new NonLeafExpressionNode(Operator.OR);
                for (ExpressionNode exp : leftChildNLE.getChildExps()) {
                    NonLeafExpressionNode rightChildNLEClone = rightChildNLE.deepClone();
                    rightChildNLEClone.addChildExp(exp);
                    newNode.addChildExp(rightChildNLEClone);
                }
            } else if (leftChildNLE.getOperator() == Operator.AND && rightChildNLE.getOperator() == Operator.OR) {
                newNode = new NonLeafExpressionNode(Operator.OR);
                for (ExpressionNode exp : rightChildNLE.getChildExps()) {
                    NonLeafExpressionNode leftChildNLEClone = leftChildNLE.deepClone();
                    leftChildNLEClone.addChildExp(exp);
                    newNode.addChildExp(leftChildNLEClone);
                }
            } else {
                newNode = new NonLeafExpressionNode(Operator.OR);
                for (ExpressionNode leftExp : leftChildNLE.getChildExps()) {
                    for (ExpressionNode rightExp : rightChildNLE.getChildExps()) {
                        NonLeafExpressionNode newChild = new NonLeafExpressionNode(Operator.AND);
                        newChild.addChildExp(leftExp.deepClone());
                        newChild.addChildExp(rightExp.deepClone());
                        newNode.addChildExp(newChild);
                    }
                }
            }
        }
        return newNode;
    }

    private NonLeafExpressionNode mergeChildNodes(NonLeafExpressionNode newOuterNode, Operator outerOp, ExpressionNode lChild, NonLeafExpressionNode nlChild) {
        if (nlChild.getOperator() == outerOp) {
            NonLeafExpressionNode leftChildNLEClone = nlChild.deepClone();
            leftChildNLEClone.addChildExp(lChild);
            newOuterNode = leftChildNLEClone;
        } else if (outerOp == Operator.AND) {
            assert (nlChild.getOperator() == Operator.OR);
            newOuterNode = new NonLeafExpressionNode(Operator.OR);
            for (ExpressionNode exp : nlChild.getChildExps()) {
                newOuterNode.addChildExp(new NonLeafExpressionNode(Operator.AND, exp, lChild));
            }
        }
        return newOuterNode;
    }
}

