/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.snapshot;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileChecksum;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.io.HFileLink;
import org.apache.hadoop.hbase.io.HLogLink;
import org.apache.hadoop.hbase.mapreduce.JobUtil;
import org.apache.hadoop.hbase.mapreduce.TableMapReduceUtil;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.regionserver.StoreFileInfo;
import org.apache.hadoop.hbase.security.UserProvider;
import org.apache.hadoop.hbase.security.token.FsDelegationToken;
import org.apache.hadoop.hbase.snapshot.ExportSnapshotException;
import org.apache.hadoop.hbase.snapshot.SnapshotDescriptionUtils;
import org.apache.hadoop.hbase.snapshot.SnapshotReferenceUtil;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.lib.input.SequenceFileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.NullOutputFormat;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public final class ExportSnapshot
extends Configured
implements Tool {
    private static final Log LOG = LogFactory.getLog(ExportSnapshot.class);
    private static final String CONF_FILES_USER = "snapshot.export.files.attributes.user";
    private static final String CONF_FILES_GROUP = "snapshot.export.files.attributes.group";
    private static final String CONF_FILES_MODE = "snapshot.export.files.attributes.mode";
    private static final String CONF_CHECKSUM_VERIFY = "snapshot.export.checksum.verify";
    private static final String CONF_OUTPUT_ROOT = "snapshot.export.output.root";
    private static final String CONF_INPUT_ROOT = "snapshot.export.input.root";
    private static final String CONF_BUFFER_SIZE = "snapshot.export.buffer.size";
    private static final String CONF_MAP_GROUP = "snapshot.export.default.map.group";
    static final String CONF_TEST_FAILURE = "test.snapshot.export.failure";
    static final String CONF_TEST_RETRY = "test.snapshot.export.failure.retry";
    private static final String INPUT_FOLDER_PREFIX = "export-files.";

    private List<Pair<Path, Long>> getSnapshotFiles(final FileSystem fs, Path snapshotDir) throws IOException {
        HBaseProtos.SnapshotDescription snapshotDesc = SnapshotDescriptionUtils.readSnapshotInfo(fs, snapshotDir);
        final ArrayList<Pair<Path, Long>> files = new ArrayList<Pair<Path, Long>>();
        final TableName table = TableName.valueOf((String)snapshotDesc.getTable());
        final Configuration conf = this.getConf();
        SnapshotReferenceUtil.visitReferencedFiles(fs, snapshotDir, new SnapshotReferenceUtil.FileVisitor(){

            @Override
            public void storeFile(String region, String family, String hfile) throws IOException {
                Path path = HFileLink.createPath(table, region, family, hfile);
                long size = new HFileLink(conf, path).getFileStatus(fs).getLen();
                files.add(new Pair((Object)path, (Object)size));
            }

            @Override
            public void recoveredEdits(String region, String logfile) throws IOException {
            }

            @Override
            public void logFile(String server, String logfile) throws IOException {
                long size = new HLogLink(conf, server, logfile).getFileStatus(fs).getLen();
                files.add(new Pair((Object)new Path(server, logfile), (Object)size));
            }
        });
        return files;
    }

    static List<List<Path>> getBalancedSplits(List<Pair<Path, Long>> files, int ngroups) {
        Collections.sort(files, new Comparator<Pair<Path, Long>>(){

            @Override
            public int compare(Pair<Path, Long> a, Pair<Path, Long> b) {
                long r = (Long)a.getSecond() - (Long)b.getSecond();
                return r < 0L ? -1 : (r > 0L ? 1 : 0);
            }
        });
        LinkedList<List<Path>> fileGroups = new LinkedList<List<Path>>();
        long[] sizeGroups = new long[ngroups];
        int hi = files.size() - 1;
        int lo = 0;
        int dir = 1;
        int g = 0;
        while (hi >= lo) {
            List<Object> group;
            if (g == fileGroups.size()) {
                group = new LinkedList();
                fileGroups.add(group);
            } else {
                group = (List)fileGroups.get(g);
            }
            Pair<Path, Long> fileInfo = files.get(hi--);
            int n = g;
            sizeGroups[n] = sizeGroups[n] + (Long)fileInfo.getSecond();
            group.add(fileInfo.getFirst());
            if ((g += dir) == ngroups) {
                dir = -1;
                g = ngroups - 1;
                continue;
            }
            if (g >= 0) continue;
            dir = 1;
            g = 0;
        }
        if (LOG.isDebugEnabled()) {
            for (int i = 0; i < sizeGroups.length; ++i) {
                LOG.debug((Object)("export split=" + i + " size=" + StringUtils.humanReadableInt((long)sizeGroups[i])));
            }
        }
        return fileGroups;
    }

    private static Path getInputFolderPath(Configuration conf) throws IOException, InterruptedException {
        Path stagingDir = JobUtil.getStagingDir((Configuration)conf);
        return new Path(stagingDir, INPUT_FOLDER_PREFIX + String.valueOf(EnvironmentEdgeManager.currentTimeMillis()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Path[] createInputFiles(Configuration conf, Path inputFolderPath, List<Pair<Path, Long>> snapshotFiles, int mappers) throws IOException, InterruptedException {
        FileSystem fs = inputFolderPath.getFileSystem(conf);
        LOG.debug((Object)("Input folder location: " + inputFolderPath));
        List<List<Path>> splits = ExportSnapshot.getBalancedSplits(snapshotFiles, mappers);
        Path[] inputFiles = new Path[splits.size()];
        Text key = new Text();
        for (int i = 0; i < inputFiles.length; ++i) {
            List<Path> files = splits.get(i);
            inputFiles[i] = new Path(inputFolderPath, String.format("export-%d.seq", i));
            SequenceFile.Writer writer = SequenceFile.createWriter((FileSystem)fs, (Configuration)conf, (Path)inputFiles[i], Text.class, NullWritable.class);
            LOG.debug((Object)("Input split: " + i));
            try {
                for (Path file : files) {
                    LOG.debug((Object)file.toString());
                    key.set(file.toString());
                    writer.append((Writable)key, (Writable)NullWritable.get());
                }
                continue;
            }
            finally {
                writer.close();
            }
        }
        return inputFiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runCopyJob(FileSystem inputFs, Path inputRoot, FileSystem outputFs, Path outputRoot, List<Pair<Path, Long>> snapshotFiles, boolean verifyChecksum, String filesUser, String filesGroup, int filesMode, int mappers) throws IOException, InterruptedException, ClassNotFoundException {
        Configuration conf = this.getConf();
        if (filesGroup != null) {
            conf.set(CONF_FILES_GROUP, filesGroup);
        }
        if (filesUser != null) {
            conf.set(CONF_FILES_USER, filesUser);
        }
        conf.setInt(CONF_FILES_MODE, filesMode);
        conf.setBoolean(CONF_CHECKSUM_VERIFY, verifyChecksum);
        conf.set(CONF_OUTPUT_ROOT, outputRoot.toString());
        conf.set(CONF_INPUT_ROOT, inputRoot.toString());
        conf.setInt("mapreduce.job.maps", mappers);
        Job job = new Job(conf);
        job.setJobName("ExportSnapshot");
        job.setJarByClass(ExportSnapshot.class);
        TableMapReduceUtil.addDependencyJars(job);
        job.setMapperClass(ExportMapper.class);
        job.setInputFormatClass(SequenceFileInputFormat.class);
        job.setOutputFormatClass(NullOutputFormat.class);
        job.setMapSpeculativeExecution(false);
        job.setNumReduceTasks(0);
        Path inputFolderPath = ExportSnapshot.getInputFolderPath(conf);
        for (Path path : ExportSnapshot.createInputFiles(conf, inputFolderPath, snapshotFiles, mappers)) {
            LOG.debug((Object)("Add Input Path=" + path));
            SequenceFileInputFormat.addInputPath((Job)job, (Path)path);
        }
        UserProvider userProvider = UserProvider.instantiate((Configuration)job.getConfiguration());
        FsDelegationToken inputFsToken = new FsDelegationToken(userProvider, "irenewer");
        FsDelegationToken outputFsToken = new FsDelegationToken(userProvider, "orenewer");
        try {
            inputFsToken.acquireDelegationToken(inputFs);
            outputFsToken.acquireDelegationToken(outputFs);
            if (!job.waitForCompletion(true)) {
                throw new ExportSnapshotException("Copy Files Map-Reduce Job failed");
            }
        }
        finally {
            inputFsToken.releaseDelegationToken();
            outputFsToken.releaseDelegationToken();
            try {
                inputFolderPath.getFileSystem(conf).delete(inputFolderPath, true);
            }
            catch (IOException e) {
                LOG.warn((Object)("Unable to remove MR input folder: " + inputFolderPath), (Throwable)e);
            }
        }
    }

    private void verifySnapshot(Configuration baseConf, FileSystem fs, Path rootDir, Path snapshotDir) throws IOException {
        Configuration conf = new Configuration(baseConf);
        FSUtils.setRootDir(conf, rootDir);
        FSUtils.setFsDefault(conf, snapshotDir);
        HBaseProtos.SnapshotDescription snapshotDesc = SnapshotDescriptionUtils.readSnapshotInfo(fs, snapshotDir);
        SnapshotReferenceUtil.verifySnapshot(conf, fs, snapshotDir, snapshotDesc);
    }

    public int run(String[] args) throws IOException {
        boolean verifyChecksum = true;
        String snapshotName = null;
        boolean overwrite = false;
        String filesGroup = null;
        String filesUser = null;
        Path outputRoot = null;
        int filesMode = 0;
        int mappers = 0;
        Configuration conf = this.getConf();
        for (int i = 0; i < args.length; ++i) {
            String cmd = args[i];
            try {
                if (cmd.equals("-snapshot")) {
                    snapshotName = args[++i];
                    continue;
                }
                if (cmd.equals("-copy-to")) {
                    outputRoot = new Path(args[++i]);
                    continue;
                }
                if (cmd.equals("-copy-from")) {
                    Path sourceDir = new Path(args[++i]);
                    URI defaultFs = sourceDir.getFileSystem(conf).getUri();
                    FSUtils.setFsDefault(conf, new Path(defaultFs));
                    FSUtils.setRootDir(conf, sourceDir);
                    continue;
                }
                if (cmd.equals("-no-checksum-verify")) {
                    verifyChecksum = false;
                    continue;
                }
                if (cmd.equals("-mappers")) {
                    mappers = Integer.parseInt(args[++i]);
                    continue;
                }
                if (cmd.equals("-chuser")) {
                    filesUser = args[++i];
                    continue;
                }
                if (cmd.equals("-chgroup")) {
                    filesGroup = args[++i];
                    continue;
                }
                if (cmd.equals("-chmod")) {
                    filesMode = Integer.parseInt(args[++i], 8);
                    continue;
                }
                if (cmd.equals("-overwrite")) {
                    overwrite = true;
                    continue;
                }
                if (cmd.equals("-h") || cmd.equals("--help")) {
                    this.printUsageAndExit();
                    continue;
                }
                System.err.println("UNEXPECTED: " + cmd);
                this.printUsageAndExit();
                continue;
            }
            catch (Exception e) {
                this.printUsageAndExit();
            }
        }
        if (snapshotName == null) {
            System.err.println("Snapshot name not provided.");
            this.printUsageAndExit();
        }
        if (outputRoot == null) {
            System.err.println("Destination file-system not provided.");
            this.printUsageAndExit();
        }
        Path inputRoot = FSUtils.getRootDir(conf);
        FileSystem inputFs = FileSystem.get((URI)inputRoot.toUri(), (Configuration)conf);
        LOG.debug((Object)("inputFs=" + inputFs.getUri().toString() + " inputRoot=" + inputRoot));
        FileSystem outputFs = FileSystem.get((URI)outputRoot.toUri(), (Configuration)conf);
        LOG.debug((Object)("outputFs=" + outputFs.getUri().toString() + " outputRoot=" + outputRoot.toString()));
        Path snapshotDir = SnapshotDescriptionUtils.getCompletedSnapshotDir(snapshotName, inputRoot);
        Path snapshotTmpDir = SnapshotDescriptionUtils.getWorkingSnapshotDir(snapshotName, outputRoot);
        Path outputSnapshotDir = SnapshotDescriptionUtils.getCompletedSnapshotDir(snapshotName, outputRoot);
        if (outputFs.exists(outputSnapshotDir)) {
            if (overwrite) {
                if (!outputFs.delete(outputSnapshotDir, true)) {
                    System.err.println("Unable to remove existing snapshot directory: " + outputSnapshotDir);
                    return 1;
                }
            } else {
                System.err.println("The snapshot '" + snapshotName + "' already exists in the destination: " + outputSnapshotDir);
                return 1;
            }
        }
        if (outputFs.exists(snapshotTmpDir)) {
            if (overwrite) {
                if (!outputFs.delete(snapshotTmpDir, true)) {
                    System.err.println("Unable to remove existing snapshot tmp directory: " + snapshotTmpDir);
                    return 1;
                }
            } else {
                System.err.println("A snapshot with the same name '" + snapshotName + "' may be in-progress");
                System.err.println("Please check " + snapshotTmpDir + ". If the snapshot has completed, ");
                System.err.println("consider removing " + snapshotTmpDir + " by using the -overwrite option");
                return 1;
            }
        }
        LOG.info((Object)"Loading Snapshot hfile list");
        List<Pair<Path, Long>> files = this.getSnapshotFiles(inputFs, snapshotDir);
        if (mappers == 0 && files.size() > 0) {
            mappers = 1 + files.size() / conf.getInt(CONF_MAP_GROUP, 10);
            mappers = Math.min(mappers, files.size());
        }
        try {
            LOG.info((Object)"Copy Snapshot Manifest");
            FileUtil.copy((FileSystem)inputFs, (Path)snapshotDir, (FileSystem)outputFs, (Path)snapshotTmpDir, (boolean)false, (boolean)false, (Configuration)conf);
        }
        catch (IOException e) {
            throw new ExportSnapshotException("Failed to copy the snapshot directory: from=" + snapshotDir + " to=" + snapshotTmpDir, (Exception)e);
        }
        try {
            if (files.size() == 0) {
                LOG.warn((Object)"There are 0 store file to be copied. There may be no data in the table.");
            } else {
                this.runCopyJob(inputFs, inputRoot, outputFs, outputRoot, files, verifyChecksum, filesUser, filesGroup, filesMode, mappers);
            }
            LOG.info((Object)"Finalize the Snapshot Export");
            if (!outputFs.rename(snapshotTmpDir, outputSnapshotDir)) {
                throw new ExportSnapshotException("Unable to rename snapshot directory from=" + snapshotTmpDir + " to=" + outputSnapshotDir);
            }
            LOG.info((Object)"Verify snapshot validity");
            this.verifySnapshot(conf, outputFs, outputRoot, outputSnapshotDir);
            LOG.info((Object)("Export Completed: " + snapshotName));
            return 0;
        }
        catch (Exception e) {
            LOG.error((Object)"Snapshot export failed", (Throwable)e);
            outputFs.delete(snapshotTmpDir, true);
            outputFs.delete(outputSnapshotDir, true);
            return 1;
        }
    }

    private void printUsageAndExit() {
        System.err.printf("Usage: bin/hbase %s [options]%n", ((Object)((Object)this)).getClass().getName());
        System.err.println(" where [options] are:");
        System.err.println("  -h|-help                Show this help and exit.");
        System.err.println("  -snapshot NAME          Snapshot to restore.");
        System.err.println("  -copy-to NAME           Remote destination hdfs://");
        System.err.println("  -copy-from NAME         Input folder hdfs:// (default hbase.rootdir)");
        System.err.println("  -no-checksum-verify     Do not verify checksum.");
        System.err.println("  -overwrite              Rewrite the snapshot manifest if already exists");
        System.err.println("  -chuser USERNAME        Change the owner of the files to the specified one.");
        System.err.println("  -chgroup GROUP          Change the group of the files to the specified one.");
        System.err.println("  -chmod MODE             Change the permission of the files to the specified one.");
        System.err.println("  -mappers                Number of mappers to use during the copy (mapreduce.job.maps).");
        System.err.println();
        System.err.println("Examples:");
        System.err.println("  hbase " + ((Object)((Object)this)).getClass().getName() + " \\");
        System.err.println("    -snapshot MySnapshot -copy-to hdfs://srv2:8082/hbase \\");
        System.err.println("    -chuser MyUser -chgroup MyGroup -chmod 700 -mappers 16");
        System.err.println();
        System.err.println("  hbase " + ((Object)((Object)this)).getClass().getName() + " \\");
        System.err.println("    -snapshot MySnapshot -copy-from hdfs://srv2:8082/hbase \\");
        System.err.println("    -copy-to hdfs://srv1:50070/hbase \\");
        System.exit(1);
    }

    static int innerMain(Configuration conf, String[] args) throws Exception {
        return ToolRunner.run((Configuration)conf, (Tool)new ExportSnapshot(), (String[])args);
    }

    public static void main(String[] args) throws Exception {
        System.exit(ExportSnapshot.innerMain(HBaseConfiguration.create(), args));
    }

    private static class ExportMapper
    extends Mapper<Text, NullWritable, NullWritable, NullWritable> {
        static final int REPORT_SIZE = 0x100000;
        static final int BUFFER_SIZE = 65536;
        private boolean testFailures;
        private Random random;
        private boolean verifyChecksum;
        private String filesGroup;
        private String filesUser;
        private short filesMode;
        private int bufferSize;
        private FileSystem outputFs;
        private Path outputArchive;
        private Path outputRoot;
        private FileSystem inputFs;
        private Path inputArchive;
        private Path inputRoot;

        private ExportMapper() {
        }

        public void setup(Mapper.Context context) throws IOException {
            Configuration conf = context.getConfiguration();
            this.verifyChecksum = conf.getBoolean(ExportSnapshot.CONF_CHECKSUM_VERIFY, true);
            this.filesGroup = conf.get(ExportSnapshot.CONF_FILES_GROUP);
            this.filesUser = conf.get(ExportSnapshot.CONF_FILES_USER);
            this.filesMode = (short)conf.getInt(ExportSnapshot.CONF_FILES_MODE, 0);
            this.outputRoot = new Path(conf.get(ExportSnapshot.CONF_OUTPUT_ROOT));
            this.inputRoot = new Path(conf.get(ExportSnapshot.CONF_INPUT_ROOT));
            this.inputArchive = new Path(this.inputRoot, "archive");
            this.outputArchive = new Path(this.outputRoot, "archive");
            this.testFailures = conf.getBoolean(ExportSnapshot.CONF_TEST_FAILURE, false);
            try {
                this.inputFs = FileSystem.get((URI)this.inputRoot.toUri(), (Configuration)conf);
            }
            catch (IOException e) {
                throw new IOException("Could not get the input FileSystem with root=" + this.inputRoot, e);
            }
            try {
                this.outputFs = FileSystem.get((URI)this.outputRoot.toUri(), (Configuration)conf);
            }
            catch (IOException e) {
                throw new IOException("Could not get the output FileSystem with root=" + this.outputRoot, e);
            }
            int defaultBlockSize = Math.max((int)this.outputFs.getDefaultBlockSize(), 65536);
            this.bufferSize = conf.getInt(ExportSnapshot.CONF_BUFFER_SIZE, defaultBlockSize);
            LOG.info((Object)("Using bufferSize=" + StringUtils.humanReadableInt((long)this.bufferSize)));
        }

        public void map(Text key, NullWritable value, Mapper.Context context) throws InterruptedException, IOException {
            Path inputPath = new Path(key.toString());
            Path outputPath = this.getOutputPath(inputPath);
            LOG.info((Object)("copy file input=" + inputPath + " output=" + outputPath));
            this.copyFile(context, inputPath, outputPath);
        }

        private Path getOutputPath(Path inputPath) throws IOException {
            Path path;
            if (HFileLink.isHFileLink(inputPath) || StoreFileInfo.isReference(inputPath)) {
                String family = inputPath.getParent().getName();
                TableName table = HFileLink.getReferencedTableName(inputPath.getName());
                String region = HFileLink.getReferencedRegionName(inputPath.getName());
                String hfile = HFileLink.getReferencedHFileName(inputPath.getName());
                path = new Path(FSUtils.getTableDir(new Path("./"), table), new Path(region, new Path(family, hfile)));
            } else if (ExportMapper.isHLogLinkPath(inputPath)) {
                String logName = inputPath.getName();
                path = new Path(new Path(this.outputRoot, "oldWALs"), logName);
            } else {
                path = inputPath;
            }
            return new Path(this.outputArchive, path);
        }

        private void injectTestFailure(Mapper.Context context, Path inputPath) throws IOException {
            if (this.testFailures) {
                if (context.getConfiguration().getBoolean(ExportSnapshot.CONF_TEST_RETRY, false)) {
                    if (this.random == null) {
                        this.random = new Random();
                    }
                    if ((double)this.random.nextFloat() < 0.03) {
                        throw new IOException("TEST RETRY FAILURE: Unable to copy input=" + inputPath + " time=" + System.currentTimeMillis());
                    }
                } else {
                    context.getCounter((Enum)Counter.COPY_FAILED).increment(1L);
                    throw new IOException("TEST FAILURE: Unable to copy input=" + inputPath);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void copyFile(Mapper.Context context, Path inputPath, Path outputPath) throws IOException {
            FileStatus outputStat;
            this.injectTestFailure(context, inputPath);
            FileStatus inputStat = this.getSourceFileStatus(context, inputPath);
            if (this.outputFs.exists(outputPath) && (outputStat = this.outputFs.getFileStatus(outputPath)) != null && this.sameFile(inputStat, outputStat)) {
                LOG.info((Object)("Skip copy " + inputPath + " to " + outputPath + ", same file."));
                return;
            }
            FSDataInputStream in = this.openSourceFile(context, inputPath);
            try {
                context.getCounter((Enum)Counter.BYTES_EXPECTED).increment(inputStat.getLen());
                this.outputFs.mkdirs(outputPath.getParent());
                FSDataOutputStream out = this.outputFs.create(outputPath, true);
                try {
                    this.copyData(context, inputPath, in, outputPath, out, inputStat.getLen());
                }
                finally {
                    out.close();
                }
                if (!this.preserveAttributes(outputPath, inputStat)) {
                    LOG.warn((Object)("You may have to run manually chown on: " + outputPath));
                }
            }
            finally {
                in.close();
            }
        }

        private boolean preserveAttributes(Path path, FileStatus refStat) {
            String group;
            FileStatus stat;
            try {
                stat = this.outputFs.getFileStatus(path);
            }
            catch (IOException e) {
                LOG.warn((Object)("Unable to get the status for file=" + path));
                return false;
            }
            try {
                if (this.filesMode > 0 && stat.getPermission().toShort() != this.filesMode) {
                    this.outputFs.setPermission(path, new FsPermission(this.filesMode));
                } else if (!stat.getPermission().equals((Object)refStat.getPermission())) {
                    this.outputFs.setPermission(path, refStat.getPermission());
                }
            }
            catch (IOException e) {
                LOG.warn((Object)("Unable to set the permission for file=" + stat.getPath() + ": " + e.getMessage()));
                return false;
            }
            String user = this.stringIsNotEmpty(this.filesUser) ? this.filesUser : refStat.getOwner();
            String string = group = this.stringIsNotEmpty(this.filesGroup) ? this.filesGroup : refStat.getGroup();
            if (this.stringIsNotEmpty(user) || this.stringIsNotEmpty(group)) {
                try {
                    if (!user.equals(stat.getOwner()) || !group.equals(stat.getGroup())) {
                        this.outputFs.setOwner(path, user, group);
                    }
                }
                catch (IOException e) {
                    LOG.warn((Object)("Unable to set the owner/group for file=" + stat.getPath() + ": " + e.getMessage()));
                    LOG.warn((Object)("The user/group may not exist on the destination cluster: user=" + user + " group=" + group));
                    return false;
                }
            }
            return true;
        }

        private boolean stringIsNotEmpty(String str) {
            return str != null && str.length() > 0;
        }

        private void copyData(Mapper.Context context, Path inputPath, FSDataInputStream in, Path outputPath, FSDataOutputStream out, long inputFileSize) throws IOException {
            String statusMessage = "copied %s/" + StringUtils.humanReadableInt((long)inputFileSize) + " (%.1f%%)";
            try {
                int bytesRead;
                byte[] buffer = new byte[this.bufferSize];
                long totalBytesWritten = 0L;
                int reportBytes = 0;
                long stime = System.currentTimeMillis();
                while ((bytesRead = in.read(buffer)) > 0) {
                    out.write(buffer, 0, bytesRead);
                    totalBytesWritten += (long)bytesRead;
                    if ((reportBytes += bytesRead) < 0x100000) continue;
                    context.getCounter((Enum)Counter.BYTES_COPIED).increment((long)reportBytes);
                    context.setStatus(String.format(statusMessage, StringUtils.humanReadableInt((long)totalBytesWritten), Float.valueOf((float)totalBytesWritten / (float)inputFileSize * 100.0f)) + " from " + inputPath + " to " + outputPath);
                    reportBytes = 0;
                }
                long etime = System.currentTimeMillis();
                context.getCounter((Enum)Counter.BYTES_COPIED).increment((long)reportBytes);
                context.setStatus(String.format(statusMessage, StringUtils.humanReadableInt((long)totalBytesWritten), Float.valueOf((float)totalBytesWritten / (float)inputFileSize * 100.0f)) + " from " + inputPath + " to " + outputPath);
                if (totalBytesWritten != inputFileSize) {
                    String msg = "number of bytes copied not matching copied=" + totalBytesWritten + " expected=" + inputFileSize + " for file=" + inputPath;
                    throw new IOException(msg);
                }
                LOG.info((Object)("copy completed for input=" + inputPath + " output=" + outputPath));
                LOG.info((Object)("size=" + totalBytesWritten + " (" + StringUtils.humanReadableInt((long)totalBytesWritten) + ")" + " time=" + StringUtils.formatTimeDiff((long)etime, (long)stime) + String.format(" %.3fM/sec", (double)totalBytesWritten / ((double)(etime - stime) / 1000.0) / 1048576.0)));
                context.getCounter((Enum)Counter.FILES_COPIED).increment(1L);
            }
            catch (IOException e) {
                LOG.error((Object)("Error copying " + inputPath + " to " + outputPath), (Throwable)e);
                context.getCounter((Enum)Counter.COPY_FAILED).increment(1L);
                throw e;
            }
        }

        private FSDataInputStream openSourceFile(Mapper.Context context, Path path) throws IOException {
            try {
                if (HFileLink.isHFileLink(path) || StoreFileInfo.isReference(path)) {
                    return new HFileLink(this.inputRoot, this.inputArchive, path).open(this.inputFs);
                }
                if (ExportMapper.isHLogLinkPath(path)) {
                    String serverName = path.getParent().getName();
                    String logName = path.getName();
                    return new HLogLink(this.inputRoot, serverName, logName).open(this.inputFs);
                }
                return this.inputFs.open(path);
            }
            catch (IOException e) {
                context.getCounter((Enum)Counter.MISSING_FILES).increment(1L);
                LOG.error((Object)("Unable to open source file=" + path), (Throwable)e);
                throw e;
            }
        }

        private FileStatus getSourceFileStatus(Mapper.Context context, Path path) throws IOException {
            try {
                if (HFileLink.isHFileLink(path) || StoreFileInfo.isReference(path)) {
                    HFileLink link = new HFileLink(this.inputRoot, this.inputArchive, path);
                    return link.getFileStatus(this.inputFs);
                }
                if (ExportMapper.isHLogLinkPath(path)) {
                    String serverName = path.getParent().getName();
                    String logName = path.getName();
                    return new HLogLink(this.inputRoot, serverName, logName).getFileStatus(this.inputFs);
                }
                return this.inputFs.getFileStatus(path);
            }
            catch (FileNotFoundException e) {
                context.getCounter((Enum)Counter.MISSING_FILES).increment(1L);
                LOG.error((Object)("Unable to get the status for source file=" + path), (Throwable)e);
                throw e;
            }
            catch (IOException e) {
                LOG.error((Object)("Unable to get the status for source file=" + path), (Throwable)e);
                throw e;
            }
        }

        private FileChecksum getFileChecksum(FileSystem fs, Path path) {
            try {
                return fs.getFileChecksum(path);
            }
            catch (IOException e) {
                LOG.warn((Object)("Unable to get checksum for file=" + path), (Throwable)e);
                return null;
            }
        }

        private boolean sameFile(FileStatus inputStat, FileStatus outputStat) {
            if (inputStat.getLen() != outputStat.getLen()) {
                return false;
            }
            if (!this.verifyChecksum) {
                return true;
            }
            FileChecksum inChecksum = this.getFileChecksum(this.inputFs, inputStat.getPath());
            if (inChecksum == null) {
                return false;
            }
            FileChecksum outChecksum = this.getFileChecksum(this.outputFs, outputStat.getPath());
            if (outChecksum == null) {
                return false;
            }
            return inChecksum.equals((Object)outChecksum);
        }

        private static boolean isHLogLinkPath(Path path) {
            return path.depth() == 2;
        }
    }

    public static enum Counter {
        MISSING_FILES,
        COPY_FAILED,
        BYTES_EXPECTED,
        BYTES_COPIED,
        FILES_COPIED;

    }
}

