/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.balancer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.ServerLoad;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.master.RackManager;
import org.apache.hadoop.hbase.master.RegionPlan;
import org.apache.hadoop.hbase.master.ServerManager;
import org.apache.hadoop.hbase.master.SnapshotOfRegionAssignmentFromMeta;
import org.apache.hadoop.hbase.master.balancer.BaseLoadBalancer;
import org.apache.hadoop.hbase.master.balancer.FavoredNodeAssignmentHelper;
import org.apache.hadoop.hbase.master.balancer.FavoredNodesPlan;
import org.apache.hadoop.hbase.util.Pair;

@InterfaceAudience.LimitedPrivate(value={"Configuration"})
public class FavoredNodeLoadBalancer
extends BaseLoadBalancer {
    private static final Log LOG = LogFactory.getLog(FavoredNodeLoadBalancer.class);
    private FavoredNodesPlan globalFavoredNodesAssignmentPlan;
    private RackManager rackManager;
    Configuration conf;

    @Override
    public void setConf(Configuration conf) {
        this.globalFavoredNodesAssignmentPlan = new FavoredNodesPlan();
        this.rackManager = new RackManager(conf);
        this.conf = conf;
    }

    @Override
    public List<RegionPlan> balanceCluster(Map<ServerName, List<HRegionInfo>> clusterState) {
        ArrayList<RegionPlan> plans = new ArrayList<RegionPlan>();
        SnapshotOfRegionAssignmentFromMeta snaphotOfRegionAssignment = new SnapshotOfRegionAssignmentFromMeta(this.services.getCatalogTracker());
        try {
            snaphotOfRegionAssignment.initialize();
        }
        catch (IOException ie) {
            LOG.warn((Object)("Not running balancer since exception was thrown " + ie));
            return plans;
        }
        this.globalFavoredNodesAssignmentPlan = snaphotOfRegionAssignment.getExistingAssignmentPlan();
        HashMap<ServerName, ServerName> serverNameToServerNameWithoutCode = new HashMap<ServerName, ServerName>();
        HashMap<ServerName, ServerName> serverNameWithoutCodeToServerName = new HashMap<ServerName, ServerName>();
        ServerManager serverMgr = this.services.getServerManager();
        for (ServerName serverName : serverMgr.getOnlineServersList()) {
            ServerName s = ServerName.valueOf((String)serverName.getHostname(), (int)serverName.getPort(), (long)-1L);
            serverNameToServerNameWithoutCode.put(serverName, s);
            serverNameWithoutCodeToServerName.put(s, serverName);
        }
        for (Map.Entry entry : clusterState.entrySet()) {
            ServerName currentServer = (ServerName)entry.getKey();
            ServerName currentServerWithoutStartCode = ServerName.valueOf((String)currentServer.getHostname(), (int)currentServer.getPort(), (long)-1L);
            List list = (List)entry.getValue();
            for (HRegionInfo region : list) {
                List<ServerName> favoredNodes;
                if (region.getTable().getNamespaceAsString().equals(NamespaceDescriptor.SYSTEM_NAMESPACE_NAME_STR) || (favoredNodes = this.globalFavoredNodesAssignmentPlan.getFavoredNodes(region)) == null || favoredNodes.get(0).equals((Object)currentServerWithoutStartCode)) continue;
                ServerName destination = null;
                destination = (ServerName)serverNameWithoutCodeToServerName.get(favoredNodes.get(0));
                if (destination == null) {
                    if (currentServerWithoutStartCode.equals((Object)favoredNodes.get(1)) || currentServerWithoutStartCode.equals((Object)favoredNodes.get(2))) continue;
                    ServerLoad l1 = this.services.getServerManager().getLoad((ServerName)serverNameWithoutCodeToServerName.get(favoredNodes.get(1)));
                    ServerLoad l2 = this.services.getServerManager().getLoad((ServerName)serverNameWithoutCodeToServerName.get(favoredNodes.get(2)));
                    if (l1 != null && l2 != null) {
                        destination = l1.getLoad() > l2.getLoad() ? (ServerName)serverNameWithoutCodeToServerName.get(favoredNodes.get(2)) : (ServerName)serverNameWithoutCodeToServerName.get(favoredNodes.get(1));
                    } else if (l1 != null) {
                        destination = (ServerName)serverNameWithoutCodeToServerName.get(favoredNodes.get(1));
                    } else if (l2 != null) {
                        destination = (ServerName)serverNameWithoutCodeToServerName.get(favoredNodes.get(2));
                    }
                }
                if (destination == null) continue;
                RegionPlan plan = new RegionPlan(region, currentServer, destination);
                plans.add(plan);
            }
        }
        return plans;
    }

    @Override
    public Map<ServerName, List<HRegionInfo>> roundRobinAssignment(List<HRegionInfo> regions, List<ServerName> servers) {
        Map<ServerName, List<HRegionInfo>> assignmentMap;
        try {
            FavoredNodeAssignmentHelper assignmentHelper = new FavoredNodeAssignmentHelper(servers, this.rackManager);
            assignmentHelper.initialize();
            if (!assignmentHelper.canPlaceFavoredNodes()) {
                return super.roundRobinAssignment(regions, servers);
            }
            Pair<Map<ServerName, List<HRegionInfo>>, List<HRegionInfo>> segregatedRegions = this.segregateRegionsAndAssignRegionsWithFavoredNodes(regions, servers);
            Map regionsWithFavoredNodesMap = (Map)segregatedRegions.getFirst();
            List regionsWithNoFavoredNodes = (List)segregatedRegions.getSecond();
            assignmentMap = new HashMap<ServerName, List<HRegionInfo>>();
            this.roundRobinAssignmentImpl(assignmentHelper, assignmentMap, regionsWithNoFavoredNodes, servers);
            assignmentMap.putAll(regionsWithFavoredNodesMap);
        }
        catch (Exception ex) {
            LOG.warn((Object)("Encountered exception while doing favored-nodes assignment " + ex + " Falling back to regular assignment"));
            assignmentMap = super.roundRobinAssignment(regions, servers);
        }
        return assignmentMap;
    }

    @Override
    public ServerName randomAssignment(HRegionInfo regionInfo, List<ServerName> servers) {
        try {
            FavoredNodeAssignmentHelper assignmentHelper = new FavoredNodeAssignmentHelper(servers, this.rackManager);
            assignmentHelper.initialize();
            ServerName primary = super.randomAssignment(regionInfo, servers);
            if (!assignmentHelper.canPlaceFavoredNodes()) {
                return primary;
            }
            List<ServerName> favoredNodes = this.globalFavoredNodesAssignmentPlan.getFavoredNodes(regionInfo);
            if (favoredNodes != null) {
                for (ServerName s : favoredNodes) {
                    ServerName serverWithLegitStartCode = this.availableServersContains(servers, s);
                    if (serverWithLegitStartCode == null) continue;
                    return serverWithLegitStartCode;
                }
            }
            ArrayList<HRegionInfo> regions = new ArrayList<HRegionInfo>(1);
            regions.add(regionInfo);
            HashMap<HRegionInfo, ServerName> primaryRSMap = new HashMap<HRegionInfo, ServerName>(1);
            primaryRSMap.put(regionInfo, primary);
            this.assignSecondaryAndTertiaryNodesForRegion(assignmentHelper, regions, primaryRSMap);
            return primary;
        }
        catch (Exception ex) {
            LOG.warn((Object)("Encountered exception while doing favored-nodes (random)assignment " + ex + " Falling back to regular assignment"));
            return super.randomAssignment(regionInfo, servers);
        }
    }

    private Pair<Map<ServerName, List<HRegionInfo>>, List<HRegionInfo>> segregateRegionsAndAssignRegionsWithFavoredNodes(List<HRegionInfo> regions, List<ServerName> availableServers) {
        HashMap<ServerName, List<HRegionInfo>> assignmentMapForFavoredNodes = new HashMap<ServerName, List<HRegionInfo>>(regions.size() / 2);
        ArrayList<HRegionInfo> regionsWithNoFavoredNodes = new ArrayList<HRegionInfo>(regions.size() / 2);
        for (HRegionInfo region : regions) {
            List<ServerName> favoredNodes = this.globalFavoredNodesAssignmentPlan.getFavoredNodes(region);
            ServerName primaryHost = null;
            ServerName secondaryHost = null;
            ServerName tertiaryHost = null;
            if (favoredNodes != null) {
                for (ServerName s : favoredNodes) {
                    ServerName serverWithLegitStartCode = this.availableServersContains(availableServers, s);
                    if (serverWithLegitStartCode == null) continue;
                    FavoredNodesPlan.Position position = FavoredNodesPlan.getFavoredServerPosition(favoredNodes, s);
                    if (FavoredNodesPlan.Position.PRIMARY.equals((Object)position)) {
                        primaryHost = serverWithLegitStartCode;
                        continue;
                    }
                    if (FavoredNodesPlan.Position.SECONDARY.equals((Object)position)) {
                        secondaryHost = serverWithLegitStartCode;
                        continue;
                    }
                    if (!FavoredNodesPlan.Position.TERTIARY.equals((Object)position)) continue;
                    tertiaryHost = serverWithLegitStartCode;
                }
                this.assignRegionToAvailableFavoredNode(assignmentMapForFavoredNodes, region, primaryHost, secondaryHost, tertiaryHost);
            }
            if (primaryHost != null || secondaryHost != null || tertiaryHost != null) continue;
            regionsWithNoFavoredNodes.add(region);
        }
        return new Pair(assignmentMapForFavoredNodes, regionsWithNoFavoredNodes);
    }

    private ServerName availableServersContains(List<ServerName> servers, ServerName favoredNode) {
        for (ServerName server : servers) {
            if (!ServerName.isSameHostnameAndPort((ServerName)favoredNode, (ServerName)server)) continue;
            return server;
        }
        return null;
    }

    private void assignRegionToAvailableFavoredNode(Map<ServerName, List<HRegionInfo>> assignmentMapForFavoredNodes, HRegionInfo region, ServerName primaryHost, ServerName secondaryHost, ServerName tertiaryHost) {
        if (primaryHost != null) {
            this.addRegionToMap(assignmentMapForFavoredNodes, region, primaryHost);
        } else if (secondaryHost != null && tertiaryHost != null) {
            ServerLoad tertiaryLoad = this.services.getServerManager().getLoad(tertiaryHost);
            ServerLoad secondaryLoad = this.services.getServerManager().getLoad(secondaryHost);
            ServerName s = secondaryLoad.getLoad() < tertiaryLoad.getLoad() ? secondaryHost : tertiaryHost;
            this.addRegionToMap(assignmentMapForFavoredNodes, region, s);
        } else if (secondaryHost != null) {
            this.addRegionToMap(assignmentMapForFavoredNodes, region, secondaryHost);
        } else if (tertiaryHost != null) {
            this.addRegionToMap(assignmentMapForFavoredNodes, region, tertiaryHost);
        }
    }

    private void addRegionToMap(Map<ServerName, List<HRegionInfo>> assignmentMapForFavoredNodes, HRegionInfo region, ServerName host) {
        List<HRegionInfo> regionsOnServer = null;
        regionsOnServer = assignmentMapForFavoredNodes.get(host);
        if (regionsOnServer == null) {
            regionsOnServer = new ArrayList<HRegionInfo>();
            assignmentMapForFavoredNodes.put(host, regionsOnServer);
        }
        regionsOnServer.add(region);
    }

    public List<ServerName> getFavoredNodes(HRegionInfo regionInfo) {
        return this.globalFavoredNodesAssignmentPlan.getFavoredNodes(regionInfo);
    }

    private void roundRobinAssignmentImpl(FavoredNodeAssignmentHelper assignmentHelper, Map<ServerName, List<HRegionInfo>> assignmentMap, List<HRegionInfo> regions, List<ServerName> servers) {
        HashMap<HRegionInfo, ServerName> primaryRSMap = new HashMap<HRegionInfo, ServerName>();
        assignmentHelper.placePrimaryRSAsRoundRobin(assignmentMap, primaryRSMap, regions);
        this.assignSecondaryAndTertiaryNodesForRegion(assignmentHelper, regions, primaryRSMap);
    }

    private void assignSecondaryAndTertiaryNodesForRegion(FavoredNodeAssignmentHelper assignmentHelper, List<HRegionInfo> regions, Map<HRegionInfo, ServerName> primaryRSMap) {
        Map<HRegionInfo, ServerName[]> secondaryAndTertiaryRSMap = assignmentHelper.placeSecondaryAndTertiaryRS(primaryRSMap);
        for (HRegionInfo region : regions) {
            ArrayList<ServerName> favoredNodesForRegion = new ArrayList<ServerName>(3);
            ServerName sn = primaryRSMap.get(region);
            favoredNodesForRegion.add(ServerName.valueOf((String)sn.getHostname(), (int)sn.getPort(), (long)-1L));
            ServerName[] secondaryAndTertiaryNodes = secondaryAndTertiaryRSMap.get(region);
            if (secondaryAndTertiaryNodes != null) {
                favoredNodesForRegion.add(ServerName.valueOf((String)secondaryAndTertiaryNodes[0].getHostname(), (int)secondaryAndTertiaryNodes[0].getPort(), (long)-1L));
                favoredNodesForRegion.add(ServerName.valueOf((String)secondaryAndTertiaryNodes[1].getHostname(), (int)secondaryAndTertiaryNodes[1].getPort(), (long)-1L));
            }
            this.globalFavoredNodesAssignmentPlan.updateFavoredNodesMap(region, favoredNodesForRegion);
        }
    }
}

