/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.NavigableMap;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.protobuf.generated.MultiRowMutationProtos;
import org.apache.hadoop.hbase.regionserver.BaseRowProcessor;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.MiniBatchOperationInProgress;
import org.apache.hadoop.hbase.regionserver.OperationStatus;
import org.apache.hadoop.hbase.regionserver.RegionCoprocessorHost;
import org.apache.hadoop.hbase.regionserver.wal.WALEdit;
import org.apache.hadoop.hbase.util.Bytes;

@InterfaceAudience.Private
class MultiRowMutationProcessor
extends BaseRowProcessor<MultiRowMutationProtos.MultiRowMutationProcessorRequest, MultiRowMutationProtos.MultiRowMutationProcessorResponse> {
    Collection<byte[]> rowsToLock;
    Collection<Mutation> mutations;
    MiniBatchOperationInProgress<Mutation> miniBatch;

    MultiRowMutationProcessor(Collection<Mutation> mutations, Collection<byte[]> rowsToLock) {
        this.rowsToLock = rowsToLock;
        this.mutations = mutations;
    }

    @Override
    public Collection<byte[]> getRowsToLock() {
        return this.rowsToLock;
    }

    @Override
    public boolean readOnly() {
        return false;
    }

    @Override
    public MultiRowMutationProtos.MultiRowMutationProcessorResponse getResult() {
        return MultiRowMutationProtos.MultiRowMutationProcessorResponse.getDefaultInstance();
    }

    @Override
    public void process(long now, HRegion region, List<Mutation> mutationsToApply, WALEdit walEdit) throws IOException {
        byte[] byteNow = Bytes.toBytes((long)now);
        for (Mutation m : this.mutations) {
            if (m instanceof Put) {
                NavigableMap familyMap = m.getFamilyCellMap();
                region.checkFamilies(familyMap.keySet());
                region.checkTimestamps(familyMap, now);
                region.updateKVTimestamps(familyMap.values(), byteNow);
            } else if (m instanceof Delete) {
                Delete d = (Delete)m;
                region.prepareDelete(d);
                region.prepareDeleteTimestamps((Mutation)d, d.getFamilyCellMap(), byteNow);
            } else {
                throw new DoNotRetryIOException("Action must be Put or Delete. But was: " + m.getClass().getName());
            }
            mutationsToApply.add(m);
        }
        for (Mutation m : this.mutations) {
            for (List cells : m.getFamilyCellMap().values()) {
                boolean writeToWAL = m.getDurability() != Durability.SKIP_WAL;
                for (Cell cell : cells) {
                    KeyValue kv = KeyValueUtil.ensureKeyValue((Cell)cell);
                    if (!writeToWAL) continue;
                    walEdit.add(kv);
                }
            }
        }
    }

    @Override
    public void preProcess(HRegion region, WALEdit walEdit) throws IOException {
        RegionCoprocessorHost coprocessorHost = region.getCoprocessorHost();
        if (coprocessorHost != null) {
            for (Mutation m : this.mutations) {
                if (m instanceof Put) {
                    if (!coprocessorHost.prePut((Put)m, walEdit, m.getDurability())) continue;
                    return;
                }
                if (!(m instanceof Delete)) continue;
                Delete d = (Delete)m;
                region.prepareDelete(d);
                if (!coprocessorHost.preDelete(d, walEdit, d.getDurability())) continue;
                return;
            }
        }
    }

    @Override
    public void preBatchMutate(HRegion region, WALEdit walEdit) throws IOException {
        RegionCoprocessorHost coprocessorHost = region.getCoprocessorHost();
        Object[] opStatus = new OperationStatus[this.mutations.size()];
        Arrays.fill(opStatus, OperationStatus.NOT_RUN);
        WALEdit[] walEditsFromCP = new WALEdit[this.mutations.size()];
        if (coprocessorHost != null) {
            this.miniBatch = new MiniBatchOperationInProgress<Mutation>(this.mutations.toArray(new Mutation[this.mutations.size()]), (OperationStatus[])opStatus, walEditsFromCP, 0, this.mutations.size());
            coprocessorHost.preBatchMutate(this.miniBatch);
        }
        for (int i = 0; i < this.mutations.size(); ++i) {
            if (opStatus[i] != OperationStatus.NOT_RUN || walEditsFromCP[i] == null) continue;
            for (KeyValue walKv : walEditsFromCP[i].getKeyValues()) {
                walEdit.add(walKv);
            }
        }
    }

    @Override
    public void postBatchMutate(HRegion region) throws IOException {
        RegionCoprocessorHost coprocessorHost = region.getCoprocessorHost();
        if (coprocessorHost != null) {
            assert (this.miniBatch != null);
            coprocessorHost.postBatchMutate(this.miniBatch);
        }
    }

    @Override
    public void postProcess(HRegion region, WALEdit walEdit, boolean success) throws IOException {
        RegionCoprocessorHost coprocessorHost = region.getCoprocessorHost();
        if (coprocessorHost != null) {
            for (Mutation m : this.mutations) {
                if (m instanceof Put) {
                    coprocessorHost.postPut((Put)m, walEdit, m.getDurability());
                    continue;
                }
                if (!(m instanceof Delete)) continue;
                coprocessorHost.postDelete((Delete)m, walEdit, m.getDurability());
            }
            if (this.miniBatch != null) {
                coprocessorHost.postBatchMutateIndispensably(this.miniBatch, success);
            }
        }
    }

    @Override
    public MultiRowMutationProtos.MultiRowMutationProcessorRequest getRequestData() {
        return MultiRowMutationProtos.MultiRowMutationProcessorRequest.getDefaultInstance();
    }

    @Override
    public void initialize(MultiRowMutationProtos.MultiRowMutationProcessorRequest msg) {
    }

    @Override
    public Durability useDurability() {
        Durability durability = Durability.USE_DEFAULT;
        for (Mutation m : this.mutations) {
            if (m.getDurability().ordinal() <= durability.ordinal()) continue;
            durability = m.getDurability();
        }
        return durability;
    }
}

