/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.http;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.http.HttpServer;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.junit.Assert;

public class HttpServerFunctionalTest
extends Assert {
    public static final String TEST_BUILD_WEBAPPS = "test.build.webapps";
    private static final String BUILD_WEBAPPS_DIR = "build/test/webapps";
    private static final String TEST = "test";

    public static HttpServer createTestServer() throws IOException {
        HttpServerFunctionalTest.prepareTestWebapp();
        return HttpServerFunctionalTest.createServer(TEST);
    }

    public static HttpServer createTestServer(Configuration conf) throws IOException {
        HttpServerFunctionalTest.prepareTestWebapp();
        return HttpServerFunctionalTest.createServer(TEST, conf);
    }

    public static HttpServer createTestServer(Configuration conf, AccessControlList adminsAcl) throws IOException {
        HttpServerFunctionalTest.prepareTestWebapp();
        return HttpServerFunctionalTest.createServer(TEST, conf, adminsAcl);
    }

    public static HttpServer createTestServer(Configuration conf, String[] pathSpecs) throws IOException {
        HttpServerFunctionalTest.prepareTestWebapp();
        return HttpServerFunctionalTest.createServer(TEST, conf, pathSpecs);
    }

    protected static void prepareTestWebapp() {
        String webapps = System.getProperty(TEST_BUILD_WEBAPPS, BUILD_WEBAPPS_DIR);
        File testWebappDir = new File(webapps + File.separatorChar + TEST);
        try {
            if (!testWebappDir.exists()) {
                HttpServerFunctionalTest.fail((String)("Test webapp dir " + testWebappDir.getCanonicalPath() + " missing"));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static HttpServer createServer(String host, int port) throws IOException {
        HttpServerFunctionalTest.prepareTestWebapp();
        return new HttpServer.Builder().setName(TEST).addEndpoint(URI.create("http://" + host + ":" + port)).setFindPort(true).build();
    }

    public static HttpServer createServer(String webapp) throws IOException {
        return HttpServerFunctionalTest.localServerBuilder(webapp).setFindPort(true).build();
    }

    public static HttpServer createServer(String webapp, Configuration conf) throws IOException {
        return HttpServerFunctionalTest.localServerBuilder(webapp).setFindPort(true).setConf(conf).build();
    }

    public static HttpServer createServer(String webapp, Configuration conf, AccessControlList adminsAcl) throws IOException {
        return HttpServerFunctionalTest.localServerBuilder(webapp).setFindPort(true).setConf(conf).setACL(adminsAcl).build();
    }

    private static HttpServer.Builder localServerBuilder(String webapp) {
        return new HttpServer.Builder().setName(webapp).addEndpoint(URI.create("http://localhost:0"));
    }

    public static HttpServer createServer(String webapp, Configuration conf, String[] pathSpecs) throws IOException {
        return HttpServerFunctionalTest.localServerBuilder(webapp).setFindPort(true).setConf(conf).setPathSpec(pathSpecs).build();
    }

    public static HttpServer createAndStartTestServer() throws IOException {
        HttpServer server = HttpServerFunctionalTest.createTestServer();
        server.start();
        return server;
    }

    public static void stop(HttpServer server) throws Exception {
        if (server != null) {
            server.stop();
        }
    }

    public static URL getServerURL(HttpServer server) throws MalformedURLException {
        HttpServerFunctionalTest.assertNotNull((String)"No server", (Object)server);
        return new URL("http://" + NetUtils.getHostPortString((InetSocketAddress)server.getConnectorAddress(0)));
    }

    protected static String readOutput(URL url) throws IOException {
        StringBuilder out = new StringBuilder();
        InputStream in = url.openConnection().getInputStream();
        byte[] buffer = new byte[65536];
        int len = in.read(buffer);
        while (len > 0) {
            out.append(new String(buffer, 0, len));
            len = in.read(buffer);
        }
        return out.toString();
    }
}

