/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.NavigableSet;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseTestCase;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.KeepDeletedCells;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.regionserver.ScanInfo;
import org.apache.hadoop.hbase.regionserver.ScanQueryMatcher;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestQueryMatcher
extends HBaseTestCase {
    private static final boolean PRINT = false;
    private byte[] row1;
    private byte[] row2;
    private byte[] row3;
    private byte[] fam1;
    private byte[] fam2;
    private byte[] col1;
    private byte[] col2;
    private byte[] col3;
    private byte[] col4;
    private byte[] col5;
    private byte[] data;
    private Get get;
    long ttl = Long.MAX_VALUE;
    KeyValue.KVComparator rowComparator;
    private Scan scan;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.row1 = Bytes.toBytes((String)"row1");
        this.row2 = Bytes.toBytes((String)"row2");
        this.row3 = Bytes.toBytes((String)"row3");
        this.fam1 = Bytes.toBytes((String)"fam1");
        this.fam2 = Bytes.toBytes((String)"fam2");
        this.col1 = Bytes.toBytes((String)"col1");
        this.col2 = Bytes.toBytes((String)"col2");
        this.col3 = Bytes.toBytes((String)"col3");
        this.col4 = Bytes.toBytes((String)"col4");
        this.col5 = Bytes.toBytes((String)"col5");
        this.data = Bytes.toBytes((String)"data");
        this.get = new Get(this.row1);
        this.get.addFamily(this.fam1);
        this.get.addColumn(this.fam2, this.col2);
        this.get.addColumn(this.fam2, this.col4);
        this.get.addColumn(this.fam2, this.col5);
        this.scan = new Scan(this.get);
        this.rowComparator = KeyValue.COMPARATOR;
    }

    private void _testMatch_ExplicitColumns(Scan scan, List<ScanQueryMatcher.MatchCode> expected) throws IOException {
        long now = EnvironmentEdgeManager.currentTime();
        ScanQueryMatcher qm = new ScanQueryMatcher(scan, new ScanInfo(this.conf, this.fam2, 0, 1, this.ttl, KeepDeletedCells.FALSE, 0L, this.rowComparator), (NavigableSet)this.get.getFamilyMap().get(this.fam2), now - this.ttl, now);
        ArrayList<KeyValue> memstore = new ArrayList<KeyValue>();
        memstore.add(new KeyValue(this.row1, this.fam2, this.col1, 1L, this.data));
        memstore.add(new KeyValue(this.row1, this.fam2, this.col2, 1L, this.data));
        memstore.add(new KeyValue(this.row1, this.fam2, this.col3, 1L, this.data));
        memstore.add(new KeyValue(this.row1, this.fam2, this.col4, 1L, this.data));
        memstore.add(new KeyValue(this.row1, this.fam2, this.col5, 1L, this.data));
        memstore.add(new KeyValue(this.row2, this.fam1, this.col1, this.data));
        ArrayList<ScanQueryMatcher.MatchCode> actual = new ArrayList<ScanQueryMatcher.MatchCode>();
        KeyValue k = (KeyValue)memstore.get(0);
        qm.setRow(k.getRowArray(), k.getRowOffset(), k.getRowLength());
        for (KeyValue kv : memstore) {
            actual.add(qm.match((Cell)kv));
        }
        TestQueryMatcher.assertEquals((int)expected.size(), (int)actual.size());
        for (int i = 0; i < expected.size(); ++i) {
            TestQueryMatcher.assertEquals((Object)expected.get(i), actual.get(i));
        }
    }

    public void testMatch_ExplicitColumns() throws IOException {
        ArrayList<ScanQueryMatcher.MatchCode> expected = new ArrayList<ScanQueryMatcher.MatchCode>();
        expected.add(ScanQueryMatcher.MatchCode.SEEK_NEXT_COL);
        expected.add(ScanQueryMatcher.MatchCode.INCLUDE_AND_SEEK_NEXT_COL);
        expected.add(ScanQueryMatcher.MatchCode.SEEK_NEXT_COL);
        expected.add(ScanQueryMatcher.MatchCode.INCLUDE_AND_SEEK_NEXT_COL);
        expected.add(ScanQueryMatcher.MatchCode.INCLUDE_AND_SEEK_NEXT_ROW);
        expected.add(ScanQueryMatcher.MatchCode.DONE);
        this._testMatch_ExplicitColumns(this.scan, expected);
    }

    public void testMatch_Wildcard() throws IOException {
        ArrayList<ScanQueryMatcher.MatchCode> expected = new ArrayList<ScanQueryMatcher.MatchCode>();
        expected.add(ScanQueryMatcher.MatchCode.INCLUDE);
        expected.add(ScanQueryMatcher.MatchCode.INCLUDE);
        expected.add(ScanQueryMatcher.MatchCode.INCLUDE);
        expected.add(ScanQueryMatcher.MatchCode.INCLUDE);
        expected.add(ScanQueryMatcher.MatchCode.INCLUDE);
        expected.add(ScanQueryMatcher.MatchCode.DONE);
        long now = EnvironmentEdgeManager.currentTime();
        ScanQueryMatcher qm = new ScanQueryMatcher(this.scan, new ScanInfo(this.conf, this.fam2, 0, 1, this.ttl, KeepDeletedCells.FALSE, 0L, this.rowComparator), null, now - this.ttl, now);
        ArrayList<KeyValue> memstore = new ArrayList<KeyValue>();
        memstore.add(new KeyValue(this.row1, this.fam2, this.col1, 1L, this.data));
        memstore.add(new KeyValue(this.row1, this.fam2, this.col2, 1L, this.data));
        memstore.add(new KeyValue(this.row1, this.fam2, this.col3, 1L, this.data));
        memstore.add(new KeyValue(this.row1, this.fam2, this.col4, 1L, this.data));
        memstore.add(new KeyValue(this.row1, this.fam2, this.col5, 1L, this.data));
        memstore.add(new KeyValue(this.row2, this.fam1, this.col1, 1L, this.data));
        ArrayList<ScanQueryMatcher.MatchCode> actual = new ArrayList<ScanQueryMatcher.MatchCode>();
        KeyValue k = (KeyValue)memstore.get(0);
        qm.setRow(k.getRowArray(), k.getRowOffset(), k.getRowLength());
        for (KeyValue kv : memstore) {
            actual.add(qm.match((Cell)kv));
        }
        TestQueryMatcher.assertEquals((int)expected.size(), (int)actual.size());
        for (int i = 0; i < expected.size(); ++i) {
            TestQueryMatcher.assertEquals(expected.get(i), actual.get(i));
        }
    }

    public void testMatch_ExpiredExplicit() throws IOException {
        long testTTL = 1000L;
        ScanQueryMatcher.MatchCode[] expected = new ScanQueryMatcher.MatchCode[]{ScanQueryMatcher.MatchCode.SEEK_NEXT_COL, ScanQueryMatcher.MatchCode.INCLUDE_AND_SEEK_NEXT_COL, ScanQueryMatcher.MatchCode.SEEK_NEXT_COL, ScanQueryMatcher.MatchCode.INCLUDE_AND_SEEK_NEXT_COL, ScanQueryMatcher.MatchCode.SEEK_NEXT_ROW, ScanQueryMatcher.MatchCode.DONE};
        long now = EnvironmentEdgeManager.currentTime();
        ScanQueryMatcher qm = new ScanQueryMatcher(this.scan, new ScanInfo(this.conf, this.fam2, 0, 1, testTTL, KeepDeletedCells.FALSE, 0L, this.rowComparator), (NavigableSet)this.get.getFamilyMap().get(this.fam2), now - testTTL, now);
        KeyValue[] kvs = new KeyValue[]{new KeyValue(this.row1, this.fam2, this.col1, now - 100L, this.data), new KeyValue(this.row1, this.fam2, this.col2, now - 50L, this.data), new KeyValue(this.row1, this.fam2, this.col3, now - 5000L, this.data), new KeyValue(this.row1, this.fam2, this.col4, now - 500L, this.data), new KeyValue(this.row1, this.fam2, this.col5, now - 10000L, this.data), new KeyValue(this.row2, this.fam1, this.col1, now - 10L, this.data)};
        KeyValue k = kvs[0];
        qm.setRow(k.getRowArray(), k.getRowOffset(), k.getRowLength());
        ArrayList<ScanQueryMatcher.MatchCode> actual = new ArrayList<ScanQueryMatcher.MatchCode>(kvs.length);
        for (KeyValue kv : kvs) {
            actual.add(qm.match((Cell)kv));
        }
        TestQueryMatcher.assertEquals((int)expected.length, (int)actual.size());
        for (int i = 0; i < expected.length; ++i) {
            TestQueryMatcher.assertEquals((Object)expected[i], actual.get(i));
        }
    }

    public void testMatch_ExpiredWildcard() throws IOException {
        long testTTL = 1000L;
        ScanQueryMatcher.MatchCode[] expected = new ScanQueryMatcher.MatchCode[]{ScanQueryMatcher.MatchCode.INCLUDE, ScanQueryMatcher.MatchCode.INCLUDE, ScanQueryMatcher.MatchCode.SEEK_NEXT_COL, ScanQueryMatcher.MatchCode.INCLUDE, ScanQueryMatcher.MatchCode.SEEK_NEXT_COL, ScanQueryMatcher.MatchCode.DONE};
        long now = EnvironmentEdgeManager.currentTime();
        ScanQueryMatcher qm = new ScanQueryMatcher(this.scan, new ScanInfo(this.conf, this.fam2, 0, 1, testTTL, KeepDeletedCells.FALSE, 0L, this.rowComparator), null, now - testTTL, now);
        KeyValue[] kvs = new KeyValue[]{new KeyValue(this.row1, this.fam2, this.col1, now - 100L, this.data), new KeyValue(this.row1, this.fam2, this.col2, now - 50L, this.data), new KeyValue(this.row1, this.fam2, this.col3, now - 5000L, this.data), new KeyValue(this.row1, this.fam2, this.col4, now - 500L, this.data), new KeyValue(this.row1, this.fam2, this.col5, now - 10000L, this.data), new KeyValue(this.row2, this.fam1, this.col1, now - 10L, this.data)};
        KeyValue k = kvs[0];
        qm.setRow(k.getRowArray(), k.getRowOffset(), k.getRowLength());
        ArrayList<ScanQueryMatcher.MatchCode> actual = new ArrayList<ScanQueryMatcher.MatchCode>(kvs.length);
        for (KeyValue kv : kvs) {
            actual.add(qm.match((Cell)kv));
        }
        TestQueryMatcher.assertEquals((int)expected.length, (int)actual.size());
        for (int i = 0; i < expected.length; ++i) {
            TestQueryMatcher.assertEquals((Object)expected[i], actual.get(i));
        }
    }

    public void testMatch_PartialRangeDropDeletes() throws Exception {
        this.testDropDeletes(this.row2, this.row3, new byte[][]{this.row1, this.row2, this.row2, this.row3}, ScanQueryMatcher.MatchCode.INCLUDE, ScanQueryMatcher.MatchCode.SKIP, ScanQueryMatcher.MatchCode.SKIP, ScanQueryMatcher.MatchCode.INCLUDE);
        this.testDropDeletes(this.row2, this.row3, new byte[][]{this.row1, this.row1, this.row2}, ScanQueryMatcher.MatchCode.INCLUDE, ScanQueryMatcher.MatchCode.INCLUDE, ScanQueryMatcher.MatchCode.SKIP);
        this.testDropDeletes(this.row2, this.row3, new byte[][]{this.row2, this.row3, this.row3}, ScanQueryMatcher.MatchCode.SKIP, ScanQueryMatcher.MatchCode.INCLUDE, ScanQueryMatcher.MatchCode.INCLUDE);
        this.testDropDeletes(this.row1, this.row3, new byte[][]{this.row1, this.row2, this.row3}, ScanQueryMatcher.MatchCode.SKIP, ScanQueryMatcher.MatchCode.SKIP, ScanQueryMatcher.MatchCode.INCLUDE);
        this.testDropDeletes(HConstants.EMPTY_START_ROW, this.row3, new byte[][]{this.row1, this.row2, this.row3}, ScanQueryMatcher.MatchCode.SKIP, ScanQueryMatcher.MatchCode.SKIP, ScanQueryMatcher.MatchCode.INCLUDE);
        this.testDropDeletes(this.row2, HConstants.EMPTY_END_ROW, new byte[][]{this.row1, this.row2, this.row3}, ScanQueryMatcher.MatchCode.INCLUDE, ScanQueryMatcher.MatchCode.SKIP, ScanQueryMatcher.MatchCode.SKIP);
        this.testDropDeletes(HConstants.EMPTY_START_ROW, HConstants.EMPTY_END_ROW, new byte[][]{this.row1, this.row2, this.row3, this.row3}, ScanQueryMatcher.MatchCode.SKIP, ScanQueryMatcher.MatchCode.SKIP, ScanQueryMatcher.MatchCode.SKIP, ScanQueryMatcher.MatchCode.SKIP);
        this.testDropDeletes(this.row2, this.row3, new byte[][]{this.row1, this.row1, this.row3}, ScanQueryMatcher.MatchCode.INCLUDE, ScanQueryMatcher.MatchCode.INCLUDE, ScanQueryMatcher.MatchCode.INCLUDE);
        this.testDropDeletes(this.row2, this.row3, new byte[][]{this.row3, this.row3}, ScanQueryMatcher.MatchCode.INCLUDE, ScanQueryMatcher.MatchCode.INCLUDE);
        this.testDropDeletes(this.row2, this.row3, new byte[][]{this.row1, this.row1}, ScanQueryMatcher.MatchCode.INCLUDE, ScanQueryMatcher.MatchCode.INCLUDE);
    }

    private void testDropDeletes(byte[] from, byte[] to, byte[][] rows, ScanQueryMatcher.MatchCode ... expected) throws IOException {
        long now = EnvironmentEdgeManager.currentTime();
        ScanInfo scanInfo = new ScanInfo(this.conf, this.fam2, 0, 1, this.ttl, KeepDeletedCells.FALSE, -1L, this.rowComparator);
        NavigableSet cols = (NavigableSet)this.get.getFamilyMap().get(this.fam2);
        ScanQueryMatcher qm = new ScanQueryMatcher(this.scan, scanInfo, cols, Long.MAX_VALUE, Long.MIN_VALUE, Long.MIN_VALUE, now, from, to, null);
        ArrayList<ScanQueryMatcher.MatchCode> actual = new ArrayList<ScanQueryMatcher.MatchCode>(rows.length);
        byte[] prevRow = null;
        for (byte[] row : rows) {
            if (prevRow == null || !Bytes.equals(prevRow, (byte[])row)) {
                qm.setRow(row, 0, (short)row.length);
                prevRow = row;
            }
            actual.add(qm.match((Cell)new KeyValue(row, this.fam2, null, now, KeyValue.Type.Delete)));
        }
        TestQueryMatcher.assertEquals((int)expected.length, (int)actual.size());
        for (int i = 0; i < expected.length; ++i) {
            TestQueryMatcher.assertEquals((Object)expected[i], actual.get(i));
        }
    }
}

