/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.mapreduce.replication.VerifyReplication;
import org.apache.hadoop.hbase.protobuf.generated.WALProtos;
import org.apache.hadoop.hbase.regionserver.wal.WALEdit;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfig;
import org.apache.hadoop.hbase.replication.TestReplicationBase;
import org.apache.hadoop.hbase.replication.regionserver.Replication;
import org.apache.hadoop.hbase.replication.regionserver.ReplicationSource;
import org.apache.hadoop.hbase.replication.regionserver.ReplicationSourceInterface;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.apache.hadoop.hbase.wal.DefaultWALProvider;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALKey;
import org.apache.hadoop.mapreduce.Job;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={LargeTests.class})
public class TestReplicationSmallTests
extends TestReplicationBase {
    private static final Log LOG = LogFactory.getLog(TestReplicationSmallTests.class);
    private static final String PEER_ID = "2";

    @Before
    public void setUp() throws Exception {
        for (JVMClusterUtil.RegionServerThread r : utility1.getHBaseCluster().getRegionServerThreads()) {
            utility1.getHBaseAdmin().rollWALWriter(r.getRegionServer().getServerName());
        }
        int rowCount = utility1.countRows(tableName);
        utility1.deleteTableData(tableName);
        Scan scan = new Scan();
        int lastCount = 0;
        for (int i = 0; i < 10; ++i) {
            if (i == 9) {
                Assert.fail((String)"Waited too much time for truncate");
            }
            ResultScanner scanner = htable2.getScanner(scan);
            Result[] res = scanner.next(rowCount);
            scanner.close();
            if (res.length == 0) break;
            if (res.length < lastCount) {
                --i;
            }
            lastCount = res.length;
            LOG.info((Object)("Still got " + res.length + " rows"));
            Thread.sleep(500L);
        }
    }

    @Test(timeout=300000L)
    public void testDeleteTypes() throws Exception {
        Result res;
        int i;
        LOG.info((Object)"testDeleteTypes");
        byte[] v1 = Bytes.toBytes((String)"v1");
        byte[] v2 = Bytes.toBytes((String)"v2");
        byte[] v3 = Bytes.toBytes((String)"v3");
        htable1 = new HTable(conf1, tableName);
        long t = EnvironmentEdgeManager.currentTime();
        Put put = new Put(row);
        put.add(famName, row, t, v1);
        htable1.put(put);
        put = new Put(row);
        put.add(famName, row, t + 1L, v2);
        htable1.put(put);
        put = new Put(row);
        put.add(famName, row, t + 2L, v3);
        htable1.put(put);
        Get get = new Get(row);
        get.setMaxVersions();
        for (int i2 = 0; i2 < 10; ++i2) {
            Result res2;
            if (i2 == 9) {
                Assert.fail((String)"Waited too much time for put replication");
            }
            if ((res2 = htable2.get(get)).size() >= 3) {
                Assert.assertArrayEquals((byte[])CellUtil.cloneValue((Cell)res2.rawCells()[0]), (byte[])v3);
                Assert.assertArrayEquals((byte[])CellUtil.cloneValue((Cell)res2.rawCells()[1]), (byte[])v2);
                Assert.assertArrayEquals((byte[])CellUtil.cloneValue((Cell)res2.rawCells()[2]), (byte[])v1);
                break;
            }
            LOG.info((Object)"Rows not available");
            Thread.sleep(500L);
        }
        Delete d = new Delete(row);
        d.deleteColumn(famName, row, t);
        htable1.delete(d);
        get = new Get(row);
        get.setMaxVersions();
        for (i = 0; i < 10; ++i) {
            if (i == 9) {
                Assert.fail((String)"Waited too much time for put replication");
            }
            if ((res = htable2.get(get)).size() <= 2) {
                Assert.assertArrayEquals((byte[])CellUtil.cloneValue((Cell)res.rawCells()[0]), (byte[])v3);
                Assert.assertArrayEquals((byte[])CellUtil.cloneValue((Cell)res.rawCells()[1]), (byte[])v2);
                break;
            }
            LOG.info((Object)"Version not deleted");
            Thread.sleep(500L);
        }
        d = new Delete(row);
        d.deleteColumns(famName, row, t + 2L);
        htable1.delete(d);
        get = new Get(row);
        for (i = 0; i < 10; ++i) {
            if (i == 9) {
                Assert.fail((String)"Waited too much time for del replication");
            }
            if ((res = htable2.get(get)).size() < 1) break;
            LOG.info((Object)"Rows not deleted");
            Thread.sleep(500L);
        }
    }

    @Test(timeout=300000L)
    public void testSimplePutDelete() throws Exception {
        LOG.info((Object)"testSimplePutDelete");
        Put put = new Put(row);
        put.add(famName, row, row);
        htable1 = new HTable(conf1, tableName);
        htable1.put(put);
        Get get = new Get(row);
        for (int i = 0; i < 10; ++i) {
            Result res;
            if (i == 9) {
                Assert.fail((String)"Waited too much time for put replication");
            }
            if ((res = htable2.get(get)).size() != 0) {
                Assert.assertArrayEquals((byte[])res.value(), (byte[])row);
                break;
            }
            LOG.info((Object)"Row not available");
            Thread.sleep(500L);
        }
        Delete del = new Delete(row);
        htable1.delete(del);
        get = new Get(row);
        for (int i = 0; i < 10; ++i) {
            Result res;
            if (i == 9) {
                Assert.fail((String)"Waited too much time for del replication");
            }
            if ((res = htable2.get(get)).size() < 1) break;
            LOG.info((Object)"Row not deleted");
            Thread.sleep(500L);
        }
    }

    @Test(timeout=300000L)
    public void testSmallBatch() throws Exception {
        LOG.info((Object)"testSmallBatch");
        this.loadData("", row);
        Scan scan = new Scan();
        ResultScanner scanner1 = htable1.getScanner(scan);
        Result[] res1 = scanner1.next(100);
        scanner1.close();
        Assert.assertEquals((long)100L, (long)res1.length);
        this.waitForReplication(100, 10);
    }

    private void waitForReplication(int expectedRows, int retries) throws IOException, InterruptedException {
        for (int i = 0; i < retries; ++i) {
            Scan scan = new Scan();
            if (i == retries - 1) {
                Assert.fail((String)"Waited too much time for normal batch replication");
            }
            ResultScanner scanner = htable2.getScanner(scan);
            Result[] res = scanner.next(expectedRows);
            scanner.close();
            if (res.length == expectedRows) break;
            LOG.info((Object)("Only got " + res.length + " rows"));
            Thread.sleep(500L);
        }
    }

    private void loadData(String prefix, byte[] row) throws IOException {
        ArrayList<Put> puts = new ArrayList<Put>();
        for (int i = 0; i < 100; ++i) {
            Put put = new Put(Bytes.toBytes((String)(prefix + Integer.toString(i))));
            put.addColumn(famName, row, row);
            puts.add(put);
        }
        htable1.put(puts);
    }

    @Test(timeout=300000L)
    public void testDisableEnable() throws Exception {
        Result res;
        int i;
        admin.disablePeer(PEER_ID);
        byte[] rowkey = Bytes.toBytes((String)"disable enable");
        Put put = new Put(rowkey);
        put.add(famName, row, row);
        htable1.put(put);
        Get get = new Get(rowkey);
        for (i = 0; i < 10; ++i) {
            res = htable2.get(get);
            if (res.size() >= 1) {
                Assert.fail((String)"Replication wasn't disabled");
                continue;
            }
            LOG.info((Object)"Row not replicated, let's wait a bit more...");
            Thread.sleep(500L);
        }
        admin.enablePeer(PEER_ID);
        for (i = 0; i < 10; ++i) {
            res = htable2.get(get);
            if (res.size() != 0) {
                Assert.assertArrayEquals((byte[])res.value(), (byte[])row);
                return;
            }
            LOG.info((Object)"Row not available");
            Thread.sleep(500L);
        }
        Assert.fail((String)"Waited too much time for put replication");
    }

    @Test(timeout=300000L)
    public void testAddAndRemoveClusters() throws Exception {
        LOG.info((Object)"testAddAndRemoveClusters");
        admin.removePeer(PEER_ID);
        Thread.sleep(500L);
        byte[] rowKey = Bytes.toBytes((String)"Won't be replicated");
        Put put = new Put(rowKey);
        put.add(famName, row, row);
        htable1.put(put);
        Get get = new Get(rowKey);
        for (int i = 0; i < 10 && i != 9; ++i) {
            Result res = htable2.get(get);
            if (res.size() >= 1) {
                Assert.fail((String)"Not supposed to be replicated");
                continue;
            }
            LOG.info((Object)"Row not replicated, let's wait a bit more...");
            Thread.sleep(500L);
        }
        ReplicationPeerConfig rpc = new ReplicationPeerConfig();
        rpc.setClusterKey(utility2.getClusterKey());
        admin.addPeer(PEER_ID, rpc);
        Thread.sleep(500L);
        rowKey = Bytes.toBytes((String)"do rep");
        put = new Put(rowKey);
        put.add(famName, row, row);
        LOG.info((Object)"Adding new row");
        htable1.put(put);
        get = new Get(rowKey);
        for (int i = 0; i < 10; ++i) {
            Result res;
            if (i == 9) {
                Assert.fail((String)"Waited too much time for put replication");
            }
            if ((res = htable2.get(get)).size() != 0) {
                Assert.assertArrayEquals((byte[])res.value(), (byte[])row);
                break;
            }
            LOG.info((Object)"Row not available");
            Thread.sleep(500L * (long)i);
        }
    }

    @Test(timeout=300000L)
    public void testLoading() throws Exception {
        LOG.info((Object)"Writing out rows to table1 in testLoading");
        ArrayList<Put> puts = new ArrayList<Put>();
        for (int i = 0; i < 1000; ++i) {
            Put put = new Put(Bytes.toBytes((int)i));
            put.add(famName, row, row);
            puts.add(put);
        }
        htable1.setWriteBufferSize(1024L);
        htable1.put(puts);
        Scan scan = new Scan();
        ResultScanner scanner = htable1.getScanner(scan);
        Result[] res = scanner.next(1000);
        scanner.close();
        Assert.assertEquals((long)1000L, (long)res.length);
        LOG.info((Object)"Looking in table2 for replicated rows in testLoading");
        long start = System.currentTimeMillis();
        long retries = 100L;
        int i = 0;
        while ((long)i < 100L) {
            scan = new Scan();
            scanner = htable2.getScanner(scan);
            res = scanner.next(1000);
            scanner.close();
            if (res.length == 1000) break;
            if ((long)i == 99L) {
                int lastRow = -1;
                for (Result result : res) {
                    int currentRow = Bytes.toInt((byte[])result.getRow());
                    for (int row = lastRow + 1; row < currentRow; ++row) {
                        LOG.error((Object)("Row missing: " + row));
                    }
                    lastRow = currentRow;
                }
                LOG.error((Object)("Last row: " + lastRow));
                Assert.fail((String)("Waited too much time for normal batch replication, " + res.length + " instead of " + 1000 + "; waited=" + (System.currentTimeMillis() - start) + "ms"));
            } else {
                LOG.info((Object)("Only got " + res.length + " rows... retrying"));
                Thread.sleep(500L);
            }
            ++i;
        }
    }

    @Test(timeout=300000L)
    public void testVerifyRepJob() throws Exception {
        this.testSmallBatch();
        String[] args = new String[]{PEER_ID, tableName.getNameAsString()};
        this.runVerifyReplication(args, 100, 0);
        Scan scan = new Scan();
        ResultScanner rs = htable2.getScanner(scan);
        Put put = null;
        for (Result result : rs) {
            put = new Put(result.getRow());
            Cell firstVal = result.rawCells()[0];
            put.add(CellUtil.cloneFamily((Cell)firstVal), CellUtil.cloneQualifier((Cell)firstVal), Bytes.toBytes((String)"diff data"));
            htable2.put(put);
        }
        Delete delete = new Delete(put.getRow());
        htable2.delete(delete);
        this.runVerifyReplication(args, 0, 100);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testVerifyRepJobWithRawOptions() throws Exception {
        LOG.info((Object)"testVerifyRepJobWithRawOptions");
        TableName tablename = TableName.valueOf((String)"test_raw");
        byte[] familyname = Bytes.toBytes((String)"fam_raw");
        byte[] row = Bytes.toBytes((String)"row_raw");
        Table lHtable1 = null;
        Table lHtable2 = null;
        try {
            HTableDescriptor table = new HTableDescriptor(tablename);
            HColumnDescriptor fam = new HColumnDescriptor(familyname);
            fam.setMaxVersions(100);
            fam.setScope(1);
            table.addFamily(fam);
            Connection connection1 = ConnectionFactory.createConnection((Configuration)conf1);
            Connection connection2 = ConnectionFactory.createConnection((Configuration)conf2);
            try (Admin admin1 = connection1.getAdmin();){
                admin1.createTable(table, HBaseTestingUtility.KEYS_FOR_HBA_CREATE_TABLE);
            }
            var11_11 = null;
            try (Admin admin2 = connection2.getAdmin();){
                admin2.createTable(table, HBaseTestingUtility.KEYS_FOR_HBA_CREATE_TABLE);
            }
            catch (Throwable x2) {
                var11_11 = x2;
                throw x2;
            }
            utility1.waitUntilAllRegionsAssigned(tablename);
            utility2.waitUntilAllRegionsAssigned(tablename);
            lHtable1 = utility1.getConnection().getTable(tablename);
            lHtable2 = utility2.getConnection().getTable(tablename);
            Put put = new Put(row);
            put.addColumn(familyname, row, row);
            lHtable1.put(put);
            Get get = new Get(row);
            for (int i = 0; i < 10; ++i) {
                Result res;
                if (i == 9) {
                    Assert.fail((String)"Waited too much time for put replication");
                }
                if ((res = lHtable2.get(get)).size() != 0) {
                    Assert.assertArrayEquals((byte[])res.value(), (byte[])row);
                    break;
                }
                LOG.info((Object)"Row not available");
                Thread.sleep(500L);
            }
            Delete del = new Delete(row);
            lHtable1.delete(del);
            get = new Get(row);
            for (int i = 0; i < 10; ++i) {
                Result res;
                if (i == 9) {
                    Assert.fail((String)"Waited too much time for del replication");
                }
                if ((res = lHtable2.get(get)).size() < 1) break;
                LOG.info((Object)"Row not deleted");
                Thread.sleep(500L);
            }
            String[] argsWithoutRaw = new String[]{PEER_ID, tablename.getNameAsString()};
            this.runVerifyReplication(argsWithoutRaw, 0, 0);
            String[] argsWithRawAsTrue = new String[]{"--raw", PEER_ID, tablename.getNameAsString()};
            this.runVerifyReplication(argsWithRawAsTrue, 1, 0);
        }
        finally {
            if (lHtable1 != null) {
                lHtable1.close();
            }
            if (lHtable2 != null) {
                lHtable2.close();
            }
        }
    }

    private void runVerifyReplication(String[] args, int expectedGoodRows, int expectedBadRows) throws IOException, InterruptedException, ClassNotFoundException {
        Job job = VerifyReplication.createSubmittableJob((Configuration)new Configuration(CONF_WITH_LOCALFS), (String[])args);
        if (job == null) {
            Assert.fail((String)"Job wasn't created, see the log");
        }
        if (!job.waitForCompletion(true)) {
            Assert.fail((String)"Job failed, see the log");
        }
        Assert.assertEquals((long)expectedGoodRows, (long)job.getCounters().findCounter((Enum)VerifyReplication.Verifier.Counters.GOODROWS).getValue());
        Assert.assertEquals((long)expectedBadRows, (long)job.getCounters().findCounter((Enum)VerifyReplication.Verifier.Counters.BADROWS).getValue());
    }

    @Test(timeout=300000L)
    public void testHBase14905() throws Exception {
        byte[] qualifierName = Bytes.toBytes((String)"f1");
        Put put = new Put(Bytes.toBytes((String)"r1"));
        put.addColumn(famName, qualifierName, Bytes.toBytes((String)"v1002"));
        htable1.put(put);
        put.addColumn(famName, qualifierName, Bytes.toBytes((String)"v1001"));
        htable1.put(put);
        put.addColumn(famName, qualifierName, Bytes.toBytes((String)"v1112"));
        htable1.put(put);
        Scan scan = new Scan();
        scan.setMaxVersions(100);
        ResultScanner scanner1 = htable1.getScanner(scan);
        Result[] res1 = scanner1.next(1);
        scanner1.close();
        Assert.assertEquals((long)1L, (long)res1.length);
        Assert.assertEquals((long)3L, (long)res1[0].getColumnCells(famName, qualifierName).size());
        for (int i = 0; i < 10; ++i) {
            scan = new Scan();
            scan.setMaxVersions(100);
            scanner1 = htable2.getScanner(scan);
            res1 = scanner1.next(1);
            scanner1.close();
            if (res1.length != 1) {
                LOG.info((Object)("Only got " + res1.length + " rows"));
                Thread.sleep(500L);
            } else {
                int cellNumber = res1[0].getColumnCells(famName, Bytes.toBytes((String)"f1")).size();
                if (cellNumber == 3) break;
                LOG.info((Object)("Only got " + cellNumber + " cells"));
                Thread.sleep(500L);
            }
            if (i != 9) continue;
            Assert.fail((String)"Waited too much time for normal batch replication");
        }
        put.addColumn(famName, qualifierName, Bytes.toBytes((String)"v1111"));
        htable2.put(put);
        put.addColumn(famName, qualifierName, Bytes.toBytes((String)"v1112"));
        htable2.put(put);
        scan = new Scan();
        scan.setMaxVersions(100);
        scanner1 = htable2.getScanner(scan);
        res1 = scanner1.next(100);
        scanner1.close();
        Assert.assertEquals((long)1L, (long)res1.length);
        Assert.assertEquals((long)5L, (long)res1[0].getColumnCells(famName, qualifierName).size());
        String[] args = new String[]{"--versions=100", PEER_ID, tableName.getNameAsString()};
        this.runVerifyReplication(args, 0, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testVersionMismatchHBase14905() throws Exception {
        byte[] qualifierName = Bytes.toBytes((String)"f1");
        Put put = new Put(Bytes.toBytes((String)"r1"));
        long ts = System.currentTimeMillis();
        put.addColumn(famName, qualifierName, ts + 1L, Bytes.toBytes((String)"v1"));
        htable1.put(put);
        put.addColumn(famName, qualifierName, ts + 2L, Bytes.toBytes((String)"v2"));
        htable1.put(put);
        put.addColumn(famName, qualifierName, ts + 3L, Bytes.toBytes((String)"v3"));
        htable1.put(put);
        Scan scan = new Scan();
        scan.setMaxVersions(100);
        ResultScanner scanner1 = htable1.getScanner(scan);
        Result[] res1 = scanner1.next(1);
        scanner1.close();
        Assert.assertEquals((long)1L, (long)res1.length);
        Assert.assertEquals((long)3L, (long)res1[0].getColumnCells(famName, qualifierName).size());
        for (int i = 0; i < 10; ++i) {
            scan = new Scan();
            scan.setMaxVersions(100);
            scanner1 = htable2.getScanner(scan);
            res1 = scanner1.next(1);
            scanner1.close();
            if (res1.length != 1) {
                LOG.info((Object)("Only got " + res1.length + " rows"));
                Thread.sleep(500L);
            } else {
                int cellNumber = res1[0].getColumnCells(famName, Bytes.toBytes((String)"f1")).size();
                if (cellNumber == 3) break;
                LOG.info((Object)("Only got " + cellNumber + " cells"));
                Thread.sleep(500L);
            }
            if (i != 9) continue;
            Assert.fail((String)"Waited too much time for normal batch replication");
        }
        try {
            admin.disablePeer(PEER_ID);
            Put put2 = new Put(Bytes.toBytes((String)"r1"));
            put2.addColumn(famName, qualifierName, ts + 2L, Bytes.toBytes((String)"v99"));
            htable2.put(put2);
            scan = new Scan();
            scan.setMaxVersions(100);
            scanner1 = htable2.getScanner(scan);
            res1 = scanner1.next(100);
            scanner1.close();
            Assert.assertEquals((long)1L, (long)res1.length);
            Assert.assertEquals((long)3L, (long)res1[0].getColumnCells(famName, qualifierName).size());
            String[] args = new String[]{"--versions=100", PEER_ID, tableName.getNameAsString()};
            this.runVerifyReplication(args, 0, 1);
        }
        finally {
            admin.enablePeer(PEER_ID);
        }
    }

    @Test(timeout=300000L)
    public void testCompactionWALEdits() throws Exception {
        WALProtos.CompactionDescriptor compactionDescriptor = WALProtos.CompactionDescriptor.getDefaultInstance();
        HRegionInfo hri = new HRegionInfo(htable1.getName(), HConstants.EMPTY_START_ROW, HConstants.EMPTY_END_ROW);
        WALEdit edit = WALEdit.createCompaction((HRegionInfo)hri, (WALProtos.CompactionDescriptor)compactionDescriptor);
        Replication.scopeWALEdits((HTableDescriptor)htable1.getTableDescriptor(), (WALKey)new WALKey(), (WALEdit)edit, (Configuration)htable1.getConfiguration(), null);
    }

    @Test(timeout=300000L)
    public void testVerifyListReplicatedTable() throws Exception {
        int i;
        LOG.info((Object)"testVerifyListReplicatedTable");
        String tName = "VerifyListReplicated_";
        String colFam = "cf1";
        int numOfTables = 3;
        HBaseAdmin hadmin = new HBaseAdmin(conf1);
        for (int i2 = 0; i2 < 3; ++i2) {
            HTableDescriptor ht = new HTableDescriptor(TableName.valueOf((String)("VerifyListReplicated_" + i2)));
            HColumnDescriptor cfd = new HColumnDescriptor("cf1");
            cfd.setScope(1);
            ht.addFamily(cfd);
            hadmin.createTable(ht);
        }
        List replicationColFams = admin.listReplicated();
        int[] match = new int[3];
        for (i = 0; i < replicationColFams.size(); ++i) {
            int m;
            HashMap replicationEntry = (HashMap)replicationColFams.get(i);
            String tn = (String)replicationEntry.get("tableName");
            if (!tn.startsWith("VerifyListReplicated_") || !((String)replicationEntry.get("columnFamlyName")).equals("cf1")) continue;
            int n = m = Integer.parseInt(tn.substring(tn.length() - 1));
            match[n] = match[n] + 1;
        }
        for (i = 0; i < match.length; ++i) {
            Assert.assertTrue((String)("listReplicated() does not match table " + i), (match[i] == 1 ? 1 : 0) != 0);
        }
        for (i = 0; i < 3; ++i) {
            String ht = "VerifyListReplicated_" + i;
            hadmin.disableTable(ht);
            hadmin.deleteTable(ht);
        }
        hadmin.close();
    }

    @Test(timeout=300000L)
    public void testVerifyReplicationPrefixFiltering() throws Exception {
        byte[] prefixRow = Bytes.toBytes((String)"prefixrow");
        byte[] prefixRow2 = Bytes.toBytes((String)"secondrow");
        this.loadData("prefixrow", prefixRow);
        this.loadData("secondrow", prefixRow2);
        this.loadData("aaa", row);
        this.loadData("zzz", row);
        this.waitForReplication(400, 40);
        String[] args = new String[]{"--row-prefixes=prefixrow,secondrow", PEER_ID, tableName.getNameAsString()};
        this.runVerifyReplication(args, 200, 0);
    }

    @Test
    public void testEmptyWALRecovery() throws Exception {
        WAL wal;
        HRegionInfo regionInfo;
        int i;
        int numRs = utility1.getHBaseCluster().getRegionServerThreads().size();
        ArrayList<Path> emptyWalPaths = new ArrayList<Path>();
        long ts = System.currentTimeMillis();
        for (i = 0; i < numRs; ++i) {
            regionInfo = utility1.getHBaseCluster().getRegions(htable1.getName()).get(0).getRegionInfo();
            wal = utility1.getHBaseCluster().getRegionServer(i).getWAL(regionInfo);
            Path currentWalPath = DefaultWALProvider.getCurrentFileName((WAL)wal);
            String walGroupId = DefaultWALProvider.getWALPrefixFromWALName((String)currentWalPath.getName());
            Path emptyWalPath = new Path(utility1.getDataTestDir(), walGroupId + "." + ts);
            utility1.getTestFileSystem().create(emptyWalPath).close();
            emptyWalPaths.add(emptyWalPath);
        }
        for (i = 0; i < numRs; ++i) {
            Replication replicationService = (Replication)utility1.getHBaseCluster().getRegionServer(i).getReplicationSourceService();
            replicationService.preLogRoll(null, (Path)emptyWalPaths.get(i));
            replicationService.postLogRoll(null, (Path)emptyWalPaths.get(i));
        }
        this.waitForLogAdvance(numRs, emptyWalPaths, false);
        for (i = 0; i < numRs; ++i) {
            regionInfo = utility1.getHBaseCluster().getRegions(htable1.getName()).get(0).getRegionInfo();
            wal = utility1.getHBaseCluster().getRegionServer(i).getWAL(regionInfo);
            wal.rollWriter(true);
        }
        this.waitForLogAdvance(numRs, emptyWalPaths, true);
        this.testSimplePutDelete();
    }

    private void waitForLogAdvance(final int numRs, final List<Path> emptyWalPaths, final boolean invert) throws Exception {
        Waiter.waitFor((Configuration)conf1, (long)10000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                for (int i = 0; i < numRs; ++i) {
                    Replication replicationService = (Replication)TestReplicationBase.utility1.getHBaseCluster().getRegionServer(i).getReplicationSourceService();
                    for (ReplicationSourceInterface rsi : replicationService.getReplicationManager().getSources()) {
                        ReplicationSource source = (ReplicationSource)rsi;
                        if (!invert && !((Path)emptyWalPaths.get(i)).equals((Object)source.getCurrentPath())) {
                            return false;
                        }
                        if (!invert || !((Path)emptyWalPaths.get(i)).equals((Object)source.getCurrentPath())) continue;
                        return false;
                    }
                }
                return true;
            }
        });
    }
}

