/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapred;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Partitioner;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class HRegionPartitioner<K2, V2>
implements Partitioner<ImmutableBytesWritable, V2> {
    private static final Log LOG = LogFactory.getLog(HRegionPartitioner.class);
    private Connection connection;
    private RegionLocator locator;
    private byte[][] startKeys;

    public void configure(JobConf job) {
        try {
            this.connection = ConnectionFactory.createConnection((Configuration)HBaseConfiguration.create((Configuration)job));
            TableName tableName = TableName.valueOf((String)job.get("hbase.mapred.outputtable"));
            this.locator = this.connection.getRegionLocator(tableName);
        }
        catch (IOException e) {
            LOG.error((Object)e);
        }
        try {
            this.startKeys = this.locator.getStartKeys();
        }
        catch (IOException e) {
            LOG.error((Object)e);
        }
    }

    public int getPartition(ImmutableBytesWritable key, V2 value, int numPartitions) {
        byte[] region = null;
        if (this.startKeys.length == 1) {
            return 0;
        }
        try {
            region = this.locator.getRegionLocation(key.get()).getRegionInfo().getStartKey();
        }
        catch (IOException e) {
            LOG.error((Object)e);
        }
        for (int i = 0; i < this.startKeys.length; ++i) {
            if (Bytes.compareTo((byte[])region, (byte[])this.startKeys[i]) != 0) continue;
            if (i >= numPartitions - 1) {
                return (Integer.toString(i).hashCode() & Integer.MAX_VALUE) % numPartitions;
            }
            return i;
        }
        return 0;
    }
}

