/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import com.google.common.base.Predicate;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.regionserver.wal.WALEdit;
import org.apache.hadoop.hbase.replication.BulkLoadCellFilter;
import org.apache.hadoop.hbase.replication.ReplicationPeer;
import org.apache.hadoop.hbase.replication.WALCellFilter;
import org.apache.hadoop.hbase.replication.WALEntryFilter;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.wal.WAL;

public class TableCfWALEntryFilter
implements WALEntryFilter,
WALCellFilter {
    private static final Log LOG = LogFactory.getLog(TableCfWALEntryFilter.class);
    private ReplicationPeer peer;
    private BulkLoadCellFilter bulkLoadFilter = new BulkLoadCellFilter();

    public TableCfWALEntryFilter(ReplicationPeer peer) {
        this.peer = peer;
    }

    @Override
    public WAL.Entry filter(WAL.Entry entry) {
        TableName tabName = entry.getKey().getTablename();
        Map<TableName, List<String>> tableCFs = this.getTableCfs();
        if (tableCFs == null) {
            return entry;
        }
        if (!tableCFs.containsKey(tabName)) {
            return null;
        }
        return entry;
    }

    @Override
    public Cell filterCell(final WAL.Entry entry, Cell cell) {
        final Map<TableName, List<String>> tableCfs = this.getTableCfs();
        if (tableCfs == null) {
            return cell;
        }
        TableName tabName = entry.getKey().getTablename();
        List<String> cfs = tableCfs.get(tabName);
        if (CellUtil.matchingColumn((Cell)cell, (byte[])WALEdit.METAFAMILY, (byte[])WALEdit.BULK_LOAD)) {
            cell = this.bulkLoadFilter.filterCell(cell, new Predicate<byte[]>(){

                public boolean apply(byte[] fam) {
                    List cfs;
                    return tableCfs != null && (cfs = (List)tableCfs.get(entry.getKey().getTablename())) != null && !cfs.contains(Bytes.toString((byte[])fam));
                }
            });
        } else if (cfs != null && !cfs.contains(Bytes.toString((byte[])cell.getFamilyArray(), (int)cell.getFamilyOffset(), (int)cell.getFamilyLength()))) {
            return null;
        }
        return cell;
    }

    Map<TableName, List<String>> getTableCfs() {
        Map tableCFs = null;
        try {
            tableCFs = this.peer.getTableCFs();
        }
        catch (IllegalArgumentException e) {
            LOG.error((Object)("should not happen: can't get tableCFs for peer " + this.peer.getId() + ", degenerate as if it's not configured by keeping tableCFs==null"));
        }
        return tableCFs;
    }
}

