/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.util.Arrays;
import java.util.Collection;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.client.ConnectionRegistry;
import org.apache.hadoop.hbase.client.TestFromClientSide;
import org.apache.hadoop.hbase.client.ZKConnectionRegistry;
import org.apache.hadoop.hbase.coprocessor.MultiRowMutationEndpoint;
import org.apache.hadoop.hbase.regionserver.NoOpScanPolicyObserver;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.junit.experimental.categories.Category;
import org.junit.runners.Parameterized;

@Category(value={LargeTests.class})
public class TestFromClientSideWithCoprocessor
extends TestFromClientSide {
    @Parameterized.Parameters
    public static Collection parameters() {
        return Arrays.asList(new Object[][]{{ZKConnectionRegistry.class}});
    }

    public TestFromClientSideWithCoprocessor(Class registry) throws Exception {
        TestFromClientSideWithCoprocessor.initialize(registry);
    }

    public static void initialize(Class<? extends ConnectionRegistry> registry) throws Exception {
        if (TestFromClientSideWithCoprocessor.isSameParameterizedCluster(registry)) {
            return;
        }
        if (TEST_UTIL != null) {
            TEST_UTIL.shutdownMiniCluster();
        }
        TEST_UTIL = new HBaseTestingUtility();
        Configuration conf = TEST_UTIL.getConfiguration();
        conf.setStrings("hbase.coprocessor.region.classes", new String[]{MultiRowMutationEndpoint.class.getName(), NoOpScanPolicyObserver.class.getName()});
        conf.setBoolean("hbase.table.sanity.checks", true);
        conf.setClass("hbase.client.registry.impl", registry, ConnectionRegistry.class);
        TEST_UTIL.startMiniCluster(SLAVES);
    }
}

