/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.coprocessor;

import java.io.IOException;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Tag;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TestFromClientSide;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.RegionObserver;
import org.apache.hadoop.hbase.security.access.AccessController;
import org.apache.hadoop.hbase.security.access.Permission;
import org.apache.hadoop.hbase.testclassification.CoprocessorTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={CoprocessorTests.class, MediumTests.class})
public class TestPostMutationBeforeWAL {
    @Rule
    public TestName name = new TestName();
    private static final Log LOG = LogFactory.getLog(TestFromClientSide.class);
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static Connection connection;
    private static final byte[] ROW;
    private static final String CF1 = "cf1";
    private static final byte[] CF1_BYTES;
    private static final String CF2 = "cf2";
    private static final byte[] CF2_BYTES;
    private static final byte[] CQ1;
    private static final byte[] CQ2;
    private static final byte[] VALUE;
    private static final byte[] VALUE2;
    private static final String USER = "User";
    private static final Permission PERMS;

    @BeforeClass
    public static void setupBeforeClass() throws Exception {
        UTIL.startMiniCluster();
        connection = UTIL.getConnection();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        connection.close();
        UTIL.shutdownMiniCluster();
    }

    private void createTableWithCoprocessor(TableName tableName, String coprocessor) throws IOException {
        HTableDescriptor tableDesc = new HTableDescriptor(tableName);
        tableDesc.addFamily(new HColumnDescriptor(CF1_BYTES));
        tableDesc.addFamily(new HColumnDescriptor(CF2_BYTES));
        tableDesc.addCoprocessor(coprocessor);
        connection.getAdmin().createTable(tableDesc);
    }

    @Test
    public void testIncrementTTLWithACLTag() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        this.createTableWithCoprocessor(tableName, ChangeCellWithACLTagObserver.class.getName());
        try (Table table = connection.getTable(tableName);){
            Increment firstIncrement = new Increment(ROW).addColumn(CF1_BYTES, CQ1, 1L).setACL(USER, PERMS);
            Result result = table.increment(firstIncrement);
            Assert.assertEquals((long)1L, (long)result.size());
            Assert.assertEquals((long)1L, (long)Bytes.toLong((byte[])result.getValue(CF1_BYTES, CQ1)));
            Get get = new Get(ROW).addColumn(CF1_BYTES, CQ1);
            result = table.get(get);
            Assert.assertEquals((long)1L, (long)result.size());
            Assert.assertEquals((long)1L, (long)Bytes.toLong((byte[])result.getValue(CF1_BYTES, CQ1)));
            Increment secondIncrement = new Increment(ROW).addColumn(CF1_BYTES, CQ1, 1L).setTTL(1000L).setACL(USER, PERMS);
            result = table.increment(secondIncrement);
            Assert.assertEquals((long)1L, (long)result.size());
            Assert.assertEquals((long)2L, (long)Bytes.toLong((byte[])result.getValue(CF1_BYTES, CQ1)));
            Thread.sleep(4000L);
            get = new Get(ROW).addColumn(CF1_BYTES, CQ1);
            result = table.get(get);
            Assert.assertEquals((long)1L, (long)result.size());
            Assert.assertEquals((long)1L, (long)Bytes.toLong((byte[])result.getValue(CF1_BYTES, CQ1)));
        }
    }

    @Test
    public void testAppendTTLWithACLTag() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        this.createTableWithCoprocessor(tableName, ChangeCellWithACLTagObserver.class.getName());
        try (Table table = connection.getTable(tableName);){
            Append firstAppend = new Append(ROW).add(CF1_BYTES, CQ2, VALUE).setACL(USER, PERMS);
            Result result = table.append(firstAppend);
            Assert.assertEquals((long)1L, (long)result.size());
            Assert.assertTrue((boolean)Bytes.equals((byte[])VALUE, (byte[])result.getValue(CF1_BYTES, CQ2)));
            Get get = new Get(ROW).addColumn(CF1_BYTES, CQ2);
            result = table.get(get);
            Assert.assertEquals((long)1L, (long)result.size());
            Assert.assertTrue((boolean)Bytes.equals((byte[])VALUE, (byte[])result.getValue(CF1_BYTES, CQ2)));
            Append secondAppend = new Append(ROW).add(CF1_BYTES, CQ2, VALUE).setTTL(1000L).setACL(USER, PERMS);
            result = table.append(secondAppend);
            Assert.assertEquals((long)1L, (long)result.size());
            Assert.assertTrue((boolean)Bytes.equals((byte[])VALUE2, (byte[])result.getValue(CF1_BYTES, CQ2)));
            Thread.sleep(4000L);
            get = new Get(ROW).addColumn(CF1_BYTES, CQ2);
            result = table.get(get);
            Assert.assertEquals((long)1L, (long)result.size());
            Assert.assertTrue((boolean)Bytes.equals((byte[])VALUE, (byte[])result.getValue(CF1_BYTES, CQ2)));
        }
    }

    private static boolean checkAclTag(byte[] acl, Cell cell) {
        Iterator iter = CellUtil.tagsIterator((byte[])cell.getTagsArray(), (int)cell.getTagsOffset(), (int)cell.getTagsLength());
        while (iter.hasNext()) {
            Tag tag = (Tag)iter.next();
            if (tag.getType() != 1) continue;
            return Bytes.equals((byte[])acl, (byte[])tag.getValue());
        }
        return false;
    }

    static {
        ROW = Bytes.toBytes((String)"row");
        CF1_BYTES = Bytes.toBytes((String)CF1);
        CF2_BYTES = Bytes.toBytes((String)CF2);
        CQ1 = Bytes.toBytes((String)"cq1");
        CQ2 = Bytes.toBytes((String)"cq2");
        VALUE = Bytes.toBytes((String)"value");
        VALUE2 = Bytes.toBytes((String)"valuevalue");
        PERMS = new Permission(new Permission.Action[]{Permission.Action.READ});
    }

    public static class ChangeCellWithACLTagObserver
    extends AccessController {
        public Cell postMutationBeforeWAL(ObserverContext<RegionCoprocessorEnvironment> ctx, RegionObserver.MutationType mutationType, Mutation mutation, Cell oldCell, Cell newCell) throws IOException {
            Cell result = super.postMutationBeforeWAL(ctx, mutationType, mutation, oldCell, newCell);
            if (mutation.getACL() != null && !TestPostMutationBeforeWAL.checkAclTag(mutation.getACL(), result)) {
                throw new DoNotRetryIOException("Unmatched ACL tag.");
            }
            return result;
        }
    }
}

