/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.RegionTransition;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.executor.EventType;
import org.apache.hadoop.hbase.master.AssignmentManager;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.zookeeper.ZKAssign;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.zookeeper.KeeperException;

public class Mocking {
    static void waitForRegionFailedToCloseAndSetToPendingClose(AssignmentManager am, HRegionInfo hri) throws InterruptedException {
        boolean wait = true;
        while (wait) {
            RegionState state = am.getRegionStates().getRegionState(hri);
            if (state != null && state.isFailedClose()) {
                am.getRegionStates().updateRegionState(hri, RegionState.State.PENDING_CLOSE);
                wait = false;
                continue;
            }
            Thread.sleep(1L);
        }
    }

    static boolean verifyRegionState(ZooKeeperWatcher zkw, HRegionInfo region, EventType expectedState) throws KeeperException, DeserializationException {
        String encoded = region.getEncodedName();
        String node = ZKAssign.getNodeName((ZooKeeperWatcher)zkw, (String)encoded);
        zkw.syncOrTimeout(node);
        byte[] existingBytes = null;
        try {
            existingBytes = ZKUtil.getDataAndWatch((ZooKeeperWatcher)zkw, (String)node);
        }
        catch (KeeperException.NoNodeException nne) {
            return false;
        }
        catch (KeeperException e) {
            throw e;
        }
        if (existingBytes == null) {
            return false;
        }
        RegionTransition rt = RegionTransition.parseFrom((byte[])existingBytes);
        return rt.getEventType().equals((Object)expectedState);
    }
}

