/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.protobuf;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.protobuf.ReplicationProtbufUtil;
import org.apache.hadoop.hbase.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.protobuf.generated.WALProtos;
import org.apache.hadoop.hbase.regionserver.MultiVersionConcurrencyControl;
import org.apache.hadoop.hbase.regionserver.wal.WALEdit;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALKey;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestReplicationProtobuf {
    @Test
    public void testGetCellScanner() throws IOException {
        ArrayList<KeyValue> a = new ArrayList<KeyValue>();
        KeyValue akv = new KeyValue(Bytes.toBytes((String)"a"), -1L);
        a.add(akv);
        a.add(new KeyValue(Bytes.toBytes((String)"aa"), -1L));
        a.add(new KeyValue(Bytes.toBytes((String)"aaa"), -1L));
        ArrayList b = new ArrayList();
        KeyValue bkv = new KeyValue(Bytes.toBytes((String)"b"), -1L);
        a.add(bkv);
        ArrayList<KeyValue> c = new ArrayList<KeyValue>();
        KeyValue ckv = new KeyValue(Bytes.toBytes((String)"c"), -1L);
        c.add(ckv);
        ArrayList all = new ArrayList();
        all.add(a);
        all.add(b);
        all.add(c);
        CellScanner scanner = ReplicationProtbufUtil.getCellScanner(all, (int)0);
        this.testAdvanceHasSameRow(scanner, akv);
        scanner.advance();
        scanner.advance();
        this.testAdvanceHasSameRow(scanner, bkv);
        this.testAdvanceHasSameRow(scanner, ckv);
        Assert.assertFalse((boolean)scanner.advance());
    }

    private void testAdvanceHasSameRow(CellScanner scanner, KeyValue kv) throws IOException {
        scanner.advance();
        Assert.assertTrue((boolean)Bytes.equals((byte[])scanner.current().getRowArray(), (int)scanner.current().getRowOffset(), (int)scanner.current().getRowLength(), (byte[])kv.getRowArray(), (int)kv.getRowOffset(), (int)kv.getRowLength()));
    }

    @Test
    public void testWALEntryProtobufConstruction() throws Exception {
        byte[] encodedRegionName = Bytes.toBytes((String)"region");
        TableName tableName = TableName.valueOf((String)"table");
        long ts = EnvironmentEdgeManager.currentTime();
        MultiVersionConcurrencyControl mvcc = null;
        HashMap<String, byte[]> extendedAttributes = new HashMap<String, byte[]>(1);
        String attrKey = "attr";
        byte[] attrValue = Bytes.toBytes((String)"attrVal");
        extendedAttributes.put(attrKey, attrValue);
        WALKey key = new WALKey(encodedRegionName, tableName, ts, mvcc, extendedAttributes);
        Cell cell = CellUtil.createCell((byte[])Bytes.toBytes((String)"row"), (byte[])Bytes.toBytes((String)"f"), (byte[])Bytes.toBytes((String)"q"), (long)ts, (byte)KeyValue.Type.Put.getCode(), (byte[])Bytes.toBytes((String)"val"));
        WALEdit edit = new WALEdit(1);
        edit.add(cell);
        WAL.Entry entry = new WAL.Entry(key, edit);
        Pair pair = ReplicationProtbufUtil.buildReplicateWALEntryRequest((WAL.Entry[])new WAL.Entry[]{entry});
        AdminProtos.ReplicateWALEntryRequest request = (AdminProtos.ReplicateWALEntryRequest)pair.getFirst();
        AdminProtos.WALEntry protoWALEntry = request.getEntry(0);
        WALProtos.WALKey protoWALKey = protoWALEntry.getKey();
        Assert.assertArrayEquals((byte[])encodedRegionName, (byte[])protoWALKey.getEncodedRegionName().toByteArray());
        Assert.assertEquals((Object)tableName, (Object)TableName.valueOf((byte[])protoWALKey.getTableName().toByteArray()));
        Assert.assertEquals((long)ts, (long)protoWALKey.getWriteTime());
        Assert.assertEquals((long)extendedAttributes.size(), (long)protoWALKey.getExtendedAttributesCount());
        for (WALProtos.Attribute attr : protoWALKey.getExtendedAttributesList()) {
            Assert.assertArrayEquals((byte[])((byte[])extendedAttributes.get(attr.getKey())), (byte[])attr.getValue().toByteArray());
        }
        Assert.assertEquals((long)edit.size(), (long)protoWALEntry.getAssociatedCellCount());
    }
}

