/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.querymatcher;

import java.io.IOException;
import java.util.ArrayList;
import java.util.NavigableSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeepDeletedCells;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.regionserver.ScanInfo;
import org.apache.hadoop.hbase.regionserver.querymatcher.AbstractTestScanQueryMatcher;
import org.apache.hadoop.hbase.regionserver.querymatcher.ScanQueryMatcher;
import org.apache.hadoop.hbase.regionserver.querymatcher.UserScanQueryMatcher;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={RegionServerTests.class, SmallTests.class})
public class TestUserScanQueryMatcher
extends AbstractTestScanQueryMatcher {
    private static final Log LOG = LogFactory.getLog(TestUserScanQueryMatcher.class);

    @Test
    public void testNeverIncludeFakeCell() throws IOException {
        long now = EnvironmentEdgeManager.currentTime();
        UserScanQueryMatcher qm = UserScanQueryMatcher.create((Scan)this.scan, (ScanInfo)new ScanInfo(this.conf, this.fam2, 10, 1, this.ttl, KeepDeletedCells.FALSE, 0L, this.rowComparator), (NavigableSet)((NavigableSet)this.get.getFamilyMap().get(this.fam2)), (long)(now - this.ttl), (long)now, null);
        KeyValue kv = new KeyValue(this.row1, this.fam2, this.col2, 1L, this.data);
        KeyValue cell = KeyValueUtil.createLastOnRowCol((Cell)kv);
        qm.setToNewRow((Cell)kv);
        ScanQueryMatcher.MatchCode code = qm.match((Cell)cell);
        Assert.assertFalse((code.compareTo((Enum)ScanQueryMatcher.MatchCode.SEEK_NEXT_COL) != 0 ? 1 : 0) != 0);
    }

    @Test
    public void testMatchExplicitColumns() throws IOException {
        ArrayList<ScanQueryMatcher.MatchCode> expected = new ArrayList<ScanQueryMatcher.MatchCode>();
        expected.add(ScanQueryMatcher.MatchCode.SEEK_NEXT_COL);
        expected.add(ScanQueryMatcher.MatchCode.INCLUDE_AND_SEEK_NEXT_COL);
        expected.add(ScanQueryMatcher.MatchCode.SEEK_NEXT_COL);
        expected.add(ScanQueryMatcher.MatchCode.INCLUDE_AND_SEEK_NEXT_COL);
        expected.add(ScanQueryMatcher.MatchCode.INCLUDE_AND_SEEK_NEXT_ROW);
        expected.add(ScanQueryMatcher.MatchCode.DONE);
        long now = EnvironmentEdgeManager.currentTime();
        UserScanQueryMatcher qm = UserScanQueryMatcher.create((Scan)this.scan, (ScanInfo)new ScanInfo(this.conf, this.fam2, 0, 1, this.ttl, KeepDeletedCells.FALSE, 0L, this.rowComparator), (NavigableSet)((NavigableSet)this.get.getFamilyMap().get(this.fam2)), (long)(now - this.ttl), (long)now, null);
        ArrayList<KeyValue> memstore = new ArrayList<KeyValue>();
        memstore.add(new KeyValue(this.row1, this.fam2, this.col1, 1L, this.data));
        memstore.add(new KeyValue(this.row1, this.fam2, this.col2, 1L, this.data));
        memstore.add(new KeyValue(this.row1, this.fam2, this.col3, 1L, this.data));
        memstore.add(new KeyValue(this.row1, this.fam2, this.col4, 1L, this.data));
        memstore.add(new KeyValue(this.row1, this.fam2, this.col5, 1L, this.data));
        memstore.add(new KeyValue(this.row2, this.fam1, this.col1, this.data));
        ArrayList<ScanQueryMatcher.MatchCode> actual = new ArrayList<ScanQueryMatcher.MatchCode>();
        KeyValue k = (KeyValue)memstore.get(0);
        qm.setToNewRow((Cell)k);
        for (KeyValue kv : memstore) {
            actual.add(qm.match((Cell)kv));
        }
        Assert.assertEquals((long)expected.size(), (long)actual.size());
        for (int i = 0; i < expected.size(); ++i) {
            LOG.debug((Object)("expected " + expected.get(i) + ", actual " + actual.get(i)));
            Assert.assertEquals(expected.get(i), actual.get(i));
        }
    }

    @Test
    public void testMatch_Wildcard() throws IOException {
        ArrayList<ScanQueryMatcher.MatchCode> expected = new ArrayList<ScanQueryMatcher.MatchCode>();
        expected.add(ScanQueryMatcher.MatchCode.INCLUDE);
        expected.add(ScanQueryMatcher.MatchCode.INCLUDE);
        expected.add(ScanQueryMatcher.MatchCode.INCLUDE);
        expected.add(ScanQueryMatcher.MatchCode.INCLUDE);
        expected.add(ScanQueryMatcher.MatchCode.INCLUDE);
        expected.add(ScanQueryMatcher.MatchCode.DONE);
        long now = EnvironmentEdgeManager.currentTime();
        UserScanQueryMatcher qm = UserScanQueryMatcher.create((Scan)this.scan, (ScanInfo)new ScanInfo(this.conf, this.fam2, 0, 1, this.ttl, KeepDeletedCells.FALSE, 0L, this.rowComparator), null, (long)(now - this.ttl), (long)now, null);
        ArrayList<KeyValue> memstore = new ArrayList<KeyValue>();
        memstore.add(new KeyValue(this.row1, this.fam2, this.col1, 1L, this.data));
        memstore.add(new KeyValue(this.row1, this.fam2, this.col2, 1L, this.data));
        memstore.add(new KeyValue(this.row1, this.fam2, this.col3, 1L, this.data));
        memstore.add(new KeyValue(this.row1, this.fam2, this.col4, 1L, this.data));
        memstore.add(new KeyValue(this.row1, this.fam2, this.col5, 1L, this.data));
        memstore.add(new KeyValue(this.row2, this.fam1, this.col1, 1L, this.data));
        ArrayList<ScanQueryMatcher.MatchCode> actual = new ArrayList<ScanQueryMatcher.MatchCode>();
        KeyValue k = (KeyValue)memstore.get(0);
        qm.setToNewRow((Cell)k);
        for (KeyValue kv : memstore) {
            actual.add(qm.match((Cell)kv));
        }
        Assert.assertEquals((long)expected.size(), (long)actual.size());
        for (int i = 0; i < expected.size(); ++i) {
            LOG.debug((Object)("expected " + expected.get(i) + ", actual " + actual.get(i)));
            Assert.assertEquals(expected.get(i), actual.get(i));
        }
    }

    @Test
    public void testMatch_ExpiredExplicit() throws IOException {
        long testTTL = 1000L;
        ScanQueryMatcher.MatchCode[] expected = new ScanQueryMatcher.MatchCode[]{ScanQueryMatcher.MatchCode.SEEK_NEXT_COL, ScanQueryMatcher.MatchCode.INCLUDE_AND_SEEK_NEXT_COL, ScanQueryMatcher.MatchCode.SEEK_NEXT_COL, ScanQueryMatcher.MatchCode.INCLUDE_AND_SEEK_NEXT_COL, ScanQueryMatcher.MatchCode.SEEK_NEXT_ROW, ScanQueryMatcher.MatchCode.DONE};
        long now = EnvironmentEdgeManager.currentTime();
        UserScanQueryMatcher qm = UserScanQueryMatcher.create((Scan)this.scan, (ScanInfo)new ScanInfo(this.conf, this.fam2, 0, 1, testTTL, KeepDeletedCells.FALSE, 0L, this.rowComparator), (NavigableSet)((NavigableSet)this.get.getFamilyMap().get(this.fam2)), (long)(now - testTTL), (long)now, null);
        KeyValue[] kvs = new KeyValue[]{new KeyValue(this.row1, this.fam2, this.col1, now - 100L, this.data), new KeyValue(this.row1, this.fam2, this.col2, now - 50L, this.data), new KeyValue(this.row1, this.fam2, this.col3, now - 5000L, this.data), new KeyValue(this.row1, this.fam2, this.col4, now - 500L, this.data), new KeyValue(this.row1, this.fam2, this.col5, now - 10000L, this.data), new KeyValue(this.row2, this.fam1, this.col1, now - 10L, this.data)};
        KeyValue k = kvs[0];
        qm.setToNewRow((Cell)k);
        ArrayList<ScanQueryMatcher.MatchCode> actual = new ArrayList<ScanQueryMatcher.MatchCode>(kvs.length);
        for (KeyValue kv : kvs) {
            actual.add(qm.match((Cell)kv));
        }
        Assert.assertEquals((long)expected.length, (long)actual.size());
        for (int i = 0; i < expected.length; ++i) {
            LOG.debug((Object)("expected " + expected[i] + ", actual " + actual.get(i)));
            Assert.assertEquals((Object)expected[i], actual.get(i));
        }
    }

    @Test
    public void testMatch_ExpiredWildcard() throws IOException {
        long testTTL = 1000L;
        ScanQueryMatcher.MatchCode[] expected = new ScanQueryMatcher.MatchCode[]{ScanQueryMatcher.MatchCode.INCLUDE, ScanQueryMatcher.MatchCode.INCLUDE, ScanQueryMatcher.MatchCode.SEEK_NEXT_COL, ScanQueryMatcher.MatchCode.INCLUDE, ScanQueryMatcher.MatchCode.SEEK_NEXT_COL, ScanQueryMatcher.MatchCode.DONE};
        long now = EnvironmentEdgeManager.currentTime();
        UserScanQueryMatcher qm = UserScanQueryMatcher.create((Scan)this.scan, (ScanInfo)new ScanInfo(this.conf, this.fam2, 0, 1, testTTL, KeepDeletedCells.FALSE, 0L, this.rowComparator), null, (long)(now - testTTL), (long)now, null);
        KeyValue[] kvs = new KeyValue[]{new KeyValue(this.row1, this.fam2, this.col1, now - 100L, this.data), new KeyValue(this.row1, this.fam2, this.col2, now - 50L, this.data), new KeyValue(this.row1, this.fam2, this.col3, now - 5000L, this.data), new KeyValue(this.row1, this.fam2, this.col4, now - 500L, this.data), new KeyValue(this.row1, this.fam2, this.col5, now - 10000L, this.data), new KeyValue(this.row2, this.fam1, this.col1, now - 10L, this.data)};
        KeyValue k = kvs[0];
        qm.setToNewRow((Cell)k);
        ArrayList<ScanQueryMatcher.MatchCode> actual = new ArrayList<ScanQueryMatcher.MatchCode>(kvs.length);
        for (KeyValue kv : kvs) {
            actual.add(qm.match((Cell)kv));
        }
        Assert.assertEquals((long)expected.length, (long)actual.size());
        for (int i = 0; i < expected.length; ++i) {
            LOG.debug((Object)("expected " + expected[i] + ", actual " + actual.get(i)));
            Assert.assertEquals((Object)expected[i], actual.get(i));
        }
    }
}

