/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util.compaction;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Random;
import java.util.Set;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.compaction.MajorCompactor;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MiscTests.class, MediumTests.class})
public class MajorCompactorTest {
    public static final byte[] FAMILY = Bytes.toBytes((String)"a");
    protected HBaseTestingUtility utility;
    protected HBaseAdmin admin;

    @Before
    public void setUp() throws Exception {
        this.utility = new HBaseTestingUtility();
        this.utility.getConfiguration().setInt("hbase.hfile.compaction.discharger.interval", 10);
        this.utility.startMiniCluster();
    }

    @After
    public void tearDown() throws Exception {
        this.utility.shutdownMiniCluster();
    }

    @Test
    public void testCompactingATable() throws Exception {
        TableName tableName = TableName.valueOf((String)"MajorCompactorTest");
        this.utility.createMultiRegionTable(tableName, FAMILY, 5);
        this.utility.waitTableAvailable(tableName);
        Connection connection = this.utility.getConnection();
        Table table = connection.getTable(tableName);
        for (int i = 0; i < 5; ++i) {
            this.loadRandomRows(table, FAMILY, 50, 100);
            this.utility.flush(tableName);
        }
        table.close();
        int numberOfRegions = this.utility.getHBaseAdmin().getTableRegions(tableName).size();
        int numHFiles = this.utility.getNumHFiles(tableName, FAMILY);
        Assert.assertTrue((numberOfRegions < numHFiles ? 1 : 0) != 0);
        MajorCompactor compactor = new MajorCompactor(this.utility.getConfiguration(), tableName, (Set)Sets.newHashSet((Object[])new String[]{Bytes.toString((byte[])FAMILY)}), 1, System.currentTimeMillis(), 200L);
        compactor.initializeWorkQueues();
        compactor.compactAllRegions();
        compactor.shutdown();
        numberOfRegions = this.utility.getHBaseAdmin().getTableRegions(tableName).size();
        numHFiles = this.utility.getNumHFiles(tableName, FAMILY);
        Assert.assertEquals((long)numHFiles, (long)numberOfRegions);
    }

    protected void loadRandomRows(Table t, byte[] f, int rowSize, int totalRows) throws IOException {
        Random r = new Random();
        byte[] row = new byte[rowSize];
        for (int i = 0; i < totalRows; ++i) {
            r.nextBytes(row);
            Put put = new Put(row);
            put.addColumn(f, new byte[]{0}, new byte[]{0});
            t.put(put);
        }
    }
}

