/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util.compaction;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.regionserver.HRegionFileSystem;
import org.apache.hadoop.hbase.regionserver.StoreFileInfo;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.compaction.MajorCompactionTTLRequest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Matchers;
import org.mockito.Mockito;

@Category(value={SmallTests.class})
public class TestMajorCompactionTTLRequest {
    private static final HBaseTestingUtility UTILITY = new HBaseTestingUtility();
    private static final String FAMILY = "a";
    private Path regionStoreDir;

    @Before
    public void setUp() throws Exception {
        Path rootRegionDir = UTILITY.getDataTestDirOnTestFS("TestMajorCompactionTTLRequest");
        this.regionStoreDir = new Path(rootRegionDir, FAMILY);
    }

    @Test
    public void testStoresNeedingCompaction() throws Exception {
        List<StoreFileInfo> storeFiles1 = this.mockStoreFiles(this.regionStoreDir, 5, 10L);
        List<StoreFileInfo> storeFiles2 = this.mockStoreFiles(this.regionStoreDir, 5, 100L);
        ArrayList storeFiles = Lists.newArrayList(storeFiles1);
        storeFiles.addAll(storeFiles2);
        MajorCompactionTTLRequest request = this.makeMockRequest(storeFiles);
        Optional result = request.createRequest((Configuration)Mockito.mock(Configuration.class), (Set)Sets.newHashSet((Object[])new String[]{FAMILY}), 10L);
        Assert.assertFalse((boolean)result.isPresent());
        result = request.createRequest((Configuration)Mockito.mock(Configuration.class), (Set)Sets.newHashSet((Object[])new String[]{FAMILY}), 100L);
        Assert.assertFalse((boolean)result.isPresent());
        result = request.createRequest((Configuration)Mockito.mock(Configuration.class), (Set)Sets.newHashSet((Object[])new String[]{FAMILY}), 101L);
        Assert.assertTrue((boolean)result.isPresent());
    }

    private MajorCompactionTTLRequest makeMockRequest(List<StoreFileInfo> storeFiles) throws IOException {
        Configuration configuration = (Configuration)Mockito.mock(Configuration.class);
        HRegionInfo regionInfo = (HRegionInfo)Mockito.mock(HRegionInfo.class);
        Mockito.when((Object)regionInfo.getEncodedName()).thenReturn((Object)"HBase");
        Mockito.when((Object)regionInfo.getTable()).thenReturn((Object)TableName.valueOf((String)"foo"));
        MajorCompactionTTLRequest request = new MajorCompactionTTLRequest(configuration, regionInfo);
        MajorCompactionTTLRequest spy = (MajorCompactionTTLRequest)Mockito.spy((Object)request);
        HRegionFileSystem fileSystem = this.mockFileSystem(regionInfo, false, storeFiles);
        ((MajorCompactionTTLRequest)Mockito.doReturn((Object)fileSystem).when((Object)spy)).getFileSystem((Connection)Matchers.isA(Connection.class));
        ((MajorCompactionTTLRequest)Mockito.doReturn((Object)Mockito.mock(Connection.class)).when((Object)spy)).getConnection((Configuration)Matchers.eq((Object)configuration));
        return spy;
    }

    private HRegionFileSystem mockFileSystem(HRegionInfo info, boolean hasReferenceFiles, List<StoreFileInfo> storeFiles) throws IOException {
        Optional found = Optional.absent();
        Iterator<StoreFileInfo> i$ = storeFiles.iterator();
        if (i$.hasNext()) {
            StoreFileInfo storeFile = i$.next();
            found = Optional.of((Object)storeFile);
        }
        long timestamp = ((StoreFileInfo)found.get()).getModificationTime();
        return this.mockFileSystem(info, hasReferenceFiles, storeFiles, timestamp);
    }

    private List<StoreFileInfo> mockStoreFiles(Path regionStoreDir, int howMany, long timestamp) throws IOException {
        ArrayList infos = Lists.newArrayList();
        for (int i = 0; i < howMany; ++i) {
            StoreFileInfo storeFileInfo = (StoreFileInfo)Mockito.mock(StoreFileInfo.class);
            ((StoreFileInfo)Mockito.doReturn((Object)timestamp).doReturn((Object)timestamp).when((Object)storeFileInfo)).getModificationTime();
            ((StoreFileInfo)Mockito.doReturn((Object)new Path(regionStoreDir, RandomStringUtils.randomAlphabetic((int)10))).when((Object)storeFileInfo)).getPath();
            infos.add(storeFileInfo);
        }
        return infos;
    }

    private HRegionFileSystem mockFileSystem(HRegionInfo info, boolean hasReferenceFiles, List<StoreFileInfo> storeFiles, long referenceFileTimestamp) throws IOException {
        FileSystem fileSystem = (FileSystem)Mockito.mock(FileSystem.class);
        if (hasReferenceFiles) {
            FileStatus fileStatus = (FileStatus)Mockito.mock(FileStatus.class);
            ((FileStatus)Mockito.doReturn((Object)referenceFileTimestamp).when((Object)fileStatus)).getModificationTime();
            ((FileSystem)Mockito.doReturn((Object)fileStatus).when((Object)fileSystem)).getFileLinkStatus((Path)Matchers.isA(Path.class));
        }
        HRegionFileSystem mockSystem = (HRegionFileSystem)Mockito.mock(HRegionFileSystem.class);
        ((HRegionFileSystem)Mockito.doReturn((Object)info).when((Object)mockSystem)).getRegionInfo();
        ((HRegionFileSystem)Mockito.doReturn((Object)this.regionStoreDir).when((Object)mockSystem)).getStoreDir(FAMILY);
        ((HRegionFileSystem)Mockito.doReturn((Object)hasReferenceFiles).when((Object)mockSystem)).hasReferences(Matchers.anyString());
        ((HRegionFileSystem)Mockito.doReturn(storeFiles).when((Object)mockSystem)).getStoreFiles(Matchers.anyString());
        ((HRegionFileSystem)Mockito.doReturn((Object)fileSystem).when((Object)mockSystem)).getFileSystem();
        return mockSystem;
    }
}

