/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.generated.master;

import com.google.protobuf.ByteString;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.JspFactory;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.SkipPageException;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.RegionLoad;
import org.apache.hadoop.hbase.ServerLoad;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.RegionReplicaUtil;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.protobuf.generated.ClusterStatusProtos;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.zookeeper.MetaTableLocator;
import org.apache.hadoop.util.StringUtils;
import org.apache.jasper.runtime.HttpJspBase;
import org.apache.jasper.runtime.JspSourceDependent;
import org.apache.jasper.runtime.ResourceInjector;

public final class table_jsp
extends HttpJspBase
implements JspSourceDependent {
    private static final JspFactory _jspxFactory = JspFactory.getDefaultFactory();
    private static Vector _jspx_dependants;
    private ResourceInjector _jspx_resourceInjector;

    public Object getDependants() {
        return _jspx_dependants;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _jspService(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        PageContext pageContext = null;
        HttpSession session = null;
        ServletContext application = null;
        ServletConfig config = null;
        JspWriter out = null;
        table_jsp page = this;
        JspWriter _jspx_out = null;
        PageContext _jspx_page_context = null;
        try {
            response.setContentType("text/html;charset=UTF-8");
            _jspx_page_context = pageContext = _jspxFactory.getPageContext((Servlet)this, (ServletRequest)request, (ServletResponse)response, null, true, 8192, true);
            application = pageContext.getServletContext();
            config = pageContext.getServletConfig();
            session = pageContext.getSession();
            _jspx_out = out = pageContext.getOut();
            this._jspx_resourceInjector = (ResourceInjector)application.getAttribute("com.sun.appserv.jsp.resource.injector");
            out.write(10);
            out.write(10);
            HMaster master = (HMaster)this.getServletContext().getAttribute("master");
            Configuration conf = master.getConfiguration();
            MetaTableLocator metaTableLocator = new MetaTableLocator();
            String fqtn = request.getParameter("name");
            String escaped_fqtn = StringEscapeUtils.escapeHtml((String)fqtn);
            HTable table = null;
            boolean withReplica = false;
            ServerName rl = metaTableLocator.getMetaRegionLocation(master.getZooKeeper());
            boolean showFragmentation = conf.getBoolean("hbase.master.ui.fragmentation.enabled", false);
            boolean readOnly = conf.getBoolean("hbase.master.ui.readonly", false);
            int numMetaReplicas = conf.getInt("hbase.meta.replica.count", 1);
            Map<String, Integer> frags = null;
            if (showFragmentation) {
                frags = FSUtils.getTableFragmentation(master);
            }
            String action = request.getParameter("action");
            String key = request.getParameter("key");
            String left = request.getParameter("left");
            String right = request.getParameter("right");
            long totalStoreFileSizeMB = 0L;
            String numRegionsParam = request.getParameter("numRegions");
            int numRegionsToRender = 10000;
            if (numRegionsParam != null) {
                if (numRegionsParam.equals("all")) {
                    numRegionsToRender = -1;
                } else {
                    try {
                        numRegionsToRender = Integer.parseInt(numRegionsParam);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
            int numRegions = 0;
            out.write("\n<!--[if IE]>\n<!DOCTYPE html>\n<![endif]-->\n<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n<html xmlns=\"http://www.w3.org/1999/xhtml\">\n  <head>\n    <meta charset=\"utf-8\">\n    ");
            if (!readOnly && action != null) {
                out.write("\n        <title>HBase Master: ");
                out.print(StringEscapeUtils.escapeHtml((String)master.getServerName().toString()));
                out.write("</title>\n    ");
            } else {
                out.write("\n        <title>Table: ");
                out.print(escaped_fqtn);
                out.write("</title>\n    ");
            }
            out.write("\n    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">\n    <meta name=\"description\" content=\"\">\n    <meta name=\"author\" content=\"\">\n\n\n      <link href=\"/static/css/bootstrap.min.css\" rel=\"stylesheet\">\n      <link href=\"/static/css/bootstrap-theme.min.css\" rel=\"stylesheet\">\n      <link href=\"/static/css/hbase.css\" rel=\"stylesheet\">\n      ");
            if (!readOnly && action != null || fqtn == null) {
                out.write("\n\t  <script type=\"text/javascript\">\n      <!--\n\t\t  setTimeout(\"history.back()\",5000);\n\t  -->\n\t  </script>\n      ");
            } else {
                out.write("\n      <!--[if lt IE 9]>\n          <script src=\"/static/js/html5shiv.js\"></script>\n      <![endif]-->\n      ");
            }
            out.write("\n</head>\n<body>\n<div class=\"navbar  navbar-fixed-top navbar-default\">\n    <div class=\"container-fluid\">\n        <div class=\"navbar-header\">\n            <button type=\"button\" class=\"navbar-toggle\" data-toggle=\"collapse\" data-target=\".navbar-collapse\">\n                <span class=\"icon-bar\"></span>\n                <span class=\"icon-bar\"></span>\n                <span class=\"icon-bar\"></span>\n            </button>\n            <a class=\"navbar-brand\" href=\"/master-status\"><img src=\"/static/hbase_logo_small.png\" alt=\"HBase Logo\"/></a>\n        </div>\n        <div class=\"collapse navbar-collapse\">\n            <ul class=\"nav navbar-nav\">\n                <li><a href=\"/master-status\">Home</a></li>\n                <li><a href=\"/tablesDetailed.jsp\">Table Details</a></li>\n                <li><a href=\"/procedures.jsp\">Procedures</a></li>\n                <li><a href=\"/logs/\">Local Logs</a></li>\n                <li><a href=\"/logLevel\">Log Level</a></li>\n                <li><a href=\"/dump\">Debug Dump</a></li>\n                <li><a href=\"/jmx\">Metrics Dump</a></li>\n");
            out.write("                <li><a href=\"/prof\">Profiler</a></li>\n                ");
            if (HBaseConfiguration.isShowConfInServlet()) {
                out.write("\n                <li><a href=\"/conf\">HBase Configuration</a></li>\n                ");
            }
            out.write("\n            </ul>\n        </div><!--/.nav-collapse -->\n    </div>\n</div>\n");
            if (fqtn != null) {
                table = new HTable(conf, fqtn);
                if (table.getTableDescriptor().getRegionReplication() > 1) {
                    withReplica = true;
                }
                if (!readOnly && action != null) {
                    out.write("\n<div class=\"container-fluid content\">\n        <div class=\"row inner_header\">\n            <div class=\"page-header\">\n                <h1>Table action request accepted</h1>\n            </div>\n        </div>\n<p><hr><p>\n");
                    try (Admin admin = master.getConnection().getAdmin();){
                        if (action.equals("split")) {
                            if (key != null && key.length() > 0) {
                                admin.splitRegion(Bytes.toBytes((String)key));
                            } else {
                                admin.split(TableName.valueOf((String)fqtn));
                            }
                            out.write(" Split request accepted. ");
                        } else if (action.equals("compact")) {
                            if (key != null && key.length() > 0) {
                                admin.compactRegion(Bytes.toBytes((String)key));
                            } else {
                                admin.compact(TableName.valueOf((String)fqtn));
                            }
                            out.write(" Compact request accepted. ");
                        } else if (action.equals("merge")) {
                            if (left != null && left.length() > 0 && right != null && right.length() > 0) {
                                admin.mergeRegions(Bytes.toBytesBinary((String)left), Bytes.toBytesBinary((String)right), false);
                            }
                            out.write(" Merge request accepted. ");
                        }
                    }
                    out.write("\n<p>Go <a href=\"javascript:history.back()\">Back</a>, or wait for the redirect.\n</div>\n");
                } else {
                    out.write("\n<div class=\"container-fluid content\">\n    <div class=\"row inner_header\">\n        <div class=\"page-header\">\n            <h1>Table <small>");
                    out.print(escaped_fqtn);
                    out.write("</small></h1>\n        </div>\n    </div>\n    <div class=\"row\">\n");
                    if (fqtn.equals(TableName.META_TABLE_NAME.getNameAsString())) {
                        String url;
                        int i;
                        ServerName metaLocation;
                        HRegionInfo meta;
                        int j;
                        out.write("\n<h2>Table Regions</h2>\n<div class=\"tabbable\">\n  <ul class=\"nav nav-pills\">\n    <li class=\"active\">\n      <a href=\"#metaTab_baseStats\" data-toggle=\"tab\">Base Stats</a>\n    </li>\n    <li class=\"\">\n      <a href=\"#metaTab_compactStats\" data-toggle=\"tab\">Compactions</a>\n    </li>\n  </ul>\n  <div class=\"tab-content\" style=\"padding-bottom: 9px; border-bottom: 1px solid #ddd;\">\n    <div class=\"tab-pane active\" id=\"metaTab_baseStats\">\n      <table id=\"tableRegionTable\" class=\"tablesorter table table-striped\">\n        <thead>\n          <tr>\n            <th>Name</th>\n            <th>Region Server</th>\n            <th>ReadRequests</th>\n            <th>WriteRequests</th>\n            <th>StorefileSize</th>\n            <th>Num.Storefiles</th>\n            <th>MemSize</th>\n            <th>Locality</th>\n            <th>Start Key</th>\n            <th>End Key</th>\n            ");
                        if (withReplica) {
                            out.write("\n            <th>ReplicaID</th>\n            ");
                        }
                        out.write("\n          </tr>\n        </thead>\n        <tbody>\n        ");
                        for (j = 0; j < numMetaReplicas; ++j) {
                            meta = RegionReplicaUtil.getRegionInfoForReplica((HRegionInfo)HRegionInfo.FIRST_META_REGIONINFO, (int)j);
                            metaLocation = metaTableLocator.waitMetaRegionLocation(master.getZooKeeper(), j, 1L);
                            for (i = 0; i < 1; ++i) {
                                url = "";
                                String readReq = "N/A";
                                String writeReq = "N/A";
                                String fileSize = "N/A";
                                String fileCount = "N/A";
                                String memSize = "N/A";
                                float locality = 0.0f;
                                if (metaLocation != null) {
                                    Map map;
                                    ServerLoad sl = master.getServerManager().getLoad(metaLocation);
                                    url = "//" + URLEncoder.encode(metaLocation.getHostname()) + ":" + master.getRegionServerInfoPort(metaLocation) + "/";
                                    if (sl != null && (map = sl.getRegionsLoad()).containsKey(meta.getRegionName())) {
                                        RegionLoad load = (RegionLoad)map.get(meta.getRegionName());
                                        readReq = String.format("%,1d", load.getReadRequestsCount());
                                        writeReq = String.format("%,1d", load.getWriteRequestsCount());
                                        fileSize = StringUtils.byteDesc((long)((long)load.getStorefileSizeMB() * 1024L * 1024L));
                                        fileCount = String.format("%,1d", load.getStorefiles());
                                        memSize = StringUtils.byteDesc((long)((long)load.getMemStoreSizeMB() * 1024L * 1024L));
                                        locality = load.getDataLocality();
                                    }
                                }
                                out.write("\n          <tr>\n            ");
                                String metaLocationString = metaLocation != null ? StringEscapeUtils.escapeHtml((String)metaLocation.getHostname().toString()) + ":" + master.getRegionServerInfoPort(metaLocation) : "(null)";
                                out.write("\n            <td>");
                                out.print(StringEscapeUtils.escapeXml((String)meta.getRegionNameAsString()));
                                out.write("</td>\n            <td><a href=\"");
                                out.print(url);
                                out.write(34);
                                out.write(62);
                                out.print(metaLocationString);
                                out.write("</a></td>\n            <td>");
                                out.print(readReq);
                                out.write("</td>\n            <td>");
                                out.print(writeReq);
                                out.write("</td>\n            <td>");
                                out.print(fileSize);
                                out.write("</td>\n            <td>");
                                out.print(fileCount);
                                out.write("</td>\n            <td>");
                                out.print(memSize);
                                out.write("</td>\n            <td>");
                                out.print(locality);
                                out.write("</td>\n            <td>");
                                out.print(StringEscapeUtils.escapeXml((String)Bytes.toString((byte[])meta.getStartKey())));
                                out.write("</td>\n            <td>");
                                out.print(StringEscapeUtils.escapeXml((String)Bytes.toString((byte[])meta.getEndKey())));
                                out.write("</td>\n          ");
                                if (withReplica) {
                                    out.write("\n              <td>");
                                    out.print(meta.getReplicaId());
                                    out.write("</td>\n          ");
                                }
                                out.write("\n          </tr>\n          ");
                            }
                            out.write("\n          ");
                        }
                        out.write("\n        </tbody>\n      </table>\n    </div>\n    <div class=\"tab-pane\" id=\"metaTab_compactStats\">\n      <table id=\"metaTableCompactStatsTable\" class=\"tablesorter table table-striped\">\n        <thead>\n          <tr>\n            <th>Name</th>\n            <th>Region Server</th>\n            <th>Num. Compacting KVs</th>\n            <th>Num. Compacted KVs</th>\n            <th>Remaining KVs</th>\n            <th>Compaction Progress</th>\n          </tr>\n        </thead>\n        <tbody>\n        ");
                        for (j = 0; j < numMetaReplicas; ++j) {
                            meta = RegionReplicaUtil.getRegionInfoForReplica((HRegionInfo)HRegionInfo.FIRST_META_REGIONINFO, (int)j);
                            metaLocation = metaTableLocator.waitMetaRegionLocation(master.getZooKeeper(), j, 1L);
                            for (i = 0; i < 1; ++i) {
                                url = "";
                                long compactingKVs = 0L;
                                long compactedKVs = 0L;
                                String compactionProgress = "";
                                if (metaLocation != null) {
                                    Map map;
                                    ServerLoad sl = master.getServerManager().getLoad(metaLocation);
                                    url = "//" + URLEncoder.encode(metaLocation.getHostname()) + ":" + master.getRegionServerInfoPort(metaLocation) + "/";
                                    if (sl != null && (map = sl.getRegionsLoad()).containsKey(meta.getRegionName())) {
                                        RegionLoad load = (RegionLoad)map.get(meta.getRegionName());
                                        compactingKVs = load.getTotalCompactingKVs();
                                        compactedKVs = load.getCurrentCompactedKVs();
                                        if (compactingKVs > 0L) {
                                            compactionProgress = String.format("%.2f", Float.valueOf(100.0f * ((float)compactedKVs / (float)compactingKVs))) + "%";
                                        }
                                    }
                                }
                                out.write("\n          <tr>\n            ");
                                String metaLocationString = metaLocation != null ? StringEscapeUtils.escapeHtml((String)metaLocation.getHostname().toString()) + ":" + master.getRegionServerInfoPort(metaLocation) : "(null)";
                                out.write("\n            <td>");
                                out.print(StringEscapeUtils.escapeXml((String)meta.getRegionNameAsString()));
                                out.write("</td>\n            <td><a href=\"");
                                out.print(url);
                                out.write(34);
                                out.write(62);
                                out.print(metaLocationString);
                                out.write("</a></td>\n            <td>");
                                out.print(String.format("%,1d", compactingKVs));
                                out.write("</td>\n            <td>");
                                out.print(String.format("%,1d", compactedKVs));
                                out.write("</td>\n            <td>");
                                out.print(String.format("%,1d", compactingKVs - compactedKVs));
                                out.write("</td>\n            <td>");
                                out.print(compactionProgress);
                                out.write("</td>\n          </tr>\n        ");
                            }
                            out.write("\n        ");
                        }
                        out.write("\n        </tbody>\n      </table>\n    </div>\n  </div>\n</div>\n");
                    } else {
                        try (Admin admin = master.getConnection().getAdmin();){
                            out.write("\n<h2>Table Attributes</h2>\n<table class=\"table table-striped\">\n  <tr>\n      <th>Attribute Name</th>\n      <th>Value</th>\n      <th>Description</th>\n  </tr>\n  <tr>\n      <td>Enabled</td>\n      <td>");
                            out.print(admin.isTableEnabled(table.getName()));
                            out.write("</td>\n      <td>Is the table enabled</td>\n  </tr>\n  <tr>\n      <td>Compaction</td>\n      <td>\n");
                            try {
                                AdminProtos.GetRegionInfoResponse.CompactionState compactionState = admin.getCompactionState(table.getName());
                                out.write(10);
                                out.print((Object)compactionState);
                                out.write(10);
                            }
                            catch (Exception e) {
                                for (StackTraceElement element : e.getStackTrace()) {
                                    out.print(StringEscapeUtils.escapeHtml((String)element.toString()));
                                }
                                out.write(" Unknown ");
                            }
                            out.write("\n      </td>\n      <td>Is the table compacting</td>\n  </tr>\n");
                            if (showFragmentation) {
                                out.write("\n  <tr>\n      <td>Fragmentation</td>\n      <td>");
                                out.print(frags.get(fqtn) != null ? frags.get(fqtn) + "%" : "n/a");
                                out.write("</td>\n      <td>How fragmented is the table. After a major compaction it is 0%.</td>\n  </tr>\n");
                            }
                            out.write("\n</table>\n<h2>Table Schema</h2>\n<table class=\"table table-striped\">\n");
                            Collection families = table.getTableDescriptor().getFamilies();
                            HashSet familyKeySet = new HashSet();
                            for (HColumnDescriptor family : families) {
                                familyKeySet.addAll(family.getValues().keySet());
                            }
                            out.write("\n  <tr>\n    <th>Property \\ Column Family Name</th>\n    ");
                            for (HColumnDescriptor family : families) {
                                out.write("\n    <th>\n      ");
                                out.print(StringEscapeUtils.escapeHtml((String)family.getNameAsString()));
                                out.write("\n    </th>\n    ");
                            }
                            out.write("\n  </tr>\n    ");
                            for (ImmutableBytesWritable familyKey : familyKeySet) {
                                out.write("\n      <tr>\n        <td>\n          ");
                                out.print(StringEscapeUtils.escapeHtml((String)Bytes.toString((byte[])familyKey.get(), (int)familyKey.getOffset(), (int)familyKey.getLength())));
                                out.write("\n        </td>\n        ");
                                for (HColumnDescriptor family : families) {
                                    String familyValueStr = "-";
                                    Map familyValues = family.getValues();
                                    if (familyValues.containsKey(familyKey)) {
                                        ImmutableBytesWritable familyValue = (ImmutableBytesWritable)familyValues.get(familyKey);
                                        familyValueStr = Bytes.toString((byte[])familyValue.get(), (int)familyValue.getOffset(), (int)familyValue.getLength());
                                    }
                                    out.write("\n        <td>\n          ");
                                    out.print(StringEscapeUtils.escapeHtml((String)familyValueStr));
                                    out.write("\n        </td>\n        ");
                                }
                                out.write("\n      </tr>\n    ");
                            }
                            out.write("\n</table>\n");
                            long totalReadReq = 0L;
                            long totalWriteReq = 0L;
                            long totalSize = 0L;
                            long totalStoreFileCount = 0L;
                            long totalMemSize = 0L;
                            long totalCompactingKVs = 0L;
                            long totalCompactedKVs = 0L;
                            String percentDone = "";
                            String urlRegionServer = null;
                            TreeMap<ServerName, Integer> regDistribution = new TreeMap<ServerName, Integer>();
                            TreeMap<ServerName, Integer> primaryRegDistribution = new TreeMap<ServerName, Integer>();
                            LinkedHashMap<HRegionInfo, RegionLoad> regionsToLoad = new LinkedHashMap<HRegionInfo, RegionLoad>();
                            Map regions = table.getRegionLocations();
                            if (regions == null) {
                                regions = new HashMap();
                            }
                            for (Map.Entry hriEntry : regions.entrySet()) {
                                HRegionInfo regionInfo = (HRegionInfo)hriEntry.getKey();
                                ServerName serverName = (ServerName)hriEntry.getValue();
                                if (serverName != null) {
                                    ServerLoad sl = master.getServerManager().getLoad(serverName);
                                    if (sl != null) {
                                        Map map = sl.getRegionsLoad();
                                        RegionLoad regionload = (RegionLoad)map.get(regionInfo.getRegionName());
                                        regionsToLoad.put(regionInfo, regionload);
                                        if (regionload != null) {
                                            totalReadReq += regionload.getReadRequestsCount();
                                            totalWriteReq += regionload.getWriteRequestsCount();
                                            totalSize += (long)regionload.getStorefileSizeMB();
                                            totalStoreFileCount += (long)regionload.getStorefiles();
                                            totalMemSize += (long)regionload.getMemStoreSizeMB();
                                            totalStoreFileSizeMB += (long)regionload.getStorefileSizeMB();
                                            totalCompactingKVs += regionload.getTotalCompactingKVs();
                                            totalCompactedKVs += regionload.getCurrentCompactedKVs();
                                            continue;
                                        }
                                        RegionLoad load0 = new RegionLoad(ClusterStatusProtos.RegionLoad.newBuilder().setRegionSpecifier(HBaseProtos.RegionSpecifier.newBuilder().setValue(ByteString.copyFrom((byte[])regionInfo.getRegionName())).build()).build());
                                        regionsToLoad.put(regionInfo, load0);
                                        continue;
                                    }
                                    RegionLoad load0 = new RegionLoad(ClusterStatusProtos.RegionLoad.newBuilder().setRegionSpecifier(HBaseProtos.RegionSpecifier.newBuilder().setValue(ByteString.copyFrom((byte[])regionInfo.getRegionName())).build()).build());
                                    regionsToLoad.put(regionInfo, load0);
                                    continue;
                                }
                                RegionLoad load0 = new RegionLoad(ClusterStatusProtos.RegionLoad.newBuilder().setRegionSpecifier(HBaseProtos.RegionSpecifier.newBuilder().setValue(ByteString.copyFrom((byte[])regionInfo.getRegionName())).build()).build());
                                regionsToLoad.put(regionInfo, load0);
                            }
                            if (totalCompactingKVs > 0L) {
                                percentDone = String.format("%.2f", Float.valueOf(100.0f * ((float)totalCompactedKVs / (float)totalCompactingKVs))) + "%";
                            }
                            if (regions != null && regions.size() > 0) {
                                String allRegionsUrl;
                                RegionLoad load;
                                ServerName addr;
                                HRegionInfo regionInfo;
                                out.write("\n<h2>Table Regions</h2>\n<div class=\"tabbable\">\n  <ul class=\"nav nav-pills\">\n    <li class=\"active\">\n      <a href=\"#tab_baseStats\" data-toggle=\"tab\">Base Stats</a>\n    </li>\n    <li class=\"\">\n      <a href=\"#tab_compactStats\" data-toggle=\"tab\">Compactions</a>\n    </li>\n  </ul>\n  <div class=\"tab-content\" style=\"padding-bottom: 9px; border-bottom: 1px solid #ddd;\">\n    <div class=\"tab-pane active\" id=\"tab_baseStats\">\n      <table id=\"regionServerDetailsTable\" class=\"tablesorter table table-striped\">\n        <thead>\n          <tr>\n            <th>Name(");
                                out.print(String.format("%,1d", regions.size()));
                                out.write(")</th>\n            <th>Region Server</th>\n            <th>ReadRequests<br>(");
                                out.print(String.format("%,1d", totalReadReq));
                                out.write(")</th>\n            <th>WriteRequests<br>(");
                                out.print(String.format("%,1d", totalWriteReq));
                                out.write(")</th>\n            <th>StorefileSize<br>(");
                                out.print(StringUtils.byteDesc((long)(totalSize * 1024L * 1024L)));
                                out.write(")</th>\n            <th>Num.Storefiles<br>(");
                                out.print(String.format("%,1d", totalStoreFileCount));
                                out.write(")</th>\n            <th>MemSize<br>(");
                                out.print(StringUtils.byteDesc((long)(totalMemSize * 1024L * 1024L)));
                                out.write(")</th>\n            <th>Locality</th>\n            <th>Start Key</th>\n            <th>End Key</th>\n            ");
                                if (withReplica) {
                                    out.write("\n            <th>ReplicaID</th>\n            ");
                                }
                                out.write("\n          </tr>\n        </thead>\n        <tbody>\n        ");
                                ArrayList entryList = new ArrayList(regionsToLoad.entrySet());
                                numRegions = regions.size();
                                int numRegionsRendered = 0;
                                if (numRegionsToRender < 0) {
                                    numRegionsToRender = numRegions;
                                }
                                for (Map.Entry entry : entryList) {
                                    regionInfo = (HRegionInfo)entry.getKey();
                                    addr = (ServerName)regions.get(regionInfo);
                                    load = (RegionLoad)entry.getValue();
                                    String readReq = "N/A";
                                    String writeReq = "N/A";
                                    String regionSize = "N/A";
                                    String fileCount = "N/A";
                                    String memSize = "N/A";
                                    float locality = 0.0f;
                                    if (load != null) {
                                        readReq = String.format("%,1d", load.getReadRequestsCount());
                                        writeReq = String.format("%,1d", load.getWriteRequestsCount());
                                        regionSize = StringUtils.byteDesc((long)((long)load.getStorefileSizeMB() * 1024L * 1024L));
                                        fileCount = String.format("%,1d", load.getStorefiles());
                                        memSize = StringUtils.byteDesc((long)((long)load.getMemStoreSizeMB() * 1024L * 1024L));
                                        locality = load.getDataLocality();
                                    }
                                    if (addr != null) {
                                        ServerLoad sl = master.getServerManager().getLoad(addr);
                                        urlRegionServer = "//" + URLEncoder.encode(addr.getHostname()) + ":" + master.getRegionServerInfoPort(addr) + "/";
                                        if (sl != null) {
                                            Integer i = (Integer)regDistribution.get(addr);
                                            if (null == i) {
                                                i = 0;
                                            }
                                            regDistribution.put(addr, i + 1);
                                            if (withReplica && RegionReplicaUtil.isDefaultReplica((int)regionInfo.getReplicaId())) {
                                                i = (Integer)primaryRegDistribution.get(addr);
                                                if (null == i) {
                                                    i = 0;
                                                }
                                                primaryRegDistribution.put(addr, i + 1);
                                            }
                                        }
                                    }
                                    if (numRegionsRendered < numRegionsToRender) {
                                        ++numRegionsRendered;
                                        out.write("\n        <tr>\n          <td>");
                                        out.print(StringEscapeUtils.escapeXml((String)Bytes.toStringBinary((byte[])regionInfo.getRegionName())));
                                        out.write("</td>\n          ");
                                        if (urlRegionServer != null) {
                                            out.write("\n          <td>\n             <a href=\"");
                                            out.print(urlRegionServer);
                                            out.write(34);
                                            out.write(62);
                                            out.print(StringEscapeUtils.escapeHtml((String)addr.getHostname().toString()) + ":" + master.getRegionServerInfoPort(addr));
                                            out.write("</a>\n          </td>\n          ");
                                        } else {
                                            out.write("\n          <td class=\"undeployed-region\">not deployed</td>\n          ");
                                        }
                                        out.write("\n          <td>");
                                        out.print(readReq);
                                        out.write("</td>\n          <td>");
                                        out.print(writeReq);
                                        out.write("</td>\n          <td>");
                                        out.print(regionSize);
                                        out.write("</td>\n          <td>");
                                        out.print(fileCount);
                                        out.write("</td>\n          <td>");
                                        out.print(memSize);
                                        out.write("</td>\n          <td>");
                                        out.print(locality);
                                        out.write("</td>\n          <td>");
                                        out.print(StringEscapeUtils.escapeXml((String)Bytes.toStringBinary((byte[])regionInfo.getStartKey())));
                                        out.write("</td>\n          <td>");
                                        out.print(StringEscapeUtils.escapeXml((String)Bytes.toStringBinary((byte[])regionInfo.getEndKey())));
                                        out.write("</td>\n          ");
                                        if (withReplica) {
                                            out.write("\n          <td>");
                                            out.print(regionInfo.getReplicaId());
                                            out.write("</td>\n          ");
                                        }
                                        out.write("\n        </tr>\n        ");
                                    }
                                    out.write("\n        ");
                                }
                                out.write("\n        </tbody>\n      </table>\n      ");
                                if (numRegions > numRegionsRendered) {
                                    allRegionsUrl = "?name=" + URLEncoder.encode(fqtn, "UTF-8") + "&numRegions=all";
                                    out.write("\n        <p>This table has <b>");
                                    out.print(numRegions);
                                    out.write("</b> regions in total, in order to improve the page load time,\n           only <b>");
                                    out.print(numRegionsRendered);
                                    out.write("</b> regions are displayed here, <a href=\"");
                                    out.print(allRegionsUrl);
                                    out.write("\">click\n           here</a> to see all regions.</p>\n      ");
                                }
                                out.write("\n    </div>\n    <div class=\"tab-pane\" id=\"tab_compactStats\">\n      <table id=\"tableCompactStatsTable\" class=\"tablesorter table table-striped\">\n        <thead>\n          <tr>\n            <th>Name(");
                                out.print(String.format("%,1d", regions.size()));
                                out.write(")</th>\n            <th>Region Server</th>\n            <th>Num. Compacting KVs<br>(");
                                out.print(String.format("%,1d", totalCompactingKVs));
                                out.write(")</th>\n            <th>Num. Compacted KVs<br>(");
                                out.print(String.format("%,1d", totalCompactedKVs));
                                out.write(")</th>\n            <th>Remaining KVs<br>(");
                                out.print(String.format("%,1d", totalCompactingKVs - totalCompactedKVs));
                                out.write(")</th>\n            <th>Compaction Progress<br>(");
                                out.print(percentDone);
                                out.write(")</th>\n          </tr>\n        </thead>\n        <tbody>\n        ");
                                numRegionsRendered = 0;
                                for (Map.Entry entry : entryList) {
                                    regionInfo = (HRegionInfo)entry.getKey();
                                    addr = (ServerName)regions.get(regionInfo);
                                    load = (RegionLoad)entry.getValue();
                                    long compactingKVs = 0L;
                                    long compactedKVs = 0L;
                                    String compactionProgress = "";
                                    if (load != null) {
                                        compactingKVs = load.getTotalCompactingKVs();
                                        compactedKVs = load.getCurrentCompactedKVs();
                                        if (compactingKVs > 0L) {
                                            compactionProgress = String.format("%.2f", Float.valueOf(100.0f * ((float)compactedKVs / (float)compactingKVs))) + "%";
                                        }
                                    }
                                    if (addr != null) {
                                        urlRegionServer = "//" + URLEncoder.encode(addr.getHostname()) + ":" + master.getRegionServerInfoPort(addr) + "/";
                                    }
                                    if (numRegionsRendered < numRegionsToRender) {
                                        ++numRegionsRendered;
                                        out.write("\n        <tr>\n          <td>");
                                        out.print(StringEscapeUtils.escapeXml((String)Bytes.toStringBinary((byte[])regionInfo.getRegionName())));
                                        out.write("</td>\n          ");
                                        if (urlRegionServer != null) {
                                            out.write("\n          <td>\n             <a href=\"");
                                            out.print(urlRegionServer);
                                            out.write(34);
                                            out.write(62);
                                            out.print(StringEscapeUtils.escapeHtml((String)addr.getHostname().toString()) + ":" + master.getRegionServerInfoPort(addr));
                                            out.write("</a>\n          </td>\n          ");
                                        } else {
                                            out.write("\n          <td class=\"undeployed-region\">not deployed</td>\n          ");
                                        }
                                        out.write("\n          <td>");
                                        out.print(String.format("%,1d", compactingKVs));
                                        out.write("</td>\n          <td>");
                                        out.print(String.format("%,1d", compactedKVs));
                                        out.write("</td>\n          <td>");
                                        out.print(String.format("%,1d", compactingKVs - compactedKVs));
                                        out.write("</td>\n          <td>");
                                        out.print(compactionProgress);
                                        out.write("</td>\n        </tr>\n        ");
                                    }
                                    out.write("\n        ");
                                }
                                out.write("\n        </tbody>\n      </table>\n      ");
                                if (numRegions > numRegionsRendered) {
                                    allRegionsUrl = "?name=" + URLEncoder.encode(fqtn, "UTF-8") + "&numRegions=all";
                                    out.write("\n      <p>This table has <b>");
                                    out.print(numRegions);
                                    out.write("</b> regions in total, in order to improve the page load time,\n        only <b>");
                                    out.print(numRegionsRendered);
                                    out.write("</b> regions are displayed here, <a href=\"");
                                    out.print(allRegionsUrl);
                                    out.write("\">click\n        here</a> to see all regions.</p>\n      ");
                                }
                                out.write("\n    </div>\n  </div>\n</div>\n<h2>Regions by Region Server</h2>\n");
                                if (withReplica) {
                                    out.write("\n<table id=\"regionServerTable\" class=\"tablesorter table table-striped\"><thead><tr><th>Region Server</th><th>Region Count</th><th>Primary Region Count</th></tr><thead>\n");
                                } else {
                                    out.write("\n<table id=\"regionServerTable\" class=\"tablesorter table table-striped\"><thead><tr><th>Region Server</th><th>Region Count</th></tr></thead>\n<tbody>\n");
                                }
                                out.write(10);
                                for (Map.Entry entry : regDistribution.entrySet()) {
                                    ServerName addr2 = (ServerName)entry.getKey();
                                    String url = "//" + URLEncoder.encode(addr2.getHostname()) + ":" + master.getRegionServerInfoPort(addr2) + "/";
                                    out.write("\n<tr>\n  <td><a href=\"");
                                    out.print(url);
                                    out.write(34);
                                    out.write(62);
                                    out.print(StringEscapeUtils.escapeHtml((String)addr2.getHostname().toString()) + ":" + master.getRegionServerInfoPort(addr2));
                                    out.write("</a></td>\n  <td>");
                                    out.print(entry.getValue());
                                    out.write("</td>\n");
                                    if (withReplica) {
                                        out.write("\n  <td>");
                                        out.print(primaryRegDistribution.get(addr2));
                                        out.write("</td>\n");
                                    }
                                    out.write("\n</tr>\n");
                                }
                                out.write("\n</tbody>\n</table>\n");
                            }
                        }
                    }
                    out.write("\n\n<h2>Table Stats</h2>\n<table class=\"table table-striped\">\n  <tr>\n    <th>Name</th>\n    <th>Value</th>\n    <th>Description</th>\n  </tr>\n  <tr>\n    <td>Size</td>\n    <td>");
                    out.print(StringUtils.TraditionalBinaryPrefix.long2String((long)(totalStoreFileSizeMB * 1024L * 1024L), (String)"B", (int)2));
                    out.write("</td>\n    <td>Total size of store files (in bytes)</td>\n  </tr>\n</table>\n\n");
                    if (!readOnly) {
                        out.write("\n<p><hr/></p>\nActions:\n<p>\n<center>\n<table class=\"table\" width=\"95%\" >\n<tr>\n  <form method=\"get\">\n  <input type=\"hidden\" name=\"action\" value=\"compact\">\n  <input type=\"hidden\" name=\"name\" value=\"");
                        out.print(escaped_fqtn);
                        out.write("\">\n  <td style=\"border-style: none; text-align: center\">\n      <input style=\"font-size: 12pt; width: 10em\" type=\"submit\" value=\"Compact\" class=\"btn\"></td>\n  <td style=\"border-style: none\" width=\"5%\">&nbsp;</td>\n  <td style=\"border-style: none\">Region Key (optional):<input type=\"text\" name=\"key\" size=\"40\"></td>\n  <td style=\"border-style: none\">This action will force a compaction of all\n  regions of the table, or, if a key is supplied, only the region containing the\n  given key.</td>\n  </form>\n</tr>\n<tr><td style=\"border-style: none\" colspan=\"4\">&nbsp;</td></tr>\n<tr>\n  <form method=\"get\">\n  <input type=\"hidden\" name=\"action\" value=\"split\">\n  <input type=\"hidden\" name=\"name\" value=\"");
                        out.print(escaped_fqtn);
                        out.write("\">\n  <td style=\"border-style: none; text-align: center\">\n      <input style=\"font-size: 12pt; width: 10em\" type=\"submit\" value=\"Split\" class=\"btn\"></td>\n  <td style=\"border-style: none\" width=\"5%\">&nbsp;</td>\n  <td style=\"border-style: none\">Region Key (optional):<input type=\"text\" name=\"key\" size=\"40\"></td>\n  <td style=\"border-style: none\">This action will force a split of all eligible\n  regions of the table, or, if a key is supplied, only the region containing the\n  given key. An eligible region is one that does not contain any references to\n  other regions. Split requests for noneligible regions will be ignored.</td>\n  </form>\n</tr>\n<tr>\n  <form method=\"get\">\n  <input type=\"hidden\" name=\"action\" value=\"merge\">\n  <input type=\"hidden\" name=\"name\" value=\"");
                        out.print(escaped_fqtn);
                        out.write("\">\n  <td style=\"border-style: none; text-align: center\">\n      <input style=\"font-size: 12pt; width: 10em\" type=\"submit\" value=\"Merge\" class=\"btn\"></td>\n  <td style=\"border-style: none\" width=\"5%\">&nbsp;</td>\n  <td style=\"border-style: none\">Region Key (Required):<input type=\"text\" name=\"left\" size=\"40\">\n  Region Key (Required) :<input type=\"text\" name=\"right\" size=\"40\"></td>\n  <td style=\"border-style: none\">This action will merge two\n  regions of the table, Merge requests for noneligible regions will be ignored.</td>\n  </form>\n</tr>\n</table>\n</center>\n</p>\n");
                    }
                    out.write("\n</div>\n</div>\n");
                }
            } else {
                out.write("\n<div class=\"container-fluid content\">\n    <div class=\"row inner_header\">\n        <div class=\"page-header\">\n            <h1>Table not ready</h1>\n        </div>\n    </div>\n<p><hr><p>\n<p>Go <a href=\"javascript:history.back()\">Back</a>, or wait for the redirect.\n</div>\n");
            }
            out.write("\n<script src=\"/static/js/jquery.min.js\" type=\"text/javascript\"></script>\n<script src=\"/static/js/jquery.tablesorter.min.js\" type=\"text/javascript\"></script>\n<script src=\"/static/js/bootstrap.min.js\" type=\"text/javascript\"></script>\n\n</body>\n</html>\n\n<script>\n$(document).ready(function() \n    { \n        $(\"#regionServerTable\").tablesorter();\n        $(\"#regionServerDetailsTable\").tablesorter();\n        $(\"#tableRegionTable\").tablesorter();\n        $(\"#tableCompactStatsTable\").tablesorter();\n        $(\"#metaTableCompactStatsTable\").tablesorter();\n    } \n);\n</script>\n");
        }
        catch (Throwable t) {
            try {
                if (!(t instanceof SkipPageException)) {
                    out = _jspx_out;
                    if (out != null && out.getBufferSize() != 0) {
                        out.clearBuffer();
                    }
                    if (_jspx_page_context != null) {
                        _jspx_page_context.handlePageException(t);
                    }
                }
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                _jspxFactory.releasePageContext(_jspx_page_context);
            }
        }
        _jspxFactory.releasePageContext(_jspx_page_context);
    }
}

