/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import com.google.common.collect.ImmutableList;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.ZNodeClearer;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.monitoring.MonitoredTask;
import org.apache.hadoop.hbase.zookeeper.MasterAddressTracker;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperListener;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.zookeeper.KeeperException;

@InterfaceAudience.Private
@SuppressWarnings(value={"JLM_JSR166_UTILCONCURRENT_MONITORENTER"}, justification="Use of an atomic type both as monitor and condition variable is intended")
public class ActiveMasterManager
extends ZooKeeperListener {
    private static final Log LOG = LogFactory.getLog(ActiveMasterManager.class);
    final AtomicBoolean clusterHasActiveMaster = new AtomicBoolean(false);
    final AtomicBoolean clusterShutDown = new AtomicBoolean(false);
    private final ServerName sn;
    private int infoPort;
    private final Server master;
    volatile ServerName activeMasterServerName;
    private volatile ImmutableList<ServerName> backupMasters;

    ActiveMasterManager(ZooKeeperWatcher watcher, ServerName sn, Server master) throws InterruptedIOException {
        super(watcher);
        watcher.registerListener((ZooKeeperListener)this);
        this.sn = sn;
        this.master = master;
        this.updateBackupMasters();
    }

    public void setInfoPort(int infoPort) {
        this.infoPort = infoPort;
    }

    public void nodeCreated(String path) {
        this.handle(path);
    }

    public void nodeChildrenChanged(String path) {
        if (path.equals(this.watcher.backupMasterAddressesZNode)) {
            try {
                this.updateBackupMasters();
            }
            catch (InterruptedIOException ioe) {
                LOG.error((Object)"Error updating backup masters", (Throwable)ioe);
            }
        }
    }

    public void nodeDeleted(String path) {
        if (path.equals(this.watcher.clusterStateZNode) && !this.master.isStopped()) {
            this.clusterShutDown.set(true);
        }
        this.handle(path);
    }

    void handle(String path) {
        if (path.equals(this.watcher.getMasterAddressZNode()) && !this.master.isStopped()) {
            this.handleMasterNodeChange();
        }
    }

    private void updateBackupMasters() throws InterruptedIOException {
        this.backupMasters = ImmutableList.copyOf((Collection)MasterAddressTracker.getBackupMastersAndRenewWatch((ZooKeeperWatcher)this.watcher));
    }

    private void fetchAndSetActiveMasterServerName() {
        LOG.debug((Object)"Attempting to fetch active master sn from zk");
        try {
            this.activeMasterServerName = MasterAddressTracker.getMasterAddress((ZooKeeperWatcher)this.watcher);
        }
        catch (IOException | KeeperException e) {
            LOG.error((Object)"Error fetching active master information", e);
        }
    }

    public ServerName getActiveMasterServerName() {
        if (!this.clusterHasActiveMaster.get()) {
            return null;
        }
        if (this.activeMasterServerName == null) {
            this.fetchAndSetActiveMasterServerName();
        }
        return this.activeMasterServerName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleMasterNodeChange() {
        try {
            AtomicBoolean atomicBoolean = this.clusterHasActiveMaster;
            synchronized (atomicBoolean) {
                if (ZKUtil.watchAndCheckExists((ZooKeeperWatcher)this.watcher, (String)this.watcher.getMasterAddressZNode())) {
                    LOG.debug((Object)"A master is now available");
                    this.clusterHasActiveMaster.set(true);
                } else {
                    LOG.debug((Object)"No master available. Notifying waiting threads");
                    this.clusterHasActiveMaster.set(false);
                    this.clusterHasActiveMaster.notifyAll();
                }
                this.activeMasterServerName = null;
            }
        }
        catch (KeeperException ke) {
            this.master.abort("Received an unexpected KeeperException, aborting", ke);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean blockUntilBecomingActiveMaster(int checkInterval, MonitoredTask startupStatus) {
        String backupZNode = ZKUtil.joinZNode((String)this.watcher.backupMasterAddressesZNode, (String)this.sn.toString());
        while (!this.master.isAborted() && !this.master.isStopped()) {
            startupStatus.setStatus("Trying to register in ZK as active master");
            try {
                String msg;
                if (MasterAddressTracker.setMasterAddress((ZooKeeperWatcher)this.watcher, (String)this.watcher.getMasterAddressZNode(), (ServerName)this.sn, (int)this.infoPort)) {
                    if (ZKUtil.checkExists((ZooKeeperWatcher)this.watcher, (String)backupZNode) != -1) {
                        LOG.info((Object)("Deleting ZNode for " + backupZNode + " from backup master directory"));
                        ZKUtil.deleteNodeFailSilent((ZooKeeperWatcher)this.watcher, (String)backupZNode);
                    }
                    ZNodeClearer.writeMyEphemeralNodeOnDisk(this.sn.toString());
                    startupStatus.setStatus("Successfully registered as active master.");
                    this.clusterHasActiveMaster.set(true);
                    LOG.info((Object)("Registered Active Master=" + this.sn));
                    this.activeMasterServerName = this.sn;
                    return true;
                }
                this.activeMasterServerName = null;
                this.clusterHasActiveMaster.set(true);
                byte[] bytes = ZKUtil.getDataAndWatch((ZooKeeperWatcher)this.watcher, (String)this.watcher.getMasterAddressZNode());
                if (bytes == null) {
                    msg = "A master was detected, but went down before its address could be read.  Attempting to become the next active master";
                } else {
                    ServerName currentMaster;
                    try {
                        currentMaster = ServerName.parseFrom((byte[])bytes);
                    }
                    catch (DeserializationException e) {
                        LOG.warn((Object)"Failed parse", (Throwable)e);
                        continue;
                    }
                    if (ServerName.isSameHostnameAndPort((ServerName)currentMaster, (ServerName)this.sn)) {
                        msg = "Current master has this master's address, " + currentMaster + "; master was restarted? Deleting node.";
                        ZKUtil.deleteNode((ZooKeeperWatcher)this.watcher, (String)this.watcher.getMasterAddressZNode());
                        ZNodeClearer.deleteMyEphemeralNodeOnDisk();
                    } else {
                        msg = "Another master is the active master, " + currentMaster + "; waiting to become the next active master";
                    }
                }
                LOG.info((Object)msg);
                startupStatus.setStatus(msg);
            }
            catch (KeeperException ke) {
                this.master.abort("Received an unexpected KeeperException, aborting", ke);
                return false;
            }
            AtomicBoolean atomicBoolean = this.clusterHasActiveMaster;
            synchronized (atomicBoolean) {
                while (this.clusterHasActiveMaster.get() && !this.master.isStopped()) {
                    try {
                        this.clusterHasActiveMaster.wait(checkInterval);
                    }
                    catch (InterruptedException e) {
                        LOG.debug((Object)"Interrupted waiting for master to die", (Throwable)e);
                    }
                }
                if (this.clusterShutDown.get()) {
                    this.master.stop("Cluster went down before this master became active");
                }
            }
        }
        return false;
    }

    boolean hasActiveMaster() {
        try {
            if (ZKUtil.checkExists((ZooKeeperWatcher)this.watcher, (String)this.watcher.getMasterAddressZNode()) >= 0) {
                return true;
            }
        }
        catch (KeeperException ke) {
            LOG.info((Object)("Received an unexpected KeeperException when checking isActiveMaster : " + (Object)((Object)ke)));
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        try {
            AtomicBoolean atomicBoolean = this.clusterHasActiveMaster;
            synchronized (atomicBoolean) {
                this.clusterHasActiveMaster.notifyAll();
            }
            ServerName activeMaster = null;
            try {
                activeMaster = MasterAddressTracker.getMasterAddress((ZooKeeperWatcher)this.watcher);
            }
            catch (IOException e) {
                LOG.warn((Object)("Failed get of master address: " + e.toString()));
            }
            if (activeMaster != null && activeMaster.equals((Object)this.sn)) {
                ZKUtil.deleteNode((ZooKeeperWatcher)this.watcher, (String)this.watcher.getMasterAddressZNode());
                ZNodeClearer.deleteMyEphemeralNodeOnDisk();
            }
        }
        catch (KeeperException e) {
            LOG.error((Object)this.watcher.prefix("Error deleting our own master address node"), (Throwable)e);
        }
    }

    public List<ServerName> getBackupMasters() {
        return this.backupMasters;
    }
}

