/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.cleaner;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ScheduledChore;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.master.snapshot.SnapshotManager;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;

@InterfaceAudience.Private
public class SnapshotCleanerChore
extends ScheduledChore {
    private static final Log LOG = LogFactory.getLog(SnapshotCleanerChore.class);
    private static final String SNAPSHOT_CLEANER_CHORE_NAME = "SnapshotCleaner";
    private static final String SNAPSHOT_CLEANER_INTERVAL = "hbase.master.cleaner.snapshot.interval";
    private static final int SNAPSHOT_CLEANER_DEFAULT_INTERVAL = 1800000;
    private static final String DELETE_SNAPSHOT_EVENT = "Eligible Snapshot for cleanup due to expired TTL.";
    private final SnapshotManager snapshotManager;

    public SnapshotCleanerChore(Stoppable stopper, Configuration configuration, SnapshotManager snapshotManager) {
        super(SNAPSHOT_CLEANER_CHORE_NAME, stopper, configuration.getInt(SNAPSHOT_CLEANER_INTERVAL, 1800000));
        this.snapshotManager = snapshotManager;
    }

    protected void chore() {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)"Snapshot Cleaner Chore is starting up...");
        }
        try {
            List<HBaseProtos.SnapshotDescription> completedSnapshotsList = this.snapshotManager.getCompletedSnapshots();
            for (HBaseProtos.SnapshotDescription snapshotDescription : completedSnapshotsList) {
                long snapshotCreatedTime = snapshotDescription.getCreationTime();
                long snapshotTtl = snapshotDescription.getTtl();
                if (snapshotCreatedTime <= 0L || snapshotTtl <= 0L || snapshotTtl >= TimeUnit.MILLISECONDS.toSeconds(Long.MAX_VALUE)) continue;
                long currentTime = EnvironmentEdgeManager.currentTime();
                if (snapshotCreatedTime + TimeUnit.SECONDS.toMillis(snapshotTtl) >= currentTime) continue;
                LOG.info((Object)("Event: Eligible Snapshot for cleanup due to expired TTL. Name: " + snapshotDescription.getName() + ", CreatedTime: " + snapshotCreatedTime + ", TTL: " + snapshotTtl + ", currentTime: " + currentTime));
                this.deleteExpiredSnapshot(snapshotDescription);
            }
        }
        catch (IOException e) {
            LOG.error((Object)"Error while cleaning up Snapshots...", (Throwable)e);
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)"Snapshot Cleaner Chore is closing...");
        }
    }

    private void deleteExpiredSnapshot(HBaseProtos.SnapshotDescription snapshotDescription) {
        try {
            this.snapshotManager.deleteSnapshot(snapshotDescription);
        }
        catch (Exception e) {
            LOG.error((Object)("Error while deleting Snapshot: " + snapshotDescription.getName()), (Throwable)e);
        }
    }
}

