/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.querymatcher;

import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeepDeletedCells;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.regionserver.DeleteTracker;
import org.apache.hadoop.hbase.regionserver.ScanInfo;
import org.apache.hadoop.hbase.regionserver.querymatcher.CompactionScanQueryMatcher;
import org.apache.hadoop.hbase.regionserver.querymatcher.ScanQueryMatcher;

@InterfaceAudience.Private
public abstract class DropDeletesCompactionScanQueryMatcher
extends CompactionScanQueryMatcher {
    protected final long timeToPurgeDeletes;
    protected final long earliestPutTs;

    protected DropDeletesCompactionScanQueryMatcher(ScanInfo scanInfo, DeleteTracker deletes, long readPointToUse, long earliestPutTs, long oldestUnexpiredTS, long now) {
        super(scanInfo, deletes, readPointToUse, oldestUnexpiredTS, now);
        this.timeToPurgeDeletes = scanInfo.getTimeToPurgeDeletes();
        this.earliestPutTs = earliestPutTs;
    }

    protected final ScanQueryMatcher.MatchCode tryDropDelete(Cell cell) {
        long timestamp = cell.getTimestamp();
        if (this.timeToPurgeDeletes > 0L && this.now - timestamp <= this.timeToPurgeDeletes) {
            return ScanQueryMatcher.MatchCode.INCLUDE;
        }
        if (this.keepDeletedCells == KeepDeletedCells.TRUE || this.keepDeletedCells == KeepDeletedCells.TTL && timestamp >= this.oldestUnexpiredTS) {
            if (timestamp < this.earliestPutTs) {
                return this.columns.getNextRowOrNextColumn(cell.getQualifierArray(), cell.getQualifierOffset(), cell.getQualifierLength());
            }
            return null;
        }
        return ScanQueryMatcher.MatchCode.SKIP;
    }
}

