/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication.regionserver;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.hbase.CompatibilitySingletonFactory;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.metrics.BaseSource;
import org.apache.hadoop.hbase.metrics.MetricRegistryInfo;
import org.apache.hadoop.hbase.replication.regionserver.MetricsReplicationSourceFactory;
import org.apache.hadoop.hbase.replication.regionserver.MetricsReplicationSourceSource;
import org.apache.hadoop.hbase.replication.regionserver.MetricsReplicationTableSource;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.wal.WAL;

@InterfaceAudience.LimitedPrivate(value={"Replication"})
public class MetricsSource
implements BaseSource {
    private Map<String, Long> lastTimestamps = new HashMap<String, Long>();
    private Map<String, Long> ageOfLastShippedOp = new HashMap<String, Long>();
    private long lastHFileRefsQueueSize = 0L;
    private String id;
    private final MetricsReplicationSourceSource singleSourceSource;
    private final MetricsReplicationSourceSource globalSourceSource;
    private Map<String, MetricsReplicationTableSource> singleSourceSourceByTable;

    public MetricsSource(String id) {
        this.id = id;
        this.singleSourceSource = ((MetricsReplicationSourceFactory)CompatibilitySingletonFactory.getInstance(MetricsReplicationSourceFactory.class)).getSource(id);
        this.globalSourceSource = ((MetricsReplicationSourceFactory)CompatibilitySingletonFactory.getInstance(MetricsReplicationSourceFactory.class)).getGlobalSource();
        this.singleSourceSourceByTable = new ConcurrentHashMap<String, MetricsReplicationTableSource>();
    }

    public MetricsSource(String id, MetricsReplicationSourceSource singleSourceSource, MetricsReplicationSourceSource globalSourceSource, Map<String, MetricsReplicationTableSource> singleSourceSourceByTable) {
        this.id = id;
        this.singleSourceSource = singleSourceSource;
        this.globalSourceSource = globalSourceSource;
        this.singleSourceSourceByTable = singleSourceSourceByTable;
    }

    private MetricsReplicationTableSource getSourceForTable(String tableName) {
        MetricsReplicationTableSource otherTableSource;
        MetricsReplicationTableSource tableSource = this.singleSourceSourceByTable.get(tableName);
        if (tableSource == null && (otherTableSource = ((ConcurrentHashMap)this.singleSourceSourceByTable).putIfAbsent(tableName, tableSource = ((MetricsReplicationSourceFactory)CompatibilitySingletonFactory.getInstance(MetricsReplicationSourceFactory.class)).getTableSource(tableName))) != null) {
            tableSource = otherTableSource;
        }
        return tableSource;
    }

    public void updateTableLevelMetrics(List<Pair<WAL.Entry, Long>> walEntries) {
        for (Pair<WAL.Entry, Long> walEntryWithSize : walEntries) {
            WAL.Entry entry = (WAL.Entry)walEntryWithSize.getFirst();
            long entrySize = (Long)walEntryWithSize.getSecond();
            String tableName = entry.getKey().getTablename().getNameAsString();
            long writeTime = entry.getKey().getWriteTime();
            long age = EnvironmentEdgeManager.currentTime() - writeTime;
            MetricsReplicationTableSource tableSource = this.getSourceForTable(tableName);
            tableSource.setLastShippedAge(age);
            tableSource.incrShippedBytes(entrySize);
        }
    }

    public void setAgeOfLastShippedOp(long timestamp, String walGroup) {
        long age = EnvironmentEdgeManager.currentTime() - timestamp;
        this.singleSourceSource.setLastShippedAge(age);
        this.globalSourceSource.setLastShippedAge(age);
        this.ageOfLastShippedOp.put(walGroup, age);
        this.lastTimestamps.put(walGroup, timestamp);
    }

    public void setAgeOfLastShippedOpByTable(long timestamp, String tableName) {
        this.getSourceForTable(tableName).setLastShippedAge(EnvironmentEdgeManager.currentTime() - timestamp);
    }

    public long getLastTimeStampOfWalGroup(String walGroup) {
        return this.lastTimestamps.get(walGroup) == null ? 0L : this.lastTimestamps.get(walGroup);
    }

    public long getAgeOfLastShippedOp(String walGroup) {
        return this.ageOfLastShippedOp.get(walGroup) == null ? 0L : this.ageOfLastShippedOp.get(walGroup);
    }

    public void refreshAgeOfLastShippedOp(String walGroupId) {
        Long lastTimestamp = this.lastTimestamps.get(walGroupId);
        if (lastTimestamp == null) {
            this.lastTimestamps.put(walGroupId, 0L);
            lastTimestamp = 0L;
        }
        if (lastTimestamp > 0L) {
            this.setAgeOfLastShippedOp(lastTimestamp, walGroupId);
        }
    }

    public void incrSizeOfLogQueue() {
        this.singleSourceSource.incrSizeOfLogQueue(1);
        this.globalSourceSource.incrSizeOfLogQueue(1);
    }

    public void decrSizeOfLogQueue() {
        this.singleSourceSource.decrSizeOfLogQueue(1);
        this.globalSourceSource.decrSizeOfLogQueue(1);
    }

    public void incrSourceInitializing() {
        this.singleSourceSource.incrSourceInitializing();
        this.globalSourceSource.incrSourceInitializing();
    }

    public void decrSourceInitializing() {
        this.singleSourceSource.decrSourceInitializing();
        this.globalSourceSource.decrSourceInitializing();
    }

    private void incrLogEditsRead(long delta) {
        this.singleSourceSource.incrLogReadInEdits(delta);
        this.globalSourceSource.incrLogReadInEdits(delta);
    }

    public void incrLogEditsRead() {
        this.incrLogEditsRead(1L);
    }

    public void incrLogEditsFiltered(long delta) {
        this.singleSourceSource.incrLogEditsFiltered(delta);
        this.globalSourceSource.incrLogEditsFiltered(delta);
    }

    public void incrLogEditsFiltered() {
        this.incrLogEditsFiltered(1L);
    }

    public void shipBatch(long batchSize, int sizeInBytes) {
        this.singleSourceSource.incrBatchesShipped(1);
        this.globalSourceSource.incrBatchesShipped(1);
        this.singleSourceSource.incrOpsShipped(batchSize);
        this.globalSourceSource.incrOpsShipped(batchSize);
        this.singleSourceSource.incrShippedBytes((long)sizeInBytes);
        this.globalSourceSource.incrShippedBytes((long)sizeInBytes);
    }

    public void shipBatch(long batchSize, int sizeInBytes, long hfiles) {
        this.shipBatch(batchSize, sizeInBytes);
        this.singleSourceSource.incrHFilesShipped(hfiles);
        this.globalSourceSource.incrHFilesShipped(hfiles);
    }

    public void incrLogReadInBytes(long readInBytes) {
        this.singleSourceSource.incrLogReadInBytes(readInBytes);
        this.globalSourceSource.incrLogReadInBytes(readInBytes);
    }

    public void clear() {
        int lastQueueSize = this.singleSourceSource.getSizeOfLogQueue();
        this.globalSourceSource.decrSizeOfLogQueue(lastQueueSize);
        this.singleSourceSource.decrSizeOfLogQueue(lastQueueSize);
        this.singleSourceSource.clear();
        this.globalSourceSource.decrSizeOfHFileRefsQueue(this.lastHFileRefsQueueSize);
        this.lastTimestamps.clear();
        this.ageOfLastShippedOp.clear();
        this.lastHFileRefsQueueSize = 0L;
    }

    public Long getAgeOfLastShippedOp() {
        return this.singleSourceSource.getLastShippedAge();
    }

    public int getSizeOfLogQueue() {
        return this.singleSourceSource.getSizeOfLogQueue();
    }

    public long getTimeStampOfLastShippedOp() {
        long lastTimestamp = 0L;
        for (long ts : this.lastTimestamps.values()) {
            if (ts <= lastTimestamp) continue;
            lastTimestamp = ts;
        }
        return lastTimestamp;
    }

    public long getUncleanlyClosedWALs() {
        return this.singleSourceSource.getUncleanlyClosedWALs();
    }

    public int getSourceInitializing() {
        return this.singleSourceSource.getSourceInitializing();
    }

    public String getPeerID() {
        return this.id;
    }

    public void incrSizeOfHFileRefsQueue(long size) {
        this.singleSourceSource.incrSizeOfHFileRefsQueue(size);
        this.globalSourceSource.incrSizeOfHFileRefsQueue(size);
        this.lastHFileRefsQueueSize = size;
    }

    public void decrSizeOfHFileRefsQueue(int size) {
        this.singleSourceSource.decrSizeOfHFileRefsQueue((long)size);
        this.globalSourceSource.decrSizeOfHFileRefsQueue((long)size);
        this.lastHFileRefsQueueSize -= (long)size;
        if (this.lastHFileRefsQueueSize < 0L) {
            this.lastHFileRefsQueueSize = 0L;
        }
    }

    public void incrUnknownFileLengthForClosedWAL() {
        this.singleSourceSource.incrUnknownFileLengthForClosedWAL();
        this.globalSourceSource.incrUnknownFileLengthForClosedWAL();
    }

    public void incrUncleanlyClosedWALs() {
        this.singleSourceSource.incrUncleanlyClosedWALs();
        this.globalSourceSource.incrUncleanlyClosedWALs();
    }

    public void incrBytesSkippedInUncleanlyClosedWALs(long bytes) {
        this.singleSourceSource.incrBytesSkippedInUncleanlyClosedWALs(bytes);
        this.globalSourceSource.incrBytesSkippedInUncleanlyClosedWALs(bytes);
    }

    public void incrRestartedWALReading() {
        this.singleSourceSource.incrRestartedWALReading();
        this.globalSourceSource.incrRestartedWALReading();
    }

    public void incrRepeatedFileBytes(long bytes) {
        this.singleSourceSource.incrRepeatedFileBytes(bytes);
        this.globalSourceSource.incrRepeatedFileBytes(bytes);
    }

    public void incrCompletedWAL() {
        this.singleSourceSource.incrCompletedWAL();
        this.globalSourceSource.incrCompletedWAL();
    }

    public void incrCompletedRecoveryQueue() {
        this.singleSourceSource.incrCompletedRecoveryQueue();
        this.globalSourceSource.incrCompletedRecoveryQueue();
    }

    public void incrFailedRecoveryQueue() {
        this.globalSourceSource.incrFailedRecoveryQueue();
    }

    public void init() {
        this.singleSourceSource.init();
        this.globalSourceSource.init();
    }

    public void setGauge(String gaugeName, long value) {
        this.singleSourceSource.setGauge(gaugeName, value);
        this.globalSourceSource.setGauge(gaugeName, value);
    }

    public void incGauge(String gaugeName, long delta) {
        this.singleSourceSource.incGauge(gaugeName, delta);
        this.globalSourceSource.incGauge(gaugeName, delta);
    }

    public void decGauge(String gaugeName, long delta) {
        this.singleSourceSource.decGauge(gaugeName, delta);
        this.globalSourceSource.decGauge(gaugeName, delta);
    }

    public void removeMetric(String key) {
        this.singleSourceSource.removeMetric(key);
        this.globalSourceSource.removeMetric(key);
    }

    public void incCounters(String counterName, long delta) {
        this.singleSourceSource.incCounters(counterName, delta);
        this.globalSourceSource.incCounters(counterName, delta);
    }

    public void updateHistogram(String name, long value) {
        this.singleSourceSource.updateHistogram(name, value);
        this.globalSourceSource.updateHistogram(name, value);
    }

    public void setOldestWalAge(long age) {
        this.singleSourceSource.setOldestWalAge(age);
    }

    public long getOldestWalAge() {
        return this.singleSourceSource.getOldestWalAge();
    }

    public String getMetricsContext() {
        return this.globalSourceSource.getMetricsContext();
    }

    public String getMetricsDescription() {
        return this.globalSourceSource.getMetricsDescription();
    }

    public String getMetricsJmxContext() {
        return this.globalSourceSource.getMetricsJmxContext();
    }

    public String getMetricsName() {
        return this.globalSourceSource.getMetricsName();
    }

    public Map<String, MetricsReplicationTableSource> getSingleSourceSourceByTable() {
        return this.singleSourceSourceByTable;
    }

    public MetricRegistryInfo getMetricRegistryInfo() {
        return new MetricRegistryInfo(this.getMetricsName(), this.getMetricsDescription(), this.getMetricsContext(), this.getMetricsJmxContext(), true);
    }
}

