/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util.hbck;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.master.cleaner.ReplicationZKNodeCleaner;
import org.apache.hadoop.hbase.replication.ReplicationQueueInfo;
import org.apache.hadoop.hbase.util.HBaseFsck;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;

@InterfaceAudience.Private
public class ReplicationChecker {
    private final HBaseFsck.ErrorReporter errorReporter;
    private Map<String, List<String>> undeletedQueueIds = new HashMap<String, List<String>>();
    private Set<String> undeletedHFileRefsQueueIds = new HashSet<String>();
    private final ReplicationZKNodeCleaner cleaner;

    public ReplicationChecker(Configuration conf, ZooKeeperWatcher zkw, HConnection connection, HBaseFsck.ErrorReporter errorReporter) throws IOException {
        this.cleaner = new ReplicationZKNodeCleaner(conf, zkw, (Abortable)connection);
        this.errorReporter = errorReporter;
    }

    public boolean hasUnDeletedQueues() {
        return this.errorReporter.getErrorList().contains((Object)HBaseFsck.ErrorReporter.ERROR_CODE.UNDELETED_REPLICATION_QUEUE);
    }

    public void checkUnDeletedQueues() throws IOException {
        this.undeletedQueueIds = this.cleaner.getUnDeletedQueues();
        for (Map.Entry<String, List<String>> replicatorAndQueueIds : this.undeletedQueueIds.entrySet()) {
            String replicator = replicatorAndQueueIds.getKey();
            for (String queueId : replicatorAndQueueIds.getValue()) {
                ReplicationQueueInfo queueInfo = new ReplicationQueueInfo(queueId);
                String msg = "Undeleted replication queue for removed peer found: " + String.format("[removedPeerId=%s, replicator=%s, queueId=%s]", queueInfo.getPeerId(), replicator, queueId);
                this.errorReporter.reportError(HBaseFsck.ErrorReporter.ERROR_CODE.UNDELETED_REPLICATION_QUEUE, msg);
            }
        }
        this.checkUnDeletedHFileRefsQueues();
    }

    private void checkUnDeletedHFileRefsQueues() throws IOException {
        this.undeletedHFileRefsQueueIds = this.cleaner.getUnDeletedHFileRefsQueues();
        if (this.undeletedHFileRefsQueueIds != null && !this.undeletedHFileRefsQueueIds.isEmpty()) {
            String msg = "Undeleted replication hfile-refs queue for removed peer found: " + this.undeletedHFileRefsQueueIds + " under hfile-refs node";
            this.errorReporter.reportError(HBaseFsck.ErrorReporter.ERROR_CODE.UNDELETED_REPLICATION_QUEUE, msg);
        }
    }

    public void fixUnDeletedQueues() throws IOException {
        if (!this.undeletedQueueIds.isEmpty()) {
            this.cleaner.removeQueues(this.undeletedQueueIds);
        }
        this.fixUnDeletedHFileRefsQueue();
    }

    private void fixUnDeletedHFileRefsQueue() throws IOException {
        if (this.undeletedHFileRefsQueueIds != null && !this.undeletedHFileRefsQueueIds.isEmpty()) {
            this.cleaner.removeHFileRefsQueues(this.undeletedHFileRefsQueueIds);
        }
    }
}

