/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.assignment;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.exceptions.UnexpectedStateException;
import org.apache.hadoop.hbase.master.assignment.AssignmentManager;
import org.apache.hadoop.hbase.master.assignment.FailedRemoteDispatchException;
import org.apache.hadoop.hbase.master.assignment.RegionStates;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.TableProcedureInterface;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureSuspendedException;
import org.apache.hadoop.hbase.procedure2.RemoteProcedureDispatcher;
import org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProcedureProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.RegionServerStatusProtos;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public abstract class RegionTransitionProcedure
extends Procedure<MasterProcedureEnv>
implements TableProcedureInterface,
RemoteProcedureDispatcher.RemoteProcedure<MasterProcedureEnv, ServerName> {
    private static final Log LOG = LogFactory.getLog(RegionTransitionProcedure.class);
    protected final AtomicBoolean aborted = new AtomicBoolean(false);
    private MasterProcedureProtos.RegionTransitionState transitionState = MasterProcedureProtos.RegionTransitionState.REGION_TRANSITION_QUEUE;
    private RegionInfo regionInfo;
    private volatile boolean lock = false;

    public RegionTransitionProcedure() {
    }

    public RegionTransitionProcedure(RegionInfo regionInfo) {
        this.regionInfo = regionInfo;
    }

    public RegionInfo getRegionInfo() {
        return this.regionInfo;
    }

    protected void setRegionInfo(RegionInfo regionInfo) {
        this.regionInfo = regionInfo;
    }

    @Override
    public TableName getTableName() {
        RegionInfo hri = this.getRegionInfo();
        return hri != null ? hri.getTable() : null;
    }

    public boolean isMeta() {
        return TableName.isMetaTableName((TableName)this.getTableName());
    }

    public void toStringClassDetails(StringBuilder sb) {
        sb.append(this.getClass().getSimpleName());
        sb.append(" table=");
        sb.append(this.getTableName());
        sb.append(", region=");
        sb.append(this.getRegionInfo() == null ? null : this.getRegionInfo().getEncodedName());
    }

    public RegionStates.RegionStateNode getRegionState(MasterProcedureEnv env) {
        return env.getAssignmentManager().getRegionStates().getOrCreateRegionNode(this.getRegionInfo());
    }

    protected void setTransitionState(MasterProcedureProtos.RegionTransitionState state) {
        this.transitionState = state;
    }

    protected MasterProcedureProtos.RegionTransitionState getTransitionState() {
        return this.transitionState;
    }

    protected abstract boolean startTransition(MasterProcedureEnv var1, RegionStates.RegionStateNode var2) throws IOException, ProcedureSuspendedException;

    protected abstract boolean updateTransition(MasterProcedureEnv var1, RegionStates.RegionStateNode var2) throws IOException, ProcedureSuspendedException;

    protected abstract void finishTransition(MasterProcedureEnv var1, RegionStates.RegionStateNode var2) throws IOException, ProcedureSuspendedException;

    protected abstract void reportTransition(MasterProcedureEnv var1, RegionStates.RegionStateNode var2, RegionServerStatusProtos.RegionStateTransition.TransitionCode var3, long var4) throws UnexpectedStateException;

    public abstract RemoteProcedureDispatcher.RemoteOperation remoteCallBuild(MasterProcedureEnv var1, ServerName var2);

    protected abstract boolean remoteCallFailed(MasterProcedureEnv var1, RegionStates.RegionStateNode var2, IOException var3);

    public void remoteCallCompleted(MasterProcedureEnv env, ServerName serverName, RemoteProcedureDispatcher.RemoteOperation response) {
    }

    public void remoteCallFailed(MasterProcedureEnv env, ServerName serverName, IOException exception) {
        RegionStates.RegionStateNode regionNode = this.getRegionState(env);
        assert (serverName.equals((Object)regionNode.getRegionLocation()));
        String msg = exception.getMessage() == null ? exception.getClass().getSimpleName() : exception.getMessage();
        LOG.warn((Object)("Remote call failed " + this + "; " + regionNode.toShortString() + "; exception=" + msg));
        if (this.remoteCallFailed(env, regionNode, exception)) {
            env.getProcedureScheduler().wakeEvent(regionNode.getProcedureEvent());
        }
    }

    protected boolean addToRemoteDispatcher(MasterProcedureEnv env, ServerName targetServer) {
        assert (targetServer.equals((Object)this.getRegionState(env).getRegionLocation())) : "targetServer=" + targetServer + " getRegionLocation=" + this.getRegionState(env).getRegionLocation();
        LOG.info((Object)("Dispatch " + this + "; " + this.getRegionState(env).toShortString()));
        env.getProcedureScheduler().suspendEvent(this.getRegionState(env).getProcedureEvent());
        if (!env.getRemoteDispatcher().addOperationToNode((Comparable)targetServer, this)) {
            this.remoteCallFailed(env, targetServer, (IOException)((Object)new FailedRemoteDispatchException(this + " to " + targetServer)));
            return false;
        }
        return true;
    }

    protected void reportTransition(MasterProcedureEnv env, ServerName serverName, RegionServerStatusProtos.RegionStateTransition.TransitionCode code, long seqId) throws UnexpectedStateException {
        RegionStates.RegionStateNode regionNode = this.getRegionState(env);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Received report " + code + " seqId=" + seqId + ", " + this + "; " + regionNode.toShortString()));
        }
        if (!serverName.equals((Object)regionNode.getRegionLocation())) {
            if (this.isMeta() && regionNode.getRegionLocation() == null) {
                regionNode.setRegionLocation(serverName);
            } else {
                throw new UnexpectedStateException(String.format("Unexpected state=%s from server=%s; expected server=%s; %s; %s", code, serverName, regionNode.getRegionLocation(), this, regionNode.toShortString()));
            }
        }
        this.reportTransition(env, regionNode, code, seqId);
        env.getProcedureScheduler().wakeEvent(regionNode.getProcedureEvent());
    }

    protected boolean isServerOnline(MasterProcedureEnv env, RegionStates.RegionStateNode regionNode) {
        return this.isServerOnline(env, regionNode.getRegionLocation());
    }

    protected boolean isServerOnline(MasterProcedureEnv env, ServerName serverName) {
        return env.getMasterServices().getServerManager().isServerOnline(serverName);
    }

    protected void toStringState(StringBuilder builder) {
        super.toStringState(builder);
        MasterProcedureProtos.RegionTransitionState ts = this.transitionState;
        if (!this.isFinished() && ts != null) {
            builder.append(":").append(ts);
        }
    }

    protected Procedure[] execute(MasterProcedureEnv env) throws ProcedureSuspendedException {
        RegionStates.RegionStateNode regionNode;
        AssignmentManager am = env.getAssignmentManager();
        if (!am.addRegionInTransition(regionNode = this.getRegionState(env), this)) {
            String msg = String.format("There is already another procedure running on this region this=%s owner=%s", this, regionNode.getProcedure());
            LOG.warn((Object)(msg + " " + this + "; " + regionNode.toShortString()));
            this.setAbortFailure(this.getClass().getSimpleName(), msg);
            return null;
        }
        try {
            boolean retry;
            do {
                retry = false;
                switch (this.transitionState) {
                    case REGION_TRANSITION_QUEUE: {
                        if (!this.startTransition(env, regionNode)) {
                            am.removeRegionInTransition(this.getRegionState(env), this);
                            return null;
                        }
                        this.transitionState = MasterProcedureProtos.RegionTransitionState.REGION_TRANSITION_DISPATCH;
                        if (!env.getProcedureScheduler().waitEvent(regionNode.getProcedureEvent(), this)) break;
                        throw new ProcedureSuspendedException();
                    }
                    case REGION_TRANSITION_DISPATCH: {
                        if (!this.updateTransition(env, regionNode)) {
                            am.removeRegionInTransition(regionNode, this);
                            return null;
                        }
                        if (this.transitionState != MasterProcedureProtos.RegionTransitionState.REGION_TRANSITION_DISPATCH) {
                            retry = true;
                            break;
                        }
                        if (!env.getProcedureScheduler().waitEvent(regionNode.getProcedureEvent(), this)) break;
                        throw new ProcedureSuspendedException();
                    }
                    case REGION_TRANSITION_FINISH: {
                        this.finishTransition(env, regionNode);
                        am.removeRegionInTransition(regionNode, this);
                        return null;
                    }
                }
            } while (retry);
        }
        catch (IOException e) {
            LOG.warn((Object)("Retryable error trying to transition: " + this + "; " + regionNode.toShortString()), (Throwable)e);
        }
        return new Procedure[]{this};
    }

    protected void rollback(MasterProcedureEnv env) {
        if (this.isRollbackSupported(this.transitionState)) {
            env.getAssignmentManager().removeRegionInTransition(this.getRegionState(env), this);
            return;
        }
        throw new UnsupportedOperationException("Unhandled state " + this.transitionState + "; there is no rollback for assignment unless we cancel the operation by dropping/disabling the table");
    }

    protected abstract boolean isRollbackSupported(MasterProcedureProtos.RegionTransitionState var1);

    protected boolean abort(MasterProcedureEnv env) {
        if (this.isRollbackSupported(this.transitionState)) {
            this.aborted.set(true);
            return true;
        }
        return false;
    }

    protected Procedure.LockState acquireLock(MasterProcedureEnv env) {
        if (!this.isMeta() && (env.waitFailoverCleanup(this) || env.getAssignmentManager().waitMetaInitialized(this, this.getRegionInfo()))) {
            return Procedure.LockState.LOCK_EVENT_WAIT;
        }
        if (env.getProcedureScheduler().waitRegion(this, this.getRegionInfo())) {
            try {
                LOG.debug((Object)(Procedure.LockState.LOCK_EVENT_WAIT + " pid=" + this.getProcId() + " " + env.getProcedureScheduler().dumpLocks()));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return Procedure.LockState.LOCK_EVENT_WAIT;
        }
        this.lock = true;
        return Procedure.LockState.LOCK_ACQUIRED;
    }

    protected void releaseLock(MasterProcedureEnv env) {
        env.getProcedureScheduler().wakeRegion(this, this.getRegionInfo());
        this.lock = false;
    }

    protected boolean holdLock(MasterProcedureEnv env) {
        return true;
    }

    protected boolean hasLock(MasterProcedureEnv env) {
        return this.lock;
    }

    protected boolean shouldWaitClientAck(MasterProcedureEnv env) {
        return false;
    }

    public abstract ServerName getServer(MasterProcedureEnv var1);
}

