/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.snapshot;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.cleaner.BaseHFileCleanerDelegate;
import org.apache.hadoop.hbase.master.snapshot.SnapshotFileCache;
import org.apache.hadoop.hbase.snapshot.CorruptedSnapshotException;
import org.apache.hadoop.hbase.snapshot.SnapshotReferenceUtil;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceAudience.LimitedPrivate(value={"Configuration"})
@InterfaceStability.Evolving
public class SnapshotHFileCleaner
extends BaseHFileCleanerDelegate {
    private static final Log LOG = LogFactory.getLog(SnapshotHFileCleaner.class);
    public static final String HFILE_CACHE_REFRESH_PERIOD_CONF_KEY = "hbase.master.hfilecleaner.plugins.snapshot.period";
    private static final long DEFAULT_HFILE_CACHE_REFRESH_PERIOD = 300000L;
    private SnapshotFileCache cache;
    private MasterServices master;

    @Override
    public synchronized Iterable<FileStatus> getDeletableFiles(Iterable<FileStatus> files) {
        try {
            return this.cache.getUnreferencedFiles(files, this.master.getSnapshotManager());
        }
        catch (CorruptedSnapshotException cse) {
            LOG.debug((Object)"Corrupted in-progress snapshot file exception, ignored ", (Throwable)cse);
        }
        catch (IOException e) {
            LOG.error((Object)"Exception while checking if files were valid, keeping them just in case.", (Throwable)e);
        }
        return Collections.emptyList();
    }

    @Override
    public void init(Map<String, Object> params) {
        if (params.containsKey("master")) {
            this.master = (MasterServices)params.get("master");
        }
    }

    @Override
    protected boolean isFileDeletable(FileStatus fStat) {
        return false;
    }

    public void setConf(final Configuration conf) {
        super.setConf(conf);
        try {
            long cacheRefreshPeriod = conf.getLong(HFILE_CACHE_REFRESH_PERIOD_CONF_KEY, 300000L);
            final FileSystem fs = FSUtils.getCurrentFileSystem(conf);
            Path rootDir = FSUtils.getRootDir(conf);
            this.cache = new SnapshotFileCache(fs, rootDir, cacheRefreshPeriod, cacheRefreshPeriod, "snapshot-hfile-cleaner-cache-refresher", new SnapshotFileCache.SnapshotFileInspector(){

                @Override
                public Collection<String> filesUnderSnapshot(Path snapshotDir) throws IOException {
                    return SnapshotReferenceUtil.getHFileNames(conf, fs, snapshotDir);
                }
            });
        }
        catch (IOException e) {
            LOG.error((Object)"Failed to create cleaner util", (Throwable)e);
        }
    }

    @Override
    public void stop(String why) {
        this.cache.stop(why);
    }

    @Override
    public boolean isStopped() {
        return this.cache.isStopped();
    }

    public SnapshotFileCache getFileCacheForTesting() {
        return this.cache;
    }
}

