/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Comparator;
import org.apache.hadoop.hbase.ByteBufferKeyValue;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.regionserver.CSLMImmutableSegment;
import org.apache.hadoop.hbase.regionserver.CellChunkMap;
import org.apache.hadoop.hbase.regionserver.CellSet;
import org.apache.hadoop.hbase.regionserver.Chunk;
import org.apache.hadoop.hbase.regionserver.ChunkCreator;
import org.apache.hadoop.hbase.regionserver.ImmutableSegment;
import org.apache.hadoop.hbase.regionserver.KeyValueScanner;
import org.apache.hadoop.hbase.regionserver.MemStoreCompactor;
import org.apache.hadoop.hbase.regionserver.MemStoreLAB;
import org.apache.hadoop.hbase.regionserver.MemStoreSegmentsIterator;
import org.apache.hadoop.hbase.regionserver.MemStoreSizing;
import org.apache.hadoop.hbase.util.ByteBufferUtils;
import org.apache.hadoop.hbase.util.ClassSize;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class CellChunkImmutableSegment
extends ImmutableSegment {
    public static final long DEEP_OVERHEAD_CCM = ImmutableSegment.DEEP_OVERHEAD + (long)ClassSize.CELL_CHUNK_MAP;

    protected CellChunkImmutableSegment(CellComparator comparator, MemStoreSegmentsIterator iterator, MemStoreLAB memStoreLAB, int numOfCells, MemStoreCompactor.Action action) {
        super(null, comparator, memStoreLAB);
        this.incSize(0L, DEEP_OVERHEAD_CCM);
        this.initializeCellSet(numOfCells, iterator, action);
    }

    protected CellChunkImmutableSegment(CSLMImmutableSegment segment, MemStoreSizing memstoreSizing) {
        super(segment);
        this.incSize(0L, -CSLMImmutableSegment.DEEP_OVERHEAD_CSLM + DEEP_OVERHEAD_CCM);
        int numOfCells = segment.getCellsCount();
        this.reinitializeCellSet(numOfCells, segment.getScanner(Long.MAX_VALUE), segment.getCellSet());
        long newSegmentSizeDelta = (long)numOfCells * (this.indexEntrySize() - (long)ClassSize.CONCURRENT_SKIPLISTMAP_ENTRY);
        this.incSize(0L, newSegmentSizeDelta);
        memstoreSizing.incMemStoreSize(0L, newSegmentSizeDelta);
    }

    @Override
    protected long indexEntrySize() {
        return (long)ClassSize.CELL_CHUNK_MAP_ENTRY - KeyValue.FIXED_OVERHEAD;
    }

    @Override
    protected boolean canBeFlattened() {
        return false;
    }

    private void initializeCellSet(int numOfCells, MemStoreSegmentsIterator iterator, MemStoreCompactor.Action action) {
        int chunkSize = ChunkCreator.getInstance().getChunkSize();
        int numOfCellsInChunk = CellChunkMap.NUM_OF_CELL_REPS_IN_CHUNK;
        int numberOfChunks = this.calculateNumberOfChunks(numOfCells, numOfCellsInChunk);
        int numOfCellsAfterCompaction = 0;
        int currentChunkIdx = 0;
        int offsetInCurentChunk = 4;
        Chunk[] chunks = new Chunk[numberOfChunks];
        for (int i = 0; i < numberOfChunks; ++i) {
            chunks[i] = this.getMemStoreLAB().getNewExternalChunk();
        }
        while (iterator.hasNext()) {
            Cell c = (Cell)iterator.next();
            ++numOfCellsAfterCompaction;
            assert (c instanceof ByteBufferKeyValue);
            if (offsetInCurentChunk + ClassSize.CELL_CHUNK_MAP_ENTRY > chunkSize) {
                ++currentChunkIdx;
                offsetInCurentChunk = 4;
            }
            if (action == MemStoreCompactor.Action.COMPACT) {
                c = this.maybeCloneWithAllocator(c);
            }
            offsetInCurentChunk = this.createCellReference((ByteBufferKeyValue)c, chunks[currentChunkIdx].getData(), offsetInCurentChunk);
            this.updateMetaInfo(c, true, null);
        }
        CellChunkMap ccm = new CellChunkMap((Comparator<? super Cell>)this.getComparator(), chunks, 0, numOfCellsAfterCompaction, false);
        this.setCellSet(null, new CellSet(ccm));
    }

    private void reinitializeCellSet(int numOfCells, KeyValueScanner segmentScanner, CellSet oldCellSet) {
        int chunkSize = ChunkCreator.getInstance().getChunkSize();
        int numOfCellsInChunk = CellChunkMap.NUM_OF_CELL_REPS_IN_CHUNK;
        int numberOfChunks = this.calculateNumberOfChunks(numOfCells, numOfCellsInChunk);
        Chunk[] chunks = new Chunk[numberOfChunks];
        for (int i = 0; i < numberOfChunks; ++i) {
            chunks[i] = this.getMemStoreLAB().getNewExternalChunk();
        }
        int currentChunkIdx = 0;
        int offsetInCurentChunk = 4;
        try {
            Cell curCell;
            while ((curCell = segmentScanner.next()) != null) {
                assert (curCell instanceof ByteBufferKeyValue);
                if (offsetInCurentChunk + ClassSize.CELL_CHUNK_MAP_ENTRY > chunkSize) {
                    ++currentChunkIdx;
                    offsetInCurentChunk = 4;
                }
                offsetInCurentChunk = this.createCellReference((ByteBufferKeyValue)curCell, chunks[currentChunkIdx].getData(), offsetInCurentChunk);
            }
        }
        catch (IOException ie) {
            throw new IllegalStateException(ie);
        }
        finally {
            segmentScanner.close();
        }
        CellChunkMap ccm = new CellChunkMap((Comparator<? super Cell>)this.getComparator(), chunks, 0, numOfCells, false);
        this.setCellSet(oldCellSet, new CellSet(ccm));
    }

    private int createCellReference(ByteBufferKeyValue cell, ByteBuffer idxBuffer, int idxOffset) {
        int offset = idxOffset;
        int dataChunkID = cell.getChunkId();
        offset = ByteBufferUtils.putInt((ByteBuffer)idxBuffer, (int)offset, (int)dataChunkID);
        offset = ByteBufferUtils.putInt((ByteBuffer)idxBuffer, (int)offset, (int)cell.getOffset());
        offset = ByteBufferUtils.putInt((ByteBuffer)idxBuffer, (int)offset, (int)KeyValueUtil.length((Cell)cell));
        offset = ByteBufferUtils.putLong((ByteBuffer)idxBuffer, (int)offset, (long)cell.getSequenceId());
        return offset;
    }

    private int calculateNumberOfChunks(int numOfCells, int numOfCellsInChunk) {
        int numberOfChunks = numOfCells / numOfCellsInChunk;
        if (numOfCells % numOfCellsInChunk != 0) {
            ++numberOfChunks;
        }
        return numberOfChunks;
    }
}

