/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.IncreasingToUpperBoundRegionSplitPolicy;
import org.apache.hadoop.hbase.shaded.com.google.common.primitives.Bytes;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class DelimitedKeyPrefixRegionSplitPolicy
extends IncreasingToUpperBoundRegionSplitPolicy {
    private static final Log LOG = LogFactory.getLog(DelimitedKeyPrefixRegionSplitPolicy.class);
    public static final String DELIMITER_KEY = "DelimitedKeyPrefixRegionSplitPolicy.delimiter";
    private byte[] delimiter = null;

    @Override
    protected void configureForRegion(HRegion region) {
        super.configureForRegion(region);
        String delimiterString = region.getTableDescriptor().getValue(DELIMITER_KEY);
        if (delimiterString == null || delimiterString.length() == 0) {
            LOG.error((Object)("DelimitedKeyPrefixRegionSplitPolicy.delimiter not specified for table " + region.getTableDescriptor().getTableName() + ". Using default RegionSplitPolicy"));
            return;
        }
        this.delimiter = org.apache.hadoop.hbase.util.Bytes.toBytes((String)delimiterString);
    }

    @Override
    protected byte[] getSplitPoint() {
        byte[] splitPoint = super.getSplitPoint();
        if (splitPoint != null && this.delimiter != null) {
            int index = Bytes.indexOf((byte[])splitPoint, (byte[])this.delimiter);
            if (index < 0) {
                LOG.warn((Object)("Delimiter " + org.apache.hadoop.hbase.util.Bytes.toString((byte[])this.delimiter) + "  not found for split key " + org.apache.hadoop.hbase.util.Bytes.toString((byte[])splitPoint)));
                return splitPoint;
            }
            return Arrays.copyOf(splitPoint, Math.min(index, splitPoint.length));
        }
        return splitPoint;
    }
}

