/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.tool;

import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessor;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.RegionObserver;
import org.apache.hadoop.hbase.regionserver.MiniBatchOperationInProgress;
import org.apache.hadoop.hbase.regionserver.OperationStatus;

public class WriteSinkCoprocessor
implements RegionCoprocessor,
RegionObserver {
    private static final Log LOG = LogFactory.getLog(WriteSinkCoprocessor.class);
    private final AtomicLong ops = new AtomicLong();
    private String regionName;

    @Override
    public Optional<RegionObserver> getRegionObserver() {
        return Optional.of(this);
    }

    @Override
    public void preOpen(ObserverContext<RegionCoprocessorEnvironment> e) throws IOException {
        this.regionName = e.getEnvironment().getRegion().getRegionInfo().getRegionNameAsString();
    }

    @Override
    public void preBatchMutate(ObserverContext<RegionCoprocessorEnvironment> c, MiniBatchOperationInProgress<Mutation> miniBatchOp) throws IOException {
        if (this.ops.incrementAndGet() % 20000L == 0L) {
            LOG.info((Object)("Wrote " + this.ops.get() + " times in region " + this.regionName));
        }
        for (int i = 0; i < miniBatchOp.size(); ++i) {
            miniBatchOp.setOperationStatus(i, new OperationStatus(HConstants.OperationStatusCode.SUCCESS));
        }
        c.bypass();
    }
}

