/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import com.google.protobuf.BlockingRpcChannel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.ClusterMetrics;
import org.apache.hadoop.hbase.CompareOperator;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeepDeletedCells;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.PrivateCellUtil;
import org.apache.hadoop.hbase.RegionLocations;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.CompactionState;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.ConnectionImplementation;
import org.apache.hadoop.hbase.client.ConnectionUtils;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HConnectionTestingUtility;
import org.apache.hadoop.hbase.client.HRegionLocator;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.RegionReplicaUtil;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.RetriesExhaustedWithDetailsException;
import org.apache.hadoop.hbase.client.RowMutations;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.metrics.ScanMetrics;
import org.apache.hadoop.hbase.coprocessor.MultiRowMutationEndpoint;
import org.apache.hadoop.hbase.filter.BinaryComparator;
import org.apache.hadoop.hbase.filter.ByteArrayComparable;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hadoop.hbase.filter.FirstKeyOnlyFilter;
import org.apache.hadoop.hbase.filter.InclusiveStopFilter;
import org.apache.hadoop.hbase.filter.KeyOnlyFilter;
import org.apache.hadoop.hbase.filter.LongComparator;
import org.apache.hadoop.hbase.filter.PrefixFilter;
import org.apache.hadoop.hbase.filter.QualifierFilter;
import org.apache.hadoop.hbase.filter.RegexStringComparator;
import org.apache.hadoop.hbase.filter.RowFilter;
import org.apache.hadoop.hbase.filter.SingleColumnValueFilter;
import org.apache.hadoop.hbase.filter.SubstringComparator;
import org.apache.hadoop.hbase.filter.ValueFilter;
import org.apache.hadoop.hbase.filter.WhileMatchFilter;
import org.apache.hadoop.hbase.io.TimeRange;
import org.apache.hadoop.hbase.io.hfile.BlockCache;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.ipc.CoprocessorRpcChannel;
import org.apache.hadoop.hbase.master.LoadBalancer;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.protobuf.generated.MultiRowMutationProtos;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.NoSuchColumnFamilyException;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdge;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.NonRepeatedEnvironmentEdge;
import org.apache.hadoop.hbase.util.Pair;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={LargeTests.class, ClientTests.class})
public class TestFromClientSide {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestFromClientSide.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestFromClientSide.class);
    protected static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static byte[] ROW = Bytes.toBytes((String)"testRow");
    private static byte[] FAMILY = Bytes.toBytes((String)"testFamily");
    private static final byte[] INVALID_FAMILY = Bytes.toBytes((String)"invalidTestFamily");
    private static byte[] QUALIFIER = Bytes.toBytes((String)"testQualifier");
    private static byte[] VALUE = Bytes.toBytes((String)"testValue");
    protected static int SLAVES = 3;
    @Rule
    public TestName name = new TestName();

    protected static final void initialize(Class<?> ... cps) throws Exception {
        EnvironmentEdgeManager.injectEdge((EnvironmentEdge)new NonRepeatedEnvironmentEdge());
        Configuration conf = TEST_UTIL.getConfiguration();
        conf.setStrings("hbase.coprocessor.region.classes", (String[])Arrays.stream(cps).map(Class::getName).toArray(String[]::new));
        conf.setBoolean("hbase.table.sanity.checks", true);
        TEST_UTIL.startMiniCluster(SLAVES);
    }

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TestFromClientSide.initialize(MultiRowMutationEndpoint.class);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDuplicateAppend() throws Exception {
        HTableDescriptor hdt = TEST_UTIL.createTableDescriptor(this.name.getMethodName());
        HashMap<String, String> kvs = new HashMap<String, String>();
        kvs.put("hbase.coprocessor.SleepAtFirstRpcCall.sleepTime", "2000");
        hdt.addCoprocessor(HConnectionTestingUtility.SleepAtFirstRpcCall.class.getName(), null, 1, kvs);
        TEST_UTIL.createTable((TableDescriptor)hdt, (byte[][])new byte[][]{ROW}).close();
        Configuration c = new Configuration(TEST_UTIL.getConfiguration());
        c.setInt("hbase.client.pause", 50);
        c.setInt("hbase.rpc.timeout", 1500);
        Connection connection = ConnectionFactory.createConnection((Configuration)c);
        Table t = connection.getTable(TableName.valueOf((String)this.name.getMethodName()));
        if (t instanceof HTable) {
            HTable table = (HTable)t;
            table.setOperationTimeout(3000);
            try {
                Append append = new Append(ROW);
                append.addColumn(HBaseTestingUtility.fam1, QUALIFIER, VALUE);
                Result result = table.append(append);
                Cell[] cells = result.rawCells();
                Assert.assertEquals((long)1L, (long)cells.length);
                this.assertKey(cells[0], ROW, HBaseTestingUtility.fam1, QUALIFIER, VALUE);
                Result readResult = table.get(new Get(ROW));
                cells = readResult.rawCells();
                Assert.assertEquals((long)1L, (long)cells.length);
                this.assertKey(cells[0], ROW, HBaseTestingUtility.fam1, QUALIFIER, VALUE);
            }
            finally {
                table.close();
                connection.close();
            }
        }
    }

    @Test
    public void testKeepDeletedCells() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        byte[] FAMILY = Bytes.toBytes((String)"family");
        byte[] C0 = Bytes.toBytes((String)"c0");
        byte[] T1 = Bytes.toBytes((String)"T1");
        byte[] T2 = Bytes.toBytes((String)"T2");
        byte[] T3 = Bytes.toBytes((String)"T3");
        HColumnDescriptor hcd = new HColumnDescriptor(FAMILY).setKeepDeletedCells(KeepDeletedCells.TRUE).setMaxVersions(3);
        HTableDescriptor desc = new HTableDescriptor(tableName);
        desc.addFamily(hcd);
        TEST_UTIL.getAdmin().createTable((TableDescriptor)desc);
        Table h = TEST_UTIL.getConnection().getTable(tableName);
        long ts = System.currentTimeMillis();
        Put p = new Put(T1, ts);
        p.addColumn(FAMILY, C0, T1);
        h.put(p);
        p = new Put(T1, ts + 2L);
        p.addColumn(FAMILY, C0, T2);
        h.put(p);
        p = new Put(T1, ts + 4L);
        p.addColumn(FAMILY, C0, T3);
        h.put(p);
        Delete d = new Delete(T1, ts + 3L);
        h.delete(d);
        d = new Delete(T1, ts + 3L);
        d.addColumns(FAMILY, C0, ts + 3L);
        h.delete(d);
        Get g = new Get(T1);
        g.setTimeRange(0L, ts + 3L);
        Result r = h.get(g);
        Assert.assertArrayEquals((byte[])T2, (byte[])r.getValue(FAMILY, C0));
        Scan s = new Scan(T1);
        s.setTimeRange(0L, ts + 3L);
        s.setMaxVersions();
        ResultScanner scanner = h.getScanner(s);
        Cell[] kvs = scanner.next().rawCells();
        Assert.assertArrayEquals((byte[])T2, (byte[])CellUtil.cloneValue((Cell)kvs[0]));
        Assert.assertArrayEquals((byte[])T1, (byte[])CellUtil.cloneValue((Cell)kvs[1]));
        scanner.close();
        s = new Scan(T1);
        s.setRaw(true);
        s.setMaxVersions();
        scanner = h.getScanner(s);
        kvs = scanner.next().rawCells();
        Assert.assertTrue((boolean)PrivateCellUtil.isDeleteFamily((Cell)kvs[0]));
        Assert.assertArrayEquals((byte[])T3, (byte[])CellUtil.cloneValue((Cell)kvs[1]));
        Assert.assertTrue((boolean)CellUtil.isDelete((Cell)kvs[2]));
        Assert.assertArrayEquals((byte[])T2, (byte[])CellUtil.cloneValue((Cell)kvs[3]));
        Assert.assertArrayEquals((byte[])T1, (byte[])CellUtil.cloneValue((Cell)kvs[4]));
        scanner.close();
        h.close();
    }

    @Test
    public void testPurgeFutureDeletes() throws Exception {
        final TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        byte[] ROW = Bytes.toBytes((String)"row");
        byte[] FAMILY = Bytes.toBytes((String)"family");
        byte[] COLUMN = Bytes.toBytes((String)"column");
        byte[] VALUE = Bytes.toBytes((String)"value");
        Table table = TEST_UTIL.createTable(tableName, FAMILY);
        long ts = System.currentTimeMillis() * 2L;
        Put put = new Put(ROW, ts);
        put.addColumn(FAMILY, COLUMN, VALUE);
        table.put(put);
        Get get = new Get(ROW);
        Result result = table.get(get);
        Assert.assertArrayEquals((byte[])VALUE, (byte[])result.getValue(FAMILY, COLUMN));
        Delete del = new Delete(ROW);
        del.addColumn(FAMILY, COLUMN, ts);
        table.delete(del);
        get = new Get(ROW);
        result = table.get(get);
        Assert.assertNull((Object)result.getValue(FAMILY, COLUMN));
        TEST_UTIL.getAdmin().flush(tableName);
        TEST_UTIL.getAdmin().majorCompact(tableName);
        TEST_UTIL.waitFor(6000L, (Waiter.Predicate)new Waiter.Predicate<IOException>(){

            public boolean evaluate() throws IOException {
                return TEST_UTIL.getAdmin().getCompactionState(tableName) == CompactionState.NONE;
            }
        });
        put = new Put(ROW, ts);
        put.addColumn(FAMILY, COLUMN, VALUE);
        table.put(put);
        get = new Get(ROW);
        result = table.get(get);
        Assert.assertArrayEquals((byte[])VALUE, (byte[])result.getValue(FAMILY, COLUMN));
        table.close();
    }

    @Test
    public void testGetConfiguration() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        byte[][] FAMILIES = new byte[][]{Bytes.toBytes((String)"foo")};
        Configuration conf = TEST_UTIL.getConfiguration();
        Table table = TEST_UTIL.createTable(tableName, (byte[][])FAMILIES);
        Assert.assertSame((Object)conf, (Object)table.getConfiguration());
    }

    @Test
    public void testWeirdCacheBehaviour() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        byte[][] FAMILIES = new byte[][]{Bytes.toBytes((String)"trans-blob"), Bytes.toBytes((String)"trans-type"), Bytes.toBytes((String)"trans-date"), Bytes.toBytes((String)"trans-tags"), Bytes.toBytes((String)"trans-group")};
        Table ht = TEST_UTIL.createTable(tableName, (byte[][])FAMILIES);
        String value = "this is the value";
        String value2 = "this is some other value";
        String keyPrefix1 = TEST_UTIL.getRandomUUID().toString();
        String keyPrefix2 = TEST_UTIL.getRandomUUID().toString();
        String keyPrefix3 = TEST_UTIL.getRandomUUID().toString();
        this.putRows(ht, 3, value, keyPrefix1);
        this.putRows(ht, 3, value, keyPrefix2);
        this.putRows(ht, 3, value, keyPrefix3);
        this.putRows(ht, 3, value2, keyPrefix1);
        this.putRows(ht, 3, value2, keyPrefix2);
        this.putRows(ht, 3, value2, keyPrefix3);
        Table table = TEST_UTIL.getConnection().getTable(tableName);
        System.out.println("Checking values for key: " + keyPrefix1);
        Assert.assertEquals((String)"Got back incorrect number of rows from scan", (long)3L, (long)this.getNumberOfRows(keyPrefix1, value2, table));
        System.out.println("Checking values for key: " + keyPrefix2);
        Assert.assertEquals((String)"Got back incorrect number of rows from scan", (long)3L, (long)this.getNumberOfRows(keyPrefix2, value2, table));
        System.out.println("Checking values for key: " + keyPrefix3);
        Assert.assertEquals((String)"Got back incorrect number of rows from scan", (long)3L, (long)this.getNumberOfRows(keyPrefix3, value2, table));
        this.deleteColumns(ht, value2, keyPrefix1);
        this.deleteColumns(ht, value2, keyPrefix2);
        this.deleteColumns(ht, value2, keyPrefix3);
        System.out.println("Starting important checks.....");
        Assert.assertEquals((String)("Got back incorrect number of rows from scan: " + keyPrefix1), (long)0L, (long)this.getNumberOfRows(keyPrefix1, value2, table));
        Assert.assertEquals((String)("Got back incorrect number of rows from scan: " + keyPrefix2), (long)0L, (long)this.getNumberOfRows(keyPrefix2, value2, table));
        Assert.assertEquals((String)("Got back incorrect number of rows from scan: " + keyPrefix3), (long)0L, (long)this.getNumberOfRows(keyPrefix3, value2, table));
    }

    private void deleteColumns(Table ht, String value, String keyPrefix) throws IOException {
        ResultScanner scanner = this.buildScanner(keyPrefix, value, ht);
        Iterator it = scanner.iterator();
        int count = 0;
        while (it.hasNext()) {
            Result result = (Result)it.next();
            Delete delete = new Delete(result.getRow());
            delete.addColumn(Bytes.toBytes((String)"trans-tags"), Bytes.toBytes((String)"qual2"));
            ht.delete(delete);
            ++count;
        }
        Assert.assertEquals((String)"Did not perform correct number of deletes", (long)3L, (long)count);
    }

    private int getNumberOfRows(String keyPrefix, String value, Table ht) throws Exception {
        ResultScanner resultScanner = this.buildScanner(keyPrefix, value, ht);
        Iterator scanner = resultScanner.iterator();
        int numberOfResults = 0;
        while (scanner.hasNext()) {
            Result result = (Result)scanner.next();
            System.out.println("Got back key: " + Bytes.toString((byte[])result.getRow()));
            for (Cell kv : result.rawCells()) {
                System.out.println("kv=" + kv.toString() + ", " + Bytes.toString((byte[])CellUtil.cloneValue((Cell)kv)));
            }
            ++numberOfResults;
        }
        return numberOfResults;
    }

    private ResultScanner buildScanner(String keyPrefix, String value, Table ht) throws IOException {
        FilterList allFilters = new FilterList(new Filter[0]);
        allFilters.addFilter((Filter)new PrefixFilter(Bytes.toBytes((String)keyPrefix)));
        SingleColumnValueFilter filter = new SingleColumnValueFilter(Bytes.toBytes((String)"trans-tags"), Bytes.toBytes((String)"qual2"), CompareOperator.EQUAL, Bytes.toBytes((String)value));
        filter.setFilterIfMissing(true);
        allFilters.addFilter((Filter)filter);
        Scan scan = new Scan();
        scan.addFamily(Bytes.toBytes((String)"trans-blob"));
        scan.addFamily(Bytes.toBytes((String)"trans-type"));
        scan.addFamily(Bytes.toBytes((String)"trans-date"));
        scan.addFamily(Bytes.toBytes((String)"trans-tags"));
        scan.addFamily(Bytes.toBytes((String)"trans-group"));
        scan.setFilter((Filter)allFilters);
        return ht.getScanner(scan);
    }

    private void putRows(Table ht, int numRows, String value, String key) throws IOException {
        for (int i = 0; i < numRows; ++i) {
            String row = key + "_" + TEST_UTIL.getRandomUUID().toString();
            System.out.println(String.format("Saving row: %s, with value %s", row, value));
            Put put = new Put(Bytes.toBytes((String)row));
            put.setDurability(Durability.SKIP_WAL);
            put.addColumn(Bytes.toBytes((String)"trans-blob"), null, Bytes.toBytes((String)"value for blob"));
            put.addColumn(Bytes.toBytes((String)"trans-type"), null, Bytes.toBytes((String)"statement"));
            put.addColumn(Bytes.toBytes((String)"trans-date"), null, Bytes.toBytes((String)"20090921010101999"));
            put.addColumn(Bytes.toBytes((String)"trans-tags"), Bytes.toBytes((String)"qual2"), Bytes.toBytes((String)value));
            put.addColumn(Bytes.toBytes((String)"trans-group"), null, Bytes.toBytes((String)"adhocTransactionGroupId"));
            ht.put(put);
        }
    }

    @Test
    public void testFilterAcrossMultipleRegions() throws IOException, InterruptedException {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        Table t = TEST_UTIL.createTable(tableName, FAMILY);
        int rowCount = TEST_UTIL.loadTable(t, FAMILY, false);
        this.assertRowCount(t, rowCount);
        List<HRegionLocation> regions = this.splitTable(t);
        this.assertRowCount(t, rowCount);
        byte[] endKey = regions.get(0).getRegionInfo().getEndKey();
        int endKeyCount = TEST_UTIL.countRows(t, this.createScanWithRowFilter(endKey));
        Assert.assertTrue((endKeyCount < rowCount ? 1 : 0) != 0);
        byte[] key = new byte[]{endKey[0], endKey[1], (byte)(endKey[2] + 1)};
        int plusOneCount = TEST_UTIL.countRows(t, this.createScanWithRowFilter(key));
        Assert.assertEquals((long)(endKeyCount + 1), (long)plusOneCount);
        key = new byte[]{endKey[0], endKey[1], (byte)(endKey[2] + 2)};
        int plusTwoCount = TEST_UTIL.countRows(t, this.createScanWithRowFilter(key));
        Assert.assertEquals((long)(endKeyCount + 2), (long)plusTwoCount);
        key = new byte[]{endKey[0], endKey[1], (byte)(endKey[2] - 1)};
        int minusOneCount = TEST_UTIL.countRows(t, this.createScanWithRowFilter(key));
        Assert.assertEquals((long)(endKeyCount - 1), (long)minusOneCount);
        key = new byte[]{97, 97, 97};
        int countBBB = TEST_UTIL.countRows(t, this.createScanWithRowFilter(key, null, CompareOperator.EQUAL));
        Assert.assertEquals((long)1L, (long)countBBB);
        int countGreater = TEST_UTIL.countRows(t, this.createScanWithRowFilter(endKey, null, CompareOperator.GREATER_OR_EQUAL));
        Assert.assertEquals((long)0L, (long)countGreater);
        countGreater = TEST_UTIL.countRows(t, this.createScanWithRowFilter(endKey, endKey, CompareOperator.GREATER_OR_EQUAL));
        Assert.assertEquals((long)(rowCount - endKeyCount), (long)countGreater);
    }

    private Scan createScanWithRowFilter(byte[] key) {
        return this.createScanWithRowFilter(key, null, CompareOperator.LESS);
    }

    private Scan createScanWithRowFilter(byte[] key, byte[] startRow, CompareOperator op) {
        Assert.assertTrue((key != null && key.length > 0 && Bytes.BYTES_COMPARATOR.compare(key, new byte[]{97, 97, 97}) >= 0 ? 1 : 0) != 0);
        LOG.info("Key=" + Bytes.toString((byte[])key));
        Scan s = startRow == null ? new Scan() : new Scan(startRow);
        RowFilter f = new RowFilter(op, (ByteArrayComparable)new BinaryComparator(key));
        f = new WhileMatchFilter((Filter)f);
        s.setFilter((Filter)f);
        return s;
    }

    private void assertRowCount(Table t, int expected) throws IOException {
        Assert.assertEquals((long)expected, (long)TEST_UTIL.countRows(t, new Scan()));
    }

    private List<HRegionLocation> splitTable(Table t) throws IOException, InterruptedException {
        Admin admin = TEST_UTIL.getAdmin();
        admin.split(t.getName());
        admin.close();
        List<HRegionLocation> regions = this.waitOnSplit(t);
        Assert.assertTrue((regions.size() > 1 ? 1 : 0) != 0);
        return regions;
    }

    private List<HRegionLocation> waitOnSplit(Table t) throws IOException {
        try (RegionLocator locator = TEST_UTIL.getConnection().getRegionLocator(t.getName());){
            List regions = locator.getAllRegionLocations();
            int originalCount = regions.size();
            for (int i = 0; i < TEST_UTIL.getConfiguration().getInt("hbase.test.retries", 30); ++i) {
                Thread.currentThread();
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                regions = locator.getAllRegionLocations();
                if (regions.size() > originalCount) break;
            }
            List list = regions;
            return list;
        }
    }

    @Test
    public void testSuperSimple() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        Table ht = TEST_UTIL.createTable(tableName, FAMILY);
        Put put = new Put(ROW);
        put.addColumn(FAMILY, QUALIFIER, VALUE);
        ht.put(put);
        Scan scan = new Scan();
        scan.addColumn(FAMILY, tableName.toBytes());
        ResultScanner scanner = ht.getScanner(scan);
        Result result = scanner.next();
        Assert.assertTrue((String)"Expected null result", (result == null ? 1 : 0) != 0);
        scanner.close();
    }

    @Test
    public void testMaxKeyValueSize() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        Configuration conf = TEST_UTIL.getConfiguration();
        String oldMaxSize = conf.get("hbase.client.keyvalue.maxsize");
        Table ht = TEST_UTIL.createTable(tableName, FAMILY);
        byte[] value = new byte[0x400000];
        Put put = new Put(ROW);
        put.addColumn(FAMILY, QUALIFIER, value);
        ht.put(put);
        try {
            TEST_UTIL.getConfiguration().setInt("hbase.client.keyvalue.maxsize", 0x200000);
            try (Connection connection = ConnectionFactory.createConnection((Configuration)TEST_UTIL.getConfiguration());
                 Table t = connection.getTable(TableName.valueOf((byte[])FAMILY));){
                put = new Put(ROW);
                put.addColumn(FAMILY, QUALIFIER, value);
                t.put(put);
            }
            Assert.fail((String)"Inserting a too large KeyValue worked, should throw exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
        conf.set("hbase.client.keyvalue.maxsize", oldMaxSize);
    }

    @Test
    public void testFilters() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        Table ht = TEST_UTIL.createTable(tableName, FAMILY);
        byte[][] ROWS = this.makeN(ROW, 10);
        byte[][] QUALIFIERS = new byte[][]{Bytes.toBytes((String)"col0-<d2v1>-<d3v2>"), Bytes.toBytes((String)"col1-<d2v1>-<d3v2>"), Bytes.toBytes((String)"col2-<d2v1>-<d3v2>"), Bytes.toBytes((String)"col3-<d2v1>-<d3v2>"), Bytes.toBytes((String)"col4-<d2v1>-<d3v2>"), Bytes.toBytes((String)"col5-<d2v1>-<d3v2>"), Bytes.toBytes((String)"col6-<d2v1>-<d3v2>"), Bytes.toBytes((String)"col7-<d2v1>-<d3v2>"), Bytes.toBytes((String)"col8-<d2v1>-<d3v2>"), Bytes.toBytes((String)"col9-<d2v1>-<d3v2>")};
        for (int i = 0; i < 10; ++i) {
            Put put = new Put(ROWS[i]);
            put.setDurability(Durability.SKIP_WAL);
            put.addColumn(FAMILY, QUALIFIERS[i], VALUE);
            ht.put(put);
        }
        Scan scan = new Scan();
        scan.addFamily(FAMILY);
        QualifierFilter filter = new QualifierFilter(CompareOperator.EQUAL, (ByteArrayComparable)new RegexStringComparator("col[1-5]"));
        scan.setFilter((Filter)filter);
        ResultScanner scanner = ht.getScanner(scan);
        int expectedIndex = 1;
        for (Result result : ht.getScanner(scan)) {
            Assert.assertEquals((long)1L, (long)result.size());
            Assert.assertTrue((boolean)Bytes.equals((byte[])CellUtil.cloneRow((Cell)result.rawCells()[0]), (byte[])ROWS[expectedIndex]));
            Assert.assertTrue((boolean)Bytes.equals((byte[])CellUtil.cloneQualifier((Cell)result.rawCells()[0]), (byte[])QUALIFIERS[expectedIndex]));
            ++expectedIndex;
        }
        Assert.assertEquals((long)6L, (long)expectedIndex);
        scanner.close();
    }

    @Test
    public void testFilterWithLongCompartor() throws Exception {
        int i;
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        Table ht = TEST_UTIL.createTable(tableName, FAMILY);
        byte[][] ROWS = this.makeN(ROW, 10);
        byte[][] values = new byte[10][];
        for (i = 0; i < 10; ++i) {
            values[i] = Bytes.toBytes((long)(100L * (long)i));
        }
        for (i = 0; i < 10; ++i) {
            Put put = new Put(ROWS[i]);
            put.setDurability(Durability.SKIP_WAL);
            put.addColumn(FAMILY, QUALIFIER, values[i]);
            ht.put(put);
        }
        Scan scan = new Scan();
        scan.addFamily(FAMILY);
        SingleColumnValueFilter filter = new SingleColumnValueFilter(FAMILY, QUALIFIER, CompareOperator.GREATER, (ByteArrayComparable)new LongComparator(500L));
        scan.setFilter((Filter)filter);
        ResultScanner scanner = ht.getScanner(scan);
        int expectedIndex = 0;
        for (Result result : ht.getScanner(scan)) {
            Assert.assertEquals((long)1L, (long)result.size());
            Assert.assertTrue((Bytes.toLong((byte[])result.getValue(FAMILY, QUALIFIER)) > 500L ? 1 : 0) != 0);
            ++expectedIndex;
        }
        Assert.assertEquals((long)4L, (long)expectedIndex);
        scanner.close();
    }

    @Test
    public void testKeyOnlyFilter() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        Table ht = TEST_UTIL.createTable(tableName, FAMILY);
        byte[][] ROWS = this.makeN(ROW, 10);
        byte[][] QUALIFIERS = new byte[][]{Bytes.toBytes((String)"col0-<d2v1>-<d3v2>"), Bytes.toBytes((String)"col1-<d2v1>-<d3v2>"), Bytes.toBytes((String)"col2-<d2v1>-<d3v2>"), Bytes.toBytes((String)"col3-<d2v1>-<d3v2>"), Bytes.toBytes((String)"col4-<d2v1>-<d3v2>"), Bytes.toBytes((String)"col5-<d2v1>-<d3v2>"), Bytes.toBytes((String)"col6-<d2v1>-<d3v2>"), Bytes.toBytes((String)"col7-<d2v1>-<d3v2>"), Bytes.toBytes((String)"col8-<d2v1>-<d3v2>"), Bytes.toBytes((String)"col9-<d2v1>-<d3v2>")};
        for (int i = 0; i < 10; ++i) {
            Put put = new Put(ROWS[i]);
            put.setDurability(Durability.SKIP_WAL);
            put.addColumn(FAMILY, QUALIFIERS[i], VALUE);
            ht.put(put);
        }
        Scan scan = new Scan();
        scan.addFamily(FAMILY);
        KeyOnlyFilter filter = new KeyOnlyFilter(true);
        scan.setFilter((Filter)filter);
        ResultScanner scanner = ht.getScanner(scan);
        int count = 0;
        for (Result result : ht.getScanner(scan)) {
            Assert.assertEquals((long)1L, (long)result.size());
            Assert.assertEquals((long)4L, (long)result.rawCells()[0].getValueLength());
            Assert.assertEquals((long)VALUE.length, (long)Bytes.toInt((byte[])CellUtil.cloneValue((Cell)result.rawCells()[0])));
            ++count;
        }
        Assert.assertEquals((long)10L, (long)count);
        scanner.close();
    }

    @Test
    public void testSimpleMissing() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        Table ht = TEST_UTIL.createTable(tableName, FAMILY);
        byte[][] ROWS = this.makeN(ROW, 4);
        Get get = new Get(ROWS[0]);
        Result result = ht.get(get);
        this.assertEmptyResult(result);
        get = new Get(ROWS[0]);
        get.addFamily(FAMILY);
        result = ht.get(get);
        this.assertEmptyResult(result);
        get = new Get(ROWS[0]);
        get.addColumn(FAMILY, QUALIFIER);
        result = ht.get(get);
        this.assertEmptyResult(result);
        Scan scan = new Scan();
        result = this.getSingleScanResult(ht, scan);
        this.assertNullResult(result);
        scan = new Scan(ROWS[0]);
        result = this.getSingleScanResult(ht, scan);
        this.assertNullResult(result);
        scan = new Scan(ROWS[0], ROWS[1]);
        result = this.getSingleScanResult(ht, scan);
        this.assertNullResult(result);
        scan = new Scan();
        scan.addFamily(FAMILY);
        result = this.getSingleScanResult(ht, scan);
        this.assertNullResult(result);
        scan = new Scan();
        scan.addColumn(FAMILY, QUALIFIER);
        result = this.getSingleScanResult(ht, scan);
        this.assertNullResult(result);
        Put put = new Put(ROWS[2]);
        put.addColumn(FAMILY, QUALIFIER, VALUE);
        ht.put(put);
        get = new Get(ROWS[1]);
        result = ht.get(get);
        this.assertEmptyResult(result);
        get = new Get(ROWS[0]);
        get.addFamily(FAMILY);
        result = ht.get(get);
        this.assertEmptyResult(result);
        get = new Get(ROWS[3]);
        get.addColumn(FAMILY, QUALIFIER);
        result = ht.get(get);
        this.assertEmptyResult(result);
        scan = new Scan(ROWS[3]);
        result = this.getSingleScanResult(ht, scan);
        this.assertNullResult(result);
        scan = new Scan(ROWS[0], ROWS[2]);
        result = this.getSingleScanResult(ht, scan);
        this.assertNullResult(result);
        get = new Get(ROWS[2]);
        result = ht.get(get);
        this.assertSingleResult(result, ROWS[2], FAMILY, QUALIFIER, VALUE);
        get = new Get(ROWS[2]);
        get.addFamily(FAMILY);
        result = ht.get(get);
        this.assertSingleResult(result, ROWS[2], FAMILY, QUALIFIER, VALUE);
        get = new Get(ROWS[2]);
        get.addColumn(FAMILY, QUALIFIER);
        result = ht.get(get);
        this.assertSingleResult(result, ROWS[2], FAMILY, QUALIFIER, VALUE);
        scan = new Scan();
        result = this.getSingleScanResult(ht, scan);
        this.assertSingleResult(result, ROWS[2], FAMILY, QUALIFIER, VALUE);
        scan = new Scan(ROWS[0], ROWS[3]);
        result = this.getSingleScanResult(ht, scan);
        this.assertSingleResult(result, ROWS[2], FAMILY, QUALIFIER, VALUE);
        scan = new Scan(ROWS[2], ROWS[3]);
        result = this.getSingleScanResult(ht, scan);
        this.assertSingleResult(result, ROWS[2], FAMILY, QUALIFIER, VALUE);
    }

    @Test
    public void testSingleRowMultipleFamily() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        byte[][] ROWS = this.makeN(ROW, 3);
        byte[][] FAMILIES = this.makeNAscii(FAMILY, 10);
        byte[][] QUALIFIERS = this.makeN(QUALIFIER, 10);
        byte[][] VALUES = this.makeN(VALUE, 10);
        Table ht = TEST_UTIL.createTable(tableName, FAMILIES);
        Put put = new Put(ROWS[0]);
        put.addColumn(FAMILIES[4], QUALIFIERS[0], VALUES[0]);
        ht.put(put);
        this.getVerifySingleColumn(ht, ROWS, 0, FAMILIES, 4, QUALIFIERS, 0, VALUES, 0);
        this.scanVerifySingleColumn(ht, ROWS, 0, FAMILIES, 4, QUALIFIERS, 0, VALUES, 0);
        this.getVerifySingleEmpty(ht, ROWS, 0, FAMILIES, 4, QUALIFIERS, 0);
        this.scanVerifySingleEmpty(ht, ROWS, 0, FAMILIES, 4, QUALIFIERS, 0);
        TEST_UTIL.flush();
        this.getVerifySingleColumn(ht, ROWS, 0, FAMILIES, 4, QUALIFIERS, 0, VALUES, 0);
        this.scanVerifySingleColumn(ht, ROWS, 0, FAMILIES, 4, QUALIFIERS, 0, VALUES, 0);
        this.getVerifySingleEmpty(ht, ROWS, 0, FAMILIES, 4, QUALIFIERS, 0);
        this.scanVerifySingleEmpty(ht, ROWS, 0, FAMILIES, 4, QUALIFIERS, 0);
        put = new Put(ROWS[0]);
        put.addColumn(FAMILIES[2], QUALIFIERS[2], VALUES[2]);
        put.addColumn(FAMILIES[2], QUALIFIERS[4], VALUES[4]);
        put.addColumn(FAMILIES[4], QUALIFIERS[4], VALUES[4]);
        put.addColumn(FAMILIES[6], QUALIFIERS[6], VALUES[6]);
        put.addColumn(FAMILIES[6], QUALIFIERS[7], VALUES[7]);
        put.addColumn(FAMILIES[7], QUALIFIERS[7], VALUES[7]);
        put.addColumn(FAMILIES[9], QUALIFIERS[0], VALUES[0]);
        ht.put(put);
        this.singleRowGetTest(ht, ROWS, FAMILIES, QUALIFIERS, VALUES);
        this.singleRowScanTest(ht, ROWS, FAMILIES, QUALIFIERS, VALUES);
        TEST_UTIL.flush();
        this.singleRowGetTest(ht, ROWS, FAMILIES, QUALIFIERS, VALUES);
        this.singleRowScanTest(ht, ROWS, FAMILIES, QUALIFIERS, VALUES);
        put = new Put(ROWS[0]);
        put.addColumn(FAMILIES[6], QUALIFIERS[5], VALUES[5]);
        put.addColumn(FAMILIES[6], QUALIFIERS[8], VALUES[8]);
        put.addColumn(FAMILIES[6], QUALIFIERS[9], VALUES[9]);
        put.addColumn(FAMILIES[4], QUALIFIERS[3], VALUES[3]);
        ht.put(put);
        Delete delete = new Delete(ROWS[0]);
        delete.addColumns(FAMILIES[6], QUALIFIERS[7]);
        ht.delete(delete);
        Get get = new Get(ROWS[0]);
        get.addColumn(FAMILIES[6], QUALIFIERS[7]);
        Result result = ht.get(get);
        this.assertEmptyResult(result);
        Scan scan = new Scan();
        scan.addColumn(FAMILIES[6], QUALIFIERS[7]);
        result = this.getSingleScanResult(ht, scan);
        this.assertNullResult(result);
        get = new Get(ROWS[0]);
        get.addColumn(FAMILIES[6], QUALIFIERS[6]);
        result = ht.get(get);
        this.assertSingleResult(result, ROWS[0], FAMILIES[6], QUALIFIERS[6], VALUES[6]);
        get = new Get(ROWS[0]);
        get.addColumn(FAMILIES[6], QUALIFIERS[8]);
        result = ht.get(get);
        this.assertSingleResult(result, ROWS[0], FAMILIES[6], QUALIFIERS[8], VALUES[8]);
        scan = new Scan();
        scan.addColumn(FAMILIES[6], QUALIFIERS[6]);
        result = this.getSingleScanResult(ht, scan);
        this.assertSingleResult(result, ROWS[0], FAMILIES[6], QUALIFIERS[6], VALUES[6]);
        scan = new Scan();
        scan.addColumn(FAMILIES[6], QUALIFIERS[8]);
        result = this.getSingleScanResult(ht, scan);
        this.assertSingleResult(result, ROWS[0], FAMILIES[6], QUALIFIERS[8], VALUES[8]);
        delete = new Delete(ROWS[0]);
        delete.addColumns(FAMILIES[6], QUALIFIERS[8]);
        ht.delete(delete);
        get = new Get(ROWS[0]);
        get.addColumn(FAMILIES[6], QUALIFIERS[8]);
        result = ht.get(get);
        this.assertEmptyResult(result);
        scan = new Scan();
        scan.addColumn(FAMILIES[6], QUALIFIERS[8]);
        result = this.getSingleScanResult(ht, scan);
        this.assertNullResult(result);
        get = new Get(ROWS[0]);
        get.addColumn(FAMILIES[6], QUALIFIERS[6]);
        result = ht.get(get);
        this.assertSingleResult(result, ROWS[0], FAMILIES[6], QUALIFIERS[6], VALUES[6]);
        get = new Get(ROWS[0]);
        get.addColumn(FAMILIES[6], QUALIFIERS[9]);
        result = ht.get(get);
        this.assertSingleResult(result, ROWS[0], FAMILIES[6], QUALIFIERS[9], VALUES[9]);
        scan = new Scan();
        scan.addColumn(FAMILIES[6], QUALIFIERS[6]);
        result = this.getSingleScanResult(ht, scan);
        this.assertSingleResult(result, ROWS[0], FAMILIES[6], QUALIFIERS[6], VALUES[6]);
        scan = new Scan();
        scan.addColumn(FAMILIES[6], QUALIFIERS[9]);
        result = this.getSingleScanResult(ht, scan);
        this.assertSingleResult(result, ROWS[0], FAMILIES[6], QUALIFIERS[9], VALUES[9]);
        delete = new Delete(ROWS[0]);
        delete.addFamily(FAMILIES[4]);
        ht.delete(delete);
        get = new Get(ROWS[0]);
        get.addColumn(FAMILIES[4], QUALIFIERS[4]);
        result = ht.get(get);
        this.assertEmptyResult(result);
        get = new Get(ROWS[0]);
        get.addColumn(FAMILIES[4], QUALIFIERS[3]);
        result = ht.get(get);
        this.assertEmptyResult(result);
        get = new Get(ROWS[0]);
        get.addFamily(FAMILIES[4]);
        result = ht.get(get);
        this.assertEmptyResult(result);
        scan = new Scan();
        scan.addColumn(FAMILIES[4], QUALIFIERS[4]);
        result = this.getSingleScanResult(ht, scan);
        this.assertNullResult(result);
        scan = new Scan();
        scan.addColumn(FAMILIES[4], QUALIFIERS[3]);
        result = this.getSingleScanResult(ht, scan);
        this.assertNullResult(result);
        scan = new Scan();
        scan.addFamily(FAMILIES[4]);
        result = this.getSingleScanResult(ht, scan);
        this.assertNullResult(result);
        get = new Get(ROWS[0]);
        get.addColumn(FAMILIES[2], QUALIFIERS[2]);
        result = ht.get(get);
        this.assertSingleResult(result, ROWS[0], FAMILIES[2], QUALIFIERS[2], VALUES[2]);
        get = new Get(ROWS[0]);
        get.addColumn(FAMILIES[6], QUALIFIERS[9]);
        result = ht.get(get);
        this.assertSingleResult(result, ROWS[0], FAMILIES[6], QUALIFIERS[9], VALUES[9]);
        scan = new Scan();
        scan.addColumn(FAMILIES[6], QUALIFIERS[6]);
        result = this.getSingleScanResult(ht, scan);
        this.assertSingleResult(result, ROWS[0], FAMILIES[6], QUALIFIERS[6], VALUES[6]);
        scan = new Scan();
        scan.addColumn(FAMILIES[6], QUALIFIERS[9]);
        result = this.getSingleScanResult(ht, scan);
        this.assertSingleResult(result, ROWS[0], FAMILIES[6], QUALIFIERS[9], VALUES[9]);
        TEST_UTIL.flush();
        get = new Get(ROWS[0]);
        get.addColumn(FAMILIES[4], QUALIFIERS[4]);
        result = ht.get(get);
        this.assertEmptyResult(result);
        get = new Get(ROWS[0]);
        get.addColumn(FAMILIES[4], QUALIFIERS[3]);
        result = ht.get(get);
        this.assertEmptyResult(result);
        get = new Get(ROWS[0]);
        get.addFamily(FAMILIES[4]);
        result = ht.get(get);
        this.assertEmptyResult(result);
        scan = new Scan();
        scan.addColumn(FAMILIES[4], QUALIFIERS[4]);
        result = this.getSingleScanResult(ht, scan);
        this.assertNullResult(result);
        scan = new Scan();
        scan.addColumn(FAMILIES[4], QUALIFIERS[3]);
        result = this.getSingleScanResult(ht, scan);
        this.assertNullResult(result);
        scan = new Scan();
        scan.addFamily(FAMILIES[4]);
        result = this.getSingleScanResult(ht, scan);
        this.assertNullResult(result);
        get = new Get(ROWS[0]);
        get.addColumn(FAMILIES[2], QUALIFIERS[2]);
        result = ht.get(get);
        this.assertSingleResult(result, ROWS[0], FAMILIES[2], QUALIFIERS[2], VALUES[2]);
        get = new Get(ROWS[0]);
        get.addColumn(FAMILIES[6], QUALIFIERS[9]);
        result = ht.get(get);
        this.assertSingleResult(result, ROWS[0], FAMILIES[6], QUALIFIERS[9], VALUES[9]);
        scan = new Scan();
        scan.addColumn(FAMILIES[6], QUALIFIERS[6]);
        result = this.getSingleScanResult(ht, scan);
        this.assertSingleResult(result, ROWS[0], FAMILIES[6], QUALIFIERS[6], VALUES[6]);
        scan = new Scan();
        scan.addColumn(FAMILIES[6], QUALIFIERS[9]);
        result = this.getSingleScanResult(ht, scan);
        this.assertSingleResult(result, ROWS[0], FAMILIES[6], QUALIFIERS[9], VALUES[9]);
    }

    @Test
    public void testNull() throws Exception {
        Put put2;
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        try {
            TEST_UTIL.createTable((TableName)null, FAMILY);
            Assert.fail((String)"Creating a table with null name passed, should have failed");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            TEST_UTIL.createTable(tableName, (byte[][])new byte[][]{null});
            Assert.fail((String)"Creating a table with a null family passed, should fail");
        }
        catch (Exception exception) {
            // empty catch block
        }
        Table ht = TEST_UTIL.createTable(tableName, FAMILY);
        try {
            put2 = new Put((byte[])null);
            put2.addColumn(FAMILY, QUALIFIER, VALUE);
            ht.put(put2);
            Assert.fail((String)"Inserting a null row worked, should throw exception");
        }
        catch (Exception put2) {
            // empty catch block
        }
        put2 = new Put(ROW);
        put2.addColumn(FAMILY, null, VALUE);
        ht.put(put2);
        this.getTestNull(ht, ROW, FAMILY, VALUE);
        this.scanTestNull(ht, ROW, FAMILY, VALUE);
        Delete delete = new Delete(ROW);
        delete.addColumns(FAMILY, null);
        ht.delete(delete);
        Get get = new Get(ROW);
        Result result = ht.get(get);
        this.assertEmptyResult(result);
        ht = TEST_UTIL.createTable(TableName.valueOf((String)(this.name.getMethodName() + "2")), FAMILY);
        try {
            put2 = new Put(ROW);
            put2.addColumn(FAMILY, HConstants.EMPTY_BYTE_ARRAY, VALUE);
            ht.put(put2);
            this.getTestNull(ht, ROW, FAMILY, VALUE);
            this.scanTestNull(ht, ROW, FAMILY, VALUE);
            TEST_UTIL.flush();
            this.getTestNull(ht, ROW, FAMILY, VALUE);
            this.scanTestNull(ht, ROW, FAMILY, VALUE);
            delete = new Delete(ROW);
            delete.addColumns(FAMILY, HConstants.EMPTY_BYTE_ARRAY);
            ht.delete(delete);
            get = new Get(ROW);
            result = ht.get(get);
            this.assertEmptyResult(result);
        }
        catch (Exception e) {
            throw new IOException("Using a row with null qualifier threw exception, should ");
        }
        try {
            put2 = new Put(ROW);
            put2.addColumn(FAMILY, QUALIFIER, null);
            ht.put(put2);
            Get get2 = new Get(ROW);
            get2.addColumn(FAMILY, QUALIFIER);
            Result result2 = ht.get(get2);
            this.assertSingleResult(result2, ROW, FAMILY, QUALIFIER, null);
            Scan scan = new Scan();
            scan.addColumn(FAMILY, QUALIFIER);
            result2 = this.getSingleScanResult(ht, scan);
            this.assertSingleResult(result2, ROW, FAMILY, QUALIFIER, null);
            Delete delete2 = new Delete(ROW);
            delete2.addColumns(FAMILY, QUALIFIER);
            ht.delete(delete2);
            get2 = new Get(ROW);
            result2 = ht.get(get2);
            this.assertEmptyResult(result2);
        }
        catch (Exception e) {
            throw new IOException("Null values should be allowed, but threw exception");
        }
    }

    @Test
    public void testNullQualifier() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        Table table = TEST_UTIL.createTable(tableName, FAMILY);
        Put put = new Put(ROW);
        put.addColumn(FAMILY, null, VALUE);
        table.put(put);
        this.getTestNull(table, ROW, FAMILY, VALUE);
        this.scanTestNull(table, ROW, FAMILY, VALUE);
        Delete delete = new Delete(ROW);
        delete.addColumns(FAMILY, null);
        table.delete(delete);
        Get get = new Get(ROW);
        Result result = table.get(get);
        this.assertEmptyResult(result);
        Increment increment = new Increment(ROW);
        increment.addColumn(FAMILY, null, 1L);
        table.increment(increment);
        this.getTestNull(table, ROW, FAMILY, 1L);
        table.incrementColumnValue(ROW, FAMILY, null, 1L);
        this.getTestNull(table, ROW, FAMILY, 2L);
        delete = new Delete(ROW);
        delete.addColumns(FAMILY, null);
        table.delete(delete);
        Append append = new Append(ROW);
        append.addColumn(FAMILY, null, VALUE);
        table.append(append);
        this.getTestNull(table, ROW, FAMILY, VALUE);
        put = new Put(ROW);
        put.addColumn(FAMILY, null, Bytes.toBytes((String)"checkAndPut"));
        table.put(put);
        table.checkAndMutate(ROW, FAMILY).ifEquals(VALUE).thenPut(put);
        RowMutations mutate = new RowMutations(ROW);
        mutate.add(new Put(ROW).addColumn(FAMILY, null, Bytes.toBytes((String)"checkAndMutate")));
        table.checkAndMutate(ROW, FAMILY).ifEquals(Bytes.toBytes((String)"checkAndPut")).thenMutate(mutate);
        delete = new Delete(ROW);
        delete.addColumns(FAMILY, null);
        table.checkAndMutate(ROW, FAMILY).ifEquals(Bytes.toBytes((String)"checkAndMutate")).thenDelete(delete);
    }

    @Test
    public void testVersions() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        long[] STAMPS = this.makeStamps(20);
        byte[][] VALUES = this.makeNAscii(VALUE, 20);
        Table ht = TEST_UTIL.createTable(tableName, FAMILY, 10);
        Put put = new Put(ROW);
        put.addColumn(FAMILY, QUALIFIER, STAMPS[1], VALUES[1]);
        put.addColumn(FAMILY, QUALIFIER, STAMPS[2], VALUES[2]);
        put.addColumn(FAMILY, QUALIFIER, STAMPS[4], VALUES[4]);
        put.addColumn(FAMILY, QUALIFIER, STAMPS[5], VALUES[5]);
        ht.put(put);
        this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[1], VALUES[1]);
        this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[2], VALUES[2]);
        this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[4], VALUES[4]);
        this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[5], VALUES[5]);
        this.scanVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[1], VALUES[1]);
        this.scanVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[2], VALUES[2]);
        this.scanVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[4], VALUES[4]);
        this.scanVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[5], VALUES[5]);
        this.getVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[0]);
        this.getVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[3]);
        this.getVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[6]);
        this.scanVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[0]);
        this.scanVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[3]);
        this.scanVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[6]);
        Get get = new Get(ROW);
        get.addColumn(FAMILY, QUALIFIER);
        get.setMaxVersions(2);
        Result result = ht.get(get);
        this.assertNResult(result, ROW, FAMILY, QUALIFIER, new long[]{STAMPS[4], STAMPS[5]}, new byte[][]{VALUES[4], VALUES[5]}, 0, 1);
        Scan scan = new Scan(ROW);
        scan.addColumn(FAMILY, QUALIFIER);
        scan.setMaxVersions(2);
        result = this.getSingleScanResult(ht, scan);
        this.assertNResult(result, ROW, FAMILY, QUALIFIER, new long[]{STAMPS[4], STAMPS[5]}, new byte[][]{VALUES[4], VALUES[5]}, 0, 1);
        TEST_UTIL.flush();
        this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[1], VALUES[1]);
        this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[2], VALUES[2]);
        this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[4], VALUES[4]);
        this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[5], VALUES[5]);
        this.scanVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[1], VALUES[1]);
        this.scanVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[2], VALUES[2]);
        this.scanVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[4], VALUES[4]);
        this.scanVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[5], VALUES[5]);
        this.getVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[0]);
        this.getVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[3]);
        this.getVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[6]);
        this.scanVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[0]);
        this.scanVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[3]);
        this.scanVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[6]);
        get = new Get(ROW);
        get.addColumn(FAMILY, QUALIFIER);
        get.setMaxVersions(2);
        result = ht.get(get);
        this.assertNResult(result, ROW, FAMILY, QUALIFIER, new long[]{STAMPS[4], STAMPS[5]}, new byte[][]{VALUES[4], VALUES[5]}, 0, 1);
        scan = new Scan(ROW);
        scan.addColumn(FAMILY, QUALIFIER);
        scan.setMaxVersions(2);
        result = this.getSingleScanResult(ht, scan);
        this.assertNResult(result, ROW, FAMILY, QUALIFIER, new long[]{STAMPS[4], STAMPS[5]}, new byte[][]{VALUES[4], VALUES[5]}, 0, 1);
        put = new Put(ROW);
        put.addColumn(FAMILY, QUALIFIER, STAMPS[3], VALUES[3]);
        put.addColumn(FAMILY, QUALIFIER, STAMPS[6], VALUES[6]);
        put.addColumn(FAMILY, QUALIFIER, STAMPS[7], VALUES[7]);
        put.addColumn(FAMILY, QUALIFIER, STAMPS[8], VALUES[8]);
        ht.put(put);
        get = new Get(ROW);
        get.addColumn(FAMILY, QUALIFIER);
        get.setMaxVersions();
        result = ht.get(get);
        this.assertNResult(result, ROW, FAMILY, QUALIFIER, new long[]{STAMPS[1], STAMPS[2], STAMPS[3], STAMPS[4], STAMPS[5], STAMPS[6], STAMPS[7], STAMPS[8]}, new byte[][]{VALUES[1], VALUES[2], VALUES[3], VALUES[4], VALUES[5], VALUES[6], VALUES[7], VALUES[8]}, 0, 7);
        scan = new Scan(ROW);
        scan.addColumn(FAMILY, QUALIFIER);
        scan.setMaxVersions();
        result = this.getSingleScanResult(ht, scan);
        this.assertNResult(result, ROW, FAMILY, QUALIFIER, new long[]{STAMPS[1], STAMPS[2], STAMPS[3], STAMPS[4], STAMPS[5], STAMPS[6], STAMPS[7], STAMPS[8]}, new byte[][]{VALUES[1], VALUES[2], VALUES[3], VALUES[4], VALUES[5], VALUES[6], VALUES[7], VALUES[8]}, 0, 7);
        get = new Get(ROW);
        get.setMaxVersions();
        result = ht.get(get);
        this.assertNResult(result, ROW, FAMILY, QUALIFIER, new long[]{STAMPS[1], STAMPS[2], STAMPS[3], STAMPS[4], STAMPS[5], STAMPS[6], STAMPS[7], STAMPS[8]}, new byte[][]{VALUES[1], VALUES[2], VALUES[3], VALUES[4], VALUES[5], VALUES[6], VALUES[7], VALUES[8]}, 0, 7);
        scan = new Scan(ROW);
        scan.setMaxVersions();
        result = this.getSingleScanResult(ht, scan);
        this.assertNResult(result, ROW, FAMILY, QUALIFIER, new long[]{STAMPS[1], STAMPS[2], STAMPS[3], STAMPS[4], STAMPS[5], STAMPS[6], STAMPS[7], STAMPS[8]}, new byte[][]{VALUES[1], VALUES[2], VALUES[3], VALUES[4], VALUES[5], VALUES[6], VALUES[7], VALUES[8]}, 0, 7);
        this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[1], VALUES[1]);
        this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[2], VALUES[2]);
        this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[4], VALUES[4]);
        this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[7], VALUES[7]);
        this.scanVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[1], VALUES[1]);
        this.scanVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[2], VALUES[2]);
        this.scanVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[4], VALUES[4]);
        this.scanVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[7], VALUES[7]);
        this.getVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[0]);
        this.getVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[9]);
        this.scanVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[0]);
        this.scanVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[9]);
        TEST_UTIL.flush();
        put = new Put(ROW);
        put.addColumn(FAMILY, QUALIFIER, STAMPS[9], VALUES[9]);
        put.addColumn(FAMILY, QUALIFIER, STAMPS[11], VALUES[11]);
        put.addColumn(FAMILY, QUALIFIER, STAMPS[13], VALUES[13]);
        put.addColumn(FAMILY, QUALIFIER, STAMPS[15], VALUES[15]);
        ht.put(put);
        get = new Get(ROW);
        get.addColumn(FAMILY, QUALIFIER);
        get.setMaxVersions(Integer.MAX_VALUE);
        result = ht.get(get);
        this.assertNResult(result, ROW, FAMILY, QUALIFIER, new long[]{STAMPS[3], STAMPS[4], STAMPS[5], STAMPS[6], STAMPS[7], STAMPS[8], STAMPS[9], STAMPS[11], STAMPS[13], STAMPS[15]}, new byte[][]{VALUES[3], VALUES[4], VALUES[5], VALUES[6], VALUES[7], VALUES[8], VALUES[9], VALUES[11], VALUES[13], VALUES[15]}, 0, 9);
        scan = new Scan(ROW);
        scan.addColumn(FAMILY, QUALIFIER);
        scan.setMaxVersions(Integer.MAX_VALUE);
        result = this.getSingleScanResult(ht, scan);
        this.assertNResult(result, ROW, FAMILY, QUALIFIER, new long[]{STAMPS[3], STAMPS[4], STAMPS[5], STAMPS[6], STAMPS[7], STAMPS[8], STAMPS[9], STAMPS[11], STAMPS[13], STAMPS[15]}, new byte[][]{VALUES[3], VALUES[4], VALUES[5], VALUES[6], VALUES[7], VALUES[8], VALUES[9], VALUES[11], VALUES[13], VALUES[15]}, 0, 9);
        Delete delete = new Delete(ROW);
        delete.addColumn(FAMILY, QUALIFIER, STAMPS[11]);
        delete.addColumn(FAMILY, QUALIFIER, STAMPS[7]);
        ht.delete(delete);
        get = new Get(ROW);
        get.addColumn(FAMILY, QUALIFIER);
        get.setMaxVersions(Integer.MAX_VALUE);
        result = ht.get(get);
        this.assertNResult(result, ROW, FAMILY, QUALIFIER, new long[]{STAMPS[1], STAMPS[2], STAMPS[3], STAMPS[4], STAMPS[5], STAMPS[6], STAMPS[8], STAMPS[9], STAMPS[13], STAMPS[15]}, new byte[][]{VALUES[1], VALUES[2], VALUES[3], VALUES[4], VALUES[5], VALUES[6], VALUES[8], VALUES[9], VALUES[13], VALUES[15]}, 0, 9);
        scan = new Scan(ROW);
        scan.addColumn(FAMILY, QUALIFIER);
        scan.setMaxVersions(Integer.MAX_VALUE);
        result = this.getSingleScanResult(ht, scan);
        this.assertNResult(result, ROW, FAMILY, QUALIFIER, new long[]{STAMPS[1], STAMPS[2], STAMPS[3], STAMPS[4], STAMPS[5], STAMPS[6], STAMPS[8], STAMPS[9], STAMPS[13], STAMPS[15]}, new byte[][]{VALUES[1], VALUES[2], VALUES[3], VALUES[4], VALUES[5], VALUES[6], VALUES[8], VALUES[9], VALUES[13], VALUES[15]}, 0, 9);
    }

    @Test
    public void testVersionLimits() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        byte[][] FAMILIES = this.makeNAscii(FAMILY, 3);
        int[] LIMITS = new int[]{1, 3, 5};
        long[] STAMPS = this.makeStamps(10);
        byte[][] VALUES = this.makeNAscii(VALUE, 10);
        Table ht = TEST_UTIL.createTable(tableName, FAMILIES, LIMITS);
        Put put = new Put(ROW);
        put.addColumn(FAMILIES[0], QUALIFIER, STAMPS[0], VALUES[0]);
        put.addColumn(FAMILIES[0], QUALIFIER, STAMPS[1], VALUES[1]);
        put.addColumn(FAMILIES[1], QUALIFIER, STAMPS[0], VALUES[0]);
        put.addColumn(FAMILIES[1], QUALIFIER, STAMPS[1], VALUES[1]);
        put.addColumn(FAMILIES[1], QUALIFIER, STAMPS[2], VALUES[2]);
        put.addColumn(FAMILIES[1], QUALIFIER, STAMPS[3], VALUES[3]);
        put.addColumn(FAMILIES[2], QUALIFIER, STAMPS[0], VALUES[0]);
        put.addColumn(FAMILIES[2], QUALIFIER, STAMPS[1], VALUES[1]);
        put.addColumn(FAMILIES[2], QUALIFIER, STAMPS[2], VALUES[2]);
        put.addColumn(FAMILIES[2], QUALIFIER, STAMPS[3], VALUES[3]);
        put.addColumn(FAMILIES[2], QUALIFIER, STAMPS[4], VALUES[4]);
        put.addColumn(FAMILIES[2], QUALIFIER, STAMPS[5], VALUES[5]);
        put.addColumn(FAMILIES[2], QUALIFIER, STAMPS[6], VALUES[6]);
        ht.put(put);
        Get get = new Get(ROW);
        get.addColumn(FAMILIES[0], QUALIFIER);
        get.setMaxVersions(Integer.MAX_VALUE);
        Result result = ht.get(get);
        this.assertNResult(result, ROW, FAMILIES[0], QUALIFIER, new long[]{STAMPS[1]}, new byte[][]{VALUES[1]}, 0, 0);
        get = new Get(ROW);
        get.addFamily(FAMILIES[0]);
        get.setMaxVersions(Integer.MAX_VALUE);
        result = ht.get(get);
        this.assertNResult(result, ROW, FAMILIES[0], QUALIFIER, new long[]{STAMPS[1]}, new byte[][]{VALUES[1]}, 0, 0);
        Scan scan = new Scan(ROW);
        scan.addColumn(FAMILIES[0], QUALIFIER);
        scan.setMaxVersions(Integer.MAX_VALUE);
        result = this.getSingleScanResult(ht, scan);
        this.assertNResult(result, ROW, FAMILIES[0], QUALIFIER, new long[]{STAMPS[1]}, new byte[][]{VALUES[1]}, 0, 0);
        scan = new Scan(ROW);
        scan.addFamily(FAMILIES[0]);
        scan.setMaxVersions(Integer.MAX_VALUE);
        result = this.getSingleScanResult(ht, scan);
        this.assertNResult(result, ROW, FAMILIES[0], QUALIFIER, new long[]{STAMPS[1]}, new byte[][]{VALUES[1]}, 0, 0);
        get = new Get(ROW);
        get.addColumn(FAMILIES[1], QUALIFIER);
        get.setMaxVersions(Integer.MAX_VALUE);
        result = ht.get(get);
        this.assertNResult(result, ROW, FAMILIES[1], QUALIFIER, new long[]{STAMPS[1], STAMPS[2], STAMPS[3]}, new byte[][]{VALUES[1], VALUES[2], VALUES[3]}, 0, 2);
        get = new Get(ROW);
        get.addFamily(FAMILIES[1]);
        get.setMaxVersions(Integer.MAX_VALUE);
        result = ht.get(get);
        this.assertNResult(result, ROW, FAMILIES[1], QUALIFIER, new long[]{STAMPS[1], STAMPS[2], STAMPS[3]}, new byte[][]{VALUES[1], VALUES[2], VALUES[3]}, 0, 2);
        scan = new Scan(ROW);
        scan.addColumn(FAMILIES[1], QUALIFIER);
        scan.setMaxVersions(Integer.MAX_VALUE);
        result = this.getSingleScanResult(ht, scan);
        this.assertNResult(result, ROW, FAMILIES[1], QUALIFIER, new long[]{STAMPS[1], STAMPS[2], STAMPS[3]}, new byte[][]{VALUES[1], VALUES[2], VALUES[3]}, 0, 2);
        scan = new Scan(ROW);
        scan.addFamily(FAMILIES[1]);
        scan.setMaxVersions(Integer.MAX_VALUE);
        result = this.getSingleScanResult(ht, scan);
        this.assertNResult(result, ROW, FAMILIES[1], QUALIFIER, new long[]{STAMPS[1], STAMPS[2], STAMPS[3]}, new byte[][]{VALUES[1], VALUES[2], VALUES[3]}, 0, 2);
        get = new Get(ROW);
        get.addColumn(FAMILIES[2], QUALIFIER);
        get.setMaxVersions(Integer.MAX_VALUE);
        result = ht.get(get);
        this.assertNResult(result, ROW, FAMILIES[2], QUALIFIER, new long[]{STAMPS[2], STAMPS[3], STAMPS[4], STAMPS[5], STAMPS[6]}, new byte[][]{VALUES[2], VALUES[3], VALUES[4], VALUES[5], VALUES[6]}, 0, 4);
        get = new Get(ROW);
        get.addFamily(FAMILIES[2]);
        get.setMaxVersions(Integer.MAX_VALUE);
        result = ht.get(get);
        this.assertNResult(result, ROW, FAMILIES[2], QUALIFIER, new long[]{STAMPS[2], STAMPS[3], STAMPS[4], STAMPS[5], STAMPS[6]}, new byte[][]{VALUES[2], VALUES[3], VALUES[4], VALUES[5], VALUES[6]}, 0, 4);
        scan = new Scan(ROW);
        scan.addColumn(FAMILIES[2], QUALIFIER);
        scan.setMaxVersions(Integer.MAX_VALUE);
        result = this.getSingleScanResult(ht, scan);
        this.assertNResult(result, ROW, FAMILIES[2], QUALIFIER, new long[]{STAMPS[2], STAMPS[3], STAMPS[4], STAMPS[5], STAMPS[6]}, new byte[][]{VALUES[2], VALUES[3], VALUES[4], VALUES[5], VALUES[6]}, 0, 4);
        scan = new Scan(ROW);
        scan.addFamily(FAMILIES[2]);
        scan.setMaxVersions(Integer.MAX_VALUE);
        result = this.getSingleScanResult(ht, scan);
        this.assertNResult(result, ROW, FAMILIES[2], QUALIFIER, new long[]{STAMPS[2], STAMPS[3], STAMPS[4], STAMPS[5], STAMPS[6]}, new byte[][]{VALUES[2], VALUES[3], VALUES[4], VALUES[5], VALUES[6]}, 0, 4);
        get = new Get(ROW);
        get.setMaxVersions(Integer.MAX_VALUE);
        result = ht.get(get);
        Assert.assertTrue((String)("Expected 9 keys but received " + result.size()), (result.size() == 9 ? 1 : 0) != 0);
        get = new Get(ROW);
        get.addFamily(FAMILIES[0]);
        get.addFamily(FAMILIES[1]);
        get.addFamily(FAMILIES[2]);
        get.setMaxVersions(Integer.MAX_VALUE);
        result = ht.get(get);
        Assert.assertTrue((String)("Expected 9 keys but received " + result.size()), (result.size() == 9 ? 1 : 0) != 0);
        get = new Get(ROW);
        get.addColumn(FAMILIES[0], QUALIFIER);
        get.addColumn(FAMILIES[1], QUALIFIER);
        get.addColumn(FAMILIES[2], QUALIFIER);
        get.setMaxVersions(Integer.MAX_VALUE);
        result = ht.get(get);
        Assert.assertTrue((String)("Expected 9 keys but received " + result.size()), (result.size() == 9 ? 1 : 0) != 0);
        scan = new Scan(ROW);
        scan.setMaxVersions(Integer.MAX_VALUE);
        result = this.getSingleScanResult(ht, scan);
        Assert.assertTrue((String)("Expected 9 keys but received " + result.size()), (result.size() == 9 ? 1 : 0) != 0);
        scan = new Scan(ROW);
        scan.setMaxVersions(Integer.MAX_VALUE);
        scan.addFamily(FAMILIES[0]);
        scan.addFamily(FAMILIES[1]);
        scan.addFamily(FAMILIES[2]);
        result = this.getSingleScanResult(ht, scan);
        Assert.assertTrue((String)("Expected 9 keys but received " + result.size()), (result.size() == 9 ? 1 : 0) != 0);
        scan = new Scan(ROW);
        scan.setMaxVersions(Integer.MAX_VALUE);
        scan.addColumn(FAMILIES[0], QUALIFIER);
        scan.addColumn(FAMILIES[1], QUALIFIER);
        scan.addColumn(FAMILIES[2], QUALIFIER);
        result = this.getSingleScanResult(ht, scan);
        Assert.assertTrue((String)("Expected 9 keys but received " + result.size()), (result.size() == 9 ? 1 : 0) != 0);
    }

    @Test
    public void testDeleteFamilyVersion() throws Exception {
        Admin admin = TEST_UTIL.getAdmin();
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        byte[][] QUALIFIERS = this.makeNAscii(QUALIFIER, 1);
        byte[][] VALUES = this.makeN(VALUE, 5);
        long[] ts = new long[]{1000L, 2000L, 3000L, 4000L, 5000L};
        Table ht = TEST_UTIL.createTable(tableName, FAMILY, 5);
        Put put = new Put(ROW);
        for (int q = 0; q < 1; ++q) {
            for (int t = 0; t < 5; ++t) {
                put.addColumn(FAMILY, QUALIFIERS[q], ts[t], VALUES[t]);
            }
        }
        ht.put(put);
        admin.flush(tableName);
        Delete delete = new Delete(ROW);
        delete.addFamilyVersion(FAMILY, ts[1]);
        delete.addFamilyVersion(FAMILY, ts[3]);
        ht.delete(delete);
        admin.flush(tableName);
        for (int i = 0; i < 1; ++i) {
            Get get = new Get(ROW);
            get.addColumn(FAMILY, QUALIFIERS[i]);
            get.setMaxVersions(Integer.MAX_VALUE);
            Result result = ht.get(get);
            this.assertNResult(result, ROW, FAMILY, QUALIFIERS[i], new long[]{ts[0], ts[2], ts[4]}, new byte[][]{VALUES[0], VALUES[2], VALUES[4]}, 0, 2);
        }
        ht.close();
        admin.close();
    }

    @Test
    public void testDeleteFamilyVersionWithOtherDeletes() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        byte[][] QUALIFIERS = this.makeNAscii(QUALIFIER, 5);
        byte[][] VALUES = this.makeN(VALUE, 5);
        long[] ts = new long[]{1000L, 2000L, 3000L, 4000L, 5000L};
        Admin admin = TEST_UTIL.getAdmin();
        Table ht = TEST_UTIL.createTable(tableName, FAMILY, 5);
        Put put = null;
        Result result = null;
        Get get = null;
        Delete delete = null;
        put = new Put(ROW);
        for (int q = 0; q < 5; ++q) {
            for (int t = 0; t < 5; ++t) {
                put.addColumn(FAMILY, QUALIFIERS[q], ts[t], VALUES[t]);
            }
        }
        ht.put(put);
        admin.flush(tableName);
        byte[] ROW2 = Bytes.toBytes((String)"myRowForTest");
        put = new Put(ROW2);
        for (int q = 0; q < 5; ++q) {
            for (int t = 0; t < 5; ++t) {
                put.addColumn(FAMILY, QUALIFIERS[q], ts[t], VALUES[t]);
            }
        }
        ht.put(put);
        admin.flush(tableName);
        delete = new Delete(ROW);
        delete.addFamily(FAMILY, ts[1]);
        delete.addFamilyVersion(FAMILY, ts[3]);
        delete.addColumns(FAMILY, QUALIFIERS[0], ts[2]);
        delete.addColumns(FAMILY, QUALIFIERS[2], ts[4]);
        delete.addColumn(FAMILY, QUALIFIERS[4], ts[4]);
        ht.delete(delete);
        admin.flush(tableName);
        delete = new Delete(ROW2);
        delete.addFamilyVersion(FAMILY, ts[1]);
        delete.addFamilyVersion(FAMILY, ts[3]);
        ht.delete(delete);
        admin.flush(tableName);
        get = new Get(ROW);
        get.addColumn(FAMILY, QUALIFIERS[0]);
        get.setMaxVersions(Integer.MAX_VALUE);
        result = ht.get(get);
        this.assertNResult(result, ROW, FAMILY, QUALIFIERS[0], new long[]{ts[4]}, new byte[][]{VALUES[4]}, 0, 0);
        get = new Get(ROW);
        get.addColumn(FAMILY, QUALIFIERS[1]);
        get.setMaxVersions(Integer.MAX_VALUE);
        result = ht.get(get);
        this.assertNResult(result, ROW, FAMILY, QUALIFIERS[1], new long[]{ts[2], ts[4]}, new byte[][]{VALUES[2], VALUES[4]}, 0, 1);
        get = new Get(ROW);
        get.addColumn(FAMILY, QUALIFIERS[2]);
        get.setMaxVersions(Integer.MAX_VALUE);
        result = ht.get(get);
        Assert.assertEquals((long)0L, (long)result.size());
        get = new Get(ROW);
        get.addColumn(FAMILY, QUALIFIERS[3]);
        get.setMaxVersions(Integer.MAX_VALUE);
        result = ht.get(get);
        this.assertNResult(result, ROW, FAMILY, QUALIFIERS[3], new long[]{ts[2], ts[4]}, new byte[][]{VALUES[2], VALUES[4]}, 0, 1);
        get = new Get(ROW);
        get.addColumn(FAMILY, QUALIFIERS[4]);
        get.setMaxVersions(Integer.MAX_VALUE);
        result = ht.get(get);
        this.assertNResult(result, ROW, FAMILY, QUALIFIERS[4], new long[]{ts[2]}, new byte[][]{VALUES[2]}, 0, 0);
        for (int i = 0; i < 5; ++i) {
            get = new Get(ROW2);
            get.addColumn(FAMILY, QUALIFIERS[i]);
            get.setMaxVersions(Integer.MAX_VALUE);
            result = ht.get(get);
            this.assertNResult(result, ROW2, FAMILY, QUALIFIERS[i], new long[]{ts[0], ts[2], ts[4]}, new byte[][]{VALUES[0], VALUES[2], VALUES[4]}, 0, 2);
        }
        ht.close();
        admin.close();
    }

    @Test
    public void testDeleteWithFailed() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        byte[][] FAMILIES = this.makeNAscii(FAMILY, 3);
        byte[][] VALUES = this.makeN(VALUE, 5);
        long[] ts = new long[]{1000L, 2000L, 3000L, 4000L, 5000L};
        Table ht = TEST_UTIL.createTable(tableName, FAMILIES, 3);
        Put put = new Put(ROW);
        put.addColumn(FAMILIES[0], QUALIFIER, ts[0], VALUES[0]);
        ht.put(put);
        Delete delete = new Delete(ROW);
        delete.addFamily(FAMILIES[1], ts[0]);
        ht.delete(delete);
        Get get = new Get(ROW);
        get.addFamily(FAMILIES[0]);
        get.readAllVersions();
        Result result = ht.get(get);
        Assert.assertTrue((boolean)Bytes.equals((byte[])result.getValue(FAMILIES[0], QUALIFIER), (byte[])VALUES[0]));
    }

    @Test
    public void testDeletes() throws Exception {
        byte[] bytes;
        int i;
        byte[] bytes2;
        int i2;
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        byte[][] ROWS = this.makeNAscii(ROW, 6);
        byte[][] FAMILIES = this.makeNAscii(FAMILY, 3);
        byte[][] VALUES = this.makeN(VALUE, 5);
        long[] ts = new long[]{1000L, 2000L, 3000L, 4000L, 5000L};
        Table ht = TEST_UTIL.createTable(tableName, FAMILIES, 3);
        Put put = new Put(ROW);
        put.addColumn(FAMILIES[0], QUALIFIER, ts[0], VALUES[0]);
        put.addColumn(FAMILIES[0], QUALIFIER, ts[1], VALUES[1]);
        ht.put(put);
        Delete delete = new Delete(ROW);
        delete.addFamily(FAMILIES[0], ts[0]);
        ht.delete(delete);
        Get get = new Get(ROW);
        get.addFamily(FAMILIES[0]);
        get.setMaxVersions(Integer.MAX_VALUE);
        Result result = ht.get(get);
        this.assertNResult(result, ROW, FAMILIES[0], QUALIFIER, new long[]{ts[1]}, new byte[][]{VALUES[1]}, 0, 0);
        Scan scan = new Scan(ROW);
        scan.addFamily(FAMILIES[0]);
        scan.setMaxVersions(Integer.MAX_VALUE);
        result = this.getSingleScanResult(ht, scan);
        this.assertNResult(result, ROW, FAMILIES[0], QUALIFIER, new long[]{ts[1]}, new byte[][]{VALUES[1]}, 0, 0);
        put = new Put(ROW);
        put.addColumn(FAMILIES[0], QUALIFIER, ts[4], VALUES[4]);
        put.addColumn(FAMILIES[0], QUALIFIER, ts[2], VALUES[2]);
        put.addColumn(FAMILIES[0], QUALIFIER, ts[3], VALUES[3]);
        put.addColumn(FAMILIES[0], null, ts[4], VALUES[4]);
        put.addColumn(FAMILIES[0], null, ts[2], VALUES[2]);
        put.addColumn(FAMILIES[0], null, ts[3], VALUES[3]);
        ht.put(put);
        delete = new Delete(ROW);
        delete.addColumn(FAMILIES[0], QUALIFIER);
        ht.delete(delete);
        get = new Get(ROW);
        get.addColumn(FAMILIES[0], QUALIFIER);
        get.setMaxVersions(Integer.MAX_VALUE);
        result = ht.get(get);
        this.assertNResult(result, ROW, FAMILIES[0], QUALIFIER, new long[]{ts[1], ts[2], ts[3]}, new byte[][]{VALUES[1], VALUES[2], VALUES[3]}, 0, 2);
        scan = new Scan(ROW);
        scan.addColumn(FAMILIES[0], QUALIFIER);
        scan.setMaxVersions(Integer.MAX_VALUE);
        result = this.getSingleScanResult(ht, scan);
        this.assertNResult(result, ROW, FAMILIES[0], QUALIFIER, new long[]{ts[1], ts[2], ts[3]}, new byte[][]{VALUES[1], VALUES[2], VALUES[3]}, 0, 2);
        delete = new Delete(ROW);
        delete.addColumn(FAMILIES[0], null);
        ht.delete(delete);
        delete = new Delete(ROW);
        delete.addColumns(FAMILIES[0], null);
        ht.delete(delete);
        put = new Put(ROW);
        put.addColumn(FAMILIES[0], QUALIFIER, ts[0], VALUES[0]);
        put.addColumn(FAMILIES[0], QUALIFIER, ts[4], VALUES[4]);
        ht.put(put);
        get = new Get(ROW);
        get.addFamily(FAMILIES[0]);
        get.setMaxVersions(Integer.MAX_VALUE);
        result = ht.get(get);
        this.assertNResult(result, ROW, FAMILIES[0], QUALIFIER, new long[]{ts[1], ts[2], ts[3]}, new byte[][]{VALUES[1], VALUES[2], VALUES[3]}, 0, 2);
        scan = new Scan(ROW);
        scan.addFamily(FAMILIES[0]);
        scan.setMaxVersions(Integer.MAX_VALUE);
        result = this.getSingleScanResult(ht, scan);
        this.assertNResult(result, ROW, FAMILIES[0], QUALIFIER, new long[]{ts[1], ts[2], ts[3]}, new byte[][]{VALUES[1], VALUES[2], VALUES[3]}, 0, 2);
        put = new Put(ROWS[0]);
        put.addColumn(FAMILIES[1], QUALIFIER, ts[0], VALUES[0]);
        put.addColumn(FAMILIES[1], QUALIFIER, ts[1], VALUES[1]);
        put.addColumn(FAMILIES[2], QUALIFIER, ts[2], VALUES[2]);
        put.addColumn(FAMILIES[2], QUALIFIER, ts[3], VALUES[3]);
        ht.put(put);
        put = new Put(ROWS[1]);
        put.addColumn(FAMILIES[1], QUALIFIER, ts[0], VALUES[0]);
        put.addColumn(FAMILIES[1], QUALIFIER, ts[1], VALUES[1]);
        put.addColumn(FAMILIES[2], QUALIFIER, ts[2], VALUES[2]);
        put.addColumn(FAMILIES[2], QUALIFIER, ts[3], VALUES[3]);
        ht.put(put);
        put = new Put(ROWS[2]);
        put.addColumn(FAMILIES[1], QUALIFIER, ts[0], VALUES[0]);
        put.addColumn(FAMILIES[1], QUALIFIER, ts[1], VALUES[1]);
        put.addColumn(FAMILIES[2], QUALIFIER, ts[2], VALUES[2]);
        put.addColumn(FAMILIES[2], QUALIFIER, ts[3], VALUES[3]);
        ht.put(put);
        get = new Get(ROWS[2]);
        get.addFamily(FAMILIES[1]);
        get.addFamily(FAMILIES[2]);
        get.setMaxVersions(Integer.MAX_VALUE);
        result = ht.get(get);
        Assert.assertTrue((String)("Expected 4 key but received " + result.size() + ": " + result), (result.size() == 4 ? 1 : 0) != 0);
        delete = new Delete(ROWS[0]);
        delete.addFamily(FAMILIES[2]);
        ht.delete(delete);
        delete = new Delete(ROWS[1]);
        delete.addColumns(FAMILIES[1], QUALIFIER);
        ht.delete(delete);
        delete = new Delete(ROWS[2]);
        delete.addColumn(FAMILIES[1], QUALIFIER);
        delete.addColumn(FAMILIES[1], QUALIFIER);
        delete.addColumn(FAMILIES[2], QUALIFIER);
        ht.delete(delete);
        get = new Get(ROWS[0]);
        get.addFamily(FAMILIES[1]);
        get.addFamily(FAMILIES[2]);
        get.setMaxVersions(Integer.MAX_VALUE);
        result = ht.get(get);
        Assert.assertTrue((String)("Expected 2 keys but received " + result.size()), (result.size() == 2 ? 1 : 0) != 0);
        this.assertNResult(result, ROWS[0], FAMILIES[1], QUALIFIER, new long[]{ts[0], ts[1]}, new byte[][]{VALUES[0], VALUES[1]}, 0, 1);
        scan = new Scan(ROWS[0]);
        scan.addFamily(FAMILIES[1]);
        scan.addFamily(FAMILIES[2]);
        scan.setMaxVersions(Integer.MAX_VALUE);
        result = this.getSingleScanResult(ht, scan);
        Assert.assertTrue((String)("Expected 2 keys but received " + result.size()), (result.size() == 2 ? 1 : 0) != 0);
        this.assertNResult(result, ROWS[0], FAMILIES[1], QUALIFIER, new long[]{ts[0], ts[1]}, new byte[][]{VALUES[0], VALUES[1]}, 0, 1);
        get = new Get(ROWS[1]);
        get.addFamily(FAMILIES[1]);
        get.addFamily(FAMILIES[2]);
        get.setMaxVersions(Integer.MAX_VALUE);
        result = ht.get(get);
        Assert.assertTrue((String)("Expected 2 keys but received " + result.size()), (result.size() == 2 ? 1 : 0) != 0);
        scan = new Scan(ROWS[1]);
        scan.addFamily(FAMILIES[1]);
        scan.addFamily(FAMILIES[2]);
        scan.setMaxVersions(Integer.MAX_VALUE);
        result = this.getSingleScanResult(ht, scan);
        Assert.assertTrue((String)("Expected 2 keys but received " + result.size()), (result.size() == 2 ? 1 : 0) != 0);
        get = new Get(ROWS[2]);
        get.addFamily(FAMILIES[1]);
        get.addFamily(FAMILIES[2]);
        get.setMaxVersions(Integer.MAX_VALUE);
        result = ht.get(get);
        Assert.assertEquals((long)1L, (long)result.size());
        this.assertNResult(result, ROWS[2], FAMILIES[2], QUALIFIER, new long[]{ts[2]}, new byte[][]{VALUES[2]}, 0, 0);
        scan = new Scan(ROWS[2]);
        scan.addFamily(FAMILIES[1]);
        scan.addFamily(FAMILIES[2]);
        scan.setMaxVersions(Integer.MAX_VALUE);
        result = this.getSingleScanResult(ht, scan);
        Assert.assertEquals((long)1L, (long)result.size());
        this.assertNResult(result, ROWS[2], FAMILIES[2], QUALIFIER, new long[]{ts[2]}, new byte[][]{VALUES[2]}, 0, 0);
        delete = new Delete(ROWS[3]);
        delete.addFamily(FAMILIES[1]);
        ht.delete(delete);
        put = new Put(ROWS[3]);
        put.addColumn(FAMILIES[2], QUALIFIER, VALUES[0]);
        ht.put(put);
        put = new Put(ROWS[4]);
        put.addColumn(FAMILIES[1], QUALIFIER, VALUES[1]);
        put.addColumn(FAMILIES[2], QUALIFIER, VALUES[2]);
        ht.put(put);
        get = new Get(ROWS[3]);
        get.addFamily(FAMILIES[1]);
        get.addFamily(FAMILIES[2]);
        get.setMaxVersions(Integer.MAX_VALUE);
        result = ht.get(get);
        Assert.assertTrue((String)("Expected 1 key but received " + result.size()), (result.size() == 1 ? 1 : 0) != 0);
        get = new Get(ROWS[4]);
        get.addFamily(FAMILIES[1]);
        get.addFamily(FAMILIES[2]);
        get.setMaxVersions(Integer.MAX_VALUE);
        result = ht.get(get);
        Assert.assertTrue((String)("Expected 2 keys but received " + result.size()), (result.size() == 2 ? 1 : 0) != 0);
        scan = new Scan(ROWS[3]);
        scan.addFamily(FAMILIES[1]);
        scan.addFamily(FAMILIES[2]);
        scan.setMaxVersions(Integer.MAX_VALUE);
        ResultScanner scanner = ht.getScanner(scan);
        result = scanner.next();
        Assert.assertTrue((String)("Expected 1 key but received " + result.size()), (result.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)Bytes.equals((byte[])CellUtil.cloneRow((Cell)result.rawCells()[0]), (byte[])ROWS[3]));
        Assert.assertTrue((boolean)Bytes.equals((byte[])CellUtil.cloneValue((Cell)result.rawCells()[0]), (byte[])VALUES[0]));
        result = scanner.next();
        Assert.assertTrue((String)("Expected 2 keys but received " + result.size()), (result.size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)Bytes.equals((byte[])CellUtil.cloneRow((Cell)result.rawCells()[0]), (byte[])ROWS[4]));
        Assert.assertTrue((boolean)Bytes.equals((byte[])CellUtil.cloneRow((Cell)result.rawCells()[1]), (byte[])ROWS[4]));
        Assert.assertTrue((boolean)Bytes.equals((byte[])CellUtil.cloneValue((Cell)result.rawCells()[0]), (byte[])VALUES[1]));
        Assert.assertTrue((boolean)Bytes.equals((byte[])CellUtil.cloneValue((Cell)result.rawCells()[1]), (byte[])VALUES[2]));
        scanner.close();
        for (i2 = 0; i2 < 10; ++i2) {
            bytes2 = Bytes.toBytes((int)i2);
            put = new Put(bytes2);
            put.setDurability(Durability.SKIP_WAL);
            put.addColumn(FAMILIES[0], QUALIFIER, bytes2);
            ht.put(put);
        }
        for (i2 = 0; i2 < 10; ++i2) {
            bytes2 = Bytes.toBytes((int)i2);
            get = new Get(bytes2);
            get.addFamily(FAMILIES[0]);
            result = ht.get(get);
            Assert.assertTrue((result.size() == 1 ? 1 : 0) != 0);
        }
        ArrayList<Delete> deletes = new ArrayList<Delete>();
        for (i = 0; i < 10; ++i) {
            bytes = Bytes.toBytes((int)i);
            delete = new Delete(bytes);
            delete.addFamily(FAMILIES[0]);
            deletes.add(delete);
        }
        ht.delete(deletes);
        for (i = 0; i < 10; ++i) {
            bytes = Bytes.toBytes((int)i);
            get = new Get(bytes);
            get.addFamily(FAMILIES[0]);
            result = ht.get(get);
            Assert.assertTrue((boolean)result.isEmpty());
        }
    }

    @Test
    public void testBatchOperationsWithErrors() throws Exception {
        Delete delete;
        Put put;
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        Table foo = TEST_UTIL.createTable(tableName, (byte[][])new byte[][]{FAMILY}, 10);
        int NUM_OPS = 100;
        int FAILED_OPS = 50;
        RetriesExhaustedWithDetailsException expectedException = null;
        IllegalArgumentException iae = null;
        ArrayList<Put> puts = new ArrayList<Put>(NUM_OPS);
        for (int i = 0; i != NUM_OPS; ++i) {
            put = new Put(Bytes.toBytes((int)i));
            puts.add(put);
        }
        try {
            foo.put(puts);
        }
        catch (IllegalArgumentException e) {
            iae = e;
        }
        Assert.assertNotNull((Object)iae);
        Assert.assertEquals((long)NUM_OPS, (long)puts.size());
        iae = null;
        puts.clear();
        for (int i = 0; i != NUM_OPS; ++i) {
            put = new Put(Bytes.toBytes((int)i));
            put.addColumn(i % 2 == 0 ? FAMILY : INVALID_FAMILY, FAMILY, Bytes.toBytes((int)i));
            puts.add(put);
        }
        try {
            foo.put(puts);
        }
        catch (RetriesExhaustedWithDetailsException e) {
            expectedException = e;
        }
        Assert.assertNotNull((Object)((Object)expectedException));
        Assert.assertEquals((long)FAILED_OPS, (long)expectedException.exceptions.size());
        Assert.assertTrue((boolean)expectedException.actions.contains(puts.get(1)));
        ArrayList<Get> gets = new ArrayList<Get>(NUM_OPS);
        for (int i = 0; i < NUM_OPS; ++i) {
            Get get = new Get(Bytes.toBytes((int)i));
            gets.add(get);
        }
        Result[] getsResult = foo.get(gets);
        Assert.assertNotNull((Object)getsResult);
        Assert.assertEquals((long)NUM_OPS, (long)getsResult.length);
        Assert.assertNull((Object)getsResult[1].getRow());
        gets.clear();
        getsResult = null;
        expectedException = null;
        for (int i = 0; i < NUM_OPS; ++i) {
            Get get = new Get(Bytes.toBytes((int)i));
            get.addColumn(i % 2 == 0 ? FAMILY : INVALID_FAMILY, FAMILY);
            gets.add(get);
        }
        try {
            getsResult = foo.get(gets);
        }
        catch (RetriesExhaustedWithDetailsException e) {
            expectedException = e;
        }
        Assert.assertNull((Object)getsResult);
        Assert.assertNotNull((Object)((Object)expectedException));
        Assert.assertEquals((long)FAILED_OPS, (long)expectedException.exceptions.size());
        Assert.assertTrue((boolean)expectedException.actions.contains(gets.get(1)));
        expectedException = null;
        ArrayList<Delete> deletes = new ArrayList<Delete>(NUM_OPS);
        for (int i = 0; i < NUM_OPS; ++i) {
            delete = new Delete(Bytes.toBytes((int)i));
            delete.addColumn(i % 2 == 0 ? FAMILY : INVALID_FAMILY, FAMILY);
            deletes.add(delete);
        }
        try {
            foo.delete(deletes);
        }
        catch (RetriesExhaustedWithDetailsException e) {
            expectedException = e;
        }
        Assert.assertEquals((long)(NUM_OPS - FAILED_OPS), (long)deletes.size());
        Assert.assertNotNull((Object)((Object)expectedException));
        Assert.assertEquals((long)FAILED_OPS, (long)expectedException.exceptions.size());
        Assert.assertTrue((boolean)expectedException.actions.contains(deletes.get(1)));
        deletes.clear();
        for (int i = 0; i < NUM_OPS; ++i) {
            delete = new Delete(Bytes.toBytes((int)i));
            deletes.add(delete);
        }
        foo.delete(deletes);
        Assert.assertTrue((boolean)deletes.isEmpty());
    }

    @Ignore
    @Test
    public void testMillions() throws Exception {
    }

    @Ignore
    @Test
    public void testMultipleRegionsAndBatchPuts() throws Exception {
    }

    @Ignore
    @Test
    public void testMultipleRowMultipleFamily() throws Exception {
    }

    @Test
    public void testJiraTest867() throws Exception {
        int i;
        int numRows = 10;
        int numColsPerRow = 2000;
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        byte[][] ROWS = this.makeN(ROW, numRows);
        byte[][] QUALIFIERS = this.makeN(QUALIFIER, numColsPerRow);
        Table ht = TEST_UTIL.createTable(tableName, FAMILY);
        for (int i2 = 0; i2 < numRows; ++i2) {
            Put put = new Put(ROWS[i2]);
            put.setDurability(Durability.SKIP_WAL);
            for (int j = 0; j < numColsPerRow; ++j) {
                put.addColumn(FAMILY, QUALIFIERS[j], QUALIFIERS[j]);
            }
            Assert.assertTrue((String)("Put expected to contain " + numColsPerRow + " columns but only contains " + put.size()), (put.size() == numColsPerRow ? 1 : 0) != 0);
            ht.put(put);
        }
        Get get = new Get(ROWS[numRows - 1]);
        Result result = ht.get(get);
        this.assertNumKeys(result, numColsPerRow);
        Cell[] keys = result.rawCells();
        for (int i3 = 0; i3 < result.size(); ++i3) {
            this.assertKey(keys[i3], ROWS[numRows - 1], FAMILY, QUALIFIERS[i3], QUALIFIERS[i3]);
        }
        Scan scan = new Scan();
        ResultScanner scanner = ht.getScanner(scan);
        int rowCount = 0;
        while ((result = scanner.next()) != null) {
            this.assertNumKeys(result, numColsPerRow);
            Cell[] kvs = result.rawCells();
            for (i = 0; i < numColsPerRow; ++i) {
                this.assertKey(kvs[i], ROWS[rowCount], FAMILY, QUALIFIERS[i], QUALIFIERS[i]);
            }
            ++rowCount;
        }
        scanner.close();
        Assert.assertTrue((String)("Expected to scan " + numRows + " rows but actually scanned " + rowCount + " rows"), (rowCount == numRows ? 1 : 0) != 0);
        TEST_UTIL.flush();
        get = new Get(ROWS[numRows - 1]);
        result = ht.get(get);
        this.assertNumKeys(result, numColsPerRow);
        keys = result.rawCells();
        for (int i4 = 0; i4 < result.size(); ++i4) {
            this.assertKey(keys[i4], ROWS[numRows - 1], FAMILY, QUALIFIERS[i4], QUALIFIERS[i4]);
        }
        scan = new Scan();
        scanner = ht.getScanner(scan);
        rowCount = 0;
        while ((result = scanner.next()) != null) {
            this.assertNumKeys(result, numColsPerRow);
            Cell[] kvs = result.rawCells();
            for (i = 0; i < numColsPerRow; ++i) {
                this.assertKey(kvs[i], ROWS[rowCount], FAMILY, QUALIFIERS[i], QUALIFIERS[i]);
            }
            ++rowCount;
        }
        scanner.close();
        Assert.assertTrue((String)("Expected to scan " + numRows + " rows but actually scanned " + rowCount + " rows"), (rowCount == numRows ? 1 : 0) != 0);
    }

    @Test
    public void testJiraTest861() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        byte[][] VALUES = this.makeNAscii(VALUE, 7);
        long[] STAMPS = this.makeStamps(7);
        Table ht = TEST_UTIL.createTable(tableName, FAMILY, 10);
        Put put = new Put(ROW);
        put.addColumn(FAMILY, QUALIFIER, STAMPS[3], VALUES[3]);
        put.addColumn(FAMILY, QUALIFIER, STAMPS[2], VALUES[2]);
        put.addColumn(FAMILY, QUALIFIER, STAMPS[4], VALUES[4]);
        ht.put(put);
        this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[2], VALUES[2]);
        this.getVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[1]);
        this.getVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[5]);
        TEST_UTIL.flush();
        this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[2], VALUES[2]);
        this.getVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[1]);
        this.getVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[5]);
        put = new Put(ROW);
        put.addColumn(FAMILY, QUALIFIER, STAMPS[0], VALUES[0]);
        put.addColumn(FAMILY, QUALIFIER, STAMPS[6], VALUES[6]);
        ht.put(put);
        this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[0], VALUES[0]);
        this.getVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[1]);
        this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[2], VALUES[2]);
        this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[3], VALUES[3]);
        this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[4], VALUES[4]);
        this.getVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[5]);
        this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[6], VALUES[6]);
        TEST_UTIL.flush();
        this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[0], VALUES[0]);
        this.getVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[1]);
        this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[2], VALUES[2]);
        this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[3], VALUES[3]);
        this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[4], VALUES[4]);
        this.getVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[5]);
        this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[6], VALUES[6]);
    }

    @Test
    public void testJiraTest33() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        byte[][] VALUES = this.makeNAscii(VALUE, 7);
        long[] STAMPS = this.makeStamps(7);
        Table ht = TEST_UTIL.createTable(tableName, FAMILY, 10);
        Put put = new Put(ROW);
        put.addColumn(FAMILY, QUALIFIER, STAMPS[0], VALUES[0]);
        put.addColumn(FAMILY, QUALIFIER, STAMPS[1], VALUES[1]);
        put.addColumn(FAMILY, QUALIFIER, STAMPS[2], VALUES[2]);
        put.addColumn(FAMILY, QUALIFIER, STAMPS[3], VALUES[3]);
        put.addColumn(FAMILY, QUALIFIER, STAMPS[4], VALUES[4]);
        put.addColumn(FAMILY, QUALIFIER, STAMPS[5], VALUES[5]);
        ht.put(put);
        this.getVersionRangeAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS, VALUES, 0, 5);
        this.getVersionRangeAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS, VALUES, 0, 2);
        this.getVersionRangeAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS, VALUES, 4, 5);
        this.getVersionRangeAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS, VALUES, 2, 3);
        this.scanVersionRangeAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS, VALUES, 0, 5);
        this.scanVersionRangeAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS, VALUES, 0, 2);
        this.scanVersionRangeAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS, VALUES, 4, 5);
        this.scanVersionRangeAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS, VALUES, 2, 3);
        TEST_UTIL.flush();
        this.getVersionRangeAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS, VALUES, 0, 5);
        this.getVersionRangeAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS, VALUES, 0, 2);
        this.getVersionRangeAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS, VALUES, 4, 5);
        this.getVersionRangeAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS, VALUES, 2, 3);
        this.scanVersionRangeAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS, VALUES, 0, 5);
        this.scanVersionRangeAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS, VALUES, 0, 2);
        this.scanVersionRangeAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS, VALUES, 4, 5);
        this.scanVersionRangeAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS, VALUES, 2, 3);
    }

    @Test
    public void testJiraTest1014() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        Table ht = TEST_UTIL.createTable(tableName, FAMILY, 10);
        long manualStamp = 12345L;
        Put put = new Put(ROW);
        put.addColumn(FAMILY, QUALIFIER, manualStamp, VALUE);
        ht.put(put);
        this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, manualStamp, VALUE);
        this.getVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, manualStamp - 1L);
        this.getVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, manualStamp + 1L);
    }

    @Test
    public void testJiraTest1182() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        byte[][] VALUES = this.makeNAscii(VALUE, 7);
        long[] STAMPS = this.makeStamps(7);
        Table ht = TEST_UTIL.createTable(tableName, FAMILY, 10);
        Put put = new Put(ROW);
        put.addColumn(FAMILY, QUALIFIER, STAMPS[0], VALUES[0]);
        put.addColumn(FAMILY, QUALIFIER, STAMPS[1], VALUES[1]);
        put.addColumn(FAMILY, QUALIFIER, STAMPS[2], VALUES[2]);
        put.addColumn(FAMILY, QUALIFIER, STAMPS[3], VALUES[3]);
        put.addColumn(FAMILY, QUALIFIER, STAMPS[4], VALUES[4]);
        put.addColumn(FAMILY, QUALIFIER, STAMPS[5], VALUES[5]);
        ht.put(put);
        this.getVersionRangeAndVerifyGreaterThan(ht, ROW, FAMILY, QUALIFIER, STAMPS, VALUES, 0, 5);
        this.getVersionRangeAndVerifyGreaterThan(ht, ROW, FAMILY, QUALIFIER, STAMPS, VALUES, 2, 5);
        this.getVersionRangeAndVerifyGreaterThan(ht, ROW, FAMILY, QUALIFIER, STAMPS, VALUES, 4, 5);
        this.scanVersionRangeAndVerifyGreaterThan(ht, ROW, FAMILY, QUALIFIER, STAMPS, VALUES, 0, 5);
        this.scanVersionRangeAndVerifyGreaterThan(ht, ROW, FAMILY, QUALIFIER, STAMPS, VALUES, 2, 5);
        this.scanVersionRangeAndVerifyGreaterThan(ht, ROW, FAMILY, QUALIFIER, STAMPS, VALUES, 4, 5);
        TEST_UTIL.flush();
        this.getVersionRangeAndVerifyGreaterThan(ht, ROW, FAMILY, QUALIFIER, STAMPS, VALUES, 0, 5);
        this.getVersionRangeAndVerifyGreaterThan(ht, ROW, FAMILY, QUALIFIER, STAMPS, VALUES, 2, 5);
        this.getVersionRangeAndVerifyGreaterThan(ht, ROW, FAMILY, QUALIFIER, STAMPS, VALUES, 4, 5);
        this.scanVersionRangeAndVerifyGreaterThan(ht, ROW, FAMILY, QUALIFIER, STAMPS, VALUES, 0, 5);
        this.scanVersionRangeAndVerifyGreaterThan(ht, ROW, FAMILY, QUALIFIER, STAMPS, VALUES, 2, 5);
        this.scanVersionRangeAndVerifyGreaterThan(ht, ROW, FAMILY, QUALIFIER, STAMPS, VALUES, 4, 5);
    }

    @Test
    public void testJiraTest52() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        byte[][] VALUES = this.makeNAscii(VALUE, 7);
        long[] STAMPS = this.makeStamps(7);
        Table ht = TEST_UTIL.createTable(tableName, FAMILY, 10);
        Put put = new Put(ROW);
        put.addColumn(FAMILY, QUALIFIER, STAMPS[0], VALUES[0]);
        put.addColumn(FAMILY, QUALIFIER, STAMPS[1], VALUES[1]);
        put.addColumn(FAMILY, QUALIFIER, STAMPS[2], VALUES[2]);
        put.addColumn(FAMILY, QUALIFIER, STAMPS[3], VALUES[3]);
        put.addColumn(FAMILY, QUALIFIER, STAMPS[4], VALUES[4]);
        put.addColumn(FAMILY, QUALIFIER, STAMPS[5], VALUES[5]);
        ht.put(put);
        this.getAllVersionsAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS, VALUES, 0, 5);
        this.scanAllVersionsAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS, VALUES, 0, 5);
        TEST_UTIL.flush();
        this.getAllVersionsAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS, VALUES, 0, 5);
        this.scanAllVersionsAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS, VALUES, 0, 5);
    }

    private void getVersionRangeAndVerifyGreaterThan(Table ht, byte[] row, byte[] family, byte[] qualifier, long[] stamps, byte[][] values, int start, int end) throws IOException {
        Get get = new Get(row);
        get.addColumn(family, qualifier);
        get.setMaxVersions(Integer.MAX_VALUE);
        get.setTimeRange(stamps[start + 1], Long.MAX_VALUE);
        Result result = ht.get(get);
        this.assertNResult(result, row, family, qualifier, stamps, values, start + 1, end);
    }

    private void getVersionRangeAndVerify(Table ht, byte[] row, byte[] family, byte[] qualifier, long[] stamps, byte[][] values, int start, int end) throws IOException {
        Get get = new Get(row);
        get.addColumn(family, qualifier);
        get.setMaxVersions(Integer.MAX_VALUE);
        get.setTimeRange(stamps[start], stamps[end] + 1L);
        Result result = ht.get(get);
        this.assertNResult(result, row, family, qualifier, stamps, values, start, end);
    }

    private void getAllVersionsAndVerify(Table ht, byte[] row, byte[] family, byte[] qualifier, long[] stamps, byte[][] values, int start, int end) throws IOException {
        Get get = new Get(row);
        get.addColumn(family, qualifier);
        get.setMaxVersions(Integer.MAX_VALUE);
        Result result = ht.get(get);
        this.assertNResult(result, row, family, qualifier, stamps, values, start, end);
    }

    private void scanVersionRangeAndVerifyGreaterThan(Table ht, byte[] row, byte[] family, byte[] qualifier, long[] stamps, byte[][] values, int start, int end) throws IOException {
        Scan scan = new Scan(row);
        scan.addColumn(family, qualifier);
        scan.setMaxVersions(Integer.MAX_VALUE);
        scan.setTimeRange(stamps[start + 1], Long.MAX_VALUE);
        Result result = this.getSingleScanResult(ht, scan);
        this.assertNResult(result, row, family, qualifier, stamps, values, start + 1, end);
    }

    private void scanVersionRangeAndVerify(Table ht, byte[] row, byte[] family, byte[] qualifier, long[] stamps, byte[][] values, int start, int end) throws IOException {
        Scan scan = new Scan(row);
        scan.addColumn(family, qualifier);
        scan.setMaxVersions(Integer.MAX_VALUE);
        scan.setTimeRange(stamps[start], stamps[end] + 1L);
        Result result = this.getSingleScanResult(ht, scan);
        this.assertNResult(result, row, family, qualifier, stamps, values, start, end);
    }

    private void scanAllVersionsAndVerify(Table ht, byte[] row, byte[] family, byte[] qualifier, long[] stamps, byte[][] values, int start, int end) throws IOException {
        Scan scan = new Scan(row);
        scan.addColumn(family, qualifier);
        scan.setMaxVersions(Integer.MAX_VALUE);
        Result result = this.getSingleScanResult(ht, scan);
        this.assertNResult(result, row, family, qualifier, stamps, values, start, end);
    }

    private void getVersionAndVerify(Table ht, byte[] row, byte[] family, byte[] qualifier, long stamp, byte[] value) throws Exception {
        Get get = new Get(row);
        get.addColumn(family, qualifier);
        get.setTimestamp(stamp);
        get.setMaxVersions(Integer.MAX_VALUE);
        Result result = ht.get(get);
        this.assertSingleResult(result, row, family, qualifier, stamp, value);
    }

    private void getVersionAndVerifyMissing(Table ht, byte[] row, byte[] family, byte[] qualifier, long stamp) throws Exception {
        Get get = new Get(row);
        get.addColumn(family, qualifier);
        get.setTimestamp(stamp);
        get.setMaxVersions(Integer.MAX_VALUE);
        Result result = ht.get(get);
        this.assertEmptyResult(result);
    }

    private void scanVersionAndVerify(Table ht, byte[] row, byte[] family, byte[] qualifier, long stamp, byte[] value) throws Exception {
        Scan scan = new Scan(row);
        scan.addColumn(family, qualifier);
        scan.setTimestamp(stamp);
        scan.setMaxVersions(Integer.MAX_VALUE);
        Result result = this.getSingleScanResult(ht, scan);
        this.assertSingleResult(result, row, family, qualifier, stamp, value);
    }

    private void scanVersionAndVerifyMissing(Table ht, byte[] row, byte[] family, byte[] qualifier, long stamp) throws Exception {
        Scan scan = new Scan(row);
        scan.addColumn(family, qualifier);
        scan.setTimestamp(stamp);
        scan.setMaxVersions(Integer.MAX_VALUE);
        Result result = this.getSingleScanResult(ht, scan);
        this.assertNullResult(result);
    }

    private void getTestNull(Table ht, byte[] row, byte[] family, byte[] value) throws Exception {
        Get get = new Get(row);
        get.addColumn(family, null);
        Result result = ht.get(get);
        this.assertSingleResult(result, row, family, null, value);
        get = new Get(row);
        get.addColumn(family, HConstants.EMPTY_BYTE_ARRAY);
        result = ht.get(get);
        this.assertSingleResult(result, row, family, HConstants.EMPTY_BYTE_ARRAY, value);
        get = new Get(row);
        get.addFamily(family);
        result = ht.get(get);
        this.assertSingleResult(result, row, family, HConstants.EMPTY_BYTE_ARRAY, value);
        get = new Get(row);
        result = ht.get(get);
        this.assertSingleResult(result, row, family, HConstants.EMPTY_BYTE_ARRAY, value);
    }

    private void getTestNull(Table ht, byte[] row, byte[] family, long value) throws Exception {
        Get get = new Get(row);
        get.addColumn(family, null);
        Result result = ht.get(get);
        this.assertSingleResult(result, row, family, null, value);
        get = new Get(row);
        get.addColumn(family, HConstants.EMPTY_BYTE_ARRAY);
        result = ht.get(get);
        this.assertSingleResult(result, row, family, HConstants.EMPTY_BYTE_ARRAY, value);
        get = new Get(row);
        get.addFamily(family);
        result = ht.get(get);
        this.assertSingleResult(result, row, family, HConstants.EMPTY_BYTE_ARRAY, value);
        get = new Get(row);
        result = ht.get(get);
        this.assertSingleResult(result, row, family, HConstants.EMPTY_BYTE_ARRAY, value);
    }

    private void scanTestNull(Table ht, byte[] row, byte[] family, byte[] value) throws Exception {
        this.scanTestNull(ht, row, family, value, false);
    }

    private void scanTestNull(Table ht, byte[] row, byte[] family, byte[] value, boolean isReversedScan) throws Exception {
        Scan scan = new Scan();
        scan.setReversed(isReversedScan);
        scan.addColumn(family, null);
        Result result = this.getSingleScanResult(ht, scan);
        this.assertSingleResult(result, row, family, HConstants.EMPTY_BYTE_ARRAY, value);
        scan = new Scan();
        scan.setReversed(isReversedScan);
        scan.addColumn(family, HConstants.EMPTY_BYTE_ARRAY);
        result = this.getSingleScanResult(ht, scan);
        this.assertSingleResult(result, row, family, HConstants.EMPTY_BYTE_ARRAY, value);
        scan = new Scan();
        scan.setReversed(isReversedScan);
        scan.addFamily(family);
        result = this.getSingleScanResult(ht, scan);
        this.assertSingleResult(result, row, family, HConstants.EMPTY_BYTE_ARRAY, value);
        scan = new Scan();
        scan.setReversed(isReversedScan);
        result = this.getSingleScanResult(ht, scan);
        this.assertSingleResult(result, row, family, HConstants.EMPTY_BYTE_ARRAY, value);
    }

    private void singleRowGetTest(Table ht, byte[][] ROWS, byte[][] FAMILIES, byte[][] QUALIFIERS, byte[][] VALUES) throws Exception {
        Get get = new Get(ROWS[0]);
        get.addColumn(FAMILIES[4], QUALIFIERS[0]);
        Result result = ht.get(get);
        this.assertSingleResult(result, ROWS[0], FAMILIES[4], QUALIFIERS[0], VALUES[0]);
        get = new Get(ROWS[0]);
        get.addColumn(FAMILIES[2], QUALIFIERS[2]);
        result = ht.get(get);
        this.assertSingleResult(result, ROWS[0], FAMILIES[2], QUALIFIERS[2], VALUES[2]);
        get = new Get(ROWS[0]);
        get.addFamily(FAMILIES[7]);
        result = ht.get(get);
        this.assertSingleResult(result, ROWS[0], FAMILIES[7], QUALIFIERS[7], VALUES[7]);
        get = new Get(ROWS[0]);
        get.addFamily(FAMILIES[4]);
        result = ht.get(get);
        this.assertDoubleResult(result, ROWS[0], FAMILIES[4], QUALIFIERS[0], VALUES[0], FAMILIES[4], QUALIFIERS[4], VALUES[4]);
        get = new Get(ROWS[0]);
        get.addColumn(FAMILIES[4], QUALIFIERS[0]);
        get.addColumn(FAMILIES[4], QUALIFIERS[4]);
        result = ht.get(get);
        this.assertDoubleResult(result, ROWS[0], FAMILIES[4], QUALIFIERS[0], VALUES[0], FAMILIES[4], QUALIFIERS[4], VALUES[4]);
        get = new Get(ROWS[0]);
        get.addFamily(FAMILIES[4]);
        get.addFamily(FAMILIES[7]);
        result = ht.get(get);
        this.assertNResult(result, ROWS[0], FAMILIES, QUALIFIERS, VALUES, new int[][]{{4, 0, 0}, {4, 4, 4}, {7, 7, 7}});
        get = new Get(ROWS[0]);
        get.addFamily(FAMILIES[2]);
        get.addFamily(FAMILIES[4]);
        get.addFamily(FAMILIES[6]);
        get.addFamily(FAMILIES[7]);
        result = ht.get(get);
        this.assertNResult(result, ROWS[0], FAMILIES, QUALIFIERS, VALUES, new int[][]{{2, 2, 2}, {2, 4, 4}, {4, 0, 0}, {4, 4, 4}, {6, 6, 6}, {6, 7, 7}, {7, 7, 7}});
        get = new Get(ROWS[0]);
        get.addColumn(FAMILIES[2], QUALIFIERS[2]);
        get.addColumn(FAMILIES[2], QUALIFIERS[4]);
        get.addColumn(FAMILIES[4], QUALIFIERS[0]);
        get.addColumn(FAMILIES[4], QUALIFIERS[4]);
        get.addColumn(FAMILIES[6], QUALIFIERS[6]);
        get.addColumn(FAMILIES[6], QUALIFIERS[7]);
        get.addColumn(FAMILIES[7], QUALIFIERS[7]);
        get.addColumn(FAMILIES[7], QUALIFIERS[8]);
        result = ht.get(get);
        this.assertNResult(result, ROWS[0], FAMILIES, QUALIFIERS, VALUES, new int[][]{{2, 2, 2}, {2, 4, 4}, {4, 0, 0}, {4, 4, 4}, {6, 6, 6}, {6, 7, 7}, {7, 7, 7}});
        get = new Get(ROWS[0]);
        result = ht.get(get);
        this.assertNResult(result, ROWS[0], FAMILIES, QUALIFIERS, VALUES, new int[][]{{2, 2, 2}, {2, 4, 4}, {4, 0, 0}, {4, 4, 4}, {6, 6, 6}, {6, 7, 7}, {7, 7, 7}, {9, 0, 0}});
        get = new Get(ROWS[1]);
        result = ht.get(get);
        this.assertEmptyResult(result);
        get = new Get(ROWS[0]);
        get.addColumn(FAMILIES[4], QUALIFIERS[3]);
        get.addColumn(FAMILIES[2], QUALIFIERS[3]);
        result = ht.get(get);
        this.assertEmptyResult(result);
    }

    private void singleRowScanTest(Table ht, byte[][] ROWS, byte[][] FAMILIES, byte[][] QUALIFIERS, byte[][] VALUES) throws Exception {
        Scan scan = new Scan();
        scan.addColumn(FAMILIES[4], QUALIFIERS[0]);
        Result result = this.getSingleScanResult(ht, scan);
        this.assertSingleResult(result, ROWS[0], FAMILIES[4], QUALIFIERS[0], VALUES[0]);
        scan = new Scan();
        scan.addColumn(FAMILIES[2], QUALIFIERS[2]);
        result = this.getSingleScanResult(ht, scan);
        this.assertSingleResult(result, ROWS[0], FAMILIES[2], QUALIFIERS[2], VALUES[2]);
        scan = new Scan();
        scan.addFamily(FAMILIES[7]);
        result = this.getSingleScanResult(ht, scan);
        this.assertSingleResult(result, ROWS[0], FAMILIES[7], QUALIFIERS[7], VALUES[7]);
        scan = new Scan();
        scan.addFamily(FAMILIES[4]);
        result = this.getSingleScanResult(ht, scan);
        this.assertDoubleResult(result, ROWS[0], FAMILIES[4], QUALIFIERS[0], VALUES[0], FAMILIES[4], QUALIFIERS[4], VALUES[4]);
        scan = new Scan();
        scan.addColumn(FAMILIES[4], QUALIFIERS[0]);
        scan.addColumn(FAMILIES[4], QUALIFIERS[4]);
        result = this.getSingleScanResult(ht, scan);
        this.assertDoubleResult(result, ROWS[0], FAMILIES[4], QUALIFIERS[0], VALUES[0], FAMILIES[4], QUALIFIERS[4], VALUES[4]);
        scan = new Scan();
        scan.addFamily(FAMILIES[4]);
        scan.addFamily(FAMILIES[7]);
        result = this.getSingleScanResult(ht, scan);
        this.assertNResult(result, ROWS[0], FAMILIES, QUALIFIERS, VALUES, new int[][]{{4, 0, 0}, {4, 4, 4}, {7, 7, 7}});
        scan = new Scan();
        scan.addFamily(FAMILIES[2]);
        scan.addFamily(FAMILIES[4]);
        scan.addFamily(FAMILIES[6]);
        scan.addFamily(FAMILIES[7]);
        result = this.getSingleScanResult(ht, scan);
        this.assertNResult(result, ROWS[0], FAMILIES, QUALIFIERS, VALUES, new int[][]{{2, 2, 2}, {2, 4, 4}, {4, 0, 0}, {4, 4, 4}, {6, 6, 6}, {6, 7, 7}, {7, 7, 7}});
        scan = new Scan();
        scan.addColumn(FAMILIES[2], QUALIFIERS[2]);
        scan.addColumn(FAMILIES[2], QUALIFIERS[4]);
        scan.addColumn(FAMILIES[4], QUALIFIERS[0]);
        scan.addColumn(FAMILIES[4], QUALIFIERS[4]);
        scan.addColumn(FAMILIES[6], QUALIFIERS[6]);
        scan.addColumn(FAMILIES[6], QUALIFIERS[7]);
        scan.addColumn(FAMILIES[7], QUALIFIERS[7]);
        scan.addColumn(FAMILIES[7], QUALIFIERS[8]);
        result = this.getSingleScanResult(ht, scan);
        this.assertNResult(result, ROWS[0], FAMILIES, QUALIFIERS, VALUES, new int[][]{{2, 2, 2}, {2, 4, 4}, {4, 0, 0}, {4, 4, 4}, {6, 6, 6}, {6, 7, 7}, {7, 7, 7}});
        scan = new Scan();
        result = this.getSingleScanResult(ht, scan);
        this.assertNResult(result, ROWS[0], FAMILIES, QUALIFIERS, VALUES, new int[][]{{2, 2, 2}, {2, 4, 4}, {4, 0, 0}, {4, 4, 4}, {6, 6, 6}, {6, 7, 7}, {7, 7, 7}, {9, 0, 0}});
        scan = new Scan(ROWS[1]);
        result = this.getSingleScanResult(ht, scan);
        this.assertNullResult(result);
        scan = new Scan();
        scan.addColumn(FAMILIES[4], QUALIFIERS[3]);
        scan.addColumn(FAMILIES[2], QUALIFIERS[3]);
        result = this.getSingleScanResult(ht, scan);
        this.assertNullResult(result);
    }

    private void getVerifySingleColumn(Table ht, byte[][] ROWS, int ROWIDX, byte[][] FAMILIES, int FAMILYIDX, byte[][] QUALIFIERS, int QUALIFIERIDX, byte[][] VALUES, int VALUEIDX) throws Exception {
        Get get = new Get(ROWS[ROWIDX]);
        Result result = ht.get(get);
        this.assertSingleResult(result, ROWS[ROWIDX], FAMILIES[FAMILYIDX], QUALIFIERS[QUALIFIERIDX], VALUES[VALUEIDX]);
        get = new Get(ROWS[ROWIDX]);
        get.addFamily(FAMILIES[FAMILYIDX]);
        result = ht.get(get);
        this.assertSingleResult(result, ROWS[ROWIDX], FAMILIES[FAMILYIDX], QUALIFIERS[QUALIFIERIDX], VALUES[VALUEIDX]);
        get = new Get(ROWS[ROWIDX]);
        get.addFamily(FAMILIES[FAMILYIDX - 2]);
        get.addFamily(FAMILIES[FAMILYIDX]);
        get.addFamily(FAMILIES[FAMILYIDX + 2]);
        result = ht.get(get);
        this.assertSingleResult(result, ROWS[ROWIDX], FAMILIES[FAMILYIDX], QUALIFIERS[QUALIFIERIDX], VALUES[VALUEIDX]);
        get = new Get(ROWS[ROWIDX]);
        get.addColumn(FAMILIES[FAMILYIDX], QUALIFIERS[0]);
        result = ht.get(get);
        this.assertSingleResult(result, ROWS[ROWIDX], FAMILIES[FAMILYIDX], QUALIFIERS[QUALIFIERIDX], VALUES[VALUEIDX]);
        get = new Get(ROWS[ROWIDX]);
        get.addColumn(FAMILIES[FAMILYIDX], QUALIFIERS[1]);
        get.addFamily(FAMILIES[FAMILYIDX]);
        result = ht.get(get);
        this.assertSingleResult(result, ROWS[ROWIDX], FAMILIES[FAMILYIDX], QUALIFIERS[QUALIFIERIDX], VALUES[VALUEIDX]);
        get = new Get(ROWS[ROWIDX]);
        get.addFamily(FAMILIES[FAMILYIDX]);
        get.addColumn(FAMILIES[FAMILYIDX + 1], QUALIFIERS[1]);
        get.addColumn(FAMILIES[FAMILYIDX - 2], QUALIFIERS[1]);
        get.addFamily(FAMILIES[FAMILYIDX - 1]);
        get.addFamily(FAMILIES[FAMILYIDX + 2]);
        result = ht.get(get);
        this.assertSingleResult(result, ROWS[ROWIDX], FAMILIES[FAMILYIDX], QUALIFIERS[QUALIFIERIDX], VALUES[VALUEIDX]);
    }

    private void scanVerifySingleColumn(Table ht, byte[][] ROWS, int ROWIDX, byte[][] FAMILIES, int FAMILYIDX, byte[][] QUALIFIERS, int QUALIFIERIDX, byte[][] VALUES, int VALUEIDX) throws Exception {
        Scan scan = new Scan();
        Result result = this.getSingleScanResult(ht, scan);
        this.assertSingleResult(result, ROWS[ROWIDX], FAMILIES[FAMILYIDX], QUALIFIERS[QUALIFIERIDX], VALUES[VALUEIDX]);
        scan = new Scan(ROWS[ROWIDX]);
        result = this.getSingleScanResult(ht, scan);
        this.assertSingleResult(result, ROWS[ROWIDX], FAMILIES[FAMILYIDX], QUALIFIERS[QUALIFIERIDX], VALUES[VALUEIDX]);
        scan = new Scan(ROWS[ROWIDX], ROWS[ROWIDX + 1]);
        result = this.getSingleScanResult(ht, scan);
        this.assertSingleResult(result, ROWS[ROWIDX], FAMILIES[FAMILYIDX], QUALIFIERS[QUALIFIERIDX], VALUES[VALUEIDX]);
        scan = new Scan(HConstants.EMPTY_START_ROW, ROWS[ROWIDX + 1]);
        result = this.getSingleScanResult(ht, scan);
        this.assertSingleResult(result, ROWS[ROWIDX], FAMILIES[FAMILYIDX], QUALIFIERS[QUALIFIERIDX], VALUES[VALUEIDX]);
        scan = new Scan();
        scan.addFamily(FAMILIES[FAMILYIDX]);
        result = this.getSingleScanResult(ht, scan);
        this.assertSingleResult(result, ROWS[ROWIDX], FAMILIES[FAMILYIDX], QUALIFIERS[QUALIFIERIDX], VALUES[VALUEIDX]);
        scan = new Scan();
        scan.addColumn(FAMILIES[FAMILYIDX], QUALIFIERS[QUALIFIERIDX]);
        result = this.getSingleScanResult(ht, scan);
        this.assertSingleResult(result, ROWS[ROWIDX], FAMILIES[FAMILYIDX], QUALIFIERS[QUALIFIERIDX], VALUES[VALUEIDX]);
        scan = new Scan();
        scan.addColumn(FAMILIES[FAMILYIDX], QUALIFIERS[QUALIFIERIDX + 1]);
        scan.addFamily(FAMILIES[FAMILYIDX]);
        result = this.getSingleScanResult(ht, scan);
        this.assertSingleResult(result, ROWS[ROWIDX], FAMILIES[FAMILYIDX], QUALIFIERS[QUALIFIERIDX], VALUES[VALUEIDX]);
        scan = new Scan();
        scan.addColumn(FAMILIES[FAMILYIDX - 1], QUALIFIERS[QUALIFIERIDX + 1]);
        scan.addColumn(FAMILIES[FAMILYIDX], QUALIFIERS[QUALIFIERIDX]);
        scan.addFamily(FAMILIES[FAMILYIDX + 1]);
        result = this.getSingleScanResult(ht, scan);
        this.assertSingleResult(result, ROWS[ROWIDX], FAMILIES[FAMILYIDX], QUALIFIERS[QUALIFIERIDX], VALUES[VALUEIDX]);
    }

    private void getVerifySingleEmpty(Table ht, byte[][] ROWS, int ROWIDX, byte[][] FAMILIES, int FAMILYIDX, byte[][] QUALIFIERS, int QUALIFIERIDX) throws Exception {
        Get get = new Get(ROWS[ROWIDX]);
        get.addFamily(FAMILIES[4]);
        get.addColumn(FAMILIES[4], QUALIFIERS[1]);
        Result result = ht.get(get);
        this.assertEmptyResult(result);
        get = new Get(ROWS[ROWIDX]);
        get.addFamily(FAMILIES[4]);
        get.addColumn(FAMILIES[4], QUALIFIERS[2]);
        result = ht.get(get);
        this.assertEmptyResult(result);
        get = new Get(ROWS[ROWIDX]);
        get.addFamily(FAMILIES[3]);
        get.addColumn(FAMILIES[4], QUALIFIERS[2]);
        get.addFamily(FAMILIES[5]);
        result = ht.get(get);
        this.assertEmptyResult(result);
        get = new Get(ROWS[ROWIDX + 1]);
        result = ht.get(get);
        this.assertEmptyResult(result);
    }

    private void scanVerifySingleEmpty(Table ht, byte[][] ROWS, int ROWIDX, byte[][] FAMILIES, int FAMILYIDX, byte[][] QUALIFIERS, int QUALIFIERIDX) throws Exception {
        Scan scan = new Scan(ROWS[ROWIDX + 1]);
        Result result = this.getSingleScanResult(ht, scan);
        this.assertNullResult(result);
        scan = new Scan(ROWS[ROWIDX + 1], ROWS[ROWIDX + 2]);
        result = this.getSingleScanResult(ht, scan);
        this.assertNullResult(result);
        scan = new Scan(HConstants.EMPTY_START_ROW, ROWS[ROWIDX]);
        result = this.getSingleScanResult(ht, scan);
        this.assertNullResult(result);
        scan = new Scan();
        scan.addColumn(FAMILIES[FAMILYIDX], QUALIFIERS[QUALIFIERIDX + 1]);
        scan.addFamily(FAMILIES[FAMILYIDX - 1]);
        result = this.getSingleScanResult(ht, scan);
        this.assertNullResult(result);
    }

    private void assertKey(Cell key, byte[] row, byte[] family, byte[] qualifier, byte[] value) throws Exception {
        Assert.assertTrue((String)("Expected row [" + Bytes.toString((byte[])row) + "] Got row [" + Bytes.toString((byte[])CellUtil.cloneRow((Cell)key)) + "]"), (boolean)TestFromClientSide.equals(row, CellUtil.cloneRow((Cell)key)));
        Assert.assertTrue((String)("Expected family [" + Bytes.toString((byte[])family) + "] Got family [" + Bytes.toString((byte[])CellUtil.cloneFamily((Cell)key)) + "]"), (boolean)TestFromClientSide.equals(family, CellUtil.cloneFamily((Cell)key)));
        Assert.assertTrue((String)("Expected qualifier [" + Bytes.toString((byte[])qualifier) + "] Got qualifier [" + Bytes.toString((byte[])CellUtil.cloneQualifier((Cell)key)) + "]"), (boolean)TestFromClientSide.equals(qualifier, CellUtil.cloneQualifier((Cell)key)));
        Assert.assertTrue((String)("Expected value [" + Bytes.toString((byte[])value) + "] Got value [" + Bytes.toString((byte[])CellUtil.cloneValue((Cell)key)) + "]"), (boolean)TestFromClientSide.equals(value, CellUtil.cloneValue((Cell)key)));
    }

    static void assertIncrementKey(Cell key, byte[] row, byte[] family, byte[] qualifier, long value) throws Exception {
        Assert.assertTrue((String)("Expected row [" + Bytes.toString((byte[])row) + "] Got row [" + Bytes.toString((byte[])CellUtil.cloneRow((Cell)key)) + "]"), (boolean)TestFromClientSide.equals(row, CellUtil.cloneRow((Cell)key)));
        Assert.assertTrue((String)("Expected family [" + Bytes.toString((byte[])family) + "] Got family [" + Bytes.toString((byte[])CellUtil.cloneFamily((Cell)key)) + "]"), (boolean)TestFromClientSide.equals(family, CellUtil.cloneFamily((Cell)key)));
        Assert.assertTrue((String)("Expected qualifier [" + Bytes.toString((byte[])qualifier) + "] Got qualifier [" + Bytes.toString((byte[])CellUtil.cloneQualifier((Cell)key)) + "]"), (boolean)TestFromClientSide.equals(qualifier, CellUtil.cloneQualifier((Cell)key)));
        Assert.assertTrue((String)("Expected value [" + value + "] Got value [" + Bytes.toLong((byte[])CellUtil.cloneValue((Cell)key)) + "]"), (Bytes.toLong((byte[])CellUtil.cloneValue((Cell)key)) == value ? 1 : 0) != 0);
    }

    private void assertNumKeys(Result result, int n) throws Exception {
        Assert.assertTrue((String)("Expected " + n + " keys but got " + result.size()), (result.size() == n ? 1 : 0) != 0);
    }

    private void assertNResult(Result result, byte[] row, byte[][] families, byte[][] qualifiers, byte[][] values, int[][] idxs) throws Exception {
        Assert.assertTrue((String)("Expected row [" + Bytes.toString((byte[])row) + "] Got row [" + Bytes.toString((byte[])result.getRow()) + "]"), (boolean)TestFromClientSide.equals(row, result.getRow()));
        Assert.assertTrue((String)("Expected " + idxs.length + " keys but result contains " + result.size()), (result.size() == idxs.length ? 1 : 0) != 0);
        Cell[] keys = result.rawCells();
        for (int i = 0; i < keys.length; ++i) {
            byte[] family = families[idxs[i][0]];
            byte[] qualifier = qualifiers[idxs[i][1]];
            byte[] value = values[idxs[i][2]];
            Cell key = keys[i];
            byte[] famb = CellUtil.cloneFamily((Cell)key);
            byte[] qualb = CellUtil.cloneQualifier((Cell)key);
            byte[] valb = CellUtil.cloneValue((Cell)key);
            Assert.assertTrue((String)("(" + i + ") Expected family [" + Bytes.toString((byte[])family) + "] Got family [" + Bytes.toString((byte[])famb) + "]"), (boolean)TestFromClientSide.equals(family, famb));
            Assert.assertTrue((String)("(" + i + ") Expected qualifier [" + Bytes.toString((byte[])qualifier) + "] Got qualifier [" + Bytes.toString((byte[])qualb) + "]"), (boolean)TestFromClientSide.equals(qualifier, qualb));
            Assert.assertTrue((String)("(" + i + ") Expected value [" + Bytes.toString((byte[])value) + "] Got value [" + Bytes.toString((byte[])valb) + "]"), (boolean)TestFromClientSide.equals(value, valb));
        }
    }

    private void assertNResult(Result result, byte[] row, byte[] family, byte[] qualifier, long[] stamps, byte[][] values, int start, int end) throws IOException {
        Assert.assertTrue((String)("Expected row [" + Bytes.toString((byte[])row) + "] Got row [" + Bytes.toString((byte[])result.getRow()) + "]"), (boolean)TestFromClientSide.equals(row, result.getRow()));
        int expectedResults = end - start + 1;
        Assert.assertEquals((long)expectedResults, (long)result.size());
        Cell[] keys = result.rawCells();
        for (int i = 0; i < keys.length; ++i) {
            byte[] value = values[end - i];
            long ts = stamps[end - i];
            Cell key = keys[i];
            Assert.assertTrue((String)("(" + i + ") Expected family [" + Bytes.toString((byte[])family) + "] Got family [" + Bytes.toString((byte[])CellUtil.cloneFamily((Cell)key)) + "]"), (boolean)CellUtil.matchingFamily((Cell)key, (byte[])family));
            Assert.assertTrue((String)("(" + i + ") Expected qualifier [" + Bytes.toString((byte[])qualifier) + "] Got qualifier [" + Bytes.toString((byte[])CellUtil.cloneQualifier((Cell)key)) + "]"), (boolean)CellUtil.matchingQualifier((Cell)key, (byte[])qualifier));
            Assert.assertTrue((String)("Expected ts [" + ts + "] Got ts [" + key.getTimestamp() + "]"), (ts == key.getTimestamp() ? 1 : 0) != 0);
            Assert.assertTrue((String)("(" + i + ") Expected value [" + Bytes.toString((byte[])value) + "] Got value [" + Bytes.toString((byte[])CellUtil.cloneValue((Cell)key)) + "]"), (boolean)CellUtil.matchingValue((Cell)key, (byte[])value));
        }
    }

    private void assertDoubleResult(Result result, byte[] row, byte[] familyA, byte[] qualifierA, byte[] valueA, byte[] familyB, byte[] qualifierB, byte[] valueB) throws Exception {
        Assert.assertTrue((String)("Expected row [" + Bytes.toString((byte[])row) + "] Got row [" + Bytes.toString((byte[])result.getRow()) + "]"), (boolean)TestFromClientSide.equals(row, result.getRow()));
        Assert.assertTrue((String)("Expected two keys but result contains " + result.size()), (result.size() == 2 ? 1 : 0) != 0);
        Cell[] kv = result.rawCells();
        Cell kvA = kv[0];
        Assert.assertTrue((String)("(A) Expected family [" + Bytes.toString((byte[])familyA) + "] Got family [" + Bytes.toString((byte[])CellUtil.cloneFamily((Cell)kvA)) + "]"), (boolean)TestFromClientSide.equals(familyA, CellUtil.cloneFamily((Cell)kvA)));
        Assert.assertTrue((String)("(A) Expected qualifier [" + Bytes.toString((byte[])qualifierA) + "] Got qualifier [" + Bytes.toString((byte[])CellUtil.cloneQualifier((Cell)kvA)) + "]"), (boolean)TestFromClientSide.equals(qualifierA, CellUtil.cloneQualifier((Cell)kvA)));
        Assert.assertTrue((String)("(A) Expected value [" + Bytes.toString((byte[])valueA) + "] Got value [" + Bytes.toString((byte[])CellUtil.cloneValue((Cell)kvA)) + "]"), (boolean)TestFromClientSide.equals(valueA, CellUtil.cloneValue((Cell)kvA)));
        Cell kvB = kv[1];
        Assert.assertTrue((String)("(B) Expected family [" + Bytes.toString((byte[])familyB) + "] Got family [" + Bytes.toString((byte[])CellUtil.cloneFamily((Cell)kvB)) + "]"), (boolean)TestFromClientSide.equals(familyB, CellUtil.cloneFamily((Cell)kvB)));
        Assert.assertTrue((String)("(B) Expected qualifier [" + Bytes.toString((byte[])qualifierB) + "] Got qualifier [" + Bytes.toString((byte[])CellUtil.cloneQualifier((Cell)kvB)) + "]"), (boolean)TestFromClientSide.equals(qualifierB, CellUtil.cloneQualifier((Cell)kvB)));
        Assert.assertTrue((String)("(B) Expected value [" + Bytes.toString((byte[])valueB) + "] Got value [" + Bytes.toString((byte[])CellUtil.cloneValue((Cell)kvB)) + "]"), (boolean)TestFromClientSide.equals(valueB, CellUtil.cloneValue((Cell)kvB)));
    }

    private void assertSingleResult(Result result, byte[] row, byte[] family, byte[] qualifier, byte[] value) throws Exception {
        Assert.assertTrue((String)("Expected row [" + Bytes.toString((byte[])row) + "] Got row [" + Bytes.toString((byte[])result.getRow()) + "]"), (boolean)TestFromClientSide.equals(row, result.getRow()));
        Assert.assertTrue((String)("Expected a single key but result contains " + result.size()), (result.size() == 1 ? 1 : 0) != 0);
        Cell kv = result.rawCells()[0];
        Assert.assertTrue((String)("Expected family [" + Bytes.toString((byte[])family) + "] Got family [" + Bytes.toString((byte[])CellUtil.cloneFamily((Cell)kv)) + "]"), (boolean)TestFromClientSide.equals(family, CellUtil.cloneFamily((Cell)kv)));
        Assert.assertTrue((String)("Expected qualifier [" + Bytes.toString((byte[])qualifier) + "] Got qualifier [" + Bytes.toString((byte[])CellUtil.cloneQualifier((Cell)kv)) + "]"), (boolean)TestFromClientSide.equals(qualifier, CellUtil.cloneQualifier((Cell)kv)));
        Assert.assertTrue((String)("Expected value [" + Bytes.toString((byte[])value) + "] Got value [" + Bytes.toString((byte[])CellUtil.cloneValue((Cell)kv)) + "]"), (boolean)TestFromClientSide.equals(value, CellUtil.cloneValue((Cell)kv)));
    }

    private void assertSingleResult(Result result, byte[] row, byte[] family, byte[] qualifier, long value) throws Exception {
        Assert.assertTrue((String)("Expected row [" + Bytes.toString((byte[])row) + "] Got row [" + Bytes.toString((byte[])result.getRow()) + "]"), (boolean)TestFromClientSide.equals(row, result.getRow()));
        Assert.assertTrue((String)("Expected a single key but result contains " + result.size()), (result.size() == 1 ? 1 : 0) != 0);
        Cell kv = result.rawCells()[0];
        Assert.assertTrue((String)("Expected family [" + Bytes.toString((byte[])family) + "] Got family [" + Bytes.toString((byte[])CellUtil.cloneFamily((Cell)kv)) + "]"), (boolean)TestFromClientSide.equals(family, CellUtil.cloneFamily((Cell)kv)));
        Assert.assertTrue((String)("Expected qualifier [" + Bytes.toString((byte[])qualifier) + "] Got qualifier [" + Bytes.toString((byte[])CellUtil.cloneQualifier((Cell)kv)) + "]"), (boolean)TestFromClientSide.equals(qualifier, CellUtil.cloneQualifier((Cell)kv)));
        Assert.assertTrue((String)("Expected value [" + value + "] Got value [" + Bytes.toLong((byte[])CellUtil.cloneValue((Cell)kv)) + "]"), (value == Bytes.toLong((byte[])CellUtil.cloneValue((Cell)kv)) ? 1 : 0) != 0);
    }

    private void assertSingleResult(Result result, byte[] row, byte[] family, byte[] qualifier, long ts, byte[] value) throws Exception {
        Assert.assertTrue((String)("Expected row [" + Bytes.toString((byte[])row) + "] Got row [" + Bytes.toString((byte[])result.getRow()) + "]"), (boolean)TestFromClientSide.equals(row, result.getRow()));
        Assert.assertTrue((String)("Expected a single key but result contains " + result.size()), (result.size() == 1 ? 1 : 0) != 0);
        Cell kv = result.rawCells()[0];
        Assert.assertTrue((String)("Expected family [" + Bytes.toString((byte[])family) + "] Got family [" + Bytes.toString((byte[])CellUtil.cloneFamily((Cell)kv)) + "]"), (boolean)TestFromClientSide.equals(family, CellUtil.cloneFamily((Cell)kv)));
        Assert.assertTrue((String)("Expected qualifier [" + Bytes.toString((byte[])qualifier) + "] Got qualifier [" + Bytes.toString((byte[])CellUtil.cloneQualifier((Cell)kv)) + "]"), (boolean)TestFromClientSide.equals(qualifier, CellUtil.cloneQualifier((Cell)kv)));
        Assert.assertTrue((String)("Expected ts [" + ts + "] Got ts [" + kv.getTimestamp() + "]"), (ts == kv.getTimestamp() ? 1 : 0) != 0);
        Assert.assertTrue((String)("Expected value [" + Bytes.toString((byte[])value) + "] Got value [" + Bytes.toString((byte[])CellUtil.cloneValue((Cell)kv)) + "]"), (boolean)TestFromClientSide.equals(value, CellUtil.cloneValue((Cell)kv)));
    }

    private void assertEmptyResult(Result result) throws Exception {
        Assert.assertTrue((String)("expected an empty result but result contains " + result.size() + " keys"), (boolean)result.isEmpty());
    }

    private void assertNullResult(Result result) throws Exception {
        Assert.assertTrue((String)"expected null result but received a non-null result", (result == null ? 1 : 0) != 0);
    }

    private Result getSingleScanResult(Table ht, Scan scan) throws IOException {
        ResultScanner scanner = ht.getScanner(scan);
        Result result = scanner.next();
        scanner.close();
        return result;
    }

    private byte[][] makeNAscii(byte[] base, int n) {
        if (n > 256) {
            return this.makeNBig(base, n);
        }
        byte[][] ret = new byte[n][];
        for (int i = 0; i < n; ++i) {
            byte[] tail = Bytes.toBytes((String)Integer.toString(i));
            ret[i] = Bytes.add((byte[])base, (byte[])tail);
        }
        return ret;
    }

    private byte[][] makeN(byte[] base, int n) {
        if (n > 256) {
            return this.makeNBig(base, n);
        }
        byte[][] ret = new byte[n][];
        for (int i = 0; i < n; ++i) {
            ret[i] = Bytes.add((byte[])base, (byte[])new byte[]{(byte)i});
        }
        return ret;
    }

    private byte[][] makeNBig(byte[] base, int n) {
        byte[][] ret = new byte[n][];
        for (int i = 0; i < n; ++i) {
            int byteA = i % 256;
            int byteB = i >> 8;
            ret[i] = Bytes.add((byte[])base, (byte[])new byte[]{(byte)byteB, (byte)byteA});
        }
        return ret;
    }

    private long[] makeStamps(int n) {
        long[] stamps = new long[n];
        for (int i = 0; i < n; ++i) {
            stamps[i] = (long)i + 1L;
        }
        return stamps;
    }

    static boolean equals(byte[] left, byte[] right) {
        if (left == null && right == null) {
            return true;
        }
        if (left == null && right.length == 0) {
            return true;
        }
        if (right == null && left.length == 0) {
            return true;
        }
        return Bytes.equals((byte[])left, (byte[])right);
    }

    @Test
    public void testDuplicateVersions() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        long[] STAMPS = this.makeStamps(20);
        byte[][] VALUES = this.makeNAscii(VALUE, 20);
        Table ht = TEST_UTIL.createTable(tableName, FAMILY, 10);
        Put put = new Put(ROW);
        put.addColumn(FAMILY, QUALIFIER, STAMPS[1], VALUES[1]);
        put.addColumn(FAMILY, QUALIFIER, STAMPS[2], VALUES[2]);
        put.addColumn(FAMILY, QUALIFIER, STAMPS[4], VALUES[4]);
        put.addColumn(FAMILY, QUALIFIER, STAMPS[5], VALUES[5]);
        ht.put(put);
        this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[1], VALUES[1]);
        this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[2], VALUES[2]);
        this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[4], VALUES[4]);
        this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[5], VALUES[5]);
        this.scanVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[1], VALUES[1]);
        this.scanVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[2], VALUES[2]);
        this.scanVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[4], VALUES[4]);
        this.scanVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[5], VALUES[5]);
        this.getVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[0]);
        this.getVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[3]);
        this.getVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[6]);
        this.scanVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[0]);
        this.scanVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[3]);
        this.scanVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[6]);
        Get get = new Get(ROW);
        get.addColumn(FAMILY, QUALIFIER);
        get.setMaxVersions(2);
        Result result = ht.get(get);
        this.assertNResult(result, ROW, FAMILY, QUALIFIER, new long[]{STAMPS[4], STAMPS[5]}, new byte[][]{VALUES[4], VALUES[5]}, 0, 1);
        Scan scan = new Scan(ROW);
        scan.addColumn(FAMILY, QUALIFIER);
        scan.setMaxVersions(2);
        result = this.getSingleScanResult(ht, scan);
        this.assertNResult(result, ROW, FAMILY, QUALIFIER, new long[]{STAMPS[4], STAMPS[5]}, new byte[][]{VALUES[4], VALUES[5]}, 0, 1);
        TEST_UTIL.flush();
        this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[1], VALUES[1]);
        this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[2], VALUES[2]);
        this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[4], VALUES[4]);
        this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[5], VALUES[5]);
        this.scanVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[1], VALUES[1]);
        this.scanVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[2], VALUES[2]);
        this.scanVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[4], VALUES[4]);
        this.scanVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[5], VALUES[5]);
        this.getVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[0]);
        this.getVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[3]);
        this.getVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[6]);
        this.scanVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[0]);
        this.scanVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[3]);
        this.scanVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[6]);
        get = new Get(ROW);
        get.addColumn(FAMILY, QUALIFIER);
        get.setMaxVersions(2);
        result = ht.get(get);
        this.assertNResult(result, ROW, FAMILY, QUALIFIER, new long[]{STAMPS[4], STAMPS[5]}, new byte[][]{VALUES[4], VALUES[5]}, 0, 1);
        scan = new Scan(ROW);
        scan.addColumn(FAMILY, QUALIFIER);
        scan.setMaxVersions(2);
        result = this.getSingleScanResult(ht, scan);
        this.assertNResult(result, ROW, FAMILY, QUALIFIER, new long[]{STAMPS[4], STAMPS[5]}, new byte[][]{VALUES[4], VALUES[5]}, 0, 1);
        put = new Put(ROW);
        put.addColumn(FAMILY, QUALIFIER, STAMPS[3], VALUES[3]);
        put.addColumn(FAMILY, QUALIFIER, STAMPS[4], VALUES[14]);
        put.addColumn(FAMILY, QUALIFIER, STAMPS[6], VALUES[6]);
        put.addColumn(FAMILY, QUALIFIER, STAMPS[7], VALUES[7]);
        put.addColumn(FAMILY, QUALIFIER, STAMPS[8], VALUES[8]);
        ht.put(put);
        get = new Get(ROW);
        get.addColumn(FAMILY, QUALIFIER);
        get.setMaxVersions(7);
        result = ht.get(get);
        this.assertNResult(result, ROW, FAMILY, QUALIFIER, new long[]{STAMPS[2], STAMPS[3], STAMPS[4], STAMPS[5], STAMPS[6], STAMPS[7], STAMPS[8]}, new byte[][]{VALUES[2], VALUES[3], VALUES[14], VALUES[5], VALUES[6], VALUES[7], VALUES[8]}, 0, 6);
        scan = new Scan(ROW);
        scan.addColumn(FAMILY, QUALIFIER);
        scan.setMaxVersions(7);
        result = this.getSingleScanResult(ht, scan);
        this.assertNResult(result, ROW, FAMILY, QUALIFIER, new long[]{STAMPS[2], STAMPS[3], STAMPS[4], STAMPS[5], STAMPS[6], STAMPS[7], STAMPS[8]}, new byte[][]{VALUES[2], VALUES[3], VALUES[14], VALUES[5], VALUES[6], VALUES[7], VALUES[8]}, 0, 6);
        get = new Get(ROW);
        get.setMaxVersions(7);
        result = ht.get(get);
        this.assertNResult(result, ROW, FAMILY, QUALIFIER, new long[]{STAMPS[2], STAMPS[3], STAMPS[4], STAMPS[5], STAMPS[6], STAMPS[7], STAMPS[8]}, new byte[][]{VALUES[2], VALUES[3], VALUES[14], VALUES[5], VALUES[6], VALUES[7], VALUES[8]}, 0, 6);
        scan = new Scan(ROW);
        scan.setMaxVersions(7);
        result = this.getSingleScanResult(ht, scan);
        this.assertNResult(result, ROW, FAMILY, QUALIFIER, new long[]{STAMPS[2], STAMPS[3], STAMPS[4], STAMPS[5], STAMPS[6], STAMPS[7], STAMPS[8]}, new byte[][]{VALUES[2], VALUES[3], VALUES[14], VALUES[5], VALUES[6], VALUES[7], VALUES[8]}, 0, 6);
        this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[1], VALUES[1]);
        this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[2], VALUES[2]);
        this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[4], VALUES[14]);
        this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[7], VALUES[7]);
        this.scanVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[1], VALUES[1]);
        this.scanVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[2], VALUES[2]);
        this.scanVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[4], VALUES[14]);
        this.scanVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[7], VALUES[7]);
        this.getVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[0]);
        this.getVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[9]);
        this.scanVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[0]);
        this.scanVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[9]);
        TEST_UTIL.flush();
        put = new Put(ROW);
        put.addColumn(FAMILY, QUALIFIER, STAMPS[9], VALUES[9]);
        put.addColumn(FAMILY, QUALIFIER, STAMPS[11], VALUES[11]);
        put.addColumn(FAMILY, QUALIFIER, STAMPS[13], VALUES[13]);
        put.addColumn(FAMILY, QUALIFIER, STAMPS[15], VALUES[15]);
        ht.put(put);
        get = new Get(ROW);
        get.addColumn(FAMILY, QUALIFIER);
        get.setMaxVersions(Integer.MAX_VALUE);
        result = ht.get(get);
        this.assertNResult(result, ROW, FAMILY, QUALIFIER, new long[]{STAMPS[3], STAMPS[4], STAMPS[5], STAMPS[6], STAMPS[7], STAMPS[8], STAMPS[9], STAMPS[11], STAMPS[13], STAMPS[15]}, new byte[][]{VALUES[3], VALUES[14], VALUES[5], VALUES[6], VALUES[7], VALUES[8], VALUES[9], VALUES[11], VALUES[13], VALUES[15]}, 0, 9);
        scan = new Scan(ROW);
        scan.addColumn(FAMILY, QUALIFIER);
        scan.setMaxVersions(Integer.MAX_VALUE);
        result = this.getSingleScanResult(ht, scan);
        this.assertNResult(result, ROW, FAMILY, QUALIFIER, new long[]{STAMPS[3], STAMPS[4], STAMPS[5], STAMPS[6], STAMPS[7], STAMPS[8], STAMPS[9], STAMPS[11], STAMPS[13], STAMPS[15]}, new byte[][]{VALUES[3], VALUES[14], VALUES[5], VALUES[6], VALUES[7], VALUES[8], VALUES[9], VALUES[11], VALUES[13], VALUES[15]}, 0, 9);
        Delete delete = new Delete(ROW);
        delete.addColumn(FAMILY, QUALIFIER, STAMPS[11]);
        delete.addColumn(FAMILY, QUALIFIER, STAMPS[7]);
        ht.delete(delete);
        get = new Get(ROW);
        get.addColumn(FAMILY, QUALIFIER);
        get.setMaxVersions(Integer.MAX_VALUE);
        result = ht.get(get);
        this.assertNResult(result, ROW, FAMILY, QUALIFIER, new long[]{STAMPS[1], STAMPS[2], STAMPS[3], STAMPS[4], STAMPS[5], STAMPS[6], STAMPS[8], STAMPS[9], STAMPS[13], STAMPS[15]}, new byte[][]{VALUES[1], VALUES[2], VALUES[3], VALUES[14], VALUES[5], VALUES[6], VALUES[8], VALUES[9], VALUES[13], VALUES[15]}, 0, 9);
        scan = new Scan(ROW);
        scan.addColumn(FAMILY, QUALIFIER);
        scan.setMaxVersions(Integer.MAX_VALUE);
        result = this.getSingleScanResult(ht, scan);
        this.assertNResult(result, ROW, FAMILY, QUALIFIER, new long[]{STAMPS[1], STAMPS[2], STAMPS[3], STAMPS[4], STAMPS[5], STAMPS[6], STAMPS[8], STAMPS[9], STAMPS[13], STAMPS[15]}, new byte[][]{VALUES[1], VALUES[2], VALUES[3], VALUES[14], VALUES[5], VALUES[6], VALUES[8], VALUES[9], VALUES[13], VALUES[15]}, 0, 9);
    }

    @Test
    public void testUpdates() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        Table hTable = TEST_UTIL.createTable(tableName, FAMILY, 10);
        byte[] row = Bytes.toBytes((String)"row1");
        byte[] qualifier = Bytes.toBytes((String)"myCol");
        Put put = new Put(row);
        put.addColumn(FAMILY, qualifier, 1L, Bytes.toBytes((String)"AAA"));
        hTable.put(put);
        put = new Put(row);
        put.addColumn(FAMILY, qualifier, 2L, Bytes.toBytes((String)"BBB"));
        hTable.put(put);
        put = new Put(row);
        put.addColumn(FAMILY, qualifier, 3L, Bytes.toBytes((String)"EEE"));
        hTable.put(put);
        Get get = new Get(row);
        get.addColumn(FAMILY, qualifier);
        get.setMaxVersions();
        Result result = hTable.get(get);
        NavigableMap navigableMap = (NavigableMap)((NavigableMap)result.getMap().get(FAMILY)).get(qualifier);
        Assert.assertEquals((Object)"AAA", (Object)Bytes.toString((byte[])((byte[])navigableMap.get(1L))));
        Assert.assertEquals((Object)"BBB", (Object)Bytes.toString((byte[])((byte[])navigableMap.get(2L))));
        put = new Put(row);
        put.addColumn(FAMILY, qualifier, 1L, Bytes.toBytes((String)"CCC"));
        hTable.put(put);
        put = new Put(row);
        put.addColumn(FAMILY, qualifier, 2L, Bytes.toBytes((String)"DDD"));
        hTable.put(put);
        result = hTable.get(get);
        navigableMap = (NavigableMap)((NavigableMap)result.getMap().get(FAMILY)).get(qualifier);
        Assert.assertEquals((Object)"CCC", (Object)Bytes.toString((byte[])((byte[])navigableMap.get(1L))));
        Assert.assertEquals((Object)"DDD", (Object)Bytes.toString((byte[])((byte[])navigableMap.get(2L))));
    }

    @Test
    public void testUpdatesWithMajorCompaction() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        Table hTable = TEST_UTIL.createTable(tableName, FAMILY, 10);
        Admin admin = TEST_UTIL.getAdmin();
        byte[] row = Bytes.toBytes((String)"row2");
        byte[] qualifier = Bytes.toBytes((String)"myCol");
        Put put = new Put(row);
        put.addColumn(FAMILY, qualifier, 1L, Bytes.toBytes((String)"AAA"));
        hTable.put(put);
        put = new Put(row);
        put.addColumn(FAMILY, qualifier, 2L, Bytes.toBytes((String)"BBB"));
        hTable.put(put);
        put = new Put(row);
        put.addColumn(FAMILY, qualifier, 3L, Bytes.toBytes((String)"EEE"));
        hTable.put(put);
        Get get = new Get(row);
        get.addColumn(FAMILY, qualifier);
        get.setMaxVersions();
        Result result = hTable.get(get);
        NavigableMap navigableMap = (NavigableMap)((NavigableMap)result.getMap().get(FAMILY)).get(qualifier);
        Assert.assertEquals((Object)"AAA", (Object)Bytes.toString((byte[])((byte[])navigableMap.get(1L))));
        Assert.assertEquals((Object)"BBB", (Object)Bytes.toString((byte[])((byte[])navigableMap.get(2L))));
        admin.flush(tableName);
        admin.majorCompact(tableName);
        Thread.sleep(6000L);
        put = new Put(row);
        put.addColumn(FAMILY, qualifier, 1L, Bytes.toBytes((String)"CCC"));
        hTable.put(put);
        put = new Put(row);
        put.addColumn(FAMILY, qualifier, 2L, Bytes.toBytes((String)"DDD"));
        hTable.put(put);
        admin.flush(tableName);
        admin.majorCompact(tableName);
        Thread.sleep(6000L);
        result = hTable.get(get);
        navigableMap = (NavigableMap)((NavigableMap)result.getMap().get(FAMILY)).get(qualifier);
        Assert.assertEquals((Object)"CCC", (Object)Bytes.toString((byte[])((byte[])navigableMap.get(1L))));
        Assert.assertEquals((Object)"DDD", (Object)Bytes.toString((byte[])((byte[])navigableMap.get(2L))));
    }

    @Test
    public void testMajorCompactionBetweenTwoUpdates() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        Table hTable = TEST_UTIL.createTable(tableName, FAMILY, 10);
        Admin admin = TEST_UTIL.getAdmin();
        byte[] row = Bytes.toBytes((String)"row3");
        byte[] qualifier = Bytes.toBytes((String)"myCol");
        Put put = new Put(row);
        put.addColumn(FAMILY, qualifier, 1L, Bytes.toBytes((String)"AAA"));
        hTable.put(put);
        put = new Put(row);
        put.addColumn(FAMILY, qualifier, 2L, Bytes.toBytes((String)"BBB"));
        hTable.put(put);
        put = new Put(row);
        put.addColumn(FAMILY, qualifier, 3L, Bytes.toBytes((String)"EEE"));
        hTable.put(put);
        Get get = new Get(row);
        get.addColumn(FAMILY, qualifier);
        get.setMaxVersions();
        Result result = hTable.get(get);
        NavigableMap navigableMap = (NavigableMap)((NavigableMap)result.getMap().get(FAMILY)).get(qualifier);
        Assert.assertEquals((Object)"AAA", (Object)Bytes.toString((byte[])((byte[])navigableMap.get(1L))));
        Assert.assertEquals((Object)"BBB", (Object)Bytes.toString((byte[])((byte[])navigableMap.get(2L))));
        admin.flush(tableName);
        admin.majorCompact(tableName);
        Thread.sleep(6000L);
        put = new Put(row);
        put.addColumn(FAMILY, qualifier, 1L, Bytes.toBytes((String)"CCC"));
        hTable.put(put);
        admin.flush(tableName);
        admin.majorCompact(tableName);
        Thread.sleep(6000L);
        put = new Put(row);
        put.addColumn(FAMILY, qualifier, 2L, Bytes.toBytes((String)"DDD"));
        hTable.put(put);
        admin.flush(tableName);
        admin.majorCompact(tableName);
        Thread.sleep(6000L);
        result = hTable.get(get);
        navigableMap = (NavigableMap)((NavigableMap)result.getMap().get(FAMILY)).get(qualifier);
        Assert.assertEquals((Object)"CCC", (Object)Bytes.toString((byte[])((byte[])navigableMap.get(1L))));
        Assert.assertEquals((Object)"DDD", (Object)Bytes.toString((byte[])((byte[])navigableMap.get(2L))));
    }

    @Test
    public void testGet_EmptyTable() throws IOException {
        Table table = TEST_UTIL.createTable(TableName.valueOf((String)this.name.getMethodName()), FAMILY);
        Get get = new Get(ROW);
        get.addFamily(FAMILY);
        Result r = table.get(get);
        Assert.assertTrue((boolean)r.isEmpty());
    }

    @Test
    public void testGet_NullQualifier() throws IOException {
        Table table = TEST_UTIL.createTable(TableName.valueOf((String)this.name.getMethodName()), FAMILY);
        Put put = new Put(ROW);
        put.addColumn(FAMILY, QUALIFIER, VALUE);
        table.put(put);
        put = new Put(ROW);
        put.addColumn(FAMILY, null, VALUE);
        table.put(put);
        LOG.info("Row put");
        Get get = new Get(ROW);
        get.addColumn(FAMILY, null);
        Result r = table.get(get);
        Assert.assertEquals((long)1L, (long)r.size());
        get = new Get(ROW);
        get.addFamily(FAMILY);
        r = table.get(get);
        Assert.assertEquals((long)2L, (long)r.size());
    }

    @Test
    public void testGet_NonExistentRow() throws IOException {
        Table table = TEST_UTIL.createTable(TableName.valueOf((String)this.name.getMethodName()), FAMILY);
        Put put = new Put(ROW);
        put.addColumn(FAMILY, QUALIFIER, VALUE);
        table.put(put);
        LOG.info("Row put");
        Get get = new Get(ROW);
        get.addFamily(FAMILY);
        Result r = table.get(get);
        Assert.assertFalse((boolean)r.isEmpty());
        System.out.println("Row retrieved successfully");
        byte[] missingrow = Bytes.toBytes((String)"missingrow");
        get = new Get(missingrow);
        get.addFamily(FAMILY);
        r = table.get(get);
        Assert.assertTrue((boolean)r.isEmpty());
        LOG.info("Row missing as it should be");
    }

    @Test
    public void testPut() throws IOException {
        byte[] CONTENTS_FAMILY = Bytes.toBytes((String)"contents");
        byte[] SMALL_FAMILY = Bytes.toBytes((String)"smallfam");
        byte[] row1 = Bytes.toBytes((String)"row1");
        byte[] row2 = Bytes.toBytes((String)"row2");
        byte[] value = Bytes.toBytes((String)"abcd");
        Table table = TEST_UTIL.createTable(TableName.valueOf((String)this.name.getMethodName()), (byte[][])new byte[][]{CONTENTS_FAMILY, SMALL_FAMILY});
        Put put = new Put(row1);
        put.addColumn(CONTENTS_FAMILY, null, value);
        table.put(put);
        put = new Put(row2);
        put.addColumn(CONTENTS_FAMILY, null, value);
        Assert.assertEquals((long)1L, (long)put.size());
        Assert.assertEquals((long)1L, (long)((List)put.getFamilyCellMap().get(CONTENTS_FAMILY)).size());
        KeyValue kv = (KeyValue)((List)put.getFamilyCellMap().get(CONTENTS_FAMILY)).get(0);
        Assert.assertTrue((boolean)Bytes.equals((byte[])CellUtil.cloneFamily((Cell)kv), (byte[])CONTENTS_FAMILY));
        Assert.assertTrue((boolean)Bytes.equals((byte[])CellUtil.cloneQualifier((Cell)kv), (byte[])new byte[0]));
        Assert.assertTrue((boolean)Bytes.equals((byte[])CellUtil.cloneValue((Cell)kv), (byte[])value));
        table.put(put);
        Scan scan = new Scan();
        scan.addColumn(CONTENTS_FAMILY, null);
        ResultScanner scanner = table.getScanner(scan);
        for (Result r : scanner) {
            for (Cell key : r.rawCells()) {
                System.out.println(Bytes.toString((byte[])r.getRow()) + ": " + key.toString());
            }
        }
    }

    @Test
    public void testPutNoCF() throws IOException {
        byte[] BAD_FAM = Bytes.toBytes((String)"BAD_CF");
        byte[] VAL = Bytes.toBytes((int)100);
        Table table = TEST_UTIL.createTable(TableName.valueOf((String)this.name.getMethodName()), FAMILY);
        boolean caughtNSCFE = false;
        try {
            Put p = new Put(ROW);
            p.addColumn(BAD_FAM, QUALIFIER, VAL);
            table.put(p);
        }
        catch (Exception e) {
            caughtNSCFE = e instanceof NoSuchColumnFamilyException;
        }
        Assert.assertTrue((String)"Should throw NoSuchColumnFamilyException", (boolean)caughtNSCFE);
    }

    @Test
    public void testRowsPut() throws IOException {
        byte[] CONTENTS_FAMILY = Bytes.toBytes((String)"contents");
        byte[] SMALL_FAMILY = Bytes.toBytes((String)"smallfam");
        int NB_BATCH_ROWS = 10;
        byte[] value = Bytes.toBytes((String)"abcd");
        Table table = TEST_UTIL.createTable(TableName.valueOf((String)this.name.getMethodName()), (byte[][])new byte[][]{CONTENTS_FAMILY, SMALL_FAMILY});
        ArrayList<Put> rowsUpdate = new ArrayList<Put>();
        for (int i = 0; i < 10; ++i) {
            byte[] row = Bytes.toBytes((String)("row" + i));
            Put put = new Put(row);
            put.setDurability(Durability.SKIP_WAL);
            put.addColumn(CONTENTS_FAMILY, null, value);
            rowsUpdate.add(put);
        }
        table.put(rowsUpdate);
        Scan scan = new Scan();
        scan.addFamily(CONTENTS_FAMILY);
        ResultScanner scanner = table.getScanner(scan);
        int nbRows = 0;
        for (Result row : scanner) {
            ++nbRows;
        }
        Assert.assertEquals((long)10L, (long)nbRows);
    }

    @Test
    public void testRowsPutBufferedManyManyFlushes() throws IOException {
        byte[] CONTENTS_FAMILY = Bytes.toBytes((String)"contents");
        byte[] SMALL_FAMILY = Bytes.toBytes((String)"smallfam");
        byte[] value = Bytes.toBytes((String)"abcd");
        int NB_BATCH_ROWS = 10;
        Table table = TEST_UTIL.createTable(TableName.valueOf((String)this.name.getMethodName()), (byte[][])new byte[][]{CONTENTS_FAMILY, SMALL_FAMILY});
        ArrayList<Put> rowsUpdate = new ArrayList<Put>();
        for (int i = 0; i < 100; ++i) {
            byte[] row = Bytes.toBytes((String)("row" + i));
            Put put = new Put(row);
            put.setDurability(Durability.SKIP_WAL);
            put.addColumn(CONTENTS_FAMILY, null, value);
            rowsUpdate.add(put);
        }
        table.put(rowsUpdate);
        Scan scan = new Scan();
        scan.addFamily(CONTENTS_FAMILY);
        ResultScanner scanner = table.getScanner(scan);
        int nbRows = 0;
        for (Result row : scanner) {
            ++nbRows;
        }
        Assert.assertEquals((long)100L, (long)nbRows);
    }

    @Test
    public void testAddKeyValue() throws IOException {
        byte[] CONTENTS_FAMILY = Bytes.toBytes((String)"contents");
        byte[] value = Bytes.toBytes((String)"abcd");
        byte[] row1 = Bytes.toBytes((String)"row1");
        byte[] row2 = Bytes.toBytes((String)"row2");
        byte[] qualifier = Bytes.toBytes((String)"qf1");
        Put put = new Put(row1);
        KeyValue kv = new KeyValue(row1, CONTENTS_FAMILY, qualifier, value);
        boolean ok = true;
        try {
            put.add((Cell)kv);
        }
        catch (IOException e) {
            ok = false;
        }
        Assert.assertEquals((Object)true, (Object)ok);
        kv = new KeyValue(row2, CONTENTS_FAMILY, qualifier, value);
        ok = false;
        try {
            put.add((Cell)kv);
        }
        catch (IOException e) {
            ok = true;
        }
        Assert.assertEquals((Object)true, (Object)ok);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHBase737() throws IOException {
        int i;
        Result r;
        byte[] FAM1 = Bytes.toBytes((String)"fam1");
        byte[] FAM2 = Bytes.toBytes((String)"fam2");
        Table table = TEST_UTIL.createTable(TableName.valueOf((String)this.name.getMethodName()), (byte[][])new byte[][]{FAM1, FAM2});
        Put put = new Put(ROW);
        put.addColumn(FAM1, Bytes.toBytes((String)"letters"), Bytes.toBytes((String)"abcdefg"));
        table.put(put);
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        put = new Put(ROW);
        put.addColumn(FAM1, Bytes.toBytes((String)"numbers"), Bytes.toBytes((String)"123456"));
        table.put(put);
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        put = new Put(ROW);
        put.addColumn(FAM2, Bytes.toBytes((String)"letters"), Bytes.toBytes((String)"hijklmnop"));
        table.put(put);
        long[] times = new long[3];
        Scan scan = new Scan();
        scan.addFamily(FAM1);
        scan.addFamily(FAM2);
        try (ResultScanner s = table.getScanner(scan);){
            int index = 0;
            r = null;
            while ((r = s.next()) != null) {
                for (Cell key : r.rawCells()) {
                    times[index++] = key.getTimestamp();
                }
            }
        }
        for (i = 0; i < times.length - 1; ++i) {
            for (int j = i + 1; j < times.length; ++j) {
                Assert.assertTrue((times[j] > times[i] ? 1 : 0) != 0);
            }
        }
        TEST_UTIL.flush();
        for (i = 0; i < times.length; ++i) {
            times[i] = 0L;
        }
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException i2) {
            // empty catch block
        }
        scan = new Scan();
        scan.addFamily(FAM1);
        scan.addFamily(FAM2);
        s = table.getScanner(scan);
        try {
            int index = 0;
            r = null;
            while ((r = s.next()) != null) {
                for (Cell key : r.rawCells()) {
                    times[index++] = key.getTimestamp();
                }
            }
        }
        finally {
            s.close();
        }
        for (int i3 = 0; i3 < times.length - 1; ++i3) {
            for (int j = i3 + 1; j < times.length; ++j) {
                Assert.assertTrue((times[j] > times[i3] ? 1 : 0) != 0);
            }
        }
    }

    @Test
    public void testListTables() throws IOException, InterruptedException {
        TableName tableName1 = TableName.valueOf((String)(this.name.getMethodName() + "1"));
        TableName tableName2 = TableName.valueOf((String)(this.name.getMethodName() + "2"));
        TableName tableName3 = TableName.valueOf((String)(this.name.getMethodName() + "3"));
        TableName[] tables = new TableName[]{tableName1, tableName2, tableName3};
        for (int i = 0; i < tables.length; ++i) {
            TEST_UTIL.createTable(tables[i], FAMILY);
        }
        Admin admin = TEST_UTIL.getAdmin();
        HTableDescriptor[] ts = admin.listTables();
        HashSet result = new HashSet(ts.length);
        Collections.addAll(result, ts);
        int size = result.size();
        Assert.assertTrue((size >= tables.length ? 1 : 0) != 0);
        for (int i = 0; i < tables.length && i < size; ++i) {
            boolean found = false;
            for (int j = 0; j < ts.length; ++j) {
                if (!ts[j].getTableName().equals((Object)tables[i])) continue;
                found = true;
                break;
            }
            Assert.assertTrue((String)("Not found: " + tables[i]), (boolean)found);
        }
    }

    @Test
    public void testUnmanagedHConnection() throws IOException {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        TEST_UTIL.createTable(tableName, HConstants.CATALOG_FAMILY);
        Connection conn = ConnectionFactory.createConnection((Configuration)TEST_UTIL.getConfiguration());
        Table t = conn.getTable(tableName);
        Admin admin = conn.getAdmin();
        Assert.assertTrue((boolean)admin.tableExists(tableName));
        Assert.assertTrue((boolean)t.get(new Get(ROW)).isEmpty());
        admin.close();
    }

    @Test
    public void testUnmanagedHConnectionReconnect() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        TEST_UTIL.createTable(tableName, HConstants.CATALOG_FAMILY);
        Connection conn = ConnectionFactory.createConnection((Configuration)TEST_UTIL.getConfiguration());
        Table t = conn.getTable(tableName);
        try (Admin admin = conn.getAdmin();){
            Assert.assertTrue((boolean)admin.tableExists(tableName));
            Assert.assertTrue((boolean)t.get(new Get(ROW)).isEmpty());
        }
        MiniHBaseCluster cluster = TEST_UTIL.getHBaseCluster();
        cluster.stopMaster(0, false);
        cluster.waitOnMaster(0);
        cluster.startMaster();
        Assert.assertTrue((boolean)cluster.waitForActiveAndReadyMaster());
        boolean tablesOnMaster = LoadBalancer.isTablesOnMaster((Configuration)TEST_UTIL.getConfiguration());
        try (Admin admin = conn.getAdmin();){
            Assert.assertTrue((boolean)admin.tableExists(tableName));
            Assert.assertTrue((admin.getClusterMetrics(EnumSet.of(ClusterMetrics.Option.LIVE_SERVERS)).getLiveServerMetrics().size() == SLAVES + (tablesOnMaster ? 1 : 0) ? 1 : 0) != 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMiscHTableStuff() throws IOException {
        TableName tableAname = TableName.valueOf((String)(this.name.getMethodName() + "A"));
        TableName tableBname = TableName.valueOf((String)(this.name.getMethodName() + "B"));
        byte[] attrName = Bytes.toBytes((String)"TESTATTR");
        byte[] attrValue = Bytes.toBytes((String)"somevalue");
        byte[] value = Bytes.toBytes((String)"value");
        Table a = TEST_UTIL.createTable(tableAname, HConstants.CATALOG_FAMILY);
        Table b = TEST_UTIL.createTable(tableBname, HConstants.CATALOG_FAMILY);
        Put put = new Put(ROW);
        put.addColumn(HConstants.CATALOG_FAMILY, null, value);
        a.put(put);
        Table newA = TEST_UTIL.getConnection().getTable(tableAname);
        Scan scan = new Scan();
        scan.addFamily(HConstants.CATALOG_FAMILY);
        try (ResultScanner s = newA.getScanner(scan);){
            for (Result r : s) {
                put = new Put(r.getRow());
                put.setDurability(Durability.SKIP_WAL);
                for (Cell kv : r.rawCells()) {
                    put.add(kv);
                }
                b.put(put);
            }
        }
        Table anotherA = TEST_UTIL.getConnection().getTable(tableAname);
        Get get = new Get(ROW);
        get.addFamily(HConstants.CATALOG_FAMILY);
        anotherA.get(get);
        Admin admin = TEST_UTIL.getAdmin();
        HTableDescriptor desc = new HTableDescriptor(a.getTableDescriptor());
        admin.disableTable(tableAname);
        desc.setValue(attrName, attrValue);
        for (HColumnDescriptor c : desc.getFamilies()) {
            c.setValue(attrName, attrValue);
        }
        admin.modifyTable(tableAname, (TableDescriptor)desc);
        admin.enableTable(tableAname);
        desc = a.getTableDescriptor();
        Assert.assertEquals((String)"wrong table descriptor returned", (Object)desc.getTableName(), (Object)tableAname);
        value = desc.getValue(attrName);
        Assert.assertFalse((String)"missing HTD attribute value", (value == null ? 1 : 0) != 0);
        Assert.assertFalse((String)"HTD attribute value is incorrect", (Bytes.compareTo((byte[])value, (byte[])attrValue) != 0 ? 1 : 0) != 0);
        for (HColumnDescriptor c : desc.getFamilies()) {
            value = c.getValue(attrName);
            Assert.assertFalse((String)"missing HCD attribute value", (value == null ? 1 : 0) != 0);
            Assert.assertFalse((String)"HCD attribute value is incorrect", (Bytes.compareTo((byte[])value, (byte[])attrValue) != 0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testGetClosestRowBefore() throws IOException, InterruptedException {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        byte[] firstRow = Bytes.toBytes((String)"row111");
        byte[] secondRow = Bytes.toBytes((String)"row222");
        byte[] thirdRow = Bytes.toBytes((String)"row333");
        byte[] forthRow = Bytes.toBytes((String)"row444");
        byte[] beforeFirstRow = Bytes.toBytes((String)"row");
        byte[] beforeSecondRow = Bytes.toBytes((String)"row22");
        byte[] beforeThirdRow = Bytes.toBytes((String)"row33");
        byte[] beforeForthRow = Bytes.toBytes((String)"row44");
        try (Table table = TEST_UTIL.createTable(tableName, (byte[][])new byte[][]{HConstants.CATALOG_FAMILY, Bytes.toBytes((String)"info2")}, 1, 1024);
             RegionLocator locator = TEST_UTIL.getConnection().getRegionLocator(tableName);){
            String regionName = ((HRegionLocation)locator.getAllRegionLocations().get(0)).getRegionInfo().getEncodedName();
            HRegion region = TEST_UTIL.getRSForFirstRegionInTable(tableName).getRegion(regionName);
            Put put1 = new Put(firstRow);
            Put put2 = new Put(secondRow);
            Put put3 = new Put(thirdRow);
            Put put4 = new Put(forthRow);
            byte[] one = new byte[]{1};
            byte[] two = new byte[]{2};
            byte[] three = new byte[]{3};
            byte[] four = new byte[]{4};
            put1.addColumn(HConstants.CATALOG_FAMILY, null, one);
            put2.addColumn(HConstants.CATALOG_FAMILY, null, two);
            put3.addColumn(HConstants.CATALOG_FAMILY, null, three);
            put4.addColumn(HConstants.CATALOG_FAMILY, null, four);
            table.put(put1);
            table.put(put2);
            table.put(put3);
            table.put(put4);
            region.flush(true);
            Result result = this.getReverseScanResult(table, beforeFirstRow, HConstants.CATALOG_FAMILY);
            Assert.assertNull((Object)result);
            result = this.getReverseScanResult(table, firstRow, HConstants.CATALOG_FAMILY);
            Assert.assertTrue((boolean)result.containsColumn(HConstants.CATALOG_FAMILY, null));
            Assert.assertTrue((boolean)Bytes.equals((byte[])result.getRow(), (byte[])firstRow));
            Assert.assertTrue((boolean)Bytes.equals((byte[])result.getValue(HConstants.CATALOG_FAMILY, null), (byte[])one));
            result = this.getReverseScanResult(table, beforeSecondRow, HConstants.CATALOG_FAMILY);
            Assert.assertTrue((boolean)result.containsColumn(HConstants.CATALOG_FAMILY, null));
            Assert.assertTrue((boolean)Bytes.equals((byte[])result.getRow(), (byte[])firstRow));
            Assert.assertTrue((boolean)Bytes.equals((byte[])result.getValue(HConstants.CATALOG_FAMILY, null), (byte[])one));
            result = this.getReverseScanResult(table, secondRow, HConstants.CATALOG_FAMILY);
            Assert.assertTrue((boolean)result.containsColumn(HConstants.CATALOG_FAMILY, null));
            Assert.assertTrue((boolean)Bytes.equals((byte[])result.getRow(), (byte[])secondRow));
            Assert.assertTrue((boolean)Bytes.equals((byte[])result.getValue(HConstants.CATALOG_FAMILY, null), (byte[])two));
            result = this.getReverseScanResult(table, beforeThirdRow, HConstants.CATALOG_FAMILY);
            Assert.assertTrue((boolean)result.containsColumn(HConstants.CATALOG_FAMILY, null));
            Assert.assertTrue((boolean)Bytes.equals((byte[])result.getRow(), (byte[])secondRow));
            Assert.assertTrue((boolean)Bytes.equals((byte[])result.getValue(HConstants.CATALOG_FAMILY, null), (byte[])two));
            result = this.getReverseScanResult(table, thirdRow, HConstants.CATALOG_FAMILY);
            Assert.assertTrue((boolean)result.containsColumn(HConstants.CATALOG_FAMILY, null));
            Assert.assertTrue((boolean)Bytes.equals((byte[])result.getRow(), (byte[])thirdRow));
            Assert.assertTrue((boolean)Bytes.equals((byte[])result.getValue(HConstants.CATALOG_FAMILY, null), (byte[])three));
            result = this.getReverseScanResult(table, beforeForthRow, HConstants.CATALOG_FAMILY);
            Assert.assertTrue((boolean)result.containsColumn(HConstants.CATALOG_FAMILY, null));
            Assert.assertTrue((boolean)Bytes.equals((byte[])result.getRow(), (byte[])thirdRow));
            Assert.assertTrue((boolean)Bytes.equals((byte[])result.getValue(HConstants.CATALOG_FAMILY, null), (byte[])three));
            result = this.getReverseScanResult(table, forthRow, HConstants.CATALOG_FAMILY);
            Assert.assertTrue((boolean)result.containsColumn(HConstants.CATALOG_FAMILY, null));
            Assert.assertTrue((boolean)Bytes.equals((byte[])result.getRow(), (byte[])forthRow));
            Assert.assertTrue((boolean)Bytes.equals((byte[])result.getValue(HConstants.CATALOG_FAMILY, null), (byte[])four));
            result = this.getReverseScanResult(table, Bytes.add((byte[])forthRow, (byte[])one), HConstants.CATALOG_FAMILY);
            Assert.assertTrue((boolean)result.containsColumn(HConstants.CATALOG_FAMILY, null));
            Assert.assertTrue((boolean)Bytes.equals((byte[])result.getRow(), (byte[])forthRow));
            Assert.assertTrue((boolean)Bytes.equals((byte[])result.getValue(HConstants.CATALOG_FAMILY, null), (byte[])four));
        }
    }

    private Result getReverseScanResult(Table table, byte[] row, byte[] fam) throws IOException {
        Scan scan = new Scan(row);
        scan.setSmall(true);
        scan.setReversed(true);
        scan.setCaching(1);
        scan.addFamily(fam);
        try (ResultScanner scanner = table.getScanner(scan);){
            Result result = scanner.next();
            return result;
        }
    }

    @Test
    public void testScanVariableReuse() throws Exception {
        Scan scan = new Scan();
        scan.addFamily(FAMILY);
        scan.addColumn(FAMILY, ROW);
        Assert.assertTrue((((NavigableSet)scan.getFamilyMap().get(FAMILY)).size() == 1 ? 1 : 0) != 0);
        scan = new Scan();
        scan.addFamily(FAMILY);
        Assert.assertTrue((scan.getFamilyMap().get(FAMILY) == null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)scan.getFamilyMap().containsKey(FAMILY));
    }

    @Test
    public void testMultiRowMutation() throws Exception {
        LOG.info("Starting testMultiRowMutation");
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        byte[] ROW1 = Bytes.toBytes((String)"testRow1");
        Table t = TEST_UTIL.createTable(tableName, FAMILY);
        Put p = new Put(ROW);
        p.addColumn(FAMILY, QUALIFIER, VALUE);
        ClientProtos.MutationProto m1 = ProtobufUtil.toMutation((ClientProtos.MutationProto.MutationType)ClientProtos.MutationProto.MutationType.PUT, (Mutation)p);
        p = new Put(ROW1);
        p.addColumn(FAMILY, QUALIFIER, VALUE);
        ClientProtos.MutationProto m2 = ProtobufUtil.toMutation((ClientProtos.MutationProto.MutationType)ClientProtos.MutationProto.MutationType.PUT, (Mutation)p);
        MultiRowMutationProtos.MutateRowsRequest.Builder mrmBuilder = MultiRowMutationProtos.MutateRowsRequest.newBuilder();
        mrmBuilder.addMutationRequest(m1);
        mrmBuilder.addMutationRequest(m2);
        MultiRowMutationProtos.MutateRowsRequest mrm = mrmBuilder.build();
        CoprocessorRpcChannel channel = t.coprocessorService(ROW);
        MultiRowMutationProtos.MultiRowMutationService.BlockingInterface service = MultiRowMutationProtos.MultiRowMutationService.newBlockingStub((BlockingRpcChannel)channel);
        service.mutateRows(null, mrm);
        Get g = new Get(ROW);
        Result r = t.get(g);
        Assert.assertEquals((long)0L, (long)Bytes.compareTo((byte[])VALUE, (byte[])r.getValue(FAMILY, QUALIFIER)));
        g = new Get(ROW1);
        r = t.get(g);
        Assert.assertEquals((long)0L, (long)Bytes.compareTo((byte[])VALUE, (byte[])r.getValue(FAMILY, QUALIFIER)));
    }

    @Test
    public void testRowMutation() throws Exception {
        LOG.info("Starting testRowMutation");
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        Table t = TEST_UTIL.createTable(tableName, FAMILY);
        byte[][] QUALIFIERS = new byte[][]{Bytes.toBytes((String)"a"), Bytes.toBytes((String)"b")};
        RowMutations arm = new RowMutations(ROW);
        Put p = new Put(ROW);
        p.addColumn(FAMILY, QUALIFIERS[0], VALUE);
        arm.add(p);
        t.mutateRow(arm);
        Get g = new Get(ROW);
        Result r = t.get(g);
        Assert.assertEquals((long)0L, (long)Bytes.compareTo((byte[])VALUE, (byte[])r.getValue(FAMILY, QUALIFIERS[0])));
        arm = new RowMutations(ROW);
        p = new Put(ROW);
        p.addColumn(FAMILY, QUALIFIERS[1], VALUE);
        arm.add(p);
        Delete d = new Delete(ROW);
        d.addColumns(FAMILY, QUALIFIERS[0]);
        arm.add(d);
        t.mutateRow(arm);
        r = t.get(g);
        Assert.assertEquals((long)0L, (long)Bytes.compareTo((byte[])VALUE, (byte[])r.getValue(FAMILY, QUALIFIERS[1])));
        Assert.assertNull((Object)r.getValue(FAMILY, QUALIFIERS[0]));
        try {
            arm = new RowMutations(ROW);
            p = new Put(ROW);
            p.addColumn(new byte[]{98, 111, 103, 117, 115}, QUALIFIERS[0], VALUE);
            arm.add(p);
            t.mutateRow(arm);
            Assert.fail((String)"Expected NoSuchColumnFamilyException");
        }
        catch (RetriesExhaustedWithDetailsException e) {
            for (Throwable rootCause : e.getCauses()) {
                if (!(rootCause instanceof NoSuchColumnFamilyException)) continue;
                return;
            }
            throw e;
        }
    }

    @Test
    public void testBatchAppendWithReturnResultFalse() throws Exception {
        LOG.info("Starting testBatchAppendWithReturnResultFalse");
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        Table table = TEST_UTIL.createTable(tableName, FAMILY);
        Append append1 = new Append(Bytes.toBytes((String)"row1"));
        append1.setReturnResults(false);
        append1.addColumn(FAMILY, Bytes.toBytes((String)"f1"), Bytes.toBytes((String)"value1"));
        Append append2 = new Append(Bytes.toBytes((String)"row1"));
        append2.setReturnResults(false);
        append2.addColumn(FAMILY, Bytes.toBytes((String)"f1"), Bytes.toBytes((String)"value2"));
        ArrayList<Append> appends = new ArrayList<Append>();
        appends.add(append1);
        appends.add(append2);
        Object[] results = new Object[2];
        table.batch(appends, results);
        Assert.assertTrue((results.length == 2 ? 1 : 0) != 0);
        for (Object r : results) {
            Result result = (Result)r;
            Assert.assertTrue((boolean)result.isEmpty());
        }
        table.close();
    }

    @Test
    public void testAppend() throws Exception {
        LOG.info("Starting testAppend");
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        Table t = TEST_UTIL.createTable(tableName, FAMILY);
        byte[] v1 = Bytes.toBytes((String)"42");
        byte[] v2 = Bytes.toBytes((String)"23");
        byte[][] QUALIFIERS = new byte[][]{Bytes.toBytes((String)"b"), Bytes.toBytes((String)"a"), Bytes.toBytes((String)"c")};
        Append a = new Append(ROW);
        a.addColumn(FAMILY, QUALIFIERS[0], v1);
        a.addColumn(FAMILY, QUALIFIERS[1], v2);
        a.setReturnResults(false);
        this.assertEmptyResult(t.append(a));
        a = new Append(ROW);
        a.addColumn(FAMILY, QUALIFIERS[0], v2);
        a.addColumn(FAMILY, QUALIFIERS[1], v1);
        a.addColumn(FAMILY, QUALIFIERS[2], v2);
        Result r = t.append(a);
        Assert.assertEquals((long)0L, (long)Bytes.compareTo((byte[])Bytes.add((byte[])v1, (byte[])v2), (byte[])r.getValue(FAMILY, QUALIFIERS[0])));
        Assert.assertEquals((long)0L, (long)Bytes.compareTo((byte[])Bytes.add((byte[])v2, (byte[])v1), (byte[])r.getValue(FAMILY, QUALIFIERS[1])));
        Assert.assertEquals((long)0L, (long)Bytes.compareTo((byte[])v2, (byte[])r.getValue(FAMILY, QUALIFIERS[2])));
        Assert.assertEquals((long)r.getColumnLatestCell(FAMILY, QUALIFIERS[0]).getTimestamp(), (long)r.getColumnLatestCell(FAMILY, QUALIFIERS[2]).getTimestamp());
    }

    private List<Result> doAppend(boolean walUsed) throws IOException {
        LOG.info("Starting testAppend, walUsed is " + walUsed);
        TableName TABLENAME = TableName.valueOf((String)(walUsed ? "testAppendWithWAL" : "testAppendWithoutWAL"));
        Table t = TEST_UTIL.createTable(TABLENAME, FAMILY);
        byte[] row1 = Bytes.toBytes((String)"c");
        byte[] row2 = Bytes.toBytes((String)"b");
        byte[] row3 = Bytes.toBytes((String)"a");
        byte[] qual = Bytes.toBytes((String)"qual");
        Put put_0 = new Put(row2);
        put_0.addColumn(FAMILY, qual, Bytes.toBytes((String)"put"));
        Put put_1 = new Put(row3);
        put_1.addColumn(FAMILY, qual, Bytes.toBytes((String)"put"));
        Append append_0 = new Append(row1);
        append_0.addColumn(FAMILY, qual, Bytes.toBytes((String)"i"));
        Append append_1 = new Append(row1);
        append_1.addColumn(FAMILY, qual, Bytes.toBytes((String)"k"));
        Append append_2 = new Append(row1);
        append_2.addColumn(FAMILY, qual, Bytes.toBytes((String)"e"));
        if (!walUsed) {
            append_2.setDurability(Durability.SKIP_WAL);
        }
        Append append_3 = new Append(row1);
        append_3.addColumn(FAMILY, qual, Bytes.toBytes((String)"a"));
        Scan s = new Scan();
        s.setCaching(1);
        t.append(append_0);
        t.put(put_0);
        t.put(put_1);
        LinkedList<Result> results = new LinkedList<Result>();
        try (ResultScanner scanner = t.getScanner(s);){
            t.append(append_1);
            t.append(append_2);
            t.append(append_3);
            for (Result r : scanner) {
                results.add(r);
            }
        }
        TEST_UTIL.deleteTable(TABLENAME);
        return results;
    }

    @Test
    public void testAppendWithoutWAL() throws Exception {
        List<Result> resultsWithWal = this.doAppend(true);
        List<Result> resultsWithoutWal = this.doAppend(false);
        Assert.assertEquals((long)resultsWithWal.size(), (long)resultsWithoutWal.size());
        for (int i = 0; i != resultsWithWal.size(); ++i) {
            Result resultWithWal = resultsWithWal.get(i);
            Result resultWithoutWal = resultsWithoutWal.get(i);
            Assert.assertEquals((long)resultWithWal.rawCells().length, (long)resultWithoutWal.rawCells().length);
            for (int j = 0; j != resultWithWal.rawCells().length; ++j) {
                Cell cellWithWal = resultWithWal.rawCells()[j];
                Cell cellWithoutWal = resultWithoutWal.rawCells()[j];
                Assert.assertTrue((boolean)Bytes.equals((byte[])CellUtil.cloneRow((Cell)cellWithWal), (byte[])CellUtil.cloneRow((Cell)cellWithoutWal)));
                Assert.assertTrue((boolean)Bytes.equals((byte[])CellUtil.cloneFamily((Cell)cellWithWal), (byte[])CellUtil.cloneFamily((Cell)cellWithoutWal)));
                Assert.assertTrue((boolean)Bytes.equals((byte[])CellUtil.cloneQualifier((Cell)cellWithWal), (byte[])CellUtil.cloneQualifier((Cell)cellWithoutWal)));
                Assert.assertTrue((boolean)Bytes.equals((byte[])CellUtil.cloneValue((Cell)cellWithWal), (byte[])CellUtil.cloneValue((Cell)cellWithoutWal)));
            }
        }
    }

    @Test
    public void testClientPoolRoundRobin() throws IOException {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        int poolSize = 3;
        int numVersions = poolSize * 2;
        Configuration conf = TEST_UTIL.getConfiguration();
        conf.set("hbase.client.ipc.pool.type", "round-robin");
        conf.setInt("hbase.client.ipc.pool.size", poolSize);
        Table table = TEST_UTIL.createTable(tableName, (byte[][])new byte[][]{FAMILY}, Integer.MAX_VALUE);
        long ts = EnvironmentEdgeManager.currentTime();
        Get get = new Get(ROW);
        get.addColumn(FAMILY, QUALIFIER);
        get.setMaxVersions();
        for (int versions = 1; versions <= numVersions; ++versions) {
            Put put = new Put(ROW);
            put.addColumn(FAMILY, QUALIFIER, ts + (long)versions, VALUE);
            table.put(put);
            Result result = table.get(get);
            NavigableMap navigableMap = (NavigableMap)((NavigableMap)result.getMap().get(FAMILY)).get(QUALIFIER);
            Assert.assertEquals((String)("The number of versions of '" + Bytes.toString((byte[])FAMILY) + ":" + Bytes.toString((byte[])QUALIFIER) + " did not match"), (long)versions, (long)navigableMap.size());
            for (Map.Entry entry : navigableMap.entrySet()) {
                Assert.assertTrue((String)("The value at time " + entry.getKey() + " did not match what was put"), (boolean)Bytes.equals((byte[])VALUE, (byte[])((byte[])entry.getValue())));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Ignore(value="Flakey: HBASE-8989")
    @Test
    public void testClientPoolThreadLocal() throws IOException {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        int poolSize = Integer.MAX_VALUE;
        int numVersions = 3;
        Configuration conf = TEST_UTIL.getConfiguration();
        conf.set("hbase.client.ipc.pool.type", "thread-local");
        conf.setInt("hbase.client.ipc.pool.size", poolSize);
        final Table table = TEST_UTIL.createTable(tableName, (byte[][])new byte[][]{FAMILY}, 3);
        final long ts = EnvironmentEdgeManager.currentTime();
        final Get get = new Get(ROW);
        get.addColumn(FAMILY, QUALIFIER);
        get.setMaxVersions();
        for (int versions = 1; versions <= numVersions; ++versions) {
            Put put = new Put(ROW);
            put.addColumn(FAMILY, QUALIFIER, ts + (long)versions, VALUE);
            table.put(put);
            Result result = table.get(get);
            NavigableMap navigableMap = (NavigableMap)((NavigableMap)result.getMap().get(FAMILY)).get(QUALIFIER);
            Assert.assertEquals((String)("The number of versions of '" + Bytes.toString((byte[])FAMILY) + ":" + Bytes.toString((byte[])QUALIFIER) + " did not match"), (long)versions, (long)navigableMap.size());
            for (Map.Entry entry : navigableMap.entrySet()) {
                Assert.assertTrue((String)("The value at time " + entry.getKey() + " did not match what was put"), (boolean)Bytes.equals((byte[])VALUE, (byte[])((byte[])entry.getValue())));
            }
        }
        final Object waitLock = new Object();
        ExecutorService executorService = Executors.newFixedThreadPool(numVersions);
        final AtomicReference<Object> error = new AtomicReference<Object>(null);
        int versions = numVersions;
        while (versions < numVersions * 2) {
            final int versionsCopy = versions++;
            executorService.submit(new Callable<Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Void call() {
                    try {
                        Put put = new Put(ROW);
                        put.addColumn(FAMILY, QUALIFIER, ts + (long)versionsCopy, VALUE);
                        table.put(put);
                        Result result = table.get(get);
                        NavigableMap navigableMap = (NavigableMap)((NavigableMap)result.getMap().get(FAMILY)).get(QUALIFIER);
                        Assert.assertEquals((String)("The number of versions of '" + Bytes.toString((byte[])FAMILY) + ":" + Bytes.toString((byte[])QUALIFIER) + " did not match " + versionsCopy), (long)versionsCopy, (long)navigableMap.size());
                        for (Map.Entry entry : navigableMap.entrySet()) {
                            Assert.assertTrue((String)("The value at time " + entry.getKey() + " did not match what was put"), (boolean)Bytes.equals((byte[])VALUE, (byte[])((byte[])entry.getValue())));
                        }
                        Object object = waitLock;
                        synchronized (object) {
                            waitLock.wait();
                        }
                    }
                    catch (Exception put) {
                    }
                    catch (AssertionError e) {
                        error.set(e);
                        LOG.error(((Throwable)((Object)e)).toString(), (Throwable)((Object)e));
                    }
                    return null;
                }
            });
        }
        Object object = waitLock;
        synchronized (object) {
            waitLock.notifyAll();
        }
        executorService.shutdownNow();
        Assert.assertNull(error.get());
    }

    @Test
    public void testCheckAndPut() throws IOException {
        byte[] anotherrow = Bytes.toBytes((String)"anotherrow");
        byte[] value2 = Bytes.toBytes((String)"abcd");
        Table table = TEST_UTIL.createTable(TableName.valueOf((String)this.name.getMethodName()), FAMILY);
        Put put1 = new Put(ROW);
        put1.addColumn(FAMILY, QUALIFIER, VALUE);
        boolean ok = table.checkAndMutate(ROW, FAMILY).qualifier(QUALIFIER).ifEquals(VALUE).thenPut(put1);
        Assert.assertFalse((boolean)ok);
        ok = table.checkAndMutate(ROW, FAMILY).qualifier(QUALIFIER).ifNotExists().thenPut(put1);
        Assert.assertTrue((boolean)ok);
        ok = table.checkAndMutate(ROW, FAMILY).qualifier(QUALIFIER).ifNotExists().thenPut(put1);
        Assert.assertFalse((boolean)ok);
        Put put2 = new Put(ROW);
        put2.addColumn(FAMILY, QUALIFIER, value2);
        ok = table.checkAndMutate(ROW, FAMILY).qualifier(QUALIFIER).ifEquals(VALUE).thenPut(put2);
        Assert.assertTrue((boolean)ok);
        Put put3 = new Put(anotherrow);
        put3.addColumn(FAMILY, QUALIFIER, VALUE);
        try {
            table.checkAndMutate(ROW, FAMILY).qualifier(QUALIFIER).ifEquals(value2).thenPut(put3);
            Assert.fail((String)"trying to check and modify different rows should have failed.");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testCheckAndMutateWithTimeRange() throws IOException {
        Table table = TEST_UTIL.createTable(TableName.valueOf((String)this.name.getMethodName()), FAMILY);
        long ts = System.currentTimeMillis() / 2L;
        Put put = new Put(ROW);
        put.addColumn(FAMILY, QUALIFIER, ts, VALUE);
        boolean ok = table.checkAndMutate(ROW, FAMILY).qualifier(QUALIFIER).ifNotExists().thenPut(put);
        Assert.assertTrue((boolean)ok);
        ok = table.checkAndMutate(ROW, FAMILY).qualifier(QUALIFIER).timeRange(TimeRange.at((long)(ts + 10000L))).ifEquals(VALUE).thenPut(put);
        Assert.assertFalse((boolean)ok);
        ok = table.checkAndMutate(ROW, FAMILY).qualifier(QUALIFIER).timeRange(TimeRange.at((long)ts)).ifEquals(VALUE).thenPut(put);
        Assert.assertTrue((boolean)ok);
        RowMutations rm = new RowMutations(ROW).add((Mutation)put);
        ok = table.checkAndMutate(ROW, FAMILY).qualifier(QUALIFIER).timeRange(TimeRange.at((long)(ts + 10000L))).ifEquals(VALUE).thenMutate(rm);
        Assert.assertFalse((boolean)ok);
        ok = table.checkAndMutate(ROW, FAMILY).qualifier(QUALIFIER).timeRange(TimeRange.at((long)ts)).ifEquals(VALUE).thenMutate(rm);
        Assert.assertTrue((boolean)ok);
        Delete delete = new Delete(ROW).addColumn(FAMILY, QUALIFIER);
        ok = table.checkAndMutate(ROW, FAMILY).qualifier(QUALIFIER).timeRange(TimeRange.at((long)(ts + 10000L))).ifEquals(VALUE).thenDelete(delete);
        Assert.assertFalse((boolean)ok);
        ok = table.checkAndMutate(ROW, FAMILY).qualifier(QUALIFIER).timeRange(TimeRange.at((long)ts)).ifEquals(VALUE).thenDelete(delete);
        Assert.assertTrue((boolean)ok);
    }

    @Test
    public void testCheckAndPutWithCompareOp() throws IOException {
        byte[] value1 = Bytes.toBytes((String)"aaaa");
        byte[] value2 = Bytes.toBytes((String)"bbbb");
        byte[] value3 = Bytes.toBytes((String)"cccc");
        byte[] value4 = Bytes.toBytes((String)"dddd");
        Table table = TEST_UTIL.createTable(TableName.valueOf((String)this.name.getMethodName()), FAMILY);
        Put put2 = new Put(ROW);
        put2.addColumn(FAMILY, QUALIFIER, value2);
        Put put3 = new Put(ROW);
        put3.addColumn(FAMILY, QUALIFIER, value3);
        boolean ok = table.checkAndMutate(ROW, FAMILY).qualifier(QUALIFIER).ifNotExists().thenPut(put2);
        Assert.assertTrue((boolean)ok);
        ok = table.checkAndMutate(ROW, FAMILY).qualifier(QUALIFIER).ifMatches(CompareOperator.GREATER, value1).thenPut(put2);
        Assert.assertFalse((boolean)ok);
        ok = table.checkAndMutate(ROW, FAMILY).qualifier(QUALIFIER).ifMatches(CompareOperator.EQUAL, value1).thenPut(put2);
        Assert.assertFalse((boolean)ok);
        ok = table.checkAndMutate(ROW, FAMILY).qualifier(QUALIFIER).ifMatches(CompareOperator.GREATER_OR_EQUAL, value1).thenPut(put2);
        Assert.assertFalse((boolean)ok);
        ok = table.checkAndMutate(ROW, FAMILY).qualifier(QUALIFIER).ifMatches(CompareOperator.LESS, value1).thenPut(put2);
        Assert.assertTrue((boolean)ok);
        ok = table.checkAndMutate(ROW, FAMILY).qualifier(QUALIFIER).ifMatches(CompareOperator.LESS_OR_EQUAL, value1).thenPut(put2);
        Assert.assertTrue((boolean)ok);
        ok = table.checkAndMutate(ROW, FAMILY).qualifier(QUALIFIER).ifMatches(CompareOperator.NOT_EQUAL, value1).thenPut(put3);
        Assert.assertTrue((boolean)ok);
        ok = table.checkAndMutate(ROW, FAMILY).qualifier(QUALIFIER).ifMatches(CompareOperator.LESS, value4).thenPut(put3);
        Assert.assertFalse((boolean)ok);
        ok = table.checkAndMutate(ROW, FAMILY).qualifier(QUALIFIER).ifMatches(CompareOperator.LESS_OR_EQUAL, value4).thenPut(put3);
        Assert.assertFalse((boolean)ok);
        ok = table.checkAndMutate(ROW, FAMILY).qualifier(QUALIFIER).ifMatches(CompareOperator.EQUAL, value4).thenPut(put3);
        Assert.assertFalse((boolean)ok);
        ok = table.checkAndMutate(ROW, FAMILY).qualifier(QUALIFIER).ifMatches(CompareOperator.GREATER, value4).thenPut(put3);
        Assert.assertTrue((boolean)ok);
        ok = table.checkAndMutate(ROW, FAMILY).qualifier(QUALIFIER).ifMatches(CompareOperator.GREATER_OR_EQUAL, value4).thenPut(put3);
        Assert.assertTrue((boolean)ok);
        ok = table.checkAndMutate(ROW, FAMILY).qualifier(QUALIFIER).ifMatches(CompareOperator.NOT_EQUAL, value4).thenPut(put2);
        Assert.assertTrue((boolean)ok);
        ok = table.checkAndMutate(ROW, FAMILY).qualifier(QUALIFIER).ifMatches(CompareOperator.GREATER, value2).thenPut(put2);
        Assert.assertFalse((boolean)ok);
        ok = table.checkAndMutate(ROW, FAMILY).qualifier(QUALIFIER).ifMatches(CompareOperator.NOT_EQUAL, value2).thenPut(put2);
        Assert.assertFalse((boolean)ok);
        ok = table.checkAndMutate(ROW, FAMILY).qualifier(QUALIFIER).ifMatches(CompareOperator.LESS, value2).thenPut(put2);
        Assert.assertFalse((boolean)ok);
        ok = table.checkAndMutate(ROW, FAMILY).qualifier(QUALIFIER).ifMatches(CompareOperator.GREATER_OR_EQUAL, value2).thenPut(put2);
        Assert.assertTrue((boolean)ok);
        ok = table.checkAndMutate(ROW, FAMILY).qualifier(QUALIFIER).ifMatches(CompareOperator.LESS_OR_EQUAL, value2).thenPut(put2);
        Assert.assertTrue((boolean)ok);
        ok = table.checkAndMutate(ROW, FAMILY).qualifier(QUALIFIER).ifMatches(CompareOperator.EQUAL, value2).thenPut(put3);
        Assert.assertTrue((boolean)ok);
    }

    @Test
    public void testCheckAndDelete() throws IOException {
        byte[] value1 = Bytes.toBytes((String)"aaaa");
        Table table = TEST_UTIL.createTable(TableName.valueOf((String)this.name.getMethodName()), FAMILY);
        Put put = new Put(ROW);
        put.addColumn(FAMILY, QUALIFIER, value1);
        table.put(put);
        Delete delete = new Delete(ROW);
        delete.addColumns(FAMILY, QUALIFIER);
        boolean ok = table.checkAndMutate(ROW, FAMILY).qualifier(QUALIFIER).ifEquals(value1).thenDelete(delete);
        Assert.assertTrue((boolean)ok);
    }

    @Test
    public void testCheckAndDeleteWithCompareOp() throws IOException {
        byte[] value1 = Bytes.toBytes((String)"aaaa");
        byte[] value2 = Bytes.toBytes((String)"bbbb");
        byte[] value3 = Bytes.toBytes((String)"cccc");
        byte[] value4 = Bytes.toBytes((String)"dddd");
        Table table = TEST_UTIL.createTable(TableName.valueOf((String)this.name.getMethodName()), FAMILY);
        Put put2 = new Put(ROW);
        put2.addColumn(FAMILY, QUALIFIER, value2);
        table.put(put2);
        Put put3 = new Put(ROW);
        put3.addColumn(FAMILY, QUALIFIER, value3);
        Delete delete = new Delete(ROW);
        delete.addColumns(FAMILY, QUALIFIER);
        boolean ok = table.checkAndMutate(ROW, FAMILY).qualifier(QUALIFIER).ifMatches(CompareOperator.GREATER, value1).thenDelete(delete);
        Assert.assertFalse((boolean)ok);
        ok = table.checkAndMutate(ROW, FAMILY).qualifier(QUALIFIER).ifMatches(CompareOperator.EQUAL, value1).thenDelete(delete);
        Assert.assertFalse((boolean)ok);
        ok = table.checkAndMutate(ROW, FAMILY).qualifier(QUALIFIER).ifMatches(CompareOperator.GREATER_OR_EQUAL, value1).thenDelete(delete);
        Assert.assertFalse((boolean)ok);
        ok = table.checkAndMutate(ROW, FAMILY).qualifier(QUALIFIER).ifMatches(CompareOperator.LESS, value1).thenDelete(delete);
        Assert.assertTrue((boolean)ok);
        table.put(put2);
        ok = table.checkAndMutate(ROW, FAMILY).qualifier(QUALIFIER).ifMatches(CompareOperator.LESS_OR_EQUAL, value1).thenDelete(delete);
        Assert.assertTrue((boolean)ok);
        table.put(put2);
        ok = table.checkAndMutate(ROW, FAMILY).qualifier(QUALIFIER).ifMatches(CompareOperator.NOT_EQUAL, value1).thenDelete(delete);
        Assert.assertTrue((boolean)ok);
        table.put(put3);
        ok = table.checkAndMutate(ROW, FAMILY).qualifier(QUALIFIER).ifMatches(CompareOperator.LESS, value4).thenDelete(delete);
        Assert.assertFalse((boolean)ok);
        ok = table.checkAndMutate(ROW, FAMILY).qualifier(QUALIFIER).ifMatches(CompareOperator.LESS_OR_EQUAL, value4).thenDelete(delete);
        Assert.assertFalse((boolean)ok);
        ok = table.checkAndMutate(ROW, FAMILY).qualifier(QUALIFIER).ifMatches(CompareOperator.EQUAL, value4).thenDelete(delete);
        Assert.assertFalse((boolean)ok);
        ok = table.checkAndMutate(ROW, FAMILY).qualifier(QUALIFIER).ifMatches(CompareOperator.GREATER, value4).thenDelete(delete);
        Assert.assertTrue((boolean)ok);
        table.put(put3);
        ok = table.checkAndMutate(ROW, FAMILY).qualifier(QUALIFIER).ifMatches(CompareOperator.GREATER_OR_EQUAL, value4).thenDelete(delete);
        Assert.assertTrue((boolean)ok);
        table.put(put3);
        ok = table.checkAndMutate(ROW, FAMILY).qualifier(QUALIFIER).ifMatches(CompareOperator.NOT_EQUAL, value4).thenDelete(delete);
        Assert.assertTrue((boolean)ok);
        table.put(put2);
        ok = table.checkAndMutate(ROW, FAMILY).qualifier(QUALIFIER).ifMatches(CompareOperator.GREATER, value2).thenDelete(delete);
        Assert.assertFalse((boolean)ok);
        ok = table.checkAndMutate(ROW, FAMILY).qualifier(QUALIFIER).ifMatches(CompareOperator.NOT_EQUAL, value2).thenDelete(delete);
        Assert.assertFalse((boolean)ok);
        ok = table.checkAndMutate(ROW, FAMILY).qualifier(QUALIFIER).ifMatches(CompareOperator.LESS, value2).thenDelete(delete);
        Assert.assertFalse((boolean)ok);
        ok = table.checkAndMutate(ROW, FAMILY).qualifier(QUALIFIER).ifMatches(CompareOperator.GREATER_OR_EQUAL, value2).thenDelete(delete);
        Assert.assertTrue((boolean)ok);
        table.put(put2);
        ok = table.checkAndMutate(ROW, FAMILY).qualifier(QUALIFIER).ifMatches(CompareOperator.LESS_OR_EQUAL, value2).thenDelete(delete);
        Assert.assertTrue((boolean)ok);
        table.put(put2);
        ok = table.checkAndMutate(ROW, FAMILY).qualifier(QUALIFIER).ifMatches(CompareOperator.EQUAL, value2).thenDelete(delete);
        Assert.assertTrue((boolean)ok);
    }

    @Test
    public void testScanMetrics() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        Table ht = TEST_UTIL.createMultiRegionTable(tableName, FAMILY);
        int numOfRegions = -1;
        try (RegionLocator r = TEST_UTIL.getConnection().getRegionLocator(tableName);){
            numOfRegions = r.getStartKeys().length;
        }
        Put put1 = new Put(Bytes.toBytes((String)"zzz1"));
        put1.addColumn(FAMILY, QUALIFIER, VALUE);
        Put put2 = new Put(Bytes.toBytes((String)"zzz2"));
        put2.addColumn(FAMILY, QUALIFIER, VALUE);
        Put put3 = new Put(Bytes.toBytes((String)"zzz3"));
        put3.addColumn(FAMILY, QUALIFIER, VALUE);
        ht.put(Arrays.asList(put1, put2, put3));
        Scan scan1 = new Scan();
        int numRecords = 0;
        ResultScanner scanner = ht.getScanner(scan1);
        for (Result[] result : scanner) {
            ++numRecords;
        }
        scanner.close();
        LOG.info("test data has " + numRecords + " records.");
        Assert.assertEquals(null, (Object)scan1.getScanMetrics());
        Scan scan2 = new Scan();
        scan2.setScanMetricsEnabled(true);
        scan2.setCaching(numRecords + 1);
        scanner = ht.getScanner(scan2);
        for (Result result : scanner.next(numRecords - 1)) {
        }
        scanner.close();
        Assert.assertNotNull((Object)scan2.getScanMetrics());
        scan2 = new Scan();
        scan2.setScanMetricsEnabled(true);
        scan2.setCaching(1);
        scanner = ht.getScanner(scan2);
        for (Result result : scanner.next(numRecords - 1)) {
        }
        scanner.close();
        ScanMetrics scanMetrics = scan2.getScanMetrics();
        Assert.assertEquals((String)"Did not access all the regions in the table", (long)numOfRegions, (long)scanMetrics.countOfRegions.get());
        scan2 = new Scan();
        scan2.setScanMetricsEnabled(true);
        scan2.setCaching(1);
        scanner = ht.getScanner(scan2);
        int numBytes = 0;
        for (Result result : scanner.next(1)) {
            for (Cell cell : result.listCells()) {
                numBytes += PrivateCellUtil.estimatedSerializedSizeOf((Cell)cell);
            }
        }
        scanner.close();
        scanMetrics = scan2.getScanMetrics();
        Assert.assertEquals((String)"Did not count the result bytes", (long)numBytes, (long)scanMetrics.countOfBytesInResults.get());
        scan2 = new Scan();
        scan2.setScanMetricsEnabled(true);
        scan2.setCaching(1);
        scan2.setSmall(true);
        scanner = ht.getScanner(scan2);
        numBytes = 0;
        for (Result result : scanner.next(1)) {
            for (Cell cell : result.listCells()) {
                numBytes += PrivateCellUtil.estimatedSerializedSizeOf((Cell)cell);
            }
        }
        scanner.close();
        scanMetrics = scan2.getScanMetrics();
        Assert.assertEquals((String)"Did not count the result bytes", (long)numBytes, (long)scanMetrics.countOfBytesInResults.get());
        Scan scanWithClose = new Scan();
        scanWithClose.setCaching(numRecords);
        scanWithClose.setScanMetricsEnabled(true);
        ResultScanner scannerWithClose = ht.getScanner(scanWithClose);
        for (Result result : scannerWithClose.next(numRecords + 1)) {
        }
        scannerWithClose.close();
        ScanMetrics scanMetricsWithClose = this.getScanMetrics(scanWithClose);
        Assert.assertEquals((String)"Did not access all the regions in the table", (long)numOfRegions, (long)scanMetricsWithClose.countOfRegions.get());
    }

    private ScanMetrics getScanMetrics(Scan scan) throws Exception {
        byte[] serializedMetrics = scan.getAttribute("scan.attributes.metrics.data");
        Assert.assertTrue((String)"Serialized metrics were not found.", (serializedMetrics != null ? 1 : 0) != 0);
        ScanMetrics scanMetrics = ProtobufUtil.toScanMetrics((byte[])serializedMetrics);
        return scanMetrics;
    }

    @Test
    public void testCacheOnWriteEvictOnClose() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        byte[] data = Bytes.toBytes((String)"data");
        Table table = TEST_UTIL.createTable(tableName, FAMILY);
        try (RegionLocator locator = TEST_UTIL.getConnection().getRegionLocator(tableName);){
            String regionName = ((HRegionLocation)locator.getAllRegionLocations().get(0)).getRegionInfo().getEncodedName();
            HRegion region = TEST_UTIL.getRSForFirstRegionInTable(tableName).getRegion(regionName);
            HStore store = (HStore)region.getStores().iterator().next();
            CacheConfig cacheConf = store.getCacheConfig();
            cacheConf.setCacheDataOnWrite(true);
            cacheConf.setEvictOnClose(true);
            BlockCache cache = cacheConf.getBlockCache();
            long startBlockCount = cache.getBlockCount();
            long startBlockHits = cache.getStats().getHitCount();
            long startBlockMiss = cache.getStats().getMissCount();
            for (int i = 0; i < 5; ++i) {
                Thread.sleep(100L);
                if (startBlockCount == cache.getBlockCount() && startBlockHits == cache.getStats().getHitCount() && startBlockMiss == cache.getStats().getMissCount()) continue;
                startBlockCount = cache.getBlockCount();
                startBlockHits = cache.getStats().getHitCount();
                startBlockMiss = cache.getStats().getMissCount();
                i = -1;
            }
            Put put = new Put(ROW);
            put.addColumn(FAMILY, QUALIFIER, data);
            table.put(put);
            Assert.assertTrue((boolean)Bytes.equals((byte[])table.get(new Get(ROW)).value(), (byte[])data));
            Assert.assertEquals((long)startBlockCount, (long)cache.getBlockCount());
            Assert.assertEquals((long)startBlockHits, (long)cache.getStats().getHitCount());
            Assert.assertEquals((long)startBlockMiss, (long)cache.getStats().getMissCount());
            System.out.println("Flushing cache");
            region.flush(true);
            long expectedBlockCount = startBlockCount + 1L;
            long expectedBlockHits = startBlockHits;
            long expectedBlockMiss = startBlockMiss;
            Assert.assertEquals((long)expectedBlockCount, (long)cache.getBlockCount());
            Assert.assertEquals((long)expectedBlockHits, (long)cache.getStats().getHitCount());
            Assert.assertEquals((long)expectedBlockMiss, (long)cache.getStats().getMissCount());
            Assert.assertTrue((boolean)Bytes.equals((byte[])table.get(new Get(ROW)).value(), (byte[])data));
            Assert.assertEquals((long)expectedBlockCount, (long)cache.getBlockCount());
            Assert.assertEquals((long)(++expectedBlockHits), (long)cache.getStats().getHitCount());
            Assert.assertEquals((long)expectedBlockMiss, (long)cache.getStats().getMissCount());
            byte[] QUALIFIER2 = Bytes.add((byte[])QUALIFIER, (byte[])QUALIFIER);
            byte[] data2 = Bytes.add((byte[])data, (byte[])data);
            put = new Put(ROW);
            put.addColumn(FAMILY, QUALIFIER2, data2);
            table.put(put);
            Result r = table.get(new Get(ROW));
            Assert.assertTrue((boolean)Bytes.equals((byte[])r.getValue(FAMILY, QUALIFIER), (byte[])data));
            Assert.assertTrue((boolean)Bytes.equals((byte[])r.getValue(FAMILY, QUALIFIER2), (byte[])data2));
            Assert.assertEquals((long)expectedBlockCount, (long)cache.getBlockCount());
            Assert.assertEquals((long)(++expectedBlockHits), (long)cache.getStats().getHitCount());
            Assert.assertEquals((long)expectedBlockMiss, (long)cache.getStats().getMissCount());
            System.out.println("Flushing cache");
            region.flush(true);
            Assert.assertEquals((long)(++expectedBlockCount), (long)cache.getBlockCount());
            Assert.assertEquals((long)expectedBlockHits, (long)cache.getStats().getHitCount());
            Assert.assertEquals((long)expectedBlockMiss, (long)cache.getStats().getMissCount());
            System.out.println("Compacting");
            Assert.assertEquals((long)2L, (long)store.getStorefilesCount());
            store.triggerMajorCompaction();
            region.compact(true);
            store.closeAndArchiveCompactedFiles();
            this.waitForStoreFileCount(store, 1, 10000);
            Assert.assertEquals((long)1L, (long)store.getStorefilesCount());
            Assert.assertEquals((long)(expectedBlockCount -= 2L), (long)cache.getBlockCount());
            Assert.assertEquals((long)expectedBlockMiss, (long)cache.getStats().getMissCount());
            Assert.assertEquals((long)(expectedBlockHits += 2L), (long)cache.getStats().getHitCount());
            r = table.get(new Get(ROW));
            Assert.assertTrue((boolean)Bytes.equals((byte[])r.getValue(FAMILY, QUALIFIER), (byte[])data));
            Assert.assertTrue((boolean)Bytes.equals((byte[])r.getValue(FAMILY, QUALIFIER2), (byte[])data2));
            Assert.assertEquals((long)(++expectedBlockCount), (long)cache.getBlockCount());
            Assert.assertEquals((long)expectedBlockHits, (long)cache.getStats().getHitCount());
            Assert.assertEquals((long)(++expectedBlockMiss), (long)cache.getStats().getMissCount());
        }
    }

    private void waitForStoreFileCount(HStore store, int count, int timeout) throws InterruptedException {
        long start = System.currentTimeMillis();
        while (start + (long)timeout > System.currentTimeMillis() && store.getStorefilesCount() != count) {
            Thread.sleep(100L);
        }
        System.out.println("start=" + start + ", now=" + System.currentTimeMillis() + ", cur=" + store.getStorefilesCount());
        Assert.assertEquals((long)count, (long)store.getStorefilesCount());
    }

    @Test
    public void testNonCachedGetRegionLocation() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        byte[] family1 = Bytes.toBytes((String)"f1");
        byte[] family2 = Bytes.toBytes((String)"f2");
        try (Table table = TEST_UTIL.createTable(tableName, (byte[][])new byte[][]{family1, family2}, 10);
             Admin admin = TEST_UTIL.getAdmin();
             RegionLocator locator = TEST_UTIL.getConnection().getRegionLocator(tableName);){
            List allRegionLocations = locator.getAllRegionLocations();
            Assert.assertEquals((long)1L, (long)allRegionLocations.size());
            HRegionInfo regionInfo = ((HRegionLocation)allRegionLocations.get(0)).getRegionInfo();
            ServerName addrBefore = ((HRegionLocation)allRegionLocations.get(0)).getServerName();
            HRegionLocation addrCache = locator.getRegionLocation(regionInfo.getStartKey(), false);
            HRegionLocation addrNoCache = locator.getRegionLocation(regionInfo.getStartKey(), true);
            Assert.assertEquals((long)addrBefore.getPort(), (long)addrCache.getPort());
            Assert.assertEquals((long)addrBefore.getPort(), (long)addrNoCache.getPort());
            ServerName addrAfter = null;
            for (int i = 0; i < SLAVES; ++i) {
                HRegionServer regionServer = TEST_UTIL.getHBaseCluster().getRegionServer(i);
                ServerName addr = regionServer.getServerName();
                if (addr.getPort() == addrBefore.getPort()) continue;
                admin.move(regionInfo.getEncodedNameAsBytes(), Bytes.toBytes((String)addr.toString()));
                Thread.sleep(5000L);
                addrAfter = addr;
                break;
            }
            addrCache = locator.getRegionLocation(regionInfo.getStartKey(), false);
            addrNoCache = locator.getRegionLocation(regionInfo.getStartKey(), true);
            Assert.assertNotNull(addrAfter);
            Assert.assertTrue((addrAfter.getPort() != addrCache.getPort() ? 1 : 0) != 0);
            Assert.assertEquals((long)addrAfter.getPort(), (long)addrNoCache.getPort());
        }
    }

    @Test
    public void testGetRegionsInRange() throws Exception {
        byte[] startKey = Bytes.toBytes((String)"ddc");
        byte[] endKey = Bytes.toBytes((String)"mmm");
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        TEST_UTIL.createMultiRegionTable(tableName, new byte[][]{FAMILY}, 10);
        int numOfRegions = -1;
        try (RegionLocator r = TEST_UTIL.getConnection().getRegionLocator(tableName);){
            numOfRegions = r.getStartKeys().length;
        }
        Assert.assertEquals((long)26L, (long)numOfRegions);
        List<HRegionLocation> regionsList = this.getRegionsInRange(tableName, startKey, endKey);
        Assert.assertEquals((long)10L, (long)regionsList.size());
        startKey = Bytes.toBytes((String)"fff");
        regionsList = this.getRegionsInRange(tableName, startKey, endKey);
        Assert.assertEquals((long)7L, (long)regionsList.size());
        endKey = Bytes.toBytes((String)"nnn");
        regionsList = this.getRegionsInRange(tableName, startKey, endKey);
        Assert.assertEquals((long)8L, (long)regionsList.size());
        regionsList = this.getRegionsInRange(tableName, HConstants.EMPTY_START_ROW, endKey);
        Assert.assertEquals((long)13L, (long)regionsList.size());
        regionsList = this.getRegionsInRange(tableName, startKey, HConstants.EMPTY_END_ROW);
        Assert.assertEquals((long)21L, (long)regionsList.size());
        regionsList = this.getRegionsInRange(tableName, HConstants.EMPTY_START_ROW, HConstants.EMPTY_END_ROW);
        Assert.assertEquals((long)26L, (long)regionsList.size());
        endKey = Bytes.toBytes((String)"zzz1");
        regionsList = this.getRegionsInRange(tableName, startKey, endKey);
        Assert.assertEquals((long)21L, (long)regionsList.size());
        startKey = Bytes.toBytes((String)"aac");
        regionsList = this.getRegionsInRange(tableName, startKey, endKey);
        Assert.assertEquals((long)26L, (long)regionsList.size());
        startKey = endKey = Bytes.toBytes((String)"ccc");
        regionsList = this.getRegionsInRange(tableName, startKey, endKey);
        Assert.assertEquals((long)1L, (long)regionsList.size());
    }

    private List<HRegionLocation> getRegionsInRange(TableName tableName, byte[] startKey, byte[] endKey) throws IOException {
        ArrayList<HRegionLocation> regionsInRange = new ArrayList<HRegionLocation>();
        byte[] currentKey = startKey;
        boolean endKeyIsEndOfTable = Bytes.equals((byte[])endKey, (byte[])HConstants.EMPTY_END_ROW);
        try (RegionLocator r = TEST_UTIL.getConnection().getRegionLocator(tableName);){
            HRegionLocation regionLocation;
            do {
                regionLocation = r.getRegionLocation(currentKey);
                regionsInRange.add(regionLocation);
            } while (!Bytes.equals((byte[])(currentKey = regionLocation.getRegionInfo().getEndKey()), (byte[])HConstants.EMPTY_END_ROW) && (endKeyIsEndOfTable || Bytes.compareTo((byte[])currentKey, (byte[])endKey) < 0));
            ArrayList<HRegionLocation> arrayList = regionsInRange;
            return arrayList;
        }
    }

    @Test
    public void testJira6912() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        Table foo = TEST_UTIL.createTable(tableName, (byte[][])new byte[][]{FAMILY}, 10);
        ArrayList<Put> puts = new ArrayList<Put>();
        for (int i = 0; i != 100; ++i) {
            Put put = new Put(Bytes.toBytes((int)i));
            put.addColumn(FAMILY, FAMILY, Bytes.toBytes((int)i));
            puts.add(put);
        }
        foo.put(puts);
        TEST_UTIL.flush();
        Scan scan = new Scan();
        scan.setStartRow(Bytes.toBytes((int)1));
        scan.setStopRow(Bytes.toBytes((int)3));
        scan.addColumn(FAMILY, FAMILY);
        scan.setFilter((Filter)new RowFilter(CompareOperator.NOT_EQUAL, (ByteArrayComparable)new BinaryComparator(Bytes.toBytes((int)1))));
        ResultScanner scanner = foo.getScanner(scan);
        Result[] bar = scanner.next(100);
        Assert.assertEquals((long)1L, (long)bar.length);
    }

    @Test
    public void testScan_NullQualifier() throws IOException {
        Table table = TEST_UTIL.createTable(TableName.valueOf((String)this.name.getMethodName()), FAMILY);
        Put put = new Put(ROW);
        put.addColumn(FAMILY, QUALIFIER, VALUE);
        table.put(put);
        put = new Put(ROW);
        put.addColumn(FAMILY, null, VALUE);
        table.put(put);
        LOG.info("Row put");
        Scan scan = new Scan();
        scan.addColumn(FAMILY, null);
        ResultScanner scanner = table.getScanner(scan);
        Result[] bar = scanner.next(100);
        Assert.assertEquals((long)1L, (long)bar.length);
        Assert.assertEquals((long)1L, (long)bar[0].size());
        scan = new Scan();
        scan.addFamily(FAMILY);
        scanner = table.getScanner(scan);
        bar = scanner.next(100);
        Assert.assertEquals((long)1L, (long)bar.length);
        Assert.assertEquals((long)2L, (long)bar[0].size());
    }

    @Test
    public void testNegativeTimestamp() throws IOException {
        Delete delete;
        Put put;
        Table table = TEST_UTIL.createTable(TableName.valueOf((String)this.name.getMethodName()), FAMILY);
        try {
            put = new Put(ROW, -1L);
            put.addColumn(FAMILY, QUALIFIER, VALUE);
            table.put(put);
            Assert.fail((String)"Negative timestamps should not have been allowed");
        }
        catch (IllegalArgumentException ex) {
            Assert.assertTrue((boolean)ex.getMessage().contains("negative"));
        }
        try {
            put = new Put(ROW);
            long ts = -1L;
            put.addColumn(FAMILY, QUALIFIER, ts, VALUE);
            table.put(put);
            Assert.fail((String)"Negative timestamps should not have been allowed");
        }
        catch (IllegalArgumentException ex) {
            Assert.assertTrue((boolean)ex.getMessage().contains("negative"));
        }
        try {
            delete = new Delete(ROW, -1L);
            table.delete(delete);
            Assert.fail((String)"Negative timestamps should not have been allowed");
        }
        catch (IllegalArgumentException ex) {
            Assert.assertTrue((boolean)ex.getMessage().contains("negative"));
        }
        try {
            delete = new Delete(ROW);
            delete.addFamily(FAMILY, -1L);
            table.delete(delete);
            Assert.fail((String)"Negative timestamps should not have been allowed");
        }
        catch (IllegalArgumentException ex) {
            Assert.assertTrue((boolean)ex.getMessage().contains("negative"));
        }
        try {
            Scan scan = new Scan();
            scan.setTimeRange(-1L, 1L);
            table.getScanner(scan);
            Assert.fail((String)"Negative timestamps should not have been allowed");
        }
        catch (IllegalArgumentException ex) {
            Assert.assertTrue((boolean)ex.getMessage().contains("negative"));
        }
        try {
            new KeyValue(Bytes.toBytes((int)42), Bytes.toBytes((int)42), Bytes.toBytes((int)42), -1L, Bytes.toBytes((int)42));
        }
        catch (IllegalArgumentException ex) {
            Assert.fail((String)"KeyValue SHOULD allow negative timestamps");
        }
        table.close();
    }

    @Test
    public void testRawScanRespectsVersions() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        Table table = TEST_UTIL.createTable(tableName, FAMILY);
        byte[] row = Bytes.toBytes((String)"row");
        Put p = new Put(row);
        p.addColumn(FAMILY, QUALIFIER, 10L, VALUE);
        table.put(p);
        p = new Put(row);
        p.addColumn(FAMILY, QUALIFIER, 11L, ArrayUtils.add((byte[])VALUE, (byte)2));
        table.put(p);
        p = new Put(row);
        p.addColumn(FAMILY, QUALIFIER, 12L, ArrayUtils.add((byte[])VALUE, (byte)3));
        table.put(p);
        p = new Put(row);
        p.addColumn(FAMILY, QUALIFIER, 13L, ArrayUtils.add((byte[])VALUE, (byte)4));
        table.put(p);
        int versions = 4;
        Scan s = new Scan(row);
        s.setMaxVersions();
        s.setRaw(true);
        ResultScanner scanner = table.getScanner(s);
        int count = 0;
        for (Result r : scanner) {
            Assert.assertEquals((String)"Found an unexpected number of results for the row!", (long)versions, (long)r.listCells().size());
            ++count;
        }
        Assert.assertEquals((String)"Found more than a single row when raw scanning the table with a single row!", (long)1L, (long)count);
        scanner.close();
        versions = 2;
        s.setMaxVersions(versions);
        scanner = table.getScanner(s);
        count = 0;
        for (Result r : scanner) {
            Assert.assertEquals((String)"Found an unexpected number of results for the row!", (long)versions, (long)r.listCells().size());
            ++count;
        }
        Assert.assertEquals((String)"Found more than a single row when raw scanning the table with a single row!", (long)1L, (long)count);
        scanner.close();
        versions = 3;
        s.setMaxVersions(versions);
        scanner = table.getScanner(s);
        count = 0;
        for (Result r : scanner) {
            Assert.assertEquals((String)"Found an unexpected number of results for the row!", (long)versions, (long)r.listCells().size());
            ++count;
        }
        Assert.assertEquals((String)"Found more than a single row when raw scanning the table with a single row!", (long)1L, (long)count);
        scanner.close();
        table.close();
        TEST_UTIL.deleteTable(tableName);
    }

    @Test
    public void testEmptyFilterList() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        Table table = TEST_UTIL.createTable(tableName, FAMILY);
        Put put = new Put(Bytes.toBytes((String)"row"));
        put.addColumn(FAMILY, QUALIFIER, VALUE);
        table.put(put);
        LinkedList<Result> scanResults = new LinkedList<Result>();
        Scan scan = new Scan();
        scan.setFilter((Filter)new FilterList(new Filter[0]));
        try (ResultScanner scanner = table.getScanner(scan);){
            for (Result r : scanner) {
                scanResults.add(r);
            }
        }
        Assert.assertEquals((long)1L, (long)scanResults.size());
        Get g = new Get(Bytes.toBytes((String)"row"));
        g.setFilter((Filter)new FilterList(new Filter[0]));
        Result getResult = table.get(g);
        Result scanResult = (Result)scanResults.get(0);
        Assert.assertEquals((long)scanResult.rawCells().length, (long)getResult.rawCells().length);
        for (int i = 0; i != scanResult.rawCells().length; ++i) {
            Cell scanCell = scanResult.rawCells()[i];
            Cell getCell = getResult.rawCells()[i];
            Assert.assertEquals((long)0L, (long)Bytes.compareTo((byte[])CellUtil.cloneRow((Cell)scanCell), (byte[])CellUtil.cloneRow((Cell)getCell)));
            Assert.assertEquals((long)0L, (long)Bytes.compareTo((byte[])CellUtil.cloneFamily((Cell)scanCell), (byte[])CellUtil.cloneFamily((Cell)getCell)));
            Assert.assertEquals((long)0L, (long)Bytes.compareTo((byte[])CellUtil.cloneQualifier((Cell)scanCell), (byte[])CellUtil.cloneQualifier((Cell)getCell)));
            Assert.assertEquals((long)0L, (long)Bytes.compareTo((byte[])CellUtil.cloneValue((Cell)scanCell), (byte[])CellUtil.cloneValue((Cell)getCell)));
        }
    }

    @Test
    public void testSmallScan() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        Table table = TEST_UTIL.createTable(tableName, FAMILY);
        int insertNum = 10;
        for (int i = 0; i < 10; ++i) {
            Put put = new Put(Bytes.toBytes((String)("row" + String.format("%03d", i))));
            put.addColumn(FAMILY, QUALIFIER, VALUE);
            table.put(put);
        }
        ResultScanner scanner = table.getScanner(new Scan());
        int count = 0;
        for (Result r : scanner) {
            Assert.assertTrue((!r.isEmpty() ? 1 : 0) != 0);
            ++count;
        }
        Assert.assertEquals((long)insertNum, (long)count);
        Scan scan = new Scan(HConstants.EMPTY_START_ROW, HConstants.EMPTY_END_ROW);
        scan.setSmall(true);
        scan.setCaching(2);
        scanner = table.getScanner(scan);
        count = 0;
        for (Result r : scanner) {
            Assert.assertTrue((!r.isEmpty() ? 1 : 0) != 0);
            ++count;
        }
        Assert.assertEquals((long)insertNum, (long)count);
    }

    @Test
    public void testSuperSimpleWithReverseScan() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        Table ht = TEST_UTIL.createTable(tableName, FAMILY);
        Put put = new Put(Bytes.toBytes((String)"0-b11111-0000000000000000000"));
        put.addColumn(FAMILY, QUALIFIER, VALUE);
        ht.put(put);
        put = new Put(Bytes.toBytes((String)"0-b11111-0000000000000000002"));
        put.addColumn(FAMILY, QUALIFIER, VALUE);
        ht.put(put);
        put = new Put(Bytes.toBytes((String)"0-b11111-0000000000000000004"));
        put.addColumn(FAMILY, QUALIFIER, VALUE);
        ht.put(put);
        put = new Put(Bytes.toBytes((String)"0-b11111-0000000000000000006"));
        put.addColumn(FAMILY, QUALIFIER, VALUE);
        ht.put(put);
        put = new Put(Bytes.toBytes((String)"0-b11111-0000000000000000008"));
        put.addColumn(FAMILY, QUALIFIER, VALUE);
        ht.put(put);
        put = new Put(Bytes.toBytes((String)"0-b22222-0000000000000000001"));
        put.addColumn(FAMILY, QUALIFIER, VALUE);
        ht.put(put);
        put = new Put(Bytes.toBytes((String)"0-b22222-0000000000000000003"));
        put.addColumn(FAMILY, QUALIFIER, VALUE);
        ht.put(put);
        put = new Put(Bytes.toBytes((String)"0-b22222-0000000000000000005"));
        put.addColumn(FAMILY, QUALIFIER, VALUE);
        ht.put(put);
        put = new Put(Bytes.toBytes((String)"0-b22222-0000000000000000007"));
        put.addColumn(FAMILY, QUALIFIER, VALUE);
        ht.put(put);
        put = new Put(Bytes.toBytes((String)"0-b22222-0000000000000000009"));
        put.addColumn(FAMILY, QUALIFIER, VALUE);
        ht.put(put);
        Scan scan = new Scan(Bytes.toBytes((String)"0-b11111-9223372036854775807"), Bytes.toBytes((String)"0-b11111-0000000000000000000"));
        scan.setReversed(true);
        ResultScanner scanner = ht.getScanner(scan);
        Result result = scanner.next();
        Assert.assertTrue((boolean)Bytes.equals((byte[])result.getRow(), (byte[])Bytes.toBytes((String)"0-b11111-0000000000000000008")));
        scanner.close();
        ht.close();
    }

    @Test
    public void testFiltersWithReverseScan() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        Table ht = TEST_UTIL.createTable(tableName, FAMILY);
        byte[][] ROWS = this.makeN(ROW, 10);
        byte[][] QUALIFIERS = new byte[][]{Bytes.toBytes((String)"col0-<d2v1>-<d3v2>"), Bytes.toBytes((String)"col1-<d2v1>-<d3v2>"), Bytes.toBytes((String)"col2-<d2v1>-<d3v2>"), Bytes.toBytes((String)"col3-<d2v1>-<d3v2>"), Bytes.toBytes((String)"col4-<d2v1>-<d3v2>"), Bytes.toBytes((String)"col5-<d2v1>-<d3v2>"), Bytes.toBytes((String)"col6-<d2v1>-<d3v2>"), Bytes.toBytes((String)"col7-<d2v1>-<d3v2>"), Bytes.toBytes((String)"col8-<d2v1>-<d3v2>"), Bytes.toBytes((String)"col9-<d2v1>-<d3v2>")};
        for (int i = 0; i < 10; ++i) {
            Put put = new Put(ROWS[i]);
            put.addColumn(FAMILY, QUALIFIERS[i], VALUE);
            ht.put(put);
        }
        Scan scan = new Scan();
        scan.setReversed(true);
        scan.addFamily(FAMILY);
        QualifierFilter filter = new QualifierFilter(CompareOperator.EQUAL, (ByteArrayComparable)new RegexStringComparator("col[1-5]"));
        scan.setFilter((Filter)filter);
        ResultScanner scanner = ht.getScanner(scan);
        int expectedIndex = 5;
        for (Result result : scanner) {
            Assert.assertEquals((long)1L, (long)result.size());
            Cell c = result.rawCells()[0];
            Assert.assertTrue((boolean)Bytes.equals((byte[])c.getRowArray(), (int)c.getRowOffset(), (int)c.getRowLength(), (byte[])ROWS[expectedIndex], (int)0, (int)ROWS[expectedIndex].length));
            Assert.assertTrue((boolean)Bytes.equals((byte[])c.getQualifierArray(), (int)c.getQualifierOffset(), (int)c.getQualifierLength(), (byte[])QUALIFIERS[expectedIndex], (int)0, (int)QUALIFIERS[expectedIndex].length));
            --expectedIndex;
        }
        Assert.assertEquals((long)0L, (long)expectedIndex);
        scanner.close();
        ht.close();
    }

    @Test
    public void testKeyOnlyFilterWithReverseScan() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        Table ht = TEST_UTIL.createTable(tableName, FAMILY);
        byte[][] ROWS = this.makeN(ROW, 10);
        byte[][] QUALIFIERS = new byte[][]{Bytes.toBytes((String)"col0-<d2v1>-<d3v2>"), Bytes.toBytes((String)"col1-<d2v1>-<d3v2>"), Bytes.toBytes((String)"col2-<d2v1>-<d3v2>"), Bytes.toBytes((String)"col3-<d2v1>-<d3v2>"), Bytes.toBytes((String)"col4-<d2v1>-<d3v2>"), Bytes.toBytes((String)"col5-<d2v1>-<d3v2>"), Bytes.toBytes((String)"col6-<d2v1>-<d3v2>"), Bytes.toBytes((String)"col7-<d2v1>-<d3v2>"), Bytes.toBytes((String)"col8-<d2v1>-<d3v2>"), Bytes.toBytes((String)"col9-<d2v1>-<d3v2>")};
        for (int i = 0; i < 10; ++i) {
            Put put = new Put(ROWS[i]);
            put.addColumn(FAMILY, QUALIFIERS[i], VALUE);
            ht.put(put);
        }
        Scan scan = new Scan();
        scan.setReversed(true);
        scan.addFamily(FAMILY);
        KeyOnlyFilter filter = new KeyOnlyFilter(true);
        scan.setFilter((Filter)filter);
        ResultScanner scanner = ht.getScanner(scan);
        int count = 0;
        for (Result result : ht.getScanner(scan)) {
            Assert.assertEquals((long)1L, (long)result.size());
            Assert.assertEquals((long)4L, (long)result.rawCells()[0].getValueLength());
            Assert.assertEquals((long)VALUE.length, (long)Bytes.toInt((byte[])CellUtil.cloneValue((Cell)result.rawCells()[0])));
            ++count;
        }
        Assert.assertEquals((long)10L, (long)count);
        scanner.close();
        ht.close();
    }

    @Test
    public void testSimpleMissingWithReverseScan() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        Table ht = TEST_UTIL.createTable(tableName, FAMILY);
        byte[][] ROWS = this.makeN(ROW, 4);
        Scan scan = new Scan();
        scan.setReversed(true);
        Result result = this.getSingleScanResult(ht, scan);
        this.assertNullResult(result);
        scan = new Scan(ROWS[0]);
        scan.setReversed(true);
        result = this.getSingleScanResult(ht, scan);
        this.assertNullResult(result);
        scan = new Scan(ROWS[0], ROWS[1]);
        scan.setReversed(true);
        result = this.getSingleScanResult(ht, scan);
        this.assertNullResult(result);
        scan = new Scan();
        scan.setReversed(true);
        scan.addFamily(FAMILY);
        result = this.getSingleScanResult(ht, scan);
        this.assertNullResult(result);
        scan = new Scan();
        scan.setReversed(true);
        scan.addColumn(FAMILY, QUALIFIER);
        result = this.getSingleScanResult(ht, scan);
        this.assertNullResult(result);
        Put put = new Put(ROWS[2]);
        put.addColumn(FAMILY, QUALIFIER, VALUE);
        ht.put(put);
        scan = new Scan();
        scan.setReversed(true);
        result = this.getSingleScanResult(ht, scan);
        this.assertSingleResult(result, ROWS[2], FAMILY, QUALIFIER, VALUE);
        scan = new Scan(ROWS[3], ROWS[0]);
        scan.setReversed(true);
        result = this.getSingleScanResult(ht, scan);
        this.assertSingleResult(result, ROWS[2], FAMILY, QUALIFIER, VALUE);
        scan = new Scan(ROWS[2], ROWS[1]);
        scan.setReversed(true);
        result = this.getSingleScanResult(ht, scan);
        this.assertSingleResult(result, ROWS[2], FAMILY, QUALIFIER, VALUE);
        scan = new Scan(ROWS[1]);
        scan.setReversed(true);
        result = this.getSingleScanResult(ht, scan);
        this.assertNullResult(result);
        ht.close();
    }

    @Test
    public void testNullWithReverseScan() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        Table ht = TEST_UTIL.createTable(tableName, FAMILY);
        Put put = new Put(ROW);
        put.addColumn(FAMILY, null, VALUE);
        ht.put(put);
        this.scanTestNull(ht, ROW, FAMILY, VALUE, true);
        Delete delete = new Delete(ROW);
        delete.addColumns(FAMILY, null);
        ht.delete(delete);
        ht = TEST_UTIL.createTable(TableName.valueOf((String)(this.name.getMethodName() + "2")), FAMILY);
        put = new Put(ROW);
        put.addColumn(FAMILY, HConstants.EMPTY_BYTE_ARRAY, VALUE);
        ht.put(put);
        this.scanTestNull(ht, ROW, FAMILY, VALUE, true);
        TEST_UTIL.flush();
        this.scanTestNull(ht, ROW, FAMILY, VALUE, true);
        delete = new Delete(ROW);
        delete.addColumns(FAMILY, HConstants.EMPTY_BYTE_ARRAY);
        ht.delete(delete);
        put = new Put(ROW);
        put.addColumn(FAMILY, QUALIFIER, null);
        ht.put(put);
        Scan scan = new Scan();
        scan.setReversed(true);
        scan.addColumn(FAMILY, QUALIFIER);
        Result result = this.getSingleScanResult(ht, scan);
        this.assertSingleResult(result, ROW, FAMILY, QUALIFIER, null);
        ht.close();
    }

    @Test
    public void testDeletesWithReverseScan() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        byte[][] ROWS = this.makeNAscii(ROW, 6);
        byte[][] FAMILIES = this.makeNAscii(FAMILY, 3);
        byte[][] VALUES = this.makeN(VALUE, 5);
        long[] ts = new long[]{1000L, 2000L, 3000L, 4000L, 5000L};
        Table ht = TEST_UTIL.createTable(tableName, FAMILIES, 3);
        Put put = new Put(ROW);
        put.addColumn(FAMILIES[0], QUALIFIER, ts[0], VALUES[0]);
        put.addColumn(FAMILIES[0], QUALIFIER, ts[1], VALUES[1]);
        ht.put(put);
        Delete delete = new Delete(ROW);
        delete.addFamily(FAMILIES[0], ts[0]);
        ht.delete(delete);
        Scan scan = new Scan(ROW);
        scan.setReversed(true);
        scan.addFamily(FAMILIES[0]);
        scan.setMaxVersions(Integer.MAX_VALUE);
        Result result = this.getSingleScanResult(ht, scan);
        this.assertNResult(result, ROW, FAMILIES[0], QUALIFIER, new long[]{ts[1]}, new byte[][]{VALUES[1]}, 0, 0);
        put = new Put(ROW);
        put.addColumn(FAMILIES[0], QUALIFIER, ts[4], VALUES[4]);
        put.addColumn(FAMILIES[0], QUALIFIER, ts[2], VALUES[2]);
        put.addColumn(FAMILIES[0], QUALIFIER, ts[3], VALUES[3]);
        put.addColumn(FAMILIES[0], null, ts[4], VALUES[4]);
        put.addColumn(FAMILIES[0], null, ts[2], VALUES[2]);
        put.addColumn(FAMILIES[0], null, ts[3], VALUES[3]);
        ht.put(put);
        delete = new Delete(ROW);
        delete.addColumn(FAMILIES[0], QUALIFIER);
        ht.delete(delete);
        scan = new Scan(ROW);
        scan.setReversed(true);
        scan.addColumn(FAMILIES[0], QUALIFIER);
        scan.setMaxVersions(Integer.MAX_VALUE);
        result = this.getSingleScanResult(ht, scan);
        this.assertNResult(result, ROW, FAMILIES[0], QUALIFIER, new long[]{ts[1], ts[2], ts[3]}, new byte[][]{VALUES[1], VALUES[2], VALUES[3]}, 0, 2);
        delete = new Delete(ROW);
        delete.addColumn(FAMILIES[0], null);
        ht.delete(delete);
        delete = new Delete(ROW);
        delete.addColumns(FAMILIES[0], null);
        ht.delete(delete);
        put = new Put(ROW);
        put.addColumn(FAMILIES[0], QUALIFIER, ts[0], VALUES[0]);
        put.addColumn(FAMILIES[0], QUALIFIER, ts[4], VALUES[4]);
        ht.put(put);
        scan = new Scan(ROW);
        scan.setReversed(true);
        scan.addFamily(FAMILIES[0]);
        scan.setMaxVersions(Integer.MAX_VALUE);
        result = this.getSingleScanResult(ht, scan);
        this.assertNResult(result, ROW, FAMILIES[0], QUALIFIER, new long[]{ts[1], ts[2], ts[3]}, new byte[][]{VALUES[1], VALUES[2], VALUES[3]}, 0, 2);
        put = new Put(ROWS[0]);
        put.addColumn(FAMILIES[1], QUALIFIER, ts[0], VALUES[0]);
        put.addColumn(FAMILIES[1], QUALIFIER, ts[1], VALUES[1]);
        put.addColumn(FAMILIES[2], QUALIFIER, ts[2], VALUES[2]);
        put.addColumn(FAMILIES[2], QUALIFIER, ts[3], VALUES[3]);
        ht.put(put);
        put = new Put(ROWS[1]);
        put.addColumn(FAMILIES[1], QUALIFIER, ts[0], VALUES[0]);
        put.addColumn(FAMILIES[1], QUALIFIER, ts[1], VALUES[1]);
        put.addColumn(FAMILIES[2], QUALIFIER, ts[2], VALUES[2]);
        put.addColumn(FAMILIES[2], QUALIFIER, ts[3], VALUES[3]);
        ht.put(put);
        put = new Put(ROWS[2]);
        put.addColumn(FAMILIES[1], QUALIFIER, ts[0], VALUES[0]);
        put.addColumn(FAMILIES[1], QUALIFIER, ts[1], VALUES[1]);
        put.addColumn(FAMILIES[2], QUALIFIER, ts[2], VALUES[2]);
        put.addColumn(FAMILIES[2], QUALIFIER, ts[3], VALUES[3]);
        ht.put(put);
        delete = new Delete(ROWS[0]);
        delete.addFamily(FAMILIES[2]);
        ht.delete(delete);
        delete = new Delete(ROWS[1]);
        delete.addColumns(FAMILIES[1], QUALIFIER);
        ht.delete(delete);
        delete = new Delete(ROWS[2]);
        delete.addColumn(FAMILIES[1], QUALIFIER);
        delete.addColumn(FAMILIES[1], QUALIFIER);
        delete.addColumn(FAMILIES[2], QUALIFIER);
        ht.delete(delete);
        scan = new Scan(ROWS[0]);
        scan.setReversed(true);
        scan.addFamily(FAMILIES[1]);
        scan.addFamily(FAMILIES[2]);
        scan.setMaxVersions(Integer.MAX_VALUE);
        result = this.getSingleScanResult(ht, scan);
        Assert.assertTrue((String)("Expected 2 keys but received " + result.size()), (result.size() == 2 ? 1 : 0) != 0);
        this.assertNResult(result, ROWS[0], FAMILIES[1], QUALIFIER, new long[]{ts[0], ts[1]}, new byte[][]{VALUES[0], VALUES[1]}, 0, 1);
        scan = new Scan(ROWS[1]);
        scan.setReversed(true);
        scan.addFamily(FAMILIES[1]);
        scan.addFamily(FAMILIES[2]);
        scan.setMaxVersions(Integer.MAX_VALUE);
        result = this.getSingleScanResult(ht, scan);
        Assert.assertTrue((String)("Expected 2 keys but received " + result.size()), (result.size() == 2 ? 1 : 0) != 0);
        scan = new Scan(ROWS[2]);
        scan.setReversed(true);
        scan.addFamily(FAMILIES[1]);
        scan.addFamily(FAMILIES[2]);
        scan.setMaxVersions(Integer.MAX_VALUE);
        result = this.getSingleScanResult(ht, scan);
        Assert.assertEquals((long)1L, (long)result.size());
        this.assertNResult(result, ROWS[2], FAMILIES[2], QUALIFIER, new long[]{ts[2]}, new byte[][]{VALUES[2]}, 0, 0);
        delete = new Delete(ROWS[3]);
        delete.addFamily(FAMILIES[1]);
        ht.delete(delete);
        put = new Put(ROWS[3]);
        put.addColumn(FAMILIES[2], QUALIFIER, VALUES[0]);
        ht.put(put);
        put = new Put(ROWS[4]);
        put.addColumn(FAMILIES[1], QUALIFIER, VALUES[1]);
        put.addColumn(FAMILIES[2], QUALIFIER, VALUES[2]);
        ht.put(put);
        scan = new Scan(ROWS[4]);
        scan.setReversed(true);
        scan.addFamily(FAMILIES[1]);
        scan.addFamily(FAMILIES[2]);
        scan.setMaxVersions(Integer.MAX_VALUE);
        ResultScanner scanner = ht.getScanner(scan);
        result = scanner.next();
        Assert.assertTrue((String)("Expected 2 keys but received " + result.size()), (result.size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)Bytes.equals((byte[])CellUtil.cloneRow((Cell)result.rawCells()[0]), (byte[])ROWS[4]));
        Assert.assertTrue((boolean)Bytes.equals((byte[])CellUtil.cloneRow((Cell)result.rawCells()[1]), (byte[])ROWS[4]));
        Assert.assertTrue((boolean)Bytes.equals((byte[])CellUtil.cloneValue((Cell)result.rawCells()[0]), (byte[])VALUES[1]));
        Assert.assertTrue((boolean)Bytes.equals((byte[])CellUtil.cloneValue((Cell)result.rawCells()[1]), (byte[])VALUES[2]));
        result = scanner.next();
        Assert.assertTrue((String)("Expected 1 key but received " + result.size()), (result.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)Bytes.equals((byte[])CellUtil.cloneRow((Cell)result.rawCells()[0]), (byte[])ROWS[3]));
        Assert.assertTrue((boolean)Bytes.equals((byte[])CellUtil.cloneValue((Cell)result.rawCells()[0]), (byte[])VALUES[0]));
        scanner.close();
        ht.close();
    }

    @Test
    public void testReversedScanUnderMultiRegions() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        byte[] maxByteArray = ConnectionUtils.MAX_BYTE_ARRAY;
        byte[][] splitRows = new byte[][]{Bytes.toBytes((String)"005"), Bytes.add((byte[])Bytes.toBytes((String)"005"), (byte[])Bytes.multiple((byte[])maxByteArray, (int)16)), Bytes.toBytes((String)"006"), Bytes.add((byte[])Bytes.toBytes((String)"006"), (byte[])Bytes.multiple((byte[])maxByteArray, (int)8)), Bytes.toBytes((String)"007"), Bytes.add((byte[])Bytes.toBytes((String)"007"), (byte[])Bytes.multiple((byte[])maxByteArray, (int)4)), Bytes.toBytes((String)"008"), Bytes.multiple((byte[])maxByteArray, (int)2)};
        Table table = TEST_UTIL.createTable(tableName, FAMILY, (byte[][])splitRows);
        TEST_UTIL.waitUntilAllRegionsAssigned(table.getName());
        try (RegionLocator l = TEST_UTIL.getConnection().getRegionLocator(tableName);){
            Assert.assertEquals((long)(splitRows.length + 1), (long)l.getAllRegionLocations().size());
        }
        int insertNum = splitRows.length;
        for (int i = 0; i < insertNum; ++i) {
            Put put = new Put(splitRows[i]);
            put.addColumn(FAMILY, QUALIFIER, VALUE);
            table.put(put);
        }
        ResultScanner scanner = table.getScanner(new Scan());
        int count = 0;
        for (Result r : scanner) {
            Assert.assertTrue((!r.isEmpty() ? 1 : 0) != 0);
            ++count;
        }
        Assert.assertEquals((long)insertNum, (long)count);
        Scan scan = new Scan();
        scan.setReversed(true);
        scanner = table.getScanner(scan);
        count = 0;
        byte[] lastRow = null;
        for (Result r : scanner) {
            Assert.assertTrue((!r.isEmpty() ? 1 : 0) != 0);
            ++count;
            byte[] thisRow = r.getRow();
            if (lastRow != null) {
                Assert.assertTrue((String)("Error scan order, last row= " + Bytes.toString((byte[])lastRow) + ",this row=" + Bytes.toString((byte[])thisRow)), (Bytes.compareTo((byte[])thisRow, (byte[])lastRow) < 0 ? 1 : 0) != 0);
            }
            lastRow = thisRow;
        }
        Assert.assertEquals((long)insertNum, (long)count);
        table.close();
    }

    @Test
    public void testSmallReversedScanUnderMultiRegions() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        byte[][] splitRows = new byte[][]{Bytes.toBytes((String)"000"), Bytes.toBytes((String)"002"), Bytes.toBytes((String)"004"), Bytes.toBytes((String)"006"), Bytes.toBytes((String)"008"), Bytes.toBytes((String)"010")};
        Table table = TEST_UTIL.createTable(tableName, FAMILY, (byte[][])splitRows);
        TEST_UTIL.waitUntilAllRegionsAssigned(table.getName());
        try (RegionLocator regionLocator = TEST_UTIL.getConnection().getRegionLocator(tableName);){
            Assert.assertEquals((long)(splitRows.length + 1), (long)regionLocator.getAllRegionLocations().size());
        }
        for (byte[] splitRow : splitRows) {
            Put put = new Put(splitRow);
            put.addColumn(FAMILY, QUALIFIER, VALUE);
            table.put(put);
            byte[] nextRow = Bytes.copy((byte[])splitRow);
            int n = nextRow.length - 1;
            nextRow[n] = (byte)(nextRow[n] + 1);
            put = new Put(nextRow);
            put.addColumn(FAMILY, QUALIFIER, VALUE);
            table.put(put);
        }
        ResultScanner resultScanner = table.getScanner(new Scan());
        int count = 0;
        for (Result r : resultScanner) {
            Assert.assertTrue((!r.isEmpty() ? 1 : 0) != 0);
            ++count;
        }
        Assert.assertEquals((long)12L, (long)count);
        this.reverseScanTest(table, false);
        this.reverseScanTest(table, true);
        table.close();
    }

    private void reverseScanTest(Table table, boolean small) throws IOException {
        byte[] thisRow;
        Scan scan = new Scan();
        scan.setReversed(true);
        ResultScanner scanner = table.getScanner(scan);
        int count = 0;
        byte[] lastRow = null;
        for (Result r : scanner) {
            Assert.assertTrue((!r.isEmpty() ? 1 : 0) != 0);
            ++count;
            thisRow = r.getRow();
            if (lastRow != null) {
                Assert.assertTrue((String)("Error scan order, last row= " + Bytes.toString((byte[])lastRow) + ",this row=" + Bytes.toString((byte[])thisRow)), (Bytes.compareTo((byte[])thisRow, (byte[])lastRow) < 0 ? 1 : 0) != 0);
            }
            lastRow = thisRow;
        }
        Assert.assertEquals((long)12L, (long)count);
        scan = new Scan();
        scan.setSmall(small);
        scan.setReversed(true);
        scan.setStartRow(Bytes.toBytes((String)"002"));
        scanner = table.getScanner(scan);
        count = 0;
        lastRow = null;
        for (Result r : scanner) {
            Assert.assertTrue((!r.isEmpty() ? 1 : 0) != 0);
            ++count;
            thisRow = r.getRow();
            if (lastRow != null) {
                Assert.assertTrue((String)("Error scan order, last row= " + Bytes.toString((byte[])lastRow) + ",this row=" + Bytes.toString((byte[])thisRow)), (Bytes.compareTo((byte[])thisRow, (byte[])lastRow) < 0 ? 1 : 0) != 0);
            }
            lastRow = thisRow;
        }
        Assert.assertEquals((long)3L, (long)count);
        scan = new Scan();
        scan.setSmall(small);
        scan.setReversed(true);
        scan.setStartRow(Bytes.toBytes((String)"002"));
        scan.setStopRow(Bytes.toBytes((String)"000"));
        scanner = table.getScanner(scan);
        count = 0;
        lastRow = null;
        for (Result r : scanner) {
            Assert.assertTrue((!r.isEmpty() ? 1 : 0) != 0);
            ++count;
            thisRow = r.getRow();
            if (lastRow != null) {
                Assert.assertTrue((String)("Error scan order, last row= " + Bytes.toString((byte[])lastRow) + ",this row=" + Bytes.toString((byte[])thisRow)), (Bytes.compareTo((byte[])thisRow, (byte[])lastRow) < 0 ? 1 : 0) != 0);
            }
            lastRow = thisRow;
        }
        Assert.assertEquals((long)2L, (long)count);
        scan = new Scan();
        scan.setSmall(small);
        scan.setReversed(true);
        scan.setStartRow(Bytes.toBytes((String)"001"));
        scanner = table.getScanner(scan);
        count = 0;
        lastRow = null;
        for (Result r : scanner) {
            Assert.assertTrue((!r.isEmpty() ? 1 : 0) != 0);
            ++count;
            thisRow = r.getRow();
            if (lastRow != null) {
                Assert.assertTrue((String)("Error scan order, last row= " + Bytes.toString((byte[])lastRow) + ",this row=" + Bytes.toString((byte[])thisRow)), (Bytes.compareTo((byte[])thisRow, (byte[])lastRow) < 0 ? 1 : 0) != 0);
            }
            lastRow = thisRow;
        }
        Assert.assertEquals((long)2L, (long)count);
        scan = new Scan();
        scan.setSmall(small);
        scan.setReversed(true);
        scan.setStartRow(Bytes.toBytes((String)"000"));
        scanner = table.getScanner(scan);
        count = 0;
        lastRow = null;
        for (Result r : scanner) {
            Assert.assertTrue((!r.isEmpty() ? 1 : 0) != 0);
            ++count;
            thisRow = r.getRow();
            if (lastRow != null) {
                Assert.assertTrue((String)("Error scan order, last row= " + Bytes.toString((byte[])lastRow) + ",this row=" + Bytes.toString((byte[])thisRow)), (Bytes.compareTo((byte[])thisRow, (byte[])lastRow) < 0 ? 1 : 0) != 0);
            }
            lastRow = thisRow;
        }
        Assert.assertEquals((long)1L, (long)count);
        scan = new Scan();
        scan.setSmall(small);
        scan.setReversed(true);
        scan.setStartRow(Bytes.toBytes((String)"006"));
        scan.setStopRow(Bytes.toBytes((String)"002"));
        scanner = table.getScanner(scan);
        count = 0;
        lastRow = null;
        for (Result r : scanner) {
            Assert.assertTrue((!r.isEmpty() ? 1 : 0) != 0);
            ++count;
            thisRow = r.getRow();
            if (lastRow != null) {
                Assert.assertTrue((String)("Error scan order, last row= " + Bytes.toString((byte[])lastRow) + ",this row=" + Bytes.toString((byte[])thisRow)), (Bytes.compareTo((byte[])thisRow, (byte[])lastRow) < 0 ? 1 : 0) != 0);
            }
            lastRow = thisRow;
        }
        Assert.assertEquals((long)4L, (long)count);
    }

    @Test
    public void testGetStartEndKeysWithRegionReplicas() throws IOException {
        HTableDescriptor htd = new HTableDescriptor(TableName.valueOf((String)this.name.getMethodName()));
        HColumnDescriptor fam = new HColumnDescriptor(FAMILY);
        htd.addFamily(fam);
        byte[][] KEYS = HBaseTestingUtility.KEYS_FOR_HBA_CREATE_TABLE;
        Admin admin = TEST_UTIL.getAdmin();
        admin.createTable((TableDescriptor)htd, KEYS);
        List regions = admin.getTableRegions(htd.getTableName());
        HRegionLocator locator = (HRegionLocator)admin.getConnection().getRegionLocator(htd.getTableName());
        for (int regionReplication = 1; regionReplication < 4; ++regionReplication) {
            ArrayList<RegionLocations> regionLocations = new ArrayList<RegionLocations>();
            for (HRegionInfo region : regions) {
                HRegionLocation[] arr = new HRegionLocation[regionReplication];
                for (int i = 0; i < arr.length; ++i) {
                    arr[i] = new HRegionLocation(RegionReplicaUtil.getRegionInfoForReplica((RegionInfo)region, (int)i), null);
                }
                regionLocations.add(new RegionLocations(arr));
            }
            Pair startEndKeys = locator.getStartEndKeys(regionLocations);
            Assert.assertEquals((long)(KEYS.length + 1), (long)((byte[][])startEndKeys.getFirst()).length);
            for (int i = 0; i < KEYS.length + 1; ++i) {
                byte[] startKey = i == 0 ? HConstants.EMPTY_START_ROW : KEYS[i - 1];
                byte[] endKey = i == KEYS.length ? HConstants.EMPTY_END_ROW : KEYS[i];
                Assert.assertArrayEquals((byte[])startKey, (byte[])((byte[][])startEndKeys.getFirst())[i]);
                Assert.assertArrayEquals((byte[])endKey, (byte[])((byte[][])startEndKeys.getSecond())[i]);
            }
        }
    }

    @Test
    public void testFilterAllRecords() throws IOException {
        Scan scan = new Scan();
        scan.setBatch(1);
        scan.setCaching(1);
        scan.setFilter((Filter)new FilterList(new Filter[]{new FirstKeyOnlyFilter(), new InclusiveStopFilter(new byte[0])}));
        try (Table table = TEST_UTIL.getConnection().getTable(TableName.NAMESPACE_TABLE_NAME);
             ResultScanner s = table.getScanner(scan);){
            Assert.assertNull((Object)s.next());
        }
    }

    @Test
    public void testRegionCache() throws IOException {
        HTableDescriptor htd = new HTableDescriptor(TableName.valueOf((String)this.name.getMethodName()));
        HColumnDescriptor fam = new HColumnDescriptor(FAMILY);
        htd.addFamily(fam);
        byte[][] KEYS = HBaseTestingUtility.KEYS_FOR_HBA_CREATE_TABLE;
        Admin admin = TEST_UTIL.getAdmin();
        admin.createTable((TableDescriptor)htd, KEYS);
        HRegionLocator locator = (HRegionLocator)admin.getConnection().getRegionLocator(htd.getTableName());
        List results = locator.getAllRegionLocations();
        int number = ((ConnectionImplementation)admin.getConnection()).getNumberOfCachedRegionLocations(htd.getTableName());
        Assert.assertEquals((long)results.size(), (long)number);
    }

    @Test
    public void testCellSizeLimit() throws IOException {
        TableName tableName = TableName.valueOf((String)"testCellSizeLimit");
        HTableDescriptor htd = new HTableDescriptor(tableName);
        htd.setConfiguration("hbase.server.keyvalue.maxsize", Integer.toString(10240));
        HColumnDescriptor fam = new HColumnDescriptor(FAMILY);
        htd.addFamily(fam);
        Admin admin = TEST_UTIL.getAdmin();
        admin.createTable((TableDescriptor)htd);
        try (Table t = TEST_UTIL.getConnection().getTable(tableName);){
            t.put(new Put(ROW).addColumn(FAMILY, QUALIFIER, Bytes.toBytes((long)0L)));
            t.increment(new Increment(ROW).addColumn(FAMILY, QUALIFIER, 1L));
        }
        t = TEST_UTIL.getConnection().getTable(tableName);
        var6_6 = null;
        try {
            t.put(new Put(ROW).addColumn(FAMILY, QUALIFIER, new byte[9216]));
        }
        catch (Throwable throwable) {
            var6_6 = throwable;
            throw throwable;
        }
        finally {
            if (t != null) {
                if (var6_6 != null) {
                    try {
                        t.close();
                    }
                    catch (Throwable throwable) {
                        var6_6.addSuppressed(throwable);
                    }
                } else {
                    t.close();
                }
            }
        }
        t = TEST_UTIL.getConnection().getTable(tableName);
        var6_6 = null;
        try {
            try {
                t.put(new Put(ROW).addColumn(FAMILY, QUALIFIER, new byte[10240]));
                Assert.fail((String)"Oversize cell failed to trigger exception");
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                t.append(new Append(ROW).addColumn(FAMILY, QUALIFIER, new byte[10240]));
                Assert.fail((String)"Oversize cell failed to trigger exception");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        catch (Throwable throwable) {
            var6_6 = throwable;
            throw throwable;
        }
        finally {
            if (t != null) {
                if (var6_6 != null) {
                    try {
                        t.close();
                    }
                    catch (Throwable throwable) {
                        var6_6.addSuppressed(throwable);
                    }
                } else {
                    t.close();
                }
            }
        }
    }

    @Test
    public void testDeleteSpecifiedVersionOfSpecifiedColumn() throws Exception {
        Admin admin = TEST_UTIL.getAdmin();
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        byte[][] VALUES = this.makeN(VALUE, 5);
        long[] ts = new long[]{1000L, 2000L, 3000L, 4000L, 5000L};
        Table ht = TEST_UTIL.createTable(tableName, FAMILY, 5);
        Put put = new Put(ROW);
        for (int t = 0; t < 4; ++t) {
            put.addColumn(FAMILY, QUALIFIER, ts[t], VALUES[t]);
        }
        ht.put(put);
        Delete delete = new Delete(ROW);
        delete.addColumn(FAMILY, QUALIFIER, ts[2]);
        ht.delete(delete);
        Get get = new Get(ROW);
        get.addColumn(FAMILY, QUALIFIER);
        get.setMaxVersions(Integer.MAX_VALUE);
        Result result = ht.get(get);
        this.assertNResult(result, ROW, FAMILY, QUALIFIER, new long[]{ts[0], ts[1], ts[3]}, new byte[][]{VALUES[0], VALUES[1], VALUES[3]}, 0, 2);
        delete = new Delete(ROW);
        delete.addColumn(FAMILY, QUALIFIER, ts[4]);
        ht.delete(delete);
        get = new Get(ROW);
        get.addColumn(FAMILY, QUALIFIER);
        get.setMaxVersions(Integer.MAX_VALUE);
        result = ht.get(get);
        this.assertNResult(result, ROW, FAMILY, QUALIFIER, new long[]{ts[0], ts[1], ts[3]}, new byte[][]{VALUES[0], VALUES[1], VALUES[3]}, 0, 2);
        ht.close();
        admin.close();
    }

    @Test
    public void testDeleteLatestVersionOfSpecifiedColumn() throws Exception {
        Admin admin = TEST_UTIL.getAdmin();
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        byte[][] VALUES = this.makeN(VALUE, 5);
        long[] ts = new long[]{1000L, 2000L, 3000L, 4000L, 5000L};
        Table ht = TEST_UTIL.createTable(tableName, FAMILY, 5);
        Put put = new Put(ROW);
        for (int t = 0; t < 4; ++t) {
            put.addColumn(FAMILY, QUALIFIER, ts[t], VALUES[t]);
        }
        ht.put(put);
        Delete delete = new Delete(ROW);
        delete.addColumn(FAMILY, QUALIFIER);
        ht.delete(delete);
        Get get = new Get(ROW);
        get.addColumn(FAMILY, QUALIFIER);
        get.setMaxVersions(Integer.MAX_VALUE);
        Result result = ht.get(get);
        this.assertNResult(result, ROW, FAMILY, QUALIFIER, new long[]{ts[0], ts[1], ts[2]}, new byte[][]{VALUES[0], VALUES[1], VALUES[2]}, 0, 2);
        delete = new Delete(ROW);
        delete.addColumn(FAMILY, QUALIFIER);
        delete.addColumn(FAMILY, QUALIFIER);
        ht.delete(delete);
        get = new Get(ROW);
        get.addColumn(FAMILY, QUALIFIER);
        get.setMaxVersions(Integer.MAX_VALUE);
        result = ht.get(get);
        this.assertNResult(result, ROW, FAMILY, QUALIFIER, new long[]{ts[0]}, new byte[][]{VALUES[0]}, 0, 0);
        put = new Put(ROW);
        put.addColumn(FAMILY, QUALIFIER, ts[4], VALUES[4]);
        ht.put(put);
        get = new Get(ROW);
        get.addColumn(FAMILY, QUALIFIER);
        get.setMaxVersions(Integer.MAX_VALUE);
        result = ht.get(get);
        this.assertNResult(result, ROW, FAMILY, QUALIFIER, new long[]{ts[0], ts[4]}, new byte[][]{VALUES[0], VALUES[4]}, 0, 1);
        ht.close();
        admin.close();
    }

    @Test
    public void testReadWithFilter() throws Exception {
        Admin admin = TEST_UTIL.getAdmin();
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        Table table = TEST_UTIL.createTable(tableName, FAMILY, 3);
        byte[] VALUEA = Bytes.toBytes((String)"value-a");
        byte[] VALUEB = Bytes.toBytes((String)"value-b");
        long[] ts = new long[]{1000L, 2000L, 3000L, 4000L};
        Put put = new Put(ROW);
        for (int t = 0; t <= 3; ++t) {
            if (t <= 1) {
                put.addColumn(FAMILY, QUALIFIER, ts[t], VALUEA);
                continue;
            }
            put.addColumn(FAMILY, QUALIFIER, ts[t], VALUEB);
        }
        table.put(put);
        Scan scan = new Scan().setFilter((Filter)new ValueFilter(CompareOperator.EQUAL, (ByteArrayComparable)new SubstringComparator("value-a"))).setMaxVersions(3);
        ResultScanner scanner = table.getScanner(scan);
        Result result = scanner.next();
        this.assertNResult(result, ROW, FAMILY, QUALIFIER, new long[]{ts[1]}, new byte[][]{VALUEA}, 0, 0);
        Get get = new Get(ROW).setFilter((Filter)new ValueFilter(CompareOperator.EQUAL, (ByteArrayComparable)new SubstringComparator("value-a"))).setMaxVersions(3);
        result = table.get(get);
        this.assertNResult(result, ROW, FAMILY, QUALIFIER, new long[]{ts[1]}, new byte[][]{VALUEA}, 0, 0);
        scan = new Scan().setFilter((Filter)new ValueFilter(CompareOperator.EQUAL, (ByteArrayComparable)new SubstringComparator("value-a"))).setMaxVersions(1);
        scanner = table.getScanner(scan);
        result = scanner.next();
        this.assertNResult(result, ROW, FAMILY, QUALIFIER, new long[]{ts[1]}, new byte[][]{VALUEA}, 0, 0);
        get = new Get(ROW).setFilter((Filter)new ValueFilter(CompareOperator.EQUAL, (ByteArrayComparable)new SubstringComparator("value-a"))).setMaxVersions(1);
        result = table.get(get);
        this.assertNResult(result, ROW, FAMILY, QUALIFIER, new long[]{ts[1]}, new byte[][]{VALUEA}, 0, 0);
        scan = new Scan().setFilter((Filter)new ValueFilter(CompareOperator.EQUAL, (ByteArrayComparable)new SubstringComparator("value-a"))).setMaxVersions(5);
        scanner = table.getScanner(scan);
        result = scanner.next();
        this.assertNResult(result, ROW, FAMILY, QUALIFIER, new long[]{ts[1]}, new byte[][]{VALUEA}, 0, 0);
        get = new Get(ROW).setFilter((Filter)new ValueFilter(CompareOperator.EQUAL, (ByteArrayComparable)new SubstringComparator("value-a"))).setMaxVersions(5);
        result = table.get(get);
        this.assertNResult(result, ROW, FAMILY, QUALIFIER, new long[]{ts[1]}, new byte[][]{VALUEA}, 0, 0);
        table.close();
        admin.close();
    }

    @Test
    public void testCellUtilTypeMethods() throws IOException {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        Table table = TEST_UTIL.createTable(tableName, FAMILY);
        byte[] row = Bytes.toBytes((String)"p");
        Put p = new Put(row);
        p.addColumn(FAMILY, QUALIFIER, VALUE);
        table.put(p);
        try (ResultScanner scanner = table.getScanner(new Scan());){
            Result result = scanner.next();
            Assert.assertNotNull((Object)result);
            CellScanner cs = result.cellScanner();
            Assert.assertTrue((boolean)cs.advance());
            Cell c = cs.current();
            Assert.assertTrue((boolean)CellUtil.isPut((Cell)c));
            Assert.assertFalse((boolean)CellUtil.isDelete((Cell)c));
            Assert.assertFalse((boolean)cs.advance());
            Assert.assertNull((Object)scanner.next());
        }
        Delete d = new Delete(row);
        d.addColumn(FAMILY, QUALIFIER);
        table.delete(d);
        Scan scan = new Scan();
        scan.setRaw(true);
        try (ResultScanner scanner = table.getScanner(scan);){
            Result result = scanner.next();
            Assert.assertNotNull((Object)result);
            CellScanner cs = result.cellScanner();
            Assert.assertTrue((boolean)cs.advance());
            Cell c = cs.current();
            Assert.assertTrue((String)("Cell should be a Delete: " + c), (boolean)CellUtil.isDelete((Cell)c));
            Assert.assertFalse((String)("Cell should not be a Put: " + c), (boolean)CellUtil.isPut((Cell)c));
            Assert.assertTrue((boolean)cs.advance());
            c = cs.current();
            Assert.assertFalse((String)("Cell should not be a Delete: " + c), (boolean)CellUtil.isDelete((Cell)c));
            Assert.assertTrue((String)("Cell should be a Put: " + c), (boolean)CellUtil.isPut((Cell)c));
            Assert.assertFalse((boolean)cs.advance());
            Assert.assertNull((Object)scanner.next());
        }
    }
}

