/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.master.ServerManager;
import org.apache.hadoop.hbase.master.assignment.RegionStates;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.zookeeper.MetaTableLocator;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.apache.hadoop.hbase.zookeeper.ZNodePaths;
import org.apache.zookeeper.KeeperException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MediumTests.class})
public class TestMetaShutdownHandler {
    private static final Logger LOG = LoggerFactory.getLogger(TestMetaShutdownHandler.class);
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestMetaShutdownHandler.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    static final Configuration conf = TEST_UTIL.getConfiguration();

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.startMiniCluster(1, 3, null, null, MyRegionServer.class);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testExpireMetaRegionServer() throws Exception {
        MiniHBaseCluster cluster = TEST_UTIL.getHBaseCluster();
        HMaster master = cluster.getMaster();
        RegionStates regionStates = master.getAssignmentManager().getRegionStates();
        ServerName metaServerName = regionStates.getRegionServerOfRegion((RegionInfo)HRegionInfo.FIRST_META_REGIONINFO);
        if (master.getServerName().equals((Object)metaServerName) || metaServerName == null || !metaServerName.equals((Object)cluster.getServerHoldingMeta())) {
            metaServerName = cluster.getLiveRegionServerThreads().get(0).getRegionServer().getServerName();
            master.move(HRegionInfo.FIRST_META_REGIONINFO.getEncodedNameAsBytes(), Bytes.toBytes((String)metaServerName.getServerName()));
            TEST_UTIL.waitUntilNoRegionsInTransition(60000L);
            metaServerName = regionStates.getRegionServerOfRegion((RegionInfo)HRegionInfo.FIRST_META_REGIONINFO);
        }
        RegionState metaState = MetaTableLocator.getMetaRegionState((ZKWatcher)master.getZooKeeper());
        Assert.assertEquals((String)"Wrong state for meta!", (Object)RegionState.State.OPEN, (Object)metaState.getState());
        Assert.assertNotEquals((String)"Meta is on master!", (Object)metaServerName, (Object)master.getServerName());
        String rsEphemeralNodePath = ZNodePaths.joinZNode((String)master.getZooKeeper().getZNodePaths().rsZNode, (String)metaServerName.toString());
        ZKUtil.deleteNode((ZKWatcher)master.getZooKeeper(), (String)rsEphemeralNodePath);
        LOG.info("Deleted the znode for the RegionServer hosting hbase:meta; waiting on SSH");
        final ServerManager serverManager = master.getServerManager();
        final ServerName priorMetaServerName = metaServerName;
        TEST_UTIL.waitFor(120000L, 200L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                return !serverManager.isServerOnline(priorMetaServerName) && !serverManager.areDeadServersInProgress();
            }
        });
        LOG.info("Past wait on RIT");
        TEST_UTIL.waitUntilNoRegionsInTransition(60000L);
        Assert.assertTrue((String)"Meta should be assigned", (boolean)regionStates.isRegionOnline((RegionInfo)HRegionInfo.FIRST_META_REGIONINFO));
        metaState = MetaTableLocator.getMetaRegionState((ZKWatcher)master.getZooKeeper());
        Assert.assertEquals((String)"Meta should not be in transition", (Object)RegionState.State.OPEN, (Object)metaState.getState());
        Assert.assertEquals((String)"Meta should be assigned", (Object)metaState.getServerName(), (Object)regionStates.getRegionServerOfRegion((RegionInfo)HRegionInfo.FIRST_META_REGIONINFO));
        Assert.assertNotEquals((String)"Meta should be assigned on a different server", (Object)metaState.getServerName(), (Object)metaServerName);
    }

    public static class MyRegionServer
    extends MiniHBaseCluster.MiniHBaseClusterRegionServer {
        public MyRegionServer(Configuration conf) throws IOException, KeeperException, InterruptedException {
            super(conf);
        }

        @Override
        public void abort(String reason, Throwable cause) {
            try {
                Thread.sleep(30000L);
            }
            catch (InterruptedException e) {
                return;
            }
            super.abort(reason, cause);
        }
    }
}

