/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.master.locking.LockProcedure;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureScheduler;
import org.apache.hadoop.hbase.master.procedure.PeerProcedureInterface;
import org.apache.hadoop.hbase.master.procedure.TableProcedureInterface;
import org.apache.hadoop.hbase.procedure2.AbstractProcedureScheduler;
import org.apache.hadoop.hbase.procedure2.LockType;
import org.apache.hadoop.hbase.procedure2.LockedResource;
import org.apache.hadoop.hbase.procedure2.LockedResourceType;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureEvent;
import org.apache.hadoop.hbase.procedure2.ProcedureTestingUtility;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MasterTests.class, SmallTests.class})
public class TestMasterProcedureScheduler {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestMasterProcedureScheduler.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestMasterProcedureScheduler.class);
    private MasterProcedureScheduler queue;
    @Rule
    public TestName name = new TestName();

    @Before
    public void setUp() throws IOException {
        this.queue = new MasterProcedureScheduler();
        this.queue.start();
    }

    @After
    public void tearDown() throws IOException {
        Assert.assertEquals((String)"proc-queue expected to be empty", (long)0L, (long)this.queue.size());
        this.queue.stop();
        this.queue.clear();
    }

    @Test
    public void testSimpleTableOpsQueues() throws Exception {
        int i;
        int NUM_TABLES = 10;
        int NUM_ITEMS = 10;
        int count = 0;
        for (i = 1; i <= 10; ++i) {
            TableName tableName = TableName.valueOf((String)String.format("test-%04d", i));
            for (int j = 1; j <= 10; ++j) {
                this.queue.addBack((Procedure)new TestTableProcedure(i * 1000 + j, tableName, TableProcedureInterface.TableOperationType.EDIT));
                Assert.assertEquals((long)(++count), (long)this.queue.size());
            }
        }
        Assert.assertEquals((long)100L, (long)this.queue.size());
        for (int j = 1; j <= 10; ++j) {
            for (int i2 = 1; i2 <= 10; ++i2) {
                Procedure proc = this.queue.poll();
                Assert.assertTrue((proc != null ? 1 : 0) != 0);
                TableName tableName = ((TestTableProcedure)proc).getTableName();
                this.queue.waitTableExclusiveLock(proc, tableName);
                this.queue.wakeTableExclusiveLock(proc, tableName);
                this.queue.completionCleanup(proc);
                Assert.assertEquals((long)(--count), (long)this.queue.size());
                Assert.assertEquals((long)(i2 * 1000 + j), (long)proc.getProcId());
            }
        }
        Assert.assertEquals((long)0L, (long)this.queue.size());
        for (i = 1; i <= 10; ++i) {
            TableName tableName = TableName.valueOf((String)String.format("test-%04d", i));
            TestTableProcedure dummyProc = new TestTableProcedure(100L, tableName, TableProcedureInterface.TableOperationType.DELETE);
            Assert.assertTrue((boolean)this.queue.markTableAsDeleted(tableName, (Procedure)dummyProc));
        }
    }

    @Test
    public void testCreateDeleteTableOperationsWithWriteLock() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        TestTableProcedure dummyProc = new TestTableProcedure(100L, tableName, TableProcedureInterface.TableOperationType.DELETE);
        this.queue.addBack((Procedure)new TestTableProcedure(1L, tableName, TableProcedureInterface.TableOperationType.EDIT));
        Assert.assertFalse((boolean)this.queue.markTableAsDeleted(tableName, (Procedure)dummyProc));
        Procedure proc = this.queue.poll();
        Assert.assertEquals((long)1L, (long)proc.getProcId());
        Assert.assertEquals((Object)false, (Object)this.queue.waitTableExclusiveLock(proc, tableName));
        Assert.assertEquals((long)0L, (long)this.queue.size());
        Assert.assertFalse((boolean)this.queue.markTableAsDeleted(tableName, (Procedure)dummyProc));
        this.queue.wakeTableExclusiveLock(proc, tableName);
        Assert.assertTrue((boolean)this.queue.markTableAsDeleted(tableName, proc));
    }

    @Test
    public void testCreateDeleteTableOperationsWithReadLock() throws Exception {
        int i;
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        int nitems = 2;
        TestTableProcedure dummyProc = new TestTableProcedure(100L, tableName, TableProcedureInterface.TableOperationType.DELETE);
        for (int i2 = 1; i2 <= 2; ++i2) {
            this.queue.addBack((Procedure)new TestTableProcedure(i2, tableName, TableProcedureInterface.TableOperationType.READ));
        }
        Assert.assertFalse((boolean)this.queue.markTableAsDeleted(tableName, (Procedure)dummyProc));
        Procedure[] procs = new Procedure[2];
        for (i = 0; i < 2; ++i) {
            Procedure proc = procs[i] = this.queue.poll();
            Assert.assertEquals((long)(i + 1), (long)proc.getProcId());
            Assert.assertEquals((Object)false, (Object)this.queue.waitTableSharedLock(proc, tableName));
            Assert.assertFalse((boolean)this.queue.markTableAsDeleted(tableName, (Procedure)dummyProc));
        }
        for (i = 0; i < 2; ++i) {
            Assert.assertFalse((boolean)this.queue.markTableAsDeleted(tableName, (Procedure)dummyProc));
            this.queue.wakeTableSharedLock(procs[i], tableName);
        }
        Assert.assertEquals((long)0L, (long)this.queue.size());
        Assert.assertTrue((boolean)this.queue.markTableAsDeleted(tableName, (Procedure)dummyProc));
    }

    @Test
    public void testVerifyRwLocks() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        this.queue.addBack((Procedure)new TestTableProcedure(1L, tableName, TableProcedureInterface.TableOperationType.EDIT));
        this.queue.addBack((Procedure)new TestTableProcedure(2L, tableName, TableProcedureInterface.TableOperationType.READ));
        this.queue.addBack((Procedure)new TestTableProcedure(3L, tableName, TableProcedureInterface.TableOperationType.EDIT));
        this.queue.addBack((Procedure)new TestTableProcedure(4L, tableName, TableProcedureInterface.TableOperationType.READ));
        this.queue.addBack((Procedure)new TestTableProcedure(5L, tableName, TableProcedureInterface.TableOperationType.READ));
        Procedure proc = this.queue.poll();
        Assert.assertEquals((long)1L, (long)proc.getProcId());
        Assert.assertEquals((Object)false, (Object)this.queue.waitTableExclusiveLock(proc, tableName));
        Assert.assertEquals(null, (Object)this.queue.poll(0L));
        this.queue.wakeTableExclusiveLock(proc, tableName);
        Procedure rdProc = this.queue.poll();
        Assert.assertEquals((long)2L, (long)rdProc.getProcId());
        Assert.assertEquals((Object)false, (Object)this.queue.waitTableSharedLock(rdProc, tableName));
        Assert.assertEquals(null, (Object)this.queue.poll(0L));
        this.queue.wakeTableSharedLock(rdProc, tableName);
        Procedure wrProc = this.queue.poll();
        Assert.assertEquals((Object)false, (Object)this.queue.waitTableExclusiveLock(wrProc, tableName));
        Assert.assertEquals(null, (Object)this.queue.poll(0L));
        this.queue.wakeTableExclusiveLock(wrProc, tableName);
        rdProc = this.queue.poll();
        Assert.assertEquals((long)4L, (long)rdProc.getProcId());
        Assert.assertEquals((Object)false, (Object)this.queue.waitTableSharedLock(rdProc, tableName));
        Procedure rdProc2 = this.queue.poll();
        Assert.assertEquals((long)5L, (long)rdProc2.getProcId());
        Assert.assertEquals((Object)false, (Object)this.queue.waitTableSharedLock(rdProc2, tableName));
        this.queue.wakeTableSharedLock(rdProc, tableName);
        this.queue.wakeTableSharedLock(rdProc2, tableName);
        Assert.assertEquals((long)0L, (long)this.queue.size());
        Assert.assertTrue((String)"queue should be deleted", (boolean)this.queue.markTableAsDeleted(tableName, wrProc));
    }

    @Test
    public void testVerifyNamespaceRwLocks() throws Exception {
        String nsName1 = "ns1";
        String nsName2 = "ns2";
        TableName tableName1 = TableName.valueOf((String)nsName1, (String)this.name.getMethodName());
        TableName tableName2 = TableName.valueOf((String)nsName2, (String)this.name.getMethodName());
        this.queue.addBack((Procedure)new TestNamespaceProcedure(1L, nsName1, TableProcedureInterface.TableOperationType.EDIT));
        this.queue.addBack((Procedure)new TestTableProcedure(2L, tableName1, TableProcedureInterface.TableOperationType.EDIT));
        this.queue.addBack((Procedure)new TestTableProcedure(3L, tableName2, TableProcedureInterface.TableOperationType.EDIT));
        this.queue.addBack((Procedure)new TestNamespaceProcedure(4L, nsName2, TableProcedureInterface.TableOperationType.EDIT));
        Procedure procNs1 = this.queue.poll();
        Assert.assertEquals((long)1L, (long)procNs1.getProcId());
        Assert.assertFalse((boolean)this.queue.waitNamespaceExclusiveLock(procNs1, nsName1));
        Procedure procNs2 = this.queue.poll();
        Assert.assertEquals((long)4L, (long)procNs2.getProcId());
        Assert.assertFalse((boolean)this.queue.waitNamespaceExclusiveLock(procNs2, nsName2));
        this.queue.wakeNamespaceExclusiveLock(procNs2, nsName2);
        this.queue.yield(procNs2);
        procNs2 = this.queue.poll();
        Assert.assertEquals((long)4L, (long)procNs2.getProcId());
        Assert.assertFalse((boolean)this.queue.waitNamespaceExclusiveLock(procNs2, nsName2));
        Assert.assertNull((Object)this.queue.poll());
        this.queue.wakeNamespaceExclusiveLock(procNs1, nsName1);
        long procId = this.queue.poll().getProcId();
        Assert.assertEquals((long)2L, (long)procId);
        this.queue.wakeNamespaceExclusiveLock(procNs2, nsName2);
        procId = this.queue.poll().getProcId();
        Assert.assertEquals((long)3L, (long)procId);
    }

    @Test
    public void testVerifyNamespaceXLock() throws Exception {
        String nsName = "ns1";
        TableName tableName = TableName.valueOf((String)nsName, (String)this.name.getMethodName());
        this.queue.addBack((Procedure)new TestNamespaceProcedure(1L, nsName, TableProcedureInterface.TableOperationType.CREATE));
        this.queue.addBack((Procedure)new TestTableProcedure(2L, tableName, TableProcedureInterface.TableOperationType.READ));
        Procedure proc = this.queue.poll();
        Assert.assertEquals((long)1L, (long)proc.getProcId());
        Assert.assertEquals((Object)false, (Object)this.queue.waitNamespaceExclusiveLock(proc, nsName));
        Assert.assertEquals(null, (Object)this.queue.poll(0L));
        this.queue.wakeNamespaceExclusiveLock(proc, nsName);
        proc = this.queue.poll();
        Assert.assertEquals((long)2L, (long)proc.getProcId());
        Assert.assertEquals((Object)false, (Object)this.queue.waitTableExclusiveLock(proc, tableName));
        this.queue.wakeTableExclusiveLock(proc, tableName);
    }

    @Test
    public void testXLockWaitingForExecutingSharedLockToRelease() {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        HRegionInfo regionA = new HRegionInfo(tableName, Bytes.toBytes((String)"a"), Bytes.toBytes((String)"b"));
        this.queue.addBack((Procedure)new TestRegionProcedure(1L, tableName, TableProcedureInterface.TableOperationType.REGION_ASSIGN, regionA));
        this.queue.addBack((Procedure)new TestTableProcedure(2L, tableName, TableProcedureInterface.TableOperationType.EDIT));
        this.queue.addBack((Procedure)new TestRegionProcedure(3L, tableName, TableProcedureInterface.TableOperationType.REGION_UNASSIGN, regionA));
        Procedure proc = this.queue.poll();
        Assert.assertEquals((long)1L, (long)proc.getProcId());
        Assert.assertEquals((Object)false, (Object)this.queue.waitRegion(proc, (RegionInfo)regionA));
        Assert.assertEquals(null, (Object)this.queue.poll(0L));
        this.queue.wakeRegion(proc, (RegionInfo)regionA);
        proc = this.queue.poll();
        Assert.assertEquals((long)2L, (long)proc.getProcId());
        Assert.assertEquals((Object)false, (Object)this.queue.waitTableExclusiveLock(proc, tableName));
        Assert.assertEquals(null, (Object)this.queue.poll(0L));
        this.queue.wakeTableExclusiveLock(proc, tableName);
        proc = this.queue.poll();
        Assert.assertEquals((long)3L, (long)proc.getProcId());
        Assert.assertEquals((Object)false, (Object)this.queue.waitRegion(proc, (RegionInfo)regionA));
        Assert.assertEquals(null, (Object)this.queue.poll(0L));
        this.queue.wakeRegion(proc, (RegionInfo)regionA);
    }

    @Test
    public void testVerifyRegionLocks() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        HRegionInfo regionA = new HRegionInfo(tableName, Bytes.toBytes((String)"a"), Bytes.toBytes((String)"b"));
        HRegionInfo regionB = new HRegionInfo(tableName, Bytes.toBytes((String)"b"), Bytes.toBytes((String)"c"));
        HRegionInfo regionC = new HRegionInfo(tableName, Bytes.toBytes((String)"c"), Bytes.toBytes((String)"d"));
        this.queue.addBack((Procedure)new TestTableProcedure(1L, tableName, TableProcedureInterface.TableOperationType.EDIT));
        this.queue.addBack((Procedure)new TestRegionProcedure(2L, tableName, TableProcedureInterface.TableOperationType.REGION_MERGE, regionA, regionB));
        this.queue.addBack((Procedure)new TestRegionProcedure(3L, tableName, TableProcedureInterface.TableOperationType.REGION_SPLIT, regionA));
        this.queue.addBack((Procedure)new TestRegionProcedure(4L, tableName, TableProcedureInterface.TableOperationType.REGION_SPLIT, regionB));
        this.queue.addBack((Procedure)new TestRegionProcedure(5L, tableName, TableProcedureInterface.TableOperationType.REGION_UNASSIGN, regionC));
        Procedure proc = this.queue.poll();
        Assert.assertEquals((long)1L, (long)proc.getProcId());
        Assert.assertEquals((Object)false, (Object)this.queue.waitTableExclusiveLock(proc, tableName));
        Assert.assertEquals(null, (Object)this.queue.poll(0L));
        this.queue.wakeTableExclusiveLock(proc, tableName);
        Procedure mergeProc = this.queue.poll();
        Assert.assertEquals((long)2L, (long)mergeProc.getProcId());
        Assert.assertEquals((Object)false, (Object)this.queue.waitRegions(mergeProc, tableName, new RegionInfo[]{regionA, regionB}));
        Procedure procA = this.queue.poll();
        Assert.assertEquals((long)3L, (long)procA.getProcId());
        Assert.assertEquals((Object)true, (Object)this.queue.waitRegions(procA, tableName, new RegionInfo[]{regionA}));
        Procedure procB = this.queue.poll();
        Assert.assertEquals((long)4L, (long)procB.getProcId());
        Assert.assertEquals((Object)true, (Object)this.queue.waitRegions(procB, tableName, new RegionInfo[]{regionB}));
        Procedure procC = this.queue.poll();
        Assert.assertEquals((long)5L, (long)procC.getProcId());
        Assert.assertEquals((Object)false, (Object)this.queue.waitRegions(procC, tableName, new RegionInfo[]{regionC}));
        Assert.assertEquals(null, (Object)this.queue.poll(0L));
        this.queue.wakeRegions(mergeProc, tableName, new RegionInfo[]{regionA, regionB});
        procA = this.queue.poll();
        Assert.assertEquals((long)3L, (long)procA.getProcId());
        Assert.assertEquals((Object)false, (Object)this.queue.waitRegions(procA, tableName, new RegionInfo[]{regionA}));
        procB = this.queue.poll();
        Assert.assertEquals((long)4L, (long)procB.getProcId());
        Assert.assertEquals((Object)false, (Object)this.queue.waitRegions(procB, tableName, new RegionInfo[]{regionB}));
        this.queue.wakeRegions(procA, tableName, new RegionInfo[]{regionA});
        this.queue.wakeRegions(procB, tableName, new RegionInfo[]{regionB});
        this.queue.wakeRegions(procC, tableName, new RegionInfo[]{regionC});
    }

    @Test
    public void testVerifySubProcRegionLocks() throws Exception {
        TestRegionProcedure regionProc;
        int i;
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        HRegionInfo regionA = new HRegionInfo(tableName, Bytes.toBytes((String)"a"), Bytes.toBytes((String)"b"));
        HRegionInfo regionB = new HRegionInfo(tableName, Bytes.toBytes((String)"b"), Bytes.toBytes((String)"c"));
        HRegionInfo regionC = new HRegionInfo(tableName, Bytes.toBytes((String)"c"), Bytes.toBytes((String)"d"));
        this.queue.addBack((Procedure)new TestTableProcedure(1L, tableName, TableProcedureInterface.TableOperationType.ENABLE));
        Procedure rootProc = this.queue.poll();
        Assert.assertEquals((long)1L, (long)rootProc.getProcId());
        Assert.assertEquals((Object)false, (Object)this.queue.waitTableExclusiveLock(rootProc, tableName));
        Assert.assertEquals(null, (Object)this.queue.poll(0L));
        Procedure[] subProcs = new Procedure[]{new TestRegionProcedure(1L, 2L, tableName, TableProcedureInterface.TableOperationType.REGION_EDIT, regionA), new TestRegionProcedure(1L, 3L, tableName, TableProcedureInterface.TableOperationType.REGION_EDIT, regionB), new TestRegionProcedure(1L, 4L, tableName, TableProcedureInterface.TableOperationType.REGION_EDIT, regionC)};
        for (i = subProcs.length - 1; i >= 0; --i) {
            this.queue.addFront(subProcs[i]);
        }
        Assert.assertEquals((long)subProcs.length, (long)this.queue.size());
        for (i = 0; i < subProcs.length; ++i) {
            regionProc = (TestRegionProcedure)this.queue.poll(0L);
            Assert.assertEquals((long)subProcs[i].getProcId(), (long)regionProc.getProcId());
            Assert.assertEquals((Object)false, (Object)this.queue.waitRegions((Procedure)regionProc, tableName, (RegionInfo[])regionProc.getRegionInfo()));
        }
        Assert.assertEquals(null, (Object)this.queue.poll(0L));
        for (i = 0; i < subProcs.length; ++i) {
            regionProc = (TestRegionProcedure)subProcs[i];
            this.queue.wakeRegions((Procedure)regionProc, tableName, (RegionInfo[])regionProc.getRegionInfo());
        }
        Assert.assertEquals(null, (Object)this.queue.poll(0L));
        this.queue.wakeTableExclusiveLock(rootProc, tableName);
    }

    @Test
    public void testInheritedRegionXLock() {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        HRegionInfo region = new HRegionInfo(tableName, Bytes.toBytes((String)"a"), Bytes.toBytes((String)"b"));
        this.queue.addBack((Procedure)new TestRegionProcedure(1L, tableName, TableProcedureInterface.TableOperationType.REGION_SPLIT, region));
        this.queue.addBack((Procedure)new TestRegionProcedure(1L, 2L, tableName, TableProcedureInterface.TableOperationType.REGION_UNASSIGN, region));
        this.queue.addBack((Procedure)new TestRegionProcedure(3L, tableName, TableProcedureInterface.TableOperationType.REGION_EDIT, region));
        Procedure rootProc = this.queue.poll();
        Assert.assertEquals((long)1L, (long)rootProc.getProcId());
        Assert.assertEquals((Object)false, (Object)this.queue.waitRegion(rootProc, (RegionInfo)region));
        Procedure childProc = this.queue.poll();
        Assert.assertEquals((long)2L, (long)childProc.getProcId());
        Assert.assertEquals((Object)false, (Object)this.queue.waitRegion(childProc, (RegionInfo)region));
        Procedure proc = this.queue.poll();
        Assert.assertEquals((long)3L, (long)proc.getProcId());
        Assert.assertEquals((Object)true, (Object)this.queue.waitRegion(proc, (RegionInfo)region));
        this.queue.wakeRegion(childProc, (RegionInfo)region);
        Assert.assertEquals(null, (Object)this.queue.poll(0L));
        this.queue.wakeRegion(rootProc, (RegionInfo)region);
        proc = this.queue.poll();
        Assert.assertEquals((long)3L, (long)proc.getProcId());
        Assert.assertEquals((Object)false, (Object)this.queue.waitRegion(proc, (RegionInfo)region));
        this.queue.wakeRegion(proc, (RegionInfo)region);
    }

    @Test
    public void testSuspendedProcedure() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        this.queue.addBack((Procedure)new TestTableProcedure(1L, tableName, TableProcedureInterface.TableOperationType.READ));
        this.queue.addBack((Procedure)new TestTableProcedure(2L, tableName, TableProcedureInterface.TableOperationType.READ));
        Procedure proc = this.queue.poll();
        Assert.assertEquals((long)1L, (long)proc.getProcId());
        ProcedureEvent event = new ProcedureEvent((Object)"testSuspendedProcedureEvent");
        Assert.assertEquals((Object)true, (Object)event.suspendIfNotReady(proc));
        proc = this.queue.poll();
        Assert.assertEquals((long)2L, (long)proc.getProcId());
        Assert.assertEquals(null, (Object)this.queue.poll(0L));
        event.wake((AbstractProcedureScheduler)this.queue);
        proc = this.queue.poll();
        Assert.assertEquals((long)1L, (long)proc.getProcId());
        Assert.assertEquals(null, (Object)this.queue.poll(0L));
    }

    private static HRegionInfo[] generateRegionInfo(TableName tableName) {
        return new HRegionInfo[]{new HRegionInfo(tableName, Bytes.toBytes((String)"a"), Bytes.toBytes((String)"b")), new HRegionInfo(tableName, Bytes.toBytes((String)"b"), Bytes.toBytes((String)"c")), new HRegionInfo(tableName, Bytes.toBytes((String)"c"), Bytes.toBytes((String)"d"))};
    }

    @Test
    public void testParentXLockAndChildrenSharedLock() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        HRegionInfo[] regions = TestMasterProcedureScheduler.generateRegionInfo(tableName);
        TestRegionProcedure[] childProcs = new TestRegionProcedure[regions.length];
        for (int i = 0; i < regions.length; ++i) {
            childProcs[i] = new TestRegionProcedure(1L, (long)(2 + i), tableName, TableProcedureInterface.TableOperationType.REGION_ASSIGN, regions[i]);
        }
        this.testInheritedXLockAndChildrenSharedLock(tableName, new TestTableProcedure(1L, tableName, TableProcedureInterface.TableOperationType.CREATE), childProcs);
    }

    @Test
    public void testRootXLockAndChildrenSharedLock() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        HRegionInfo[] regions = TestMasterProcedureScheduler.generateRegionInfo(tableName);
        TestRegionProcedure[] childProcs = new TestRegionProcedure[regions.length];
        for (int i = 0; i < regions.length; ++i) {
            childProcs[i] = new TestRegionProcedure(1L, 2L, 3 + i, tableName, TableProcedureInterface.TableOperationType.REGION_ASSIGN, regions[i]);
        }
        this.testInheritedXLockAndChildrenSharedLock(tableName, new TestTableProcedure(1L, tableName, TableProcedureInterface.TableOperationType.CREATE), childProcs);
    }

    private void testInheritedXLockAndChildrenSharedLock(TableName tableName, TestTableProcedure rootProc, TestRegionProcedure[] childProcs) throws Exception {
        int i;
        this.queue.addBack((Procedure)rootProc);
        Procedure parentProc = this.queue.poll();
        Assert.assertEquals((Object)((Object)rootProc), (Object)parentProc);
        Assert.assertEquals((Object)false, (Object)this.queue.waitTableExclusiveLock(parentProc, tableName));
        for (i = 0; i < childProcs.length; ++i) {
            this.queue.addFront((Procedure)childProcs[i]);
        }
        this.queue.addBack((Procedure)new TestTableProcedure(100L, tableName, TableProcedureInterface.TableOperationType.EDIT));
        for (i = 0; i < childProcs.length; ++i) {
            TestRegionProcedure childProc = (TestRegionProcedure)this.queue.poll();
            LOG.debug("fetch children " + (Object)((Object)childProc));
            Assert.assertEquals((Object)false, (Object)this.queue.waitRegions((Procedure)childProc, tableName, (RegionInfo[])childProc.getRegionInfo()));
            this.queue.wakeRegions((Procedure)childProc, tableName, (RegionInfo[])childProc.getRegionInfo());
        }
        Assert.assertEquals(null, (Object)this.queue.poll(0L));
        this.queue.wakeTableExclusiveLock(parentProc, tableName);
        Procedure proc = this.queue.poll();
        Assert.assertEquals((long)100L, (long)proc.getProcId());
        Assert.assertEquals((Object)false, (Object)this.queue.waitTableExclusiveLock(proc, tableName));
        this.queue.wakeTableExclusiveLock(proc, tableName);
    }

    @Test
    public void testParentXLockAndChildrenXLock() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        this.testInheritedXLockAndChildrenXLock(tableName, new TestTableProcedure(1L, tableName, TableProcedureInterface.TableOperationType.EDIT), new TestTableProcedure(1L, 2L, tableName, TableProcedureInterface.TableOperationType.EDIT));
    }

    @Test
    public void testRootXLockAndChildrenXLock() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        this.testInheritedXLockAndChildrenXLock(tableName, new TestTableProcedure(1L, tableName, TableProcedureInterface.TableOperationType.EDIT), new TestTableProcedure(1L, 2L, 3L, tableName, TableProcedureInterface.TableOperationType.EDIT));
    }

    private void testInheritedXLockAndChildrenXLock(TableName tableName, TestTableProcedure rootProc, TestTableProcedure childProc) throws Exception {
        this.queue.addBack((Procedure)rootProc);
        Procedure parentProc = this.queue.poll();
        Assert.assertEquals((Object)((Object)rootProc), (Object)parentProc);
        Assert.assertEquals((Object)false, (Object)this.queue.waitTableExclusiveLock(parentProc, tableName));
        this.queue.addFront((Procedure)childProc);
        Procedure proc = this.queue.poll();
        Assert.assertEquals((Object)((Object)childProc), (Object)proc);
        Assert.assertEquals((Object)false, (Object)this.queue.waitTableExclusiveLock(proc, tableName));
        this.queue.wakeTableExclusiveLock(proc, tableName);
        this.queue.wakeTableExclusiveLock(parentProc, tableName);
    }

    @Test
    public void testYieldWithXLockHeld() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        this.queue.addBack((Procedure)new TestTableProcedure(1L, tableName, TableProcedureInterface.TableOperationType.EDIT));
        this.queue.addBack((Procedure)new TestTableProcedure(2L, tableName, TableProcedureInterface.TableOperationType.EDIT));
        Procedure proc = this.queue.poll();
        Assert.assertEquals((long)1L, (long)proc.getProcId());
        Assert.assertEquals((Object)false, (Object)this.queue.waitTableExclusiveLock(proc, tableName));
        Assert.assertEquals(null, (Object)this.queue.poll(0L));
        this.queue.yield(proc);
        proc = this.queue.poll();
        Assert.assertEquals((long)1L, (long)proc.getProcId());
        this.queue.wakeTableExclusiveLock(proc, tableName);
        proc = this.queue.poll();
        Assert.assertEquals((long)2L, (long)proc.getProcId());
    }

    @Test
    public void testYieldWithSharedLockHeld() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        this.queue.addBack((Procedure)new TestTableProcedure(1L, tableName, TableProcedureInterface.TableOperationType.READ));
        this.queue.addBack((Procedure)new TestTableProcedure(2L, tableName, TableProcedureInterface.TableOperationType.READ));
        this.queue.addBack((Procedure)new TestTableProcedure(3L, tableName, TableProcedureInterface.TableOperationType.EDIT));
        Procedure proc1 = this.queue.poll();
        Assert.assertEquals((long)1L, (long)proc1.getProcId());
        Assert.assertEquals((Object)false, (Object)this.queue.waitTableSharedLock(proc1, tableName));
        Procedure proc2 = this.queue.poll();
        Assert.assertEquals((long)2L, (long)proc2.getProcId());
        Assert.assertEquals((Object)false, (Object)this.queue.waitTableSharedLock(proc2, tableName));
        Assert.assertEquals(null, (Object)this.queue.poll(0L));
        this.queue.yield(proc2);
        this.queue.yield(proc1);
        proc1 = this.queue.poll();
        Assert.assertEquals((long)1L, (long)proc1.getProcId());
        proc2 = this.queue.poll();
        Assert.assertEquals((long)2L, (long)proc2.getProcId());
        this.queue.wakeTableSharedLock(proc1, tableName);
        this.queue.wakeTableSharedLock(proc2, tableName);
        Procedure proc3 = this.queue.poll();
        Assert.assertEquals((long)3L, (long)proc3.getProcId());
    }

    private static LockProcedure createLockProcedure(LockType lockType, long procId) throws Exception {
        LockProcedure procedure = new LockProcedure();
        Field typeField = LockProcedure.class.getDeclaredField("type");
        typeField.setAccessible(true);
        typeField.set(procedure, lockType);
        Method setProcIdMethod = Procedure.class.getDeclaredMethod("setProcId", Long.TYPE);
        setProcIdMethod.setAccessible(true);
        setProcIdMethod.invoke((Object)procedure, procId);
        return procedure;
    }

    private static LockProcedure createExclusiveLockProcedure(long procId) throws Exception {
        return TestMasterProcedureScheduler.createLockProcedure(LockType.EXCLUSIVE, procId);
    }

    private static LockProcedure createSharedLockProcedure(long procId) throws Exception {
        return TestMasterProcedureScheduler.createLockProcedure(LockType.SHARED, procId);
    }

    private static void assertLockResource(LockedResource resource, LockedResourceType resourceType, String resourceName) {
        Assert.assertEquals((Object)resourceType, (Object)resource.getResourceType());
        Assert.assertEquals((Object)resourceName, (Object)resource.getResourceName());
    }

    private static void assertExclusiveLock(LockedResource resource, Procedure<?> procedure) {
        Assert.assertEquals((Object)LockType.EXCLUSIVE, (Object)resource.getLockType());
        Assert.assertEquals(procedure, (Object)resource.getExclusiveLockOwnerProcedure());
        Assert.assertEquals((long)0L, (long)resource.getSharedLockCount());
    }

    private static void assertSharedLock(LockedResource resource, int lockCount) {
        Assert.assertEquals((Object)LockType.SHARED, (Object)resource.getLockType());
        Assert.assertEquals((long)lockCount, (long)resource.getSharedLockCount());
    }

    @Test
    public void testListLocksServer() throws Exception {
        LockProcedure procedure = TestMasterProcedureScheduler.createExclusiveLockProcedure(0L);
        this.queue.waitServerExclusiveLock((Procedure)procedure, ServerName.valueOf((String)"server1,1234,0"));
        List resources = this.queue.getLocks();
        Assert.assertEquals((long)1L, (long)resources.size());
        LockedResource serverResource = (LockedResource)resources.get(0);
        TestMasterProcedureScheduler.assertLockResource(serverResource, LockedResourceType.SERVER, "server1,1234,0");
        TestMasterProcedureScheduler.assertExclusiveLock(serverResource, procedure);
        Assert.assertTrue((boolean)serverResource.getWaitingProcedures().isEmpty());
    }

    @Test
    public void testListLocksNamespace() throws Exception {
        LockProcedure procedure = TestMasterProcedureScheduler.createExclusiveLockProcedure(1L);
        this.queue.waitNamespaceExclusiveLock((Procedure)procedure, "ns1");
        List locks = this.queue.getLocks();
        Assert.assertEquals((long)2L, (long)locks.size());
        LockedResource namespaceResource = (LockedResource)locks.get(0);
        TestMasterProcedureScheduler.assertLockResource(namespaceResource, LockedResourceType.NAMESPACE, "ns1");
        TestMasterProcedureScheduler.assertExclusiveLock(namespaceResource, procedure);
        Assert.assertTrue((boolean)namespaceResource.getWaitingProcedures().isEmpty());
        LockedResource tableResource = (LockedResource)locks.get(1);
        TestMasterProcedureScheduler.assertLockResource(tableResource, LockedResourceType.TABLE, TableName.NAMESPACE_TABLE_NAME.getNameAsString());
        TestMasterProcedureScheduler.assertSharedLock(tableResource, 1);
        Assert.assertTrue((boolean)tableResource.getWaitingProcedures().isEmpty());
    }

    @Test
    public void testListLocksTable() throws Exception {
        LockProcedure procedure = TestMasterProcedureScheduler.createExclusiveLockProcedure(2L);
        this.queue.waitTableExclusiveLock((Procedure)procedure, TableName.valueOf((String)"ns2", (String)"table2"));
        List locks = this.queue.getLocks();
        Assert.assertEquals((long)2L, (long)locks.size());
        LockedResource namespaceResource = (LockedResource)locks.get(0);
        TestMasterProcedureScheduler.assertLockResource(namespaceResource, LockedResourceType.NAMESPACE, "ns2");
        TestMasterProcedureScheduler.assertSharedLock(namespaceResource, 1);
        Assert.assertTrue((boolean)namespaceResource.getWaitingProcedures().isEmpty());
        LockedResource tableResource = (LockedResource)locks.get(1);
        TestMasterProcedureScheduler.assertLockResource(tableResource, LockedResourceType.TABLE, "ns2:table2");
        TestMasterProcedureScheduler.assertExclusiveLock(tableResource, procedure);
        Assert.assertTrue((boolean)tableResource.getWaitingProcedures().isEmpty());
    }

    @Test
    public void testListLocksRegion() throws Exception {
        LockProcedure procedure = TestMasterProcedureScheduler.createExclusiveLockProcedure(3L);
        HRegionInfo regionInfo = new HRegionInfo(TableName.valueOf((String)"ns3", (String)"table3"));
        this.queue.waitRegion((Procedure)procedure, (RegionInfo)regionInfo);
        List resources = this.queue.getLocks();
        Assert.assertEquals((long)3L, (long)resources.size());
        LockedResource namespaceResource = (LockedResource)resources.get(0);
        TestMasterProcedureScheduler.assertLockResource(namespaceResource, LockedResourceType.NAMESPACE, "ns3");
        TestMasterProcedureScheduler.assertSharedLock(namespaceResource, 1);
        Assert.assertTrue((boolean)namespaceResource.getWaitingProcedures().isEmpty());
        LockedResource tableResource = (LockedResource)resources.get(1);
        TestMasterProcedureScheduler.assertLockResource(tableResource, LockedResourceType.TABLE, "ns3:table3");
        TestMasterProcedureScheduler.assertSharedLock(tableResource, 1);
        Assert.assertTrue((boolean)tableResource.getWaitingProcedures().isEmpty());
        LockedResource regionResource = (LockedResource)resources.get(2);
        TestMasterProcedureScheduler.assertLockResource(regionResource, LockedResourceType.REGION, regionInfo.getEncodedName());
        TestMasterProcedureScheduler.assertExclusiveLock(regionResource, procedure);
        Assert.assertTrue((boolean)regionResource.getWaitingProcedures().isEmpty());
    }

    @Test
    public void testListLocksPeer() throws Exception {
        String peerId = "1";
        LockProcedure procedure = TestMasterProcedureScheduler.createExclusiveLockProcedure(4L);
        this.queue.waitPeerExclusiveLock((Procedure)procedure, peerId);
        List locks = this.queue.getLocks();
        Assert.assertEquals((long)1L, (long)locks.size());
        LockedResource resource = (LockedResource)locks.get(0);
        TestMasterProcedureScheduler.assertLockResource(resource, LockedResourceType.PEER, peerId);
        TestMasterProcedureScheduler.assertExclusiveLock(resource, procedure);
        Assert.assertTrue((boolean)resource.getWaitingProcedures().isEmpty());
        Assert.assertFalse((boolean)this.queue.waitPeerExclusiveLock((Procedure)procedure, peerId));
        LockProcedure procedure2 = TestMasterProcedureScheduler.createExclusiveLockProcedure(5L);
        Assert.assertTrue((boolean)this.queue.waitPeerExclusiveLock((Procedure)procedure2, peerId));
        locks = this.queue.getLocks();
        Assert.assertEquals((long)1L, (long)locks.size());
        resource = (LockedResource)locks.get(0);
        TestMasterProcedureScheduler.assertLockResource(resource, LockedResourceType.PEER, peerId);
        TestMasterProcedureScheduler.assertExclusiveLock(resource, procedure);
        Assert.assertEquals((long)1L, (long)resource.getWaitingProcedures().size());
    }

    @Test
    public void testListLocksWaiting() throws Exception {
        LockProcedure procedure1 = TestMasterProcedureScheduler.createExclusiveLockProcedure(1L);
        this.queue.waitTableExclusiveLock((Procedure)procedure1, TableName.valueOf((String)"ns4", (String)"table4"));
        LockProcedure procedure2 = TestMasterProcedureScheduler.createSharedLockProcedure(2L);
        this.queue.waitTableSharedLock((Procedure)procedure2, TableName.valueOf((String)"ns4", (String)"table4"));
        LockProcedure procedure3 = TestMasterProcedureScheduler.createExclusiveLockProcedure(3L);
        this.queue.waitTableExclusiveLock((Procedure)procedure3, TableName.valueOf((String)"ns4", (String)"table4"));
        List resources = this.queue.getLocks();
        Assert.assertEquals((long)2L, (long)resources.size());
        LockedResource namespaceResource = (LockedResource)resources.get(0);
        TestMasterProcedureScheduler.assertLockResource(namespaceResource, LockedResourceType.NAMESPACE, "ns4");
        TestMasterProcedureScheduler.assertSharedLock(namespaceResource, 1);
        Assert.assertTrue((boolean)namespaceResource.getWaitingProcedures().isEmpty());
        LockedResource tableLock = (LockedResource)resources.get(1);
        TestMasterProcedureScheduler.assertLockResource(tableLock, LockedResourceType.TABLE, "ns4:table4");
        TestMasterProcedureScheduler.assertExclusiveLock(tableLock, procedure1);
        List waitingProcedures = tableLock.getWaitingProcedures();
        Assert.assertEquals((long)2L, (long)waitingProcedures.size());
        LockProcedure waitingProcedure2 = (LockProcedure)waitingProcedures.get(0);
        Assert.assertEquals((Object)LockType.SHARED, (Object)waitingProcedure2.getType());
        Assert.assertEquals((Object)procedure2, (Object)waitingProcedure2);
        LockProcedure waitingProcedure3 = (LockProcedure)waitingProcedures.get(1);
        Assert.assertEquals((Object)LockType.EXCLUSIVE, (Object)waitingProcedure3.getType());
        Assert.assertEquals((Object)procedure3, (Object)waitingProcedure3);
    }

    public static class TestPeerProcedure
    extends ProcedureTestingUtility.TestProcedure
    implements PeerProcedureInterface {
        private final String peerId;
        private final PeerProcedureInterface.PeerOperationType opType;

        public TestPeerProcedure(long procId, String peerId, PeerProcedureInterface.PeerOperationType opType) {
            super(procId);
            this.peerId = peerId;
            this.opType = opType;
        }

        public String getPeerId() {
            return this.peerId;
        }

        public PeerProcedureInterface.PeerOperationType getPeerOperationType() {
            return this.opType;
        }
    }

    public static class TestNamespaceProcedure
    extends ProcedureTestingUtility.TestProcedure
    implements TableProcedureInterface {
        private final TableProcedureInterface.TableOperationType opType;
        private final String nsName;

        public TestNamespaceProcedure() {
            throw new UnsupportedOperationException("recovery should not be triggered here");
        }

        public TestNamespaceProcedure(long procId, String nsName, TableProcedureInterface.TableOperationType opType) {
            super(procId);
            this.nsName = nsName;
            this.opType = opType;
        }

        public TableName getTableName() {
            return TableName.NAMESPACE_TABLE_NAME;
        }

        public TableProcedureInterface.TableOperationType getTableOperationType() {
            return this.opType;
        }

        public void toStringClassDetails(StringBuilder sb) {
            sb.append(((Object)((Object)this)).getClass().getSimpleName());
            sb.append("(ns=");
            sb.append(this.nsName);
            sb.append(")");
        }
    }

    public static class TestRegionProcedure
    extends TestTableProcedure {
        private final HRegionInfo[] regionInfo;

        public TestRegionProcedure() {
            throw new UnsupportedOperationException("recovery should not be triggered here");
        }

        public TestRegionProcedure(long procId, TableName tableName, TableProcedureInterface.TableOperationType opType, HRegionInfo ... regionInfo) {
            this(-1L, procId, tableName, opType, regionInfo);
        }

        public TestRegionProcedure(long parentProcId, long procId, TableName tableName, TableProcedureInterface.TableOperationType opType, HRegionInfo ... regionInfo) {
            this(-1L, parentProcId, procId, tableName, opType, regionInfo);
        }

        public TestRegionProcedure(long rootProcId, long parentProcId, long procId, TableName tableName, TableProcedureInterface.TableOperationType opType, HRegionInfo ... regionInfo) {
            super(rootProcId, parentProcId, procId, tableName, opType);
            this.regionInfo = regionInfo;
        }

        public HRegionInfo[] getRegionInfo() {
            return this.regionInfo;
        }

        @Override
        public void toStringClassDetails(StringBuilder sb) {
            sb.append(((Object)((Object)this)).getClass().getSimpleName());
            sb.append("(regions=");
            sb.append(Arrays.toString(this.getRegionInfo()));
            sb.append(")");
        }
    }

    public static class TestTableProcedureWithEvent
    extends TestTableProcedure {
        private final ProcedureEvent event;

        public TestTableProcedureWithEvent(long procId, TableName tableName, TableProcedureInterface.TableOperationType opType) {
            super(procId, tableName, opType);
            this.event = new ProcedureEvent((Object)(tableName + " procId=" + procId));
        }

        public ProcedureEvent getEvent() {
            return this.event;
        }
    }

    public static class TestTableProcedure
    extends ProcedureTestingUtility.TestProcedure
    implements TableProcedureInterface {
        private final TableProcedureInterface.TableOperationType opType;
        private final TableName tableName;

        public TestTableProcedure() {
            throw new UnsupportedOperationException("recovery should not be triggered here");
        }

        public TestTableProcedure(long procId, TableName tableName, TableProcedureInterface.TableOperationType opType) {
            this(-1L, procId, tableName, opType);
        }

        public TestTableProcedure(long parentProcId, long procId, TableName tableName, TableProcedureInterface.TableOperationType opType) {
            this(-1L, parentProcId, procId, tableName, opType);
        }

        public TestTableProcedure(long rootProcId, long parentProcId, long procId, TableName tableName, TableProcedureInterface.TableOperationType opType) {
            super(procId, parentProcId, rootProcId, null);
            this.tableName = tableName;
            this.opType = opType;
        }

        public TableName getTableName() {
            return this.tableName;
        }

        public TableProcedureInterface.TableOperationType getTableOperationType() {
            return this.opType;
        }

        public void toStringClassDetails(StringBuilder sb) {
            sb.append(((Object)((Object)this)).getClass().getSimpleName());
            sb.append("(table=");
            sb.append(this.getTableName());
            sb.append(")");
        }
    }
}

