/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.io.hfile.BlockCache;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.regionserver.BloomType;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManagerTestHelper;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={RegionServerTests.class, MediumTests.class})
public class TestBlocksRead {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestBlocksRead.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestBlocksRead.class);
    @Rule
    public TestName testName = new TestName();
    static final BloomType[] BLOOM_TYPE = new BloomType[]{BloomType.ROWCOL, BloomType.ROW, BloomType.NONE};
    private static BlockCache blockCache;
    HRegion region = null;
    private static HBaseTestingUtility TEST_UTIL;
    private final String DIR = TEST_UTIL.getDataTestDir("TestBlocksRead").toString();
    private Configuration conf = TEST_UTIL.getConfiguration();

    @BeforeClass
    public static void setUp() throws Exception {
        TEST_UTIL.getConfiguration().setInt("hbase.hstore.compactionThreshold", 10000);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        EnvironmentEdgeManagerTestHelper.reset();
    }

    private HRegion initHRegion(byte[] tableName, String callingMethod, Configuration conf, String family) throws IOException {
        HTableDescriptor htd = new HTableDescriptor(TableName.valueOf((byte[])tableName));
        for (int i = 0; i < BLOOM_TYPE.length; ++i) {
            BloomType bloomType = BLOOM_TYPE[i];
            HColumnDescriptor familyDesc = new HColumnDescriptor(family + "_" + bloomType).setBlocksize(1).setBloomFilterType(BLOOM_TYPE[i]);
            htd.addFamily(familyDesc);
        }
        HRegionInfo info = new HRegionInfo(htd.getTableName(), null, null, false);
        Path path = new Path(this.DIR + callingMethod);
        HRegion r = HBaseTestingUtility.createRegionAndWAL((RegionInfo)info, path, conf, (TableDescriptor)htd);
        blockCache = new CacheConfig(conf).getBlockCache();
        return r;
    }

    private void putData(String family, String row, String col, long version) throws IOException {
        for (int i = 0; i < BLOOM_TYPE.length; ++i) {
            this.putData(Bytes.toBytes((String)(family + "_" + BLOOM_TYPE[i])), row, col, version, version);
        }
    }

    private static byte[] genValue(String row, String col, long version) {
        return Bytes.toBytes((String)("Value:" + row + "#" + col + "#" + version));
    }

    private void putData(byte[] cf, String row, String col, long versionStart, long versionEnd) throws IOException {
        byte[] columnBytes = Bytes.toBytes((String)col);
        Put put = new Put(Bytes.toBytes((String)row));
        put.setDurability(Durability.SKIP_WAL);
        for (long version = versionStart; version <= versionEnd; ++version) {
            put.addColumn(cf, columnBytes, version, TestBlocksRead.genValue(row, col, version));
        }
        this.region.put(put);
    }

    private Cell[] getData(String family, String row, List<String> columns, int expBlocks) throws IOException {
        return this.getData(family, row, columns, expBlocks, expBlocks, expBlocks);
    }

    private Cell[] getData(String family, String row, List<String> columns, int expBlocksRowCol, int expBlocksRow, int expBlocksNone) throws IOException {
        int[] expBlocks = new int[]{expBlocksRowCol, expBlocksRow, expBlocksNone};
        Cell[] kvs = null;
        for (int i = 0; i < BLOOM_TYPE.length; ++i) {
            BloomType bloomType = BLOOM_TYPE[i];
            byte[] cf = Bytes.toBytes((String)(family + "_" + bloomType));
            long blocksStart = TestBlocksRead.getBlkAccessCount(cf);
            Get get = new Get(Bytes.toBytes((String)row));
            for (String column : columns) {
                get.addColumn(cf, Bytes.toBytes((String)column));
            }
            kvs = this.region.get(get).rawCells();
            long blocksEnd = TestBlocksRead.getBlkAccessCount(cf);
            if (expBlocks[i] != -1) {
                Assert.assertEquals((String)("Blocks Read Check for Bloom: " + bloomType), (long)expBlocks[i], (long)(blocksEnd - blocksStart));
            }
            System.out.println("Blocks Read for Bloom: " + bloomType + " = " + (blocksEnd - blocksStart) + "Expected = " + expBlocks[i]);
        }
        return kvs;
    }

    private Cell[] getData(String family, String row, String column, int expBlocks) throws IOException {
        return this.getData(family, row, Arrays.asList(column), expBlocks, expBlocks, expBlocks);
    }

    private Cell[] getData(String family, String row, String column, int expBlocksRowCol, int expBlocksRow, int expBlocksNone) throws IOException {
        return this.getData(family, row, Arrays.asList(column), expBlocksRowCol, expBlocksRow, expBlocksNone);
    }

    private void deleteFamily(String family, String row, long version) throws IOException {
        Delete del = new Delete(Bytes.toBytes((String)row));
        del.addFamily(Bytes.toBytes((String)(family + "_ROWCOL")), version);
        del.addFamily(Bytes.toBytes((String)(family + "_ROW")), version);
        del.addFamily(Bytes.toBytes((String)(family + "_NONE")), version);
        this.region.delete(del);
    }

    private static void verifyData(Cell kv, String expectedRow, String expectedCol, long expectedVersion) {
        TestCase.assertTrue((String)"RowCheck", (boolean)CellUtil.matchingRows((Cell)kv, (byte[])Bytes.toBytes((String)expectedRow)));
        TestCase.assertTrue((String)"ColumnCheck", (boolean)CellUtil.matchingQualifier((Cell)kv, (byte[])Bytes.toBytes((String)expectedCol)));
        Assert.assertEquals((String)"TSCheck", (long)expectedVersion, (long)kv.getTimestamp());
        TestCase.assertTrue((String)"ValueCheck", (boolean)CellUtil.matchingValue((Cell)kv, (byte[])TestBlocksRead.genValue(expectedRow, expectedCol, expectedVersion)));
    }

    private static long getBlkAccessCount(byte[] cf) {
        return HFile.DATABLOCK_READ_COUNT.sum();
    }

    private static long getBlkCount() {
        return blockCache.getBlockCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBlocksRead() throws Exception {
        byte[] TABLE = Bytes.toBytes((String)"testBlocksRead");
        String FAMILY = "cf1";
        this.region = this.initHRegion(TABLE, this.testName.getMethodName(), this.conf, FAMILY);
        try {
            this.putData(FAMILY, "row", "col1", 1L);
            this.putData(FAMILY, "row", "col2", 2L);
            this.putData(FAMILY, "row", "col3", 3L);
            this.putData(FAMILY, "row", "col4", 4L);
            this.putData(FAMILY, "row", "col5", 5L);
            this.putData(FAMILY, "row", "col6", 6L);
            this.putData(FAMILY, "row", "col7", 7L);
            this.region.flush(true);
            Cell[] kvs = this.getData(FAMILY, "row", "col1", 1);
            Assert.assertEquals((long)1L, (long)kvs.length);
            TestBlocksRead.verifyData(kvs[0], "row", "col1", 1L);
            kvs = this.getData(FAMILY, "row", Arrays.asList("col1", "col2"), 2);
            Assert.assertEquals((long)2L, (long)kvs.length);
            TestBlocksRead.verifyData(kvs[0], "row", "col1", 1L);
            TestBlocksRead.verifyData(kvs[1], "row", "col2", 2L);
            kvs = this.getData(FAMILY, "row", Arrays.asList("col2", "col3"), 2);
            Assert.assertEquals((long)2L, (long)kvs.length);
            TestBlocksRead.verifyData(kvs[0], "row", "col2", 2L);
            TestBlocksRead.verifyData(kvs[1], "row", "col3", 3L);
            kvs = this.getData(FAMILY, "row", Arrays.asList("col5"), 1);
            Assert.assertEquals((long)1L, (long)kvs.length);
            TestBlocksRead.verifyData(kvs[0], "row", "col5", 5L);
        }
        finally {
            HBaseTestingUtility.closeRegionAndWAL(this.region);
            this.region = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLazySeekBlocksRead() throws Exception {
        byte[] TABLE = Bytes.toBytes((String)"testLazySeekBlocksRead");
        String FAMILY = "cf1";
        this.region = this.initHRegion(TABLE, this.testName.getMethodName(), this.conf, FAMILY);
        try {
            this.putData(FAMILY, "row", "col1", 1L);
            this.putData(FAMILY, "row", "col2", 2L);
            this.region.flush(true);
            this.putData(FAMILY, "row", "col1", 3L);
            this.putData(FAMILY, "row", "col2", 4L);
            this.region.flush(true);
            Cell[] kvs = this.getData(FAMILY, "row", Arrays.asList("col1"), 1);
            Assert.assertEquals((long)1L, (long)kvs.length);
            TestBlocksRead.verifyData(kvs[0], "row", "col1", 3L);
            kvs = this.getData(FAMILY, "row", Arrays.asList("col1", "col2"), 2);
            Assert.assertEquals((long)2L, (long)kvs.length);
            TestBlocksRead.verifyData(kvs[0], "row", "col1", 3L);
            TestBlocksRead.verifyData(kvs[1], "row", "col2", 4L);
            this.putData(FAMILY, "row", "col3", 5L);
            this.region.flush(true);
            kvs = this.getData(FAMILY, "row", "col3", 1);
            Assert.assertEquals((long)1L, (long)kvs.length);
            TestBlocksRead.verifyData(kvs[0], "row", "col3", 5L);
            kvs = this.getData(FAMILY, "row", Arrays.asList("col1"), 1, 2, 2);
            Assert.assertEquals((long)1L, (long)kvs.length);
            TestBlocksRead.verifyData(kvs[0], "row", "col1", 3L);
            this.deleteFamily(FAMILY, "row", 6L);
            this.region.flush(true);
            kvs = this.getData(FAMILY, "row", "col1", 2, 3, 3);
            Assert.assertEquals((long)0L, (long)kvs.length);
            kvs = this.getData(FAMILY, "row", "col2", 2, 3, 3);
            Assert.assertEquals((long)0L, (long)kvs.length);
            kvs = this.getData(FAMILY, "row", "col3", 2);
            Assert.assertEquals((long)0L, (long)kvs.length);
            kvs = this.getData(FAMILY, "row", Arrays.asList("col1", "col2", "col3"), 4);
            Assert.assertEquals((long)0L, (long)kvs.length);
            this.deleteFamily(FAMILY, "row", 10L);
            this.region.flush(true);
            this.putData(FAMILY, "row", "col1", 7L);
            this.putData(FAMILY, "row", "col2", 8L);
            this.putData(FAMILY, "row", "col3", 9L);
            this.region.flush(true);
            kvs = this.getData(FAMILY, "row", Arrays.asList("col1", "col2", "col3"), 6, 7, 7);
            Assert.assertEquals((long)0L, (long)kvs.length);
            this.putData(FAMILY, "row", "col1", 11L);
            this.putData(FAMILY, "row", "col2", 12L);
            this.putData(FAMILY, "row", "col3", 13L);
            this.region.flush(true);
            kvs = this.getData(FAMILY, "row", Arrays.asList("col1", "col2", "col3"), 8, 9, 9);
            Assert.assertEquals((long)3L, (long)kvs.length);
            TestBlocksRead.verifyData(kvs[0], "row", "col1", 11L);
            TestBlocksRead.verifyData(kvs[1], "row", "col2", 12L);
            TestBlocksRead.verifyData(kvs[2], "row", "col3", 13L);
        }
        finally {
            HBaseTestingUtility.closeRegionAndWAL(this.region);
            this.region = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBlocksStoredWhenCachingDisabled() throws Exception {
        byte[] TABLE = Bytes.toBytes((String)"testBlocksReadWhenCachingDisabled");
        String FAMILY = "cf1";
        this.region = this.initHRegion(TABLE, this.testName.getMethodName(), this.conf, FAMILY);
        try {
            this.putData(FAMILY, "row", "col1", 1L);
            this.putData(FAMILY, "row", "col2", 2L);
            this.region.flush(true);
            long blocksStart = TestBlocksRead.getBlkCount();
            Scan scan = new Scan();
            scan.setCacheBlocks(false);
            HRegion.RegionScannerImpl rs = this.region.getScanner(scan);
            ArrayList result = new ArrayList(2);
            rs.next(result);
            Assert.assertEquals((long)(2 * BLOOM_TYPE.length), (long)result.size());
            rs.close();
            long blocksEnd = TestBlocksRead.getBlkCount();
            Assert.assertEquals((long)blocksStart, (long)blocksEnd);
            blocksStart = blocksEnd;
            scan.setCacheBlocks(true);
            rs = this.region.getScanner(scan);
            result = new ArrayList(2);
            rs.next(result);
            Assert.assertEquals((long)(2 * BLOOM_TYPE.length), (long)result.size());
            rs.close();
            blocksEnd = TestBlocksRead.getBlkCount();
            Assert.assertEquals((long)(2 * BLOOM_TYPE.length), (long)(blocksEnd - blocksStart));
        }
        finally {
            HBaseTestingUtility.closeRegionAndWAL(this.region);
            this.region = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLazySeekBlocksReadWithDelete() throws Exception {
        byte[] TABLE = Bytes.toBytes((String)"testLazySeekBlocksReadWithDelete");
        String FAMILY = "cf1";
        this.region = this.initHRegion(TABLE, this.testName.getMethodName(), this.conf, FAMILY);
        try {
            this.deleteFamily(FAMILY, "row", 200L);
            for (int i = 0; i < 100; ++i) {
                this.putData(FAMILY, "row", "col" + i, i);
            }
            this.putData(FAMILY, "row", "col99", 201L);
            this.region.flush(true);
            Cell[] kvs = this.getData(FAMILY, "row", Arrays.asList("col0"), 2);
            Assert.assertEquals((long)0L, (long)kvs.length);
            kvs = this.getData(FAMILY, "row", Arrays.asList("col99"), 2);
            Assert.assertEquals((long)1L, (long)kvs.length);
            TestBlocksRead.verifyData(kvs[0], "row", "col99", 201L);
        }
        finally {
            HBaseTestingUtility.closeRegionAndWAL(this.region);
            this.region = null;
        }
    }

    static {
        TEST_UTIL = new HBaseTestingUtility();
    }
}

