/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.lang.management.ManagementFactory;
import java.nio.ByteBuffer;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.SortedSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.io.util.MemorySizeUtil;
import org.apache.hadoop.hbase.regionserver.CellArrayMap;
import org.apache.hadoop.hbase.regionserver.CellChunkMap;
import org.apache.hadoop.hbase.regionserver.CellSet;
import org.apache.hadoop.hbase.regionserver.Chunk;
import org.apache.hadoop.hbase.regionserver.ChunkCreator;
import org.apache.hadoop.hbase.regionserver.CompactingMemStore;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.ByteBufferUtils;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.ClassSize;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@Category(value={RegionServerTests.class, SmallTests.class})
@RunWith(value=Parameterized.class)
public class TestCellFlatSet {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestCellFlatSet.class);
    private static final int NUM_OF_CELLS = 4;
    private static final int SMALL_CHUNK_SIZE = 64;
    private Cell[] ascCells;
    private CellArrayMap ascCbOnHeap;
    private Cell[] descCells;
    private CellArrayMap descCbOnHeap;
    private static final Configuration CONF = new Configuration();
    private KeyValue lowerOuterCell;
    private KeyValue upperOuterCell;
    private CellChunkMap ascCCM;
    private CellChunkMap descCCM;
    private final boolean smallChunks;
    private static ChunkCreator chunkCreator;

    @Parameterized.Parameters
    public static Object[] data() {
        return new Object[]{"SMALL_CHUNKS", "NORMAL_CHUNKS"};
    }

    public TestCellFlatSet(String chunkType) {
        long globalMemStoreLimit = (long)((float)ManagementFactory.getMemoryMXBean().getHeapMemoryUsage().getMax() * MemorySizeUtil.getGlobalMemStoreHeapPercent((Configuration)CONF, (boolean)false));
        if (chunkType.equals("NORMAL_CHUNKS")) {
            chunkCreator = ChunkCreator.initialize((int)0x200000, (boolean)false, (long)globalMemStoreLimit, (float)0.2f, (float)0.0f, null);
            Assert.assertNotNull((Object)chunkCreator);
            this.smallChunks = false;
        } else {
            chunkCreator = ChunkCreator.initialize((int)64, (boolean)false, (long)globalMemStoreLimit, (float)0.2f, (float)0.0f, null);
            Assert.assertNotNull((Object)chunkCreator);
            this.smallChunks = true;
        }
    }

    @Before
    public void setUp() throws Exception {
        byte[] one = Bytes.toBytes((int)15);
        byte[] two = Bytes.toBytes((int)25);
        byte[] three = Bytes.toBytes((int)35);
        byte[] four = Bytes.toBytes((int)45);
        byte[] f = Bytes.toBytes((String)"f");
        byte[] q = Bytes.toBytes((String)"q");
        byte[] v = Bytes.toBytes((int)4);
        KeyValue kv1 = new KeyValue(one, f, q, 10L, v);
        KeyValue kv2 = new KeyValue(two, f, q, 20L, v);
        KeyValue kv3 = new KeyValue(three, f, q, 30L, v);
        KeyValue kv4 = new KeyValue(four, f, q, 40L, v);
        this.lowerOuterCell = new KeyValue(Bytes.toBytes((int)10), f, q, 10L, v);
        this.upperOuterCell = new KeyValue(Bytes.toBytes((int)50), f, q, 10L, v);
        this.ascCells = new Cell[]{kv1, kv2, kv3, kv4};
        this.ascCbOnHeap = new CellArrayMap((Comparator)CellComparator.getInstance(), this.ascCells, 0, 4, false);
        this.descCells = new Cell[]{kv4, kv3, kv2, kv1};
        this.descCbOnHeap = new CellArrayMap((Comparator)CellComparator.getInstance(), this.descCells, 0, 4, true);
        CONF.setBoolean("hbase.hregion.memstore.mslab.enabled", true);
        CONF.setFloat("hbase.hregion.memstore.chunkpool.maxsize", 0.2f);
        ChunkCreator.chunkPoolDisabled = false;
        this.ascCCM = this.setUpCellChunkMap(true);
        this.descCCM = this.setUpCellChunkMap(false);
        if (this.smallChunks) {
            this.ascCCM = this.setUpJumboCellChunkMap(true);
        }
    }

    @Test
    public void testCellArrayMapAsc() throws Exception {
        CellSet cs = new CellSet((NavigableMap)this.ascCbOnHeap);
        this.testCellBlocks(cs);
        this.testIterators(cs);
    }

    @Test
    public void testCellChunkMap() throws Exception {
        CellSet cs = new CellSet((NavigableMap)this.ascCCM);
        this.testCellBlocks(cs);
        this.testIterators(cs);
        this.testSubSet(cs);
        cs = new CellSet((NavigableMap)this.descCCM);
        this.testSubSet(cs);
    }

    @Test
    public void testAsc() throws Exception {
        CellSet ascCs = new CellSet((NavigableMap)this.ascCbOnHeap);
        Assert.assertEquals((long)4L, (long)ascCs.size());
        this.testSubSet(ascCs);
    }

    @Test
    public void testDesc() throws Exception {
        CellSet descCs = new CellSet((NavigableMap)this.descCbOnHeap);
        Assert.assertEquals((long)4L, (long)descCs.size());
        this.testSubSet(descCs);
    }

    private void testSubSet(CellSet cs) throws Exception {
        int j;
        Iterator includeIter;
        Iterator excludeIter;
        int i;
        for (i = 0; i != this.ascCells.length; ++i) {
            NavigableSet excludeTail = cs.tailSet(this.ascCells[i], false);
            NavigableSet includeTail = cs.tailSet(this.ascCells[i], true);
            Assert.assertEquals((long)(this.ascCells.length - 1 - i), (long)excludeTail.size());
            Assert.assertEquals((long)(this.ascCells.length - i), (long)includeTail.size());
            excludeIter = excludeTail.iterator();
            includeIter = includeTail.iterator();
            for (j = 1 + i; j != this.ascCells.length; ++j) {
                Assert.assertEquals((Object)true, (Object)CellUtil.equals((Cell)((Cell)excludeIter.next()), (Cell)this.ascCells[j]));
            }
            for (j = i; j != this.ascCells.length; ++j) {
                Assert.assertEquals((Object)true, (Object)CellUtil.equals((Cell)((Cell)includeIter.next()), (Cell)this.ascCells[j]));
            }
        }
        Assert.assertEquals((long)4L, (long)cs.tailSet((Cell)this.lowerOuterCell, false).size());
        Assert.assertEquals((long)0L, (long)cs.tailSet((Cell)this.upperOuterCell, false).size());
        for (i = 0; i != this.ascCells.length; ++i) {
            NavigableSet excludeHead = cs.headSet(this.ascCells[i], false);
            NavigableSet includeHead = cs.headSet(this.ascCells[i], true);
            Assert.assertEquals((long)i, (long)excludeHead.size());
            Assert.assertEquals((long)(i + 1), (long)includeHead.size());
            excludeIter = excludeHead.iterator();
            includeIter = includeHead.iterator();
            for (j = 0; j != i; ++j) {
                Assert.assertEquals((Object)true, (Object)CellUtil.equals((Cell)((Cell)excludeIter.next()), (Cell)this.ascCells[j]));
            }
            for (j = 0; j != i + 1; ++j) {
                Assert.assertEquals((Object)true, (Object)CellUtil.equals((Cell)((Cell)includeIter.next()), (Cell)this.ascCells[j]));
            }
        }
        Assert.assertEquals((long)0L, (long)cs.headSet((Cell)this.lowerOuterCell, false).size());
        Assert.assertEquals((long)4L, (long)cs.headSet((Cell)this.upperOuterCell, false).size());
        NavigableMap sub = cs.getDelegatee().subMap(this.lowerOuterCell, true, this.upperOuterCell, true);
        Assert.assertEquals((long)4L, (long)sub.size());
        Iterator iter = sub.values().iterator();
        for (int i2 = 0; i2 != this.ascCells.length; ++i2) {
            Assert.assertEquals((Object)true, (Object)CellUtil.equals((Cell)((Cell)iter.next()), (Cell)this.ascCells[i2]));
        }
    }

    private void testCellBlocks(CellSet cs) throws Exception {
        byte[] oneAndHalf = Bytes.toBytes((int)20);
        byte[] f = Bytes.toBytes((String)"f");
        byte[] q = Bytes.toBytes((String)"q");
        byte[] v = Bytes.toBytes((int)4);
        KeyValue outerCell = new KeyValue(oneAndHalf, f, q, 10L, v);
        Assert.assertEquals((long)4L, (long)cs.size());
        Assert.assertFalse((boolean)cs.contains((Object)outerCell));
        Assert.assertTrue((boolean)cs.contains((Object)this.ascCells[0]));
        Cell first = cs.first();
        Assert.assertTrue((boolean)this.ascCells[0].equals(first));
        Assert.assertTrue((boolean)cs.contains((Object)this.ascCells[3]));
        Cell last = cs.last();
        Assert.assertTrue((boolean)this.ascCells[3].equals(last));
        SortedSet tail = cs.tailSet(this.ascCells[1]);
        Assert.assertEquals((long)3L, (long)tail.size());
        SortedSet head = cs.headSet(this.ascCells[1]);
        Assert.assertEquals((long)1L, (long)head.size());
        SortedSet tailOuter = cs.tailSet((Cell)outerCell);
        Assert.assertEquals((long)3L, (long)tailOuter.size());
        Cell tailFirst = (Cell)tail.first();
        Assert.assertTrue((boolean)this.ascCells[1].equals(tailFirst));
        Cell tailLast = (Cell)tail.last();
        Assert.assertTrue((boolean)this.ascCells[3].equals(tailLast));
        Cell headFirst = (Cell)head.first();
        Assert.assertTrue((boolean)this.ascCells[0].equals(headFirst));
        Cell headLast = (Cell)head.last();
        Assert.assertTrue((boolean)this.ascCells[0].equals(headLast));
    }

    private void testIterators(CellSet cs) throws Exception {
        int count = 0;
        for (Cell kv : cs) {
            Assert.assertEquals((String)("\n\n-------------------------------------------------------------------\nComparing iteration number " + (count + 1) + " the returned cell: " + kv + ", the first Cell in the CellBlocksMap: " + this.ascCells[count] + ", and the same transformed to String: " + this.ascCells[count].toString() + "\n-------------------------------------------------------------------\n"), (Object)this.ascCells[count], (Object)kv);
            ++count;
        }
        Assert.assertEquals((long)4L, (long)count);
        count = 0;
        Iterator i = cs.descendingIterator();
        while (i.hasNext()) {
            Cell kv;
            kv = (Cell)i.next();
            Assert.assertEquals((Object)this.ascCells[4 - (count + 1)], (Object)kv);
            ++count;
        }
        Assert.assertEquals((long)4L, (long)count);
    }

    private CellChunkMap setUpCellChunkMap(boolean asc) {
        Cell[] cellArray;
        Chunk dataChunk = chunkCreator.getChunk(CompactingMemStore.IndexType.CHUNK_MAP);
        Chunk idxChunk = chunkCreator.getChunk(CompactingMemStore.IndexType.CHUNK_MAP);
        Chunk[] chunkArray = new Chunk[8];
        int chunkArrayIdx = 0;
        chunkArray[chunkArrayIdx++] = idxChunk;
        ByteBuffer idxBuffer = idxChunk.getData();
        ByteBuffer dataBuffer = dataChunk.getData();
        int dataOffset = 4;
        int idxOffset = 4;
        for (Cell kv : cellArray = asc ? this.ascCells : this.descCells) {
            if (dataOffset + KeyValueUtil.length((Cell)kv) > chunkCreator.getChunkSize()) {
                dataChunk = chunkCreator.getChunk(CompactingMemStore.IndexType.CHUNK_MAP);
                dataBuffer = dataChunk.getData();
                dataOffset = 4;
            }
            int dataStartOfset = dataOffset;
            dataOffset = KeyValueUtil.appendTo((Cell)kv, (ByteBuffer)dataBuffer, (int)dataOffset, (boolean)false);
            if (idxOffset + ClassSize.CELL_CHUNK_MAP_ENTRY > chunkCreator.getChunkSize()) {
                idxChunk = chunkCreator.getChunk(CompactingMemStore.IndexType.CHUNK_MAP);
                idxBuffer = idxChunk.getData();
                idxOffset = 4;
                chunkArray[chunkArrayIdx++] = idxChunk;
            }
            idxOffset = ByteBufferUtils.putInt((ByteBuffer)idxBuffer, (int)idxOffset, (int)dataChunk.getId());
            idxOffset = ByteBufferUtils.putInt((ByteBuffer)idxBuffer, (int)idxOffset, (int)dataStartOfset);
            idxOffset = ByteBufferUtils.putInt((ByteBuffer)idxBuffer, (int)idxOffset, (int)KeyValueUtil.length((Cell)kv));
            idxOffset = ByteBufferUtils.putLong((ByteBuffer)idxBuffer, (int)idxOffset, (long)kv.getSequenceId());
        }
        return new CellChunkMap((Comparator)CellComparator.getInstance(), chunkArray, 0, 4, !asc);
    }

    private CellChunkMap setUpJumboCellChunkMap(boolean asc) {
        Cell[] cellArray;
        int smallChunkSize = 72;
        Chunk dataJumboChunk = chunkCreator.getChunk(CompactingMemStore.IndexType.CHUNK_MAP, smallChunkSize);
        Chunk idxChunk = chunkCreator.getChunk(CompactingMemStore.IndexType.CHUNK_MAP);
        Chunk[] chunkArray = new Chunk[8];
        int chunkArrayIdx = 0;
        chunkArray[chunkArrayIdx++] = idxChunk;
        ByteBuffer idxBuffer = idxChunk.getData();
        ByteBuffer dataBuffer = dataJumboChunk.getData();
        int dataOffset = 4;
        int idxOffset = 4;
        for (Cell kv : cellArray = asc ? this.ascCells : this.descCells) {
            int dataStartOfset = dataOffset;
            dataOffset = KeyValueUtil.appendTo((Cell)kv, (ByteBuffer)dataBuffer, (int)dataOffset, (boolean)false);
            if (idxOffset + ClassSize.CELL_CHUNK_MAP_ENTRY > chunkCreator.getChunkSize()) {
                idxChunk = chunkCreator.getChunk(CompactingMemStore.IndexType.CHUNK_MAP);
                idxBuffer = idxChunk.getData();
                idxOffset = 4;
                chunkArray[chunkArrayIdx++] = idxChunk;
            }
            idxOffset = ByteBufferUtils.putInt((ByteBuffer)idxBuffer, (int)idxOffset, (int)dataJumboChunk.getId());
            idxOffset = ByteBufferUtils.putInt((ByteBuffer)idxBuffer, (int)idxOffset, (int)dataStartOfset);
            idxOffset = ByteBufferUtils.putInt((ByteBuffer)idxBuffer, (int)idxOffset, (int)KeyValueUtil.length((Cell)kv));
            idxOffset = ByteBufferUtils.putLong((ByteBuffer)idxBuffer, (int)idxOffset, (long)kv.getSequenceId());
            dataJumboChunk = chunkCreator.getChunk(CompactingMemStore.IndexType.CHUNK_MAP, smallChunkSize);
            dataBuffer = dataJumboChunk.getData();
            dataOffset = 4;
        }
        return new CellChunkMap((Comparator)CellComparator.getInstance(), chunkArray, 0, 4, !asc);
    }
}

