/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.regionserver.FlushType;
import org.apache.hadoop.hbase.regionserver.MemStoreSize;
import org.apache.hadoop.hbase.regionserver.RegionServerAccounting;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestRegionServerAccounting {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRegionServerAccounting.class);
    private static final float DEFAULT_MEMSTORE_SIZE = 0.2f;
    private static Configuration conf;

    @Before
    public void setUpConf() {
        conf = HBaseConfiguration.create();
        conf.setFloat("hbase.regionserver.global.memstore.size", 0.2f);
    }

    @Test
    public void testOnheapMemstoreHigherWaterMarkLimits() {
        RegionServerAccounting regionServerAccounting = new RegionServerAccounting(conf);
        long dataSize = regionServerAccounting.getGlobalMemStoreLimit();
        MemStoreSize memstoreSize = new MemStoreSize(dataSize, dataSize, 0L);
        regionServerAccounting.incGlobalMemStoreSize(memstoreSize);
        Assert.assertEquals((Object)FlushType.ABOVE_ONHEAP_HIGHER_MARK, (Object)regionServerAccounting.isAboveHighWaterMark());
    }

    @Test
    public void testOnheapMemstoreLowerWaterMarkLimits() {
        RegionServerAccounting regionServerAccounting = new RegionServerAccounting(conf);
        long dataSize = regionServerAccounting.getGlobalMemStoreLimit();
        MemStoreSize memstoreSize = new MemStoreSize(dataSize, dataSize, 0L);
        regionServerAccounting.incGlobalMemStoreSize(memstoreSize);
        Assert.assertEquals((Object)FlushType.ABOVE_ONHEAP_LOWER_MARK, (Object)regionServerAccounting.isAboveLowWaterMark());
    }

    @Test
    public void testOffheapMemstoreHigherWaterMarkLimitsDueToDataSize() {
        conf.setLong("hbase.regionserver.offheap.global.memstore.size", 1024L);
        RegionServerAccounting regionServerAccounting = new RegionServerAccounting(conf);
        MemStoreSize memstoreSize = new MemStoreSize(0xC0000000L, 0L, 0x40000000L);
        regionServerAccounting.incGlobalMemStoreSize(memstoreSize);
        Assert.assertEquals((Object)FlushType.ABOVE_OFFHEAP_HIGHER_MARK, (Object)regionServerAccounting.isAboveHighWaterMark());
    }

    @Test
    public void testOffheapMemstoreHigherWaterMarkLimitsDueToHeapSize() {
        conf.setLong("hbase.regionserver.offheap.global.memstore.size", 1024L);
        RegionServerAccounting regionServerAccounting = new RegionServerAccounting(conf);
        long dataSize = regionServerAccounting.getGlobalOnHeapMemStoreLimit();
        MemStoreSize memstoreSize = new MemStoreSize(dataSize, dataSize, 0L);
        regionServerAccounting.incGlobalMemStoreSize(memstoreSize);
        Assert.assertEquals((Object)FlushType.ABOVE_ONHEAP_HIGHER_MARK, (Object)regionServerAccounting.isAboveHighWaterMark());
    }

    @Test
    public void testOffheapMemstoreLowerWaterMarkLimitsDueToDataSize() {
        conf.setLong("hbase.regionserver.offheap.global.memstore.size", 1024L);
        RegionServerAccounting regionServerAccounting = new RegionServerAccounting(conf);
        MemStoreSize memstoreSize = new MemStoreSize(0xC0000000L, 0L, 0x40000000L);
        regionServerAccounting.incGlobalMemStoreSize(memstoreSize);
        Assert.assertEquals((Object)FlushType.ABOVE_OFFHEAP_LOWER_MARK, (Object)regionServerAccounting.isAboveLowWaterMark());
    }

    @Test
    public void testOffheapMemstoreLowerWaterMarkLimitsDueToHeapSize() {
        conf.setLong("hbase.regionserver.offheap.global.memstore.size", 1024L);
        RegionServerAccounting regionServerAccounting = new RegionServerAccounting(conf);
        long dataSize = regionServerAccounting.getGlobalOnHeapMemStoreLimit();
        MemStoreSize memstoreSize = new MemStoreSize(dataSize, dataSize, 0L);
        regionServerAccounting.incGlobalMemStoreSize(memstoreSize);
        Assert.assertEquals((Object)FlushType.ABOVE_ONHEAP_LOWER_MARK, (Object)regionServerAccounting.isAboveLowWaterMark());
    }
}

