/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.replication.BaseReplicationEndpoint;
import org.apache.hadoop.hbase.replication.ReplicationEndpoint;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfig;
import org.apache.hadoop.hbase.replication.ReplicationPeerDescription;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALFactory;
import org.apache.hadoop.hbase.wal.WALProvider;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.rules.TestName;

public class SerialReplicationTestBase {
    protected static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    protected static String PEER_ID = "1";
    protected static byte[] CF = Bytes.toBytes((String)"CF");
    protected static byte[] CQ = Bytes.toBytes((String)"CQ");
    protected static FileSystem FS;
    protected static Path LOG_DIR;
    protected static WALProvider.Writer WRITER;
    @Rule
    public final TestName name = new TestName();
    protected Path logPath;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        UTIL.getConfiguration().setInt("replication.source.nb.capacity", 10);
        UTIL.getConfiguration().setLong("replication.sleep.before.failover", 1000L);
        UTIL.getConfiguration().setLong("hbase.serial.replication.waiting.ms", 100L);
        UTIL.startMiniCluster(3);
        UTIL.getAdmin().balancerSwitch(false, true);
        LOG_DIR = UTIL.getDataTestDirOnTestFS("replicated");
        FS = UTIL.getTestFileSystem();
        FS.mkdirs(LOG_DIR);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        UTIL.shutdownMiniCluster();
    }

    @After
    public void tearDown() throws Exception {
        Admin admin = UTIL.getAdmin();
        for (ReplicationPeerDescription pd : admin.listReplicationPeers()) {
            admin.removeReplicationPeer(pd.getPeerId());
        }
        SerialReplicationTestBase.rollAllWALs();
        if (WRITER != null) {
            WRITER.close();
            WRITER = null;
        }
    }

    protected static void moveRegion(final RegionInfo region, final HRegionServer rs) throws Exception {
        UTIL.getAdmin().move(region.getEncodedNameAsBytes(), Bytes.toBytes((String)rs.getServerName().getServerName()));
        UTIL.waitFor(30000L, (Waiter.Predicate)new Waiter.ExplainingPredicate<Exception>(){

            public boolean evaluate() throws Exception {
                return rs.getRegion(region.getEncodedName()) != null;
            }

            public String explainFailure() throws Exception {
                return region + " is still not on " + rs;
            }
        });
    }

    protected static void rollAllWALs() throws Exception {
        for (JVMClusterUtil.RegionServerThread t : UTIL.getMiniHBaseCluster().getLiveRegionServerThreads()) {
            t.getRegionServer().getWalRoller().requestRollAll();
        }
        UTIL.waitFor(30000L, (Waiter.Predicate)new Waiter.ExplainingPredicate<Exception>(){

            public boolean evaluate() throws Exception {
                return UTIL.getMiniHBaseCluster().getLiveRegionServerThreads().stream().map(t -> t.getRegionServer()).allMatch(HRegionServer::walRollRequestFinished);
            }

            public String explainFailure() throws Exception {
                return "Log roll has not finished yet";
            }
        });
    }

    protected final void setupWALWriter() throws IOException {
        this.logPath = new Path(LOG_DIR, this.name.getMethodName());
        WRITER = WALFactory.createWALWriter((FileSystem)FS, (Path)this.logPath, (Configuration)UTIL.getConfiguration());
    }

    protected final void waitUntilReplicationDone(final int expectedEntries) throws Exception {
        UTIL.waitFor(30000L, (Waiter.Predicate)new Waiter.ExplainingPredicate<Exception>(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public boolean evaluate() throws Exception {
                try (WAL.Reader reader = WALFactory.createReader((FileSystem)FS, (Path)SerialReplicationTestBase.this.logPath, (Configuration)UTIL.getConfiguration());){
                    int count = 0;
                    while (reader.next() != null) {
                        ++count;
                    }
                    boolean bl = count >= expectedEntries;
                    return bl;
                }
                catch (IOException e) {
                    return false;
                }
            }

            public String explainFailure() throws Exception {
                return "Not enough entries replicated";
            }
        });
    }

    protected final void enablePeerAndWaitUntilReplicationDone(int expectedEntries) throws Exception {
        UTIL.getAdmin().enableReplicationPeer(PEER_ID);
        this.waitUntilReplicationDone(expectedEntries);
    }

    protected final void addPeer(boolean enabled) throws IOException {
        UTIL.getAdmin().addReplicationPeer(PEER_ID, ReplicationPeerConfig.newBuilder().setClusterKey("127.0.0.1:2181:/hbase").setReplicationEndpointImpl(LocalReplicationEndpoint.class.getName()).setSerial(true).build(), enabled);
    }

    protected final void checkOrder(int expectedEntries) throws IOException {
        try (WAL.Reader reader = WALFactory.createReader((FileSystem)UTIL.getTestFileSystem(), (Path)this.logPath, (Configuration)UTIL.getConfiguration());){
            WAL.Entry entry;
            long seqId = -1L;
            int count = 0;
            while ((entry = reader.next()) != null) {
                Assert.assertTrue((String)("Sequence id go backwards from " + seqId + " to " + entry.getKey().getSequenceId()), (entry.getKey().getSequenceId() >= seqId ? 1 : 0) != 0);
                seqId = entry.getKey().getSequenceId();
                ++count;
            }
            Assert.assertEquals((long)expectedEntries, (long)count);
        }
    }

    protected final TableName createTable() throws IOException, InterruptedException {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        UTIL.getAdmin().createTable(TableDescriptorBuilder.newBuilder((TableName)tableName).setColumnFamily(ColumnFamilyDescriptorBuilder.newBuilder((byte[])CF).setScope(1).build()).build());
        UTIL.waitTableAvailable(tableName);
        return tableName;
    }

    public static final class LocalReplicationEndpoint
    extends BaseReplicationEndpoint {
        private static final UUID PEER_UUID = UTIL.getRandomUUID();

        public UUID getPeerUUID() {
            return PEER_UUID;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean replicate(ReplicationEndpoint.ReplicateContext replicateContext) {
            WALProvider.Writer writer = WRITER;
            synchronized (writer) {
                try {
                    for (WAL.Entry entry : replicateContext.getEntries()) {
                        WRITER.append(entry);
                    }
                    WRITER.sync(false);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            return true;
        }

        public void start() {
            this.startAsync();
        }

        public void stop() {
            this.stopAsync();
        }

        protected void doStart() {
            this.notifyStarted();
        }

        protected void doStop() {
            this.notifyStopped();
        }
    }
}

