/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.access;

import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.access.Permission;
import org.apache.hadoop.hbase.security.access.SecureTestUtil;
import org.apache.hadoop.hbase.security.access.TableAuthManager;
import org.apache.hadoop.hbase.security.access.TablePermission;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.SecurityTests;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={SecurityTests.class, LargeTests.class})
public class TestZKPermissionWatcher {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestZKPermissionWatcher.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestZKPermissionWatcher.class);
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static TableAuthManager AUTH_A;
    private static TableAuthManager AUTH_B;
    private static final Abortable ABORTABLE;
    private static TableName TEST_TABLE;

    @BeforeClass
    public static void beforeClass() throws Exception {
        Configuration conf = UTIL.getConfiguration();
        SecureTestUtil.enableSecurity(conf);
        UTIL.startMiniCluster();
        AUTH_A = TableAuthManager.getOrCreate((ZKWatcher)new ZKWatcher(conf, "TestZKPermissionsWatcher_1", ABORTABLE), (Configuration)conf);
        AUTH_B = TableAuthManager.getOrCreate((ZKWatcher)new ZKWatcher(conf, "TestZKPermissionsWatcher_2", ABORTABLE), (Configuration)conf);
    }

    @AfterClass
    public static void afterClass() throws Exception {
        UTIL.shutdownMiniCluster();
    }

    @Test
    public void testPermissionsWatcher() throws Exception {
        Configuration conf = UTIL.getConfiguration();
        User george = User.createUserForTesting((Configuration)conf, (String)"george", (String[])new String[0]);
        User hubert = User.createUserForTesting((Configuration)conf, (String)"hubert", (String[])new String[0]);
        Assert.assertFalse((boolean)AUTH_A.authorizeUser(george, TEST_TABLE, null, Permission.Action.READ));
        Assert.assertFalse((boolean)AUTH_A.authorizeUser(george, TEST_TABLE, null, Permission.Action.WRITE));
        Assert.assertFalse((boolean)AUTH_A.authorizeUser(hubert, TEST_TABLE, null, Permission.Action.READ));
        Assert.assertFalse((boolean)AUTH_A.authorizeUser(hubert, TEST_TABLE, null, Permission.Action.WRITE));
        Assert.assertFalse((boolean)AUTH_B.authorizeUser(george, TEST_TABLE, null, Permission.Action.READ));
        Assert.assertFalse((boolean)AUTH_B.authorizeUser(george, TEST_TABLE, null, Permission.Action.WRITE));
        Assert.assertFalse((boolean)AUTH_B.authorizeUser(hubert, TEST_TABLE, null, Permission.Action.READ));
        Assert.assertFalse((boolean)AUTH_B.authorizeUser(hubert, TEST_TABLE, null, Permission.Action.WRITE));
        ArrayList<TablePermission> acl = new ArrayList<TablePermission>(1);
        acl.add(new TablePermission(TEST_TABLE, null, new Permission.Action[]{Permission.Action.READ, Permission.Action.WRITE}));
        final long mtimeB = AUTH_B.getMTime();
        AUTH_A.setTableUserPermissions(george.getShortName(), TEST_TABLE, acl);
        UTIL.waitFor(10000L, 100L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                return AUTH_B.getMTime() > mtimeB;
            }
        });
        Thread.sleep(1000L);
        Assert.assertTrue((boolean)AUTH_A.authorizeUser(george, TEST_TABLE, null, Permission.Action.READ));
        Assert.assertTrue((boolean)AUTH_A.authorizeUser(george, TEST_TABLE, null, Permission.Action.WRITE));
        Assert.assertTrue((boolean)AUTH_B.authorizeUser(george, TEST_TABLE, null, Permission.Action.READ));
        Assert.assertTrue((boolean)AUTH_B.authorizeUser(george, TEST_TABLE, null, Permission.Action.WRITE));
        Assert.assertFalse((boolean)AUTH_A.authorizeUser(hubert, TEST_TABLE, null, Permission.Action.READ));
        Assert.assertFalse((boolean)AUTH_A.authorizeUser(hubert, TEST_TABLE, null, Permission.Action.WRITE));
        Assert.assertFalse((boolean)AUTH_B.authorizeUser(hubert, TEST_TABLE, null, Permission.Action.READ));
        Assert.assertFalse((boolean)AUTH_B.authorizeUser(hubert, TEST_TABLE, null, Permission.Action.WRITE));
        acl = new ArrayList(1);
        acl.add(new TablePermission(TEST_TABLE, null, new Permission.Action[]{Permission.Action.READ}));
        final long mtimeA = AUTH_A.getMTime();
        AUTH_B.setTableUserPermissions("hubert", TEST_TABLE, acl);
        UTIL.waitFor(10000L, 100L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                return AUTH_A.getMTime() > mtimeA;
            }
        });
        Thread.sleep(1000L);
        Assert.assertTrue((boolean)AUTH_A.authorizeUser(george, TEST_TABLE, null, Permission.Action.READ));
        Assert.assertTrue((boolean)AUTH_A.authorizeUser(george, TEST_TABLE, null, Permission.Action.WRITE));
        Assert.assertTrue((boolean)AUTH_B.authorizeUser(george, TEST_TABLE, null, Permission.Action.READ));
        Assert.assertTrue((boolean)AUTH_B.authorizeUser(george, TEST_TABLE, null, Permission.Action.WRITE));
        Assert.assertTrue((boolean)AUTH_A.authorizeUser(hubert, TEST_TABLE, null, Permission.Action.READ));
        Assert.assertFalse((boolean)AUTH_A.authorizeUser(hubert, TEST_TABLE, null, Permission.Action.WRITE));
        Assert.assertTrue((boolean)AUTH_B.authorizeUser(hubert, TEST_TABLE, null, Permission.Action.READ));
        Assert.assertFalse((boolean)AUTH_B.authorizeUser(hubert, TEST_TABLE, null, Permission.Action.WRITE));
    }

    static {
        ABORTABLE = new Abortable(){
            private final AtomicBoolean abort = new AtomicBoolean(false);

            public void abort(String why, Throwable e) {
                LOG.info(why, e);
                this.abort.set(true);
            }

            public boolean isAborted() {
                return this.abort.get();
            }
        };
        TEST_TABLE = TableName.valueOf((String)"perms_test");
    }
}

