/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.snapshot;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.snapshot.MobSnapshotTestingUtils;
import org.apache.hadoop.hbase.snapshot.TestFlushSnapshotFromClient;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={ClientTests.class, LargeTests.class})
public class TestMobFlushSnapshotFromClient
extends TestFlushSnapshotFromClient {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestMobFlushSnapshotFromClient.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestFlushSnapshotFromClient.class);

    @BeforeClass
    public static void setupCluster() throws Exception {
        TestMobFlushSnapshotFromClient.setupConf(UTIL.getConfiguration());
        UTIL.startMiniCluster(3);
    }

    protected static void setupConf(Configuration conf) {
        TestFlushSnapshotFromClient.setupConf(conf);
        UTIL.getConfiguration().setInt("hbase.mob.file.cache.size", 0);
    }

    @Override
    protected void createTable() throws Exception {
        MobSnapshotTestingUtils.createMobTable(UTIL, TABLE_NAME, 1, (byte[][])new byte[][]{TEST_FAM});
    }

    @Override
    protected void verifyRowCount(HBaseTestingUtility util, TableName tableName, long expectedRows) throws IOException {
        MobSnapshotTestingUtils.verifyMobRowCount(util, tableName, expectedRows);
    }

    @Override
    protected int countRows(Table table, byte[] ... families) throws IOException {
        return MobSnapshotTestingUtils.countMobRows(table, families);
    }
}

