/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.snapshot;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.shaded.protobuf.generated.SnapshotProtos;
import org.apache.hadoop.hbase.snapshot.SnapshotDescriptionUtils;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManagerTestHelper;
import org.junit.After;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={RegionServerTests.class, MediumTests.class})
public class TestSnapshotDescriptionUtils {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestSnapshotDescriptionUtils.class);
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static FileSystem fs;
    private static Path root;
    private static final Logger LOG;

    @BeforeClass
    public static void setupFS() throws Exception {
        fs = UTIL.getTestFileSystem();
        root = new Path(UTIL.getDataTestDir(), "hbase");
    }

    @After
    public void cleanupFS() throws Exception {
        if (fs.exists(root)) {
            if (!fs.delete(root, true)) {
                throw new IOException("Failed to delete root test dir: " + root);
            }
            if (!fs.mkdirs(root)) {
                throw new IOException("Failed to create root test dir: " + root);
            }
        }
        EnvironmentEdgeManagerTestHelper.reset();
    }

    @Test
    public void testValidateMissingTableName() throws IOException {
        Configuration conf = new Configuration(false);
        try {
            SnapshotDescriptionUtils.validate((SnapshotProtos.SnapshotDescription)SnapshotProtos.SnapshotDescription.newBuilder().setName("fail").build(), (Configuration)conf);
            Assert.fail((String)"Snapshot was considered valid without a table name");
        }
        catch (IllegalArgumentException e) {
            LOG.debug("Correctly failed when snapshot doesn't have a tablename");
        }
    }

    @Test
    public void testCompleteSnapshotWithNoSnapshotDirectoryFailure() throws Exception {
        Path snapshotDir = new Path(root, ".hbase-snapshot");
        Path tmpDir = new Path(snapshotDir, ".tmp");
        Path workingDir = new Path(tmpDir, "not_a_snapshot");
        Assert.assertFalse((String)("Already have working snapshot dir: " + workingDir + " but shouldn't. Test file leak?"), (boolean)fs.exists(workingDir));
        SnapshotProtos.SnapshotDescription snapshot = SnapshotProtos.SnapshotDescription.newBuilder().setName("snapshot").build();
        try {
            SnapshotDescriptionUtils.completeSnapshot((SnapshotProtos.SnapshotDescription)snapshot, (Path)root, (Path)workingDir, (FileSystem)fs);
            Assert.fail((String)"Shouldn't successfully complete move of a non-existent directory.");
        }
        catch (IOException e) {
            LOG.info("Correctly failed to move non-existant directory: " + e.getMessage());
        }
    }

    static {
        LOG = LoggerFactory.getLogger(TestSnapshotDescriptionUtils.class);
    }
}

